/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.wrathy_armament.blocks.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.math.Axis;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.sashakyotoz.wrathy_armament.blocks.gui.WorldshardWorkbenchMenu;

public class WorldshardWorkbenchScreen
extends AbstractContainerScreen<WorldshardWorkbenchMenu> {
    private final Level level;
    private final Player player;
    private final ArrayList<WorkbenchSparkle> sparkles = new ArrayList();
    public static final ResourceLocation BACKGROUND_LOCATION = new ResourceLocation("wrathy_armament", "textures/gui/blocks/worldshard_workbench_bg.png");

    public WorldshardWorkbenchScreen(WorldshardWorkbenchMenu container, Inventory inventory, Component text) {
        super((AbstractContainerMenu)container, inventory, text);
        this.level = inventory.f_35978_.m_9236_();
        this.player = inventory.f_35978_;
        this.f_97726_ = 176;
        this.f_97727_ = 197;
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int gx, int gy) {
        RandomSource random;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.m_280218_(BACKGROUND_LOCATION, this.f_97735_, this.f_97736_ + 16, 0, 0, this.f_97726_, this.f_97727_);
        this.renderProgressArrow(guiGraphics);
        if (((WorldshardWorkbenchMenu)this.m_6262_()).blockEntity.hasRecipe() && (random = this.level.f_46441_).m_188503_(5) == 0) {
            this.sparkles.add(new WorkbenchSparkle(this.player, this.f_97735_, this.f_97736_, 0.5 + random.m_188500_(), 0.5 + random.m_188500_()));
        }
        RenderSystem.disableBlend();
        for (WorkbenchSparkle sparkle : this.sparkles) {
            if (sparkle.tickCount >= 1000) continue;
            sparkle.render(guiGraphics);
        }
    }

    private void renderProgressArrow(GuiGraphics graphics) {
        if (((WorldshardWorkbenchMenu)this.m_6262_()).isCrafting()) {
            graphics.m_280218_(BACKGROUND_LOCATION, this.f_97735_ + 108, this.f_97736_ + 57, 175, 41, ((WorldshardWorkbenchMenu)this.m_6262_()).getScaledProgress(), 16);
        }
    }

    public boolean m_7933_(int key, int b, int c) {
        if (key == 256) {
            this.f_96541_.f_91074_.m_6915_();
            return true;
        }
        return super.m_7933_(key, b, c);
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"block.wrathy_armament.worldshard_workbench"), 62, 124, 1044640, false);
    }

    public static class WorkbenchSparkle {
        private final int centerX;
        private final int centerY;
        private final double speedX;
        private final double speedY;
        public float scale;
        public int tickCount;
        public boolean isReverse;

        public WorkbenchSparkle(Player player, int centerX, int centerY, double speedX, double speedY) {
            this.centerX = centerX;
            this.centerY = centerY;
            this.speedX = speedX;
            this.speedY = speedY;
            this.scale = 1.0f + player.m_217043_().m_188501_() * 0.5f;
            this.isReverse = player.m_217043_().m_188499_();
        }

        public void render(GuiGraphics pGuiGraphics) {
            ++this.tickCount;
            RenderSystem.enableBlend();
            pGuiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 0.5f + Mth.m_14031_((float)((float)this.tickCount * 0.02f)) + 0.5f);
            pGuiGraphics.m_280168_().m_85836_();
            double xOff = (double)this.centerX + (double)this.tickCount * this.speedX;
            double yOff = (double)this.centerY + (double)this.tickCount * this.speedY;
            pGuiGraphics.m_280168_().m_252781_(Axis.f_252403_.m_252977_((float)this.tickCount * (this.isReverse ? -0.2f : 0.2f)));
            pGuiGraphics.m_280168_().m_85837_(xOff, yOff, 0.0);
            pGuiGraphics.m_280168_().m_85841_(this.scale, this.scale, this.scale);
            pGuiGraphics.m_280218_(new ResourceLocation("anitexlib", "textures/particle/sparkle.png"), (int)xOff, (int)yOff, 0, 0, 16, 16);
            pGuiGraphics.m_280168_().m_85849_();
            pGuiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
            RenderSystem.disableBlend();
        }
    }
}

