/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.wrathy_armament.blocks.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.sashakyotoz.wrathy_armament.WrathyArmament;
import net.sashakyotoz.wrathy_armament.blocks.entities.WorldshardWorkbenchBlockEntity;
import net.sashakyotoz.wrathy_armament.client.models.technical.ForgeModel;
import net.sashakyotoz.wrathy_armament.items.SwordLikeItem;
import net.sashakyotoz.wrathy_armament.mixin.accessor.ItemRendererAccessor;
import net.sashakyotoz.wrathy_armament.utils.OnActionsTrigger;
import net.sashakyotoz.wrathy_armament.utils.RenderUtils;
import net.sashakyotoz.wrathy_armament.utils.WARenderTypes;

public class WorldshardWorkbenchEntityRenderer
implements BlockEntityRenderer<WorldshardWorkbenchBlockEntity> {
    public static ResourceLocation CHAOS_FORGE = new ResourceLocation("wrathy_armament", "textures/block/chaos_forge.png");
    public static ResourceLocation TECHNOLOGISTIC_FORGE = new ResourceLocation("wrathy_armament", "textures/block/technologistic_forge.png");
    public static ResourceLocation ELEMENTAL_ANVIL = new ResourceLocation("wrathy_armament", "textures/block/elemental_anvil.png");
    public static ResourceLocation MYTHRIL_ANVIL = new ResourceLocation("wrathy_armament", "textures/block/mythril_anvil.png");
    private final ForgeModel forgeModel;
    private final ItemRenderer itemRenderer;

    public WorldshardWorkbenchEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.forgeModel = new ForgeModel(context.m_173585_().m_171103_(ForgeModel.LAYER_LOCATION));
        this.itemRenderer = context.m_234447_();
    }

    public void render(WorldshardWorkbenchBlockEntity entity, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        long gameTime = 0L;
        ItemStack stack = entity.itemHandler.getStackInSlot(0);
        if (entity.m_58904_() != null) {
            gameTime = entity.m_58904_().m_46467_();
        }
        if (entity.hasRecipe()) {
            ResourceLocation location = switch (entity.getModelVariantForRecipe()) {
                case 1 -> CHAOS_FORGE;
                case 2 -> ELEMENTAL_ANVIL;
                case 3 -> TECHNOLOGISTIC_FORGE;
                default -> MYTHRIL_ANVIL;
            };
            poseStack.m_85836_();
            poseStack.m_252880_(0.5f, 1.6f, 0.5f);
            poseStack.m_252781_(Axis.f_252436_.m_252961_((float)(gameTime % 360L) * 0.05f));
            poseStack.m_85841_(0.5f, -0.5f, 0.5f);
            this.forgeModel.m_7695_(poseStack, buffer.m_6299_(RenderType.m_110473_((ResourceLocation)location)), packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 0.5f);
            poseStack.m_85849_();
        } else if (!entity.stackToRender().m_41619_() || entity.progress > 0 && stack.m_41720_() instanceof SwordLikeItem) {
            poseStack.m_85836_();
            poseStack.m_252880_(0.5f, 1.5f, 0.5f);
            poseStack.m_252781_(Axis.f_252436_.m_252961_((float)(gameTime % 360L) * 0.05f));
            float scaleFactor = stack.m_41720_() instanceof SwordLikeItem ? 1.0f : 0.5f;
            poseStack.m_85841_(scaleFactor, scaleFactor, scaleFactor);
            this.itemRenderer.m_269128_(entity.stackToRender(), ItemDisplayContext.GUI, packedLight, OverlayTexture.f_118083_, poseStack, buffer, entity.m_58904_(), packedOverlay);
            if (stack.m_41720_() instanceof SwordLikeItem) {
                poseStack.m_252880_(-9.0E-4f, -9.0E-4f, 0.0f);
                poseStack.m_85841_(1.0015f, 1.0015f, 1.0015f);
                this.itemRenderer.m_115189_(((ItemRendererAccessor)this.itemRenderer).getShaper().m_109406_(stack), stack, packedLight, OverlayTexture.f_118083_, poseStack, buffer.m_6299_(OnActionsTrigger.isOculusIn() ? RenderType.m_110436_((ResourceLocation)WrathyArmament.createWALocation("textures/item/materials/lined_sparkle_blinking.png"), (float)RenderUtils.getOscillatingValue(entity.progress, 10), (float)0.0f) : WARenderTypes.translucentSwirl(WrathyArmament.createWALocation("textures/item/materials/sparkle_blinking.png"), RenderUtils.getOscillatingValue(entity.progress, 4), 0.0f)));
            }
            poseStack.m_85849_();
        }
    }
}

