/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.wrathy_armament.client.models.mobs;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.animation.Keyframe;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.AnimationState;
import net.sashakyotoz.wrathy_armament.entities.animations.HabciakAnimations;
import net.sashakyotoz.wrathy_armament.entities.bosses.Habciak;
import org.joml.Vector3f;

public class HierarchicalPlayerModel<E extends Habciak>
extends PlayerModel<E> {
    public final ModelPart root;
    private static final Vector3f ANIMATION_VECTOR_CACHE = new Vector3f();

    public HierarchicalPlayerModel(ModelPart pRoot, boolean pSlim) {
        super(pRoot, pSlim);
        this.root = pRoot;
    }

    public Optional<ModelPart> getAnyDescendantWithName(String pName) {
        return pName.equals("root") ? Optional.of(this.root) : this.root.m_171331_().filter(part -> part.m_233562_(pName)).findFirst().map(part -> part.m_171324_(pName));
    }

    protected void animate(AnimationState pAnimationState, AnimationDefinition pAnimationDefinition, float pAgeInTicks) {
        this.animate(pAnimationState, pAnimationDefinition, pAgeInTicks, 1.0f);
    }

    protected void animateWalk(AnimationDefinition pAnimationDefinition, float pLimbSwing, float pLimbSwingAmount, float pMaxAnimationSpeed, float pAnimationScaleFactor) {
        long i = (long)(pLimbSwing * 50.0f * pMaxAnimationSpeed);
        float f = Math.min(pLimbSwingAmount * pAnimationScaleFactor, 1.0f);
        HierarchicalPlayerModel.animate(this, pAnimationDefinition, i, f, ANIMATION_VECTOR_CACHE);
    }

    public static void animate(HierarchicalPlayerModel<?> pModel, AnimationDefinition pAnimationDefinition, long pAccumulatedTime, float pScale, Vector3f pAnimationVecCache) {
        if (pAnimationDefinition == HabciakAnimations.DEATH) {
            pAnimationVecCache = new Vector3f();
        }
        float f = HierarchicalPlayerModel.getElapsedSeconds(pAnimationDefinition, pAccumulatedTime);
        for (Map.Entry entry : pAnimationDefinition.f_232257_().entrySet()) {
            Optional<ModelPart> optional = pModel.getAnyDescendantWithName((String)entry.getKey());
            List list = (List)entry.getValue();
            Vector3f finalPAnimationVecCache = pAnimationVecCache;
            optional.ifPresent(part -> list.forEach(channel -> {
                Keyframe[] akeyframe = channel.f_232212_();
                int i = Math.max(0, Mth.m_14049_((int)0, (int)akeyframe.length, i1 -> f <= akeyframe[i1].f_232283_()) - 1);
                int j = Math.min(akeyframe.length - 1, i + 1);
                Keyframe keyframe = akeyframe[i];
                Keyframe keyframe1 = akeyframe[j];
                float f1 = f - keyframe.f_232283_();
                float f2 = j != i ? Mth.m_14036_((float)(f1 / (keyframe1.f_232283_() - keyframe.f_232283_())), (float)0.0f, (float)1.0f) : 0.0f;
                keyframe1.f_232285_().m_232222_(finalPAnimationVecCache, f2, akeyframe, i, j, pScale);
                channel.f_232211_().m_232247_(part, finalPAnimationVecCache);
            }));
        }
    }

    private static float getElapsedSeconds(AnimationDefinition pAnimationDefinition, long pAccumulatedTime) {
        float f = (float)pAccumulatedTime / 1000.0f;
        return pAnimationDefinition.f_232256_() ? f % pAnimationDefinition.f_232255_() : f;
    }

    protected void animate(AnimationState pAnimationState, AnimationDefinition pAnimationDefinition, float pAgeInTicks, float pSpeed) {
        pAnimationState.m_216974_(pAgeInTicks, pSpeed);
        pAnimationState.m_216979_(state -> HierarchicalPlayerModel.animate(this, pAnimationDefinition, state.m_216981_(), 1.0f, ANIMATION_VECTOR_CACHE));
    }

    public void setupAnim(E habciak, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        this.root.m_171331_().forEach(ModelPart::m_233569_);
        this.animate(((Habciak)habciak).jump, HabciakAnimations.JUMP_TELEPORT, pAgeInTicks);
        this.animate(((Habciak)habciak).floorAttack, HabciakAnimations.FLOORS_ATTACK, pAgeInTicks);
        this.animate(((Habciak)habciak).backFlip, HabciakAnimations.BACK_FLIP, pAgeInTicks);
        this.animate(((Habciak)habciak).mirrorCasting, HabciakAnimations.MIRROR_CASTING, pAgeInTicks, 0.5f);
        this.animate(((Habciak)habciak).splash, HabciakAnimations.SPLASH, pAgeInTicks, 0.5f);
        this.animate(((Habciak)habciak).death, HabciakAnimations.DEATH, pAgeInTicks);
        this.animateWalk(HabciakAnimations.WALK, pLimbSwing, pLimbSwingAmount, 2.0f, 2.5f);
    }
}

