/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.wrathy_armament.client.particles;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.sashakyotoz.wrathy_armament.WrathyArmament;
import net.sashakyotoz.wrathy_armament.client.models.technical.SphereLikeEntityModel;
import net.sashakyotoz.wrathy_armament.client.particles.options.FireSphereParticleOption;
import org.jetbrains.annotations.NotNull;

public class FireSphereParticle
extends TextureSheetParticle {
    private final float maxScale;
    private final boolean isReversed;
    private final boolean toScale;

    public FireSphereParticle(ClientLevel level, double x, double y, double z, double vx, double vy, double vz, float maxScale, boolean isReversed, boolean toScale) {
        super(level, x, y, z, vx, vy, vz);
        this.f_107663_ = 1.0f;
        this.f_107219_ = false;
        this.f_107225_ = 60;
        this.isReversed = isReversed;
        this.toScale = toScale;
        this.f_107226_ = 0.0f;
        this.maxScale = maxScale;
        this.m_172260_(0.0, 0.0, 0.0);
        this.m_107271_(0.5f);
        new SphereRenderSequence(this).start();
    }

    @NotNull
    public static FireTrailParticleProvider provider(SpriteSet spriteSet) {
        return new FireTrailParticleProvider(spriteSet);
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107434_;
    }

    public void m_5989_() {
        super.m_5989_();
        this.f_107663_ = this.toScale ? (this.isReversed ? (this.f_107663_ += this.f_107663_ > this.maxScale / 10.0f ? -0.05f : 0.0f) : (this.f_107663_ += this.f_107663_ < this.maxScale ? 0.05f : 0.0f)) : this.maxScale;
        this.f_107227_ += this.f_107227_ > 0.025f ? -0.025f : 0.0f;
        this.f_107228_ += this.f_107228_ > 0.025f ? -0.025f : 0.0f;
        this.f_107229_ += this.f_107229_ > 0.025f ? -0.025f : 0.0f;
        this.f_107230_ += this.f_107230_ > 0.05f ? -0.025f : 0.0f;
    }

    private static class SphereRenderSequence {
        private final FireSphereParticle particle;
        private final CircleRenderer renderer;

        public SphereRenderSequence(FireSphereParticle particle) {
            this.particle = particle;
            this.renderer = new CircleRenderer();
        }

        public void start() {
            MinecraftForge.EVENT_BUS.register((Object)this.renderer);
            MinecraftForge.EVENT_BUS.register((Object)this);
        }

        @SubscribeEvent
        public void tick(TickEvent.ClientTickEvent event) {
            if (!this.particle.m_107276_()) {
                this.end();
            }
        }

        private void end() {
            MinecraftForge.EVENT_BUS.unregister((Object)this.renderer);
            MinecraftForge.EVENT_BUS.unregister((Object)this);
        }

        private class CircleRenderer {
            public final EntityModel<Entity> model = new SphereLikeEntityModel<Entity>(Minecraft.m_91087_().m_167973_().m_171103_(SphereLikeEntityModel.LAYER_LOCATION));

            public CircleRenderer() {
                MinecraftForge.EVENT_BUS.register((Object)this);
            }

            @SubscribeEvent
            public void render(RenderLevelStageEvent event) {
                if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
                    VertexConsumer consumer = Minecraft.m_91087_().m_91269_().m_110104_().m_6299_(RenderType.m_110473_((ResourceLocation)WrathyArmament.createWALocation("textures/entity/particle_like/spheres/fire_circle.png")));
                    Vec3 camPos = event.getCamera().m_90583_();
                    double x = Mth.m_14139_((double)event.getPartialTick(), (double)SphereRenderSequence.this.particle.f_107209_, (double)SphereRenderSequence.this.particle.f_107212_) - camPos.m_7096_();
                    double y = Mth.m_14139_((double)event.getPartialTick(), (double)SphereRenderSequence.this.particle.f_107210_, (double)SphereRenderSequence.this.particle.f_107213_) - camPos.m_7098_() - 3.0;
                    double z = Mth.m_14139_((double)event.getPartialTick(), (double)SphereRenderSequence.this.particle.f_107211_, (double)SphereRenderSequence.this.particle.f_107214_) - camPos.m_7094_();
                    event.getPoseStack().m_85836_();
                    event.getPoseStack().m_85837_(x, y, z);
                    event.getPoseStack().m_252781_(Axis.f_252436_.m_252977_((float)(SphereRenderSequence.this.particle.f_107224_ * 5 % 360)));
                    event.getPoseStack().m_85841_(SphereRenderSequence.this.particle.f_107663_, SphereRenderSequence.this.particle.f_107663_, SphereRenderSequence.this.particle.f_107663_);
                    this.model.m_7695_(event.getPoseStack(), consumer, SphereRenderSequence.this.particle.m_6355_(event.getPartialTick()), OverlayTexture.f_118083_, SphereRenderSequence.this.particle.f_107227_, SphereRenderSequence.this.particle.f_107228_, SphereRenderSequence.this.particle.f_107229_, SphereRenderSequence.this.particle.f_107230_);
                    event.getPoseStack().m_85849_();
                }
            }
        }
    }

    public static class FireTrailParticleProvider
    implements ParticleProvider<FireSphereParticleOption> {
        private final SpriteSet spriteSet;

        public FireTrailParticleProvider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(FireSphereParticleOption typeIn, @NotNull ClientLevel pLevel, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            FireSphereParticle particle = new FireSphereParticle(pLevel, x, y, z, xSpeed, ySpeed, zSpeed, typeIn.maxScale(), typeIn.isReversed(), typeIn.toScale());
            particle.m_107253_(typeIn.redColor(), typeIn.greenColor(), typeIn.blueColor());
            return particle;
        }
    }
}

