/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.wrathy_armament.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.sashakyotoz.anitexlib.utils.TextureAnimator;
import net.sashakyotoz.wrathy_armament.WrathyArmament;
import net.sashakyotoz.wrathy_armament.client.models.technical.AxeProjectileModel;
import net.sashakyotoz.wrathy_armament.client.models.technical.DaggerProjectileModel;
import net.sashakyotoz.wrathy_armament.client.models.technical.HugeSwordModel;
import net.sashakyotoz.wrathy_armament.client.models.technical.ParticleLikeEntityModel;
import net.sashakyotoz.wrathy_armament.client.models.technical.ShieldDashModel;
import net.sashakyotoz.wrathy_armament.client.renderer.ParticleLikeEntityRenderer;
import net.sashakyotoz.wrathy_armament.entities.technical.HarmfulProjectileEntity;

public class HarmfulProjectileRenderer
extends EntityRenderer<HarmfulProjectileEntity> {
    private final ResourceLocation AXE = WrathyArmament.createWALocation("textures/entity/projectile_like/axe_projectile.png");
    private final ResourceLocation DAGGER = WrathyArmament.createWALocation("textures/entity/projectile_like/dagger_projectile.png");
    private final ResourceLocation SWORD = WrathyArmament.createWALocation("textures/entity/projectile_like/huge_sword.png");
    private EntityModel<HarmfulProjectileEntity> model;
    private final DaggerProjectileModel<HarmfulProjectileEntity> daggerModel;
    private final HugeSwordModel<HarmfulProjectileEntity> swordModel;
    private final ShieldDashModel<HarmfulProjectileEntity> shieldModel;
    private final AxeProjectileModel<HarmfulProjectileEntity> axeModel;
    private final ParticleLikeEntityModel<HarmfulProjectileEntity> circleModel;

    public HarmfulProjectileRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new DaggerProjectileModel<HarmfulProjectileEntity>(context.m_174023_(DaggerProjectileModel.LAYER_LOCATION));
        this.daggerModel = new DaggerProjectileModel(context.m_174023_(DaggerProjectileModel.LAYER_LOCATION));
        this.axeModel = new AxeProjectileModel(context.m_174023_(AxeProjectileModel.LAYER_LOCATION));
        this.swordModel = new HugeSwordModel(context.m_174023_(HugeSwordModel.LAYER_LOCATION));
        this.shieldModel = new ShieldDashModel(context.m_174023_(ShieldDashModel.LAYER_LOCATION));
        this.circleModel = new ParticleLikeEntityModel(context.m_174023_(ParticleLikeEntityModel.LAYER_LOCATION));
    }

    public void render(HarmfulProjectileEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLightIn) {
        poseStack.m_85836_();
        if (entity.rotationRelativelyToY() != 0.0f && !entity.getProjectileType().equals("huge_sword")) {
            poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - entity.rotationRelativelyToY()));
        }
        if (entity.getProjectileType().equals("vertical_circle")) {
            poseStack.m_85841_(0.75f, 0.75f, 0.75f);
            poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
            poseStack.m_252781_(Axis.f_252403_.m_252977_((float)(entity.f_19797_ % 360)));
        }
        if (entity.getProjectileType().equals("axe")) {
            poseStack.m_252781_(Axis.f_252529_.m_252961_((float)Math.PI * 2 * (float)entity.f_19797_ * 0.125f));
        }
        switch (entity.getProjectileType()) {
            case "axe": 
            case "knight_axe": {
                this.model = this.axeModel;
                break;
            }
            case "huge_sword": {
                this.model = this.swordModel;
                break;
            }
            case "shield_dash": {
                this.model = this.shieldModel;
                break;
            }
            case "vertical_circle": {
                this.model = this.circleModel;
                break;
            }
            default: {
                this.model = this.daggerModel;
            }
        }
        float f7 = this.getBob(entity, partialTicks);
        if (entity.getProjectileType().equals("huge_sword")) {
            poseStack.m_85841_(2.5f, 2.5f, 2.5f);
            poseStack.m_252781_(Axis.f_252529_.m_252961_(135.0f));
            poseStack.m_85837_(0.0, -3.5 + (double)((float)entity.timeToVanish / 40.0f), 0.0);
        } else if (entity.getProjectileType().equals("shield_dash")) {
            poseStack.m_85841_(1.5f + (float)entity.timeToVanish / 5.0f, 1.5f + (float)entity.timeToVanish / 5.0f, 1.5f + (float)entity.timeToVanish / 5.0f);
            poseStack.m_252880_(0.0f, -1.5f, 0.0f);
        } else {
            poseStack.m_85837_(0.0, -0.5, 0.0);
        }
        this.model.m_6973_((Entity)entity, 0.0f, 0.0f, f7, entity.m_146908_(), entity.m_146909_());
        VertexConsumer vertexconsumer = bufferSource.m_6299_(this.model.m_103119_(this.getTextureLocation(entity)));
        if (entity.timeToVanish > 10) {
            this.model.m_7695_(poseStack, vertexconsumer, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f - (float)entity.timeToVanish / 20.0f);
        }
        poseStack.m_85849_();
        super.m_7392_((Entity)entity, entityYaw, partialTicks, poseStack, bufferSource, packedLightIn);
    }

    private float getBob(HarmfulProjectileEntity entity, float partialTicks) {
        return (float)entity.f_19797_ + partialTicks;
    }

    public ResourceLocation getTextureLocation(HarmfulProjectileEntity entity) {
        return switch (entity.getProjectileType()) {
            case "axe", "knight_axe" -> this.AXE;
            case "huge_sword" -> this.SWORD;
            case "shield_dash" -> TextureAnimator.getAnimatedTextureByName((String)"wrathy_armament", (String)"textures/entity/particle_like/shield_dash/", (String)"shield_dash");
            case "vertical_circle" -> ParticleLikeEntityRenderer.LIGHT_CIRCLE;
            default -> this.DAGGER;
        };
    }
}

