/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.wrathy_armament.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.sashakyotoz.wrathy_armament.WrathyArmament;
import net.sashakyotoz.wrathy_armament.client.models.technical.ParticleLikeEntityModel;
import net.sashakyotoz.wrathy_armament.entities.technical.ParticleLikeEntity;

public class ParticleLikeEntityRenderer
extends EntityRenderer<ParticleLikeEntity> {
    private static final ResourceLocation FIRE_CIRCLE = WrathyArmament.createWALocation("textures/entity/particle_like/fire_circle.png");
    private static final ResourceLocation FIRE_SEMICIRCLE = WrathyArmament.createWALocation("textures/entity/particle_like/fire_semicircle.png");
    public static final ResourceLocation LIGHT_CIRCLE = WrathyArmament.createWALocation("textures/entity/particle_like/light_circle.png");
    private static final ResourceLocation PURPLE_CIRCLE = WrathyArmament.createWALocation("textures/entity/particle_like/purple_circle.png");
    private static final ResourceLocation SOUL_CIRCLE = WrathyArmament.createWALocation("textures/entity/particle_like/soul_circle.png");
    private final ParticleLikeEntityModel<ParticleLikeEntity> model;

    public ParticleLikeEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new ParticleLikeEntityModel(context.m_174023_(ParticleLikeEntityModel.LAYER_LOCATION));
    }

    public void render(ParticleLikeEntity entity, float entityYaw, float partialTicks, PoseStack stack, MultiBufferSource source, int packedLightIn) {
        stack.m_85836_();
        if (entity.toTurnParticle() && entity.rotationRelativelyToY() != 0.0f) {
            stack.m_252781_(Axis.f_252403_.m_252977_(entity.rotationRelativelyToY()));
            stack.m_252781_(Axis.f_252436_.m_252977_(180.0f - entity.rotationRelativelyToY()));
        }
        float f7 = this.getBob(entity, partialTicks);
        this.scale(entity, stack);
        if (entity.getParticleType().equals("lich_rain") || entity.getParticleType().equals("rain")) {
            stack.m_252781_(Axis.f_252436_.m_252977_((float)(entity.f_19797_ % 360) * 2.5f));
        }
        this.model.setupAnim(entity, 0.0f, 0.0f, f7, entity.m_146908_(), entity.m_146909_());
        VertexConsumer vertexconsumer = source.m_6299_(this.model.m_103119_(this.getTextureLocation(entity)));
        if (entity.timeToVanish > 10) {
            this.model.m_7695_(stack, vertexconsumer, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f - (float)entity.timeToVanish / 20.0f);
        }
        stack.m_85849_();
        super.m_7392_((Entity)entity, entityYaw, partialTicks, stack, source, packedLightIn);
    }

    public void scale(ParticleLikeEntity entity, PoseStack stack) {
        stack.m_85841_(entity.getSize(), 0.1f, entity.getSize());
    }

    private float getBob(ParticleLikeEntity entity, float partialTicks) {
        return (float)entity.f_19797_ + partialTicks;
    }

    public ResourceLocation getTextureLocation(ParticleLikeEntity entity) {
        switch (entity.getIdOfColor()) {
            case 1: {
                return FIRE_SEMICIRCLE;
            }
            case 2: {
                return LIGHT_CIRCLE;
            }
            case 3: {
                return PURPLE_CIRCLE;
            }
            case 4: {
                return SOUL_CIRCLE;
            }
        }
        return FIRE_CIRCLE;
    }
}

