/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.wrathy_armament.client.renderer.bosses;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Mob;
import net.sashakyotoz.wrathy_armament.WrathyArmament;
import net.sashakyotoz.wrathy_armament.client.models.mobs.MoonLordModel;
import net.sashakyotoz.wrathy_armament.client.renderer.bosses.FixedDeathAnimationMobRenderer;
import net.sashakyotoz.wrathy_armament.client.renderer.layers.moonlord.MoonLordEmissiveLayer;
import net.sashakyotoz.wrathy_armament.client.renderer.layers.moonlord.MoonLordEyesLayer;
import net.sashakyotoz.wrathy_armament.client.renderer.layers.moonlord.MoonLordGlowingLayer;
import net.sashakyotoz.wrathy_armament.entities.bosses.MoonLord;
import net.sashakyotoz.wrathy_armament.utils.RenderUtils;
import org.joml.Matrix4f;

public class MoonLordRenderer
extends FixedDeathAnimationMobRenderer<MoonLord, MoonLordModel<MoonLord>> {
    private static final float HALF_SQRT_3 = (float)(Math.sqrt(3.0) / 2.0);
    private final ResourceLocation TEXTURE = WrathyArmament.createWALocation("textures/entity/bosses/moon_lord.png");
    private static final ResourceLocation HEART_TEXTURE = WrathyArmament.createWALocation("textures/entity/bosses/moon_lord/heart.png");
    private static final ResourceLocation HAND_EYE_TEXTURE = WrathyArmament.createWALocation("textures/entity/bosses/moon_lord/hand_eye.png");
    private static final ResourceLocation HEAD_EYE_TEXTURE = WrathyArmament.createWALocation("textures/entity/bosses/moon_lord/head_eye.png");
    private static final ResourceLocation GLOWING_EYES_TEXTURE = WrathyArmament.createWALocation("textures/entity/bosses/glowing_eyes/moon_lord_glowing_eyes.png");

    public MoonLordRenderer(EntityRendererProvider.Context context) {
        super(context, new MoonLordModel(context.m_174023_(MoonLordModel.LAYER_LOCATION)), 0.5f);
        this.m_115326_(new MoonLordEmissiveLayer<MoonLord, MoonLordModel>((RenderLayerParent<MoonLord, MoonLordModel>)this, HEART_TEXTURE, (t, v, v1) -> Math.max(0.0f, Mth.m_14089_((float)(v1 * 0.1f)) * 0.5f), MoonLordModel::getHeartLayerModelParts));
        this.m_115326_(new MoonLordEyesLayer((RenderLayerParent<MoonLord, MoonLordModel<MoonLord>>)this, HAND_EYE_TEXTURE));
        this.m_115326_(new MoonLordEyesLayer((RenderLayerParent<MoonLord, MoonLordModel<MoonLord>>)this, HEAD_EYE_TEXTURE));
        this.m_115326_(new MoonLordGlowingLayer(this, GLOWING_EYES_TEXTURE));
    }

    public void scale(MoonLord lord, PoseStack pPoseStack, float pPartialTickTime) {
        pPoseStack.m_85841_(2.5f, 2.5f, 2.5f);
    }

    public void render(MoonLord lord, float pEntityYaw, float pPartialTicks, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight) {
        super.m_7392_((Mob)lord, pEntityYaw, pPartialTicks, pPoseStack, pBuffer, pPackedLight);
        if (lord.isInPose(MoonLord.LordPose.LASERING)) {
            RenderUtils.renderBeam((Mob)lord, pPartialTicks, pPoseStack, pBuffer, RenderType.m_110458_((ResourceLocation)WrathyArmament.createWALocation("textures/entity/bosses/moon_lord/beam.png")));
        }
        if (lord.isInPose(MoonLord.LordPose.ATTACKING)) {
            RenderUtils.renderTongue(lord, pPartialTicks, pPoseStack, pBuffer);
        }
        if (lord.deathTicks > -10 && lord.m_21224_()) {
            float f5 = ((float)lord.deathTicks + pPartialTicks) / 100.0f;
            float f7 = Math.min(f5 > 0.8f ? (f5 - 0.8f) / 0.2f : 0.0f, 1.0f);
            RandomSource randomsource = RandomSource.m_216335_((long)432L);
            VertexConsumer vertexConsumer = pBuffer.m_6299_(RenderType.m_110502_());
            pPoseStack.m_85836_();
            pPoseStack.m_252880_(0.0f, 1.0f, 0.0f);
            int i = 0;
            while ((float)i < (f5 + f5 * f5) / 2.0f * 60.0f) {
                pPoseStack.m_252781_(Axis.f_252529_.m_252977_(randomsource.m_188501_() * 360.0f));
                pPoseStack.m_252781_(Axis.f_252436_.m_252977_(randomsource.m_188501_() * 360.0f));
                pPoseStack.m_252781_(Axis.f_252403_.m_252977_(randomsource.m_188501_() * 360.0f));
                pPoseStack.m_252781_(Axis.f_252529_.m_252977_(randomsource.m_188501_() * 360.0f));
                pPoseStack.m_252781_(Axis.f_252436_.m_252977_(randomsource.m_188501_() * 360.0f));
                pPoseStack.m_252781_(Axis.f_252403_.m_252977_(randomsource.m_188501_() * 360.0f + f5 * 90.0f));
                float f3 = randomsource.m_188501_() * 20.0f + 5.0f + f7 * 10.0f;
                float f4 = randomsource.m_188501_() * 2.0f + 1.0f + f7 * 2.0f;
                Matrix4f matrix4f = pPoseStack.m_85850_().m_252922_();
                int j = (int)(255.0f * (1.0f - f7));
                MoonLordRenderer.vertex01(vertexConsumer, matrix4f, j);
                MoonLordRenderer.vertex2(vertexConsumer, matrix4f, f3, f4);
                MoonLordRenderer.vertex3(vertexConsumer, matrix4f, f3, f4);
                MoonLordRenderer.vertex01(vertexConsumer, matrix4f, j);
                MoonLordRenderer.vertex3(vertexConsumer, matrix4f, f3, f4);
                MoonLordRenderer.vertex4(vertexConsumer, matrix4f, f3, f4);
                MoonLordRenderer.vertex01(vertexConsumer, matrix4f, j);
                MoonLordRenderer.vertex4(vertexConsumer, matrix4f, f3, f4);
                MoonLordRenderer.vertex2(vertexConsumer, matrix4f, f3, f4);
                ++i;
            }
            pPoseStack.m_85849_();
        }
    }

    public ResourceLocation getTextureLocation(MoonLord pEntity) {
        return this.TEXTURE;
    }

    public boolean shouldRender(MoonLord pLivingEntity, Frustum pCamera, double pCamX, double pCamY, double pCamZ) {
        return true;
    }

    private static void vertex01(VertexConsumer pConsumer, Matrix4f pMatrix, int pAlpha) {
        pConsumer.m_252986_(pMatrix, 0.0f, 0.0f, 0.0f).m_6122_(255, 255, 255, pAlpha).m_5752_();
    }

    private static void vertex2(VertexConsumer pConsumer, Matrix4f pMatrix, float p_253704_, float p_253701_) {
        pConsumer.m_252986_(pMatrix, -HALF_SQRT_3 * p_253701_, p_253704_, -0.5f * p_253701_).m_6122_(255, 0, 255, 0).m_5752_();
    }

    private static void vertex3(VertexConsumer pConsumer, Matrix4f pMatrix, float p_253729_, float p_254030_) {
        pConsumer.m_252986_(pMatrix, HALF_SQRT_3 * p_254030_, p_253729_, -0.5f * p_254030_).m_6122_(255, 0, 255, 0).m_5752_();
    }

    private static void vertex4(VertexConsumer pConsumer, Matrix4f pMatrix, float p_253649_, float p_253694_) {
        pConsumer.m_252986_(pMatrix, 0.0f, p_253649_, p_253694_).m_6122_(255, 0, 255, 0).m_5752_();
    }
}

