/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.wrathy_armament.client.renderer.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.sashakyotoz.anitexlib.utils.TextureAnimator;
import net.sashakyotoz.wrathy_armament.client.models.technical.TransparentHumanoidLayerModel;
import net.sashakyotoz.wrathy_armament.client.renderer.layers.ModelFollowingRenderer;
import net.sashakyotoz.wrathy_armament.utils.OnActionsTrigger;
import net.sashakyotoz.wrathy_armament.utils.capabilities.ModCapabilities;
import org.antlr.v4.runtime.misc.Triple;

public class TransparentFireLayer<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    private final TransparentHumanoidLayerModel<T> humanoidLayerModel;
    private final TransparentHumanoidLayerModel<T> shadeHumanoidLayerModel;

    public TransparentFireLayer(RenderLayerParent<T, M> pRenderer, EntityModelSet modelSet) {
        super(pRenderer);
        this.humanoidLayerModel = new TransparentHumanoidLayerModel(modelSet.m_171103_(TransparentHumanoidLayerModel.LAYER_LOCATION));
        this.shadeHumanoidLayerModel = new TransparentHumanoidLayerModel(modelSet.m_171103_(TransparentHumanoidLayerModel.LAYER_LOCATION));
    }

    public void render(PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, T pLivingEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTick, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        Player player;
        if (pLivingEntity instanceof Player && this.shouldRender(player = (Player)pLivingEntity)) {
            boolean[] flags = new boolean[]{false, false};
            player.getCapability(ModCapabilities.MISTSPLITTER_DEFENCE).ifPresent(mistsplitterDefenseCapability -> {
                flags[0] = mistsplitterDefenseCapability.isDefenseModeOn();
            });
            player.getCapability(ModCapabilities.HALF_ZATOICHI_ABILITIES).ifPresent(halfZatoichiAbilityCapability -> {
                flags[1] = halfZatoichiAbilityCapability.isInAdrenalinMode();
            });
            Triple[] colors = new Triple[]{new Triple((Object)1, (Object)1, (Object)1)};
            if (flags[0] && !flags[1]) {
                player.getCapability(ModCapabilities.MISTSPLITTER_DEFENCE).ifPresent(mistsplitterDefenseCapability -> {
                    switch (mistsplitterDefenseCapability.getDefenceType()) {
                        case "air": {
                            colors[0] = new Triple((Object)Float.valueOf(1.0f), (Object)Float.valueOf(1.0f), (Object)Float.valueOf(1.0f));
                            break;
                        }
                        case "earth": {
                            colors[0] = new Triple((Object)Float.valueOf(0.2f), (Object)Float.valueOf(0.9f), (Object)Float.valueOf(0.15f));
                            break;
                        }
                        case "elemental": {
                            colors[0] = new Triple((Object)Float.valueOf(1.0f), (Object)Float.valueOf(0.0f), (Object)Float.valueOf(1.0f));
                            break;
                        }
                        case "water": {
                            colors[0] = new Triple((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f), (Object)Float.valueOf(1.0f));
                            break;
                        }
                        default: {
                            colors[0] = new Triple((Object)Float.valueOf(1.0f), (Object)Float.valueOf(0.25f), (Object)Float.valueOf(0.0f));
                        }
                    }
                });
            } else if (!flags[0] && flags[1]) {
                player.getCapability(ModCapabilities.HALF_ZATOICHI_ABILITIES).ifPresent(halfZatoichiAbilityCapability -> {
                    colors[0] = new Triple((Object)Float.valueOf(1.0f), (Object)Float.valueOf(1.0f), (Object)Float.valueOf(0.0f));
                });
            }
            ResourceLocation resourcelocation = TextureAnimator.getAnimatedTextureByName((String)"wrathy_armament", (String)"textures/entity/layers/transparent_fire/", (String)"transparent_fire_overlay");
            pPoseStack.m_85836_();
            ModelFollowingRenderer.followBodyRotations(pLivingEntity, new HumanoidModel[]{this.humanoidLayerModel});
            this.m_117386_().m_102624_(this.humanoidLayerModel);
            this.humanoidLayerModel.m_6973_((LivingEntity)pLivingEntity, pLimbSwing, pLimbSwingAmount, pAgeInTicks, pNetHeadYaw, pHeadPitch);
            VertexConsumer vertexconsumer = pBuffer.m_6299_(RenderType.m_234335_((ResourceLocation)resourcelocation, (boolean)true));
            this.humanoidLayerModel.m_7695_(pPoseStack, vertexconsumer, pPackedLight, OverlayTexture.f_118083_, ((Float)colors[0].a).floatValue(), ((Float)colors[0].b).floatValue(), ((Float)colors[0].c).floatValue(), 0.75f);
            pPoseStack.m_85849_();
            if (flags[1]) {
                pPoseStack.m_85836_();
                pPoseStack.m_85837_(0.0, OnActionsTrigger.getYVector(0.125, player.m_146909_()), 0.125);
                ModelFollowingRenderer.followBodyRotations(pLivingEntity, new HumanoidModel[]{this.shadeHumanoidLayerModel});
                this.m_117386_().m_102624_(this.shadeHumanoidLayerModel);
                this.shadeHumanoidLayerModel.m_6973_((LivingEntity)pLivingEntity, pLimbSwing, pLimbSwingAmount, pAgeInTicks, pNetHeadYaw, pHeadPitch);
                this.shadeHumanoidLayerModel.m_7695_(pPoseStack, vertexconsumer, pPackedLight, OverlayTexture.f_118083_, 0.0f, 0.0f, 0.0f, 0.675f);
                pPoseStack.m_85849_();
                pPoseStack.m_85836_();
                pPoseStack.m_85837_(0.0, OnActionsTrigger.getYVector(0.15f, player.m_146909_()), 0.25);
                ModelFollowingRenderer.followBodyRotations(pLivingEntity, new HumanoidModel[]{this.shadeHumanoidLayerModel});
                this.m_117386_().m_102624_(this.shadeHumanoidLayerModel);
                this.shadeHumanoidLayerModel.m_6973_((LivingEntity)pLivingEntity, pLimbSwing, pLimbSwingAmount, pAgeInTicks, pNetHeadYaw, pHeadPitch);
                this.shadeHumanoidLayerModel.m_7695_(pPoseStack, vertexconsumer, pPackedLight, OverlayTexture.f_118083_, 0.0f, 0.0f, 0.0f, 0.5f);
                pPoseStack.m_85849_();
            }
        }
    }

    public boolean shouldRender(Player player) {
        boolean[] flags = new boolean[]{false, false};
        player.getCapability(ModCapabilities.MISTSPLITTER_DEFENCE).ifPresent(mistsplitterDefenseCapability -> {
            flags[0] = mistsplitterDefenseCapability.isDefenseModeOn();
        });
        player.getCapability(ModCapabilities.HALF_ZATOICHI_ABILITIES).ifPresent(halfZatoichiAbilityCapability -> {
            flags[1] = halfZatoichiAbilityCapability.isInAdrenalinMode();
        });
        return flags[0] || flags[1];
    }
}

