/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.wrathy_armament.client.renderer.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.sashakyotoz.wrathy_armament.Config;
import net.sashakyotoz.wrathy_armament.items.SwordLikeItem;
import net.sashakyotoz.wrathy_armament.utils.RenderUtils;

public class WeaponsOnBackLayer<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    private final EntityRendererProvider.Context wrathy_armament$context;

    public WeaponsOnBackLayer(RenderLayerParent<T, M> pRenderer, EntityRendererProvider.Context context) {
        super(pRenderer);
        this.wrathy_armament$context = context;
    }

    public void render(PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, T pLivingEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTick, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        if (pLivingEntity instanceof Player) {
            Player player = (Player)pLivingEntity;
            if (((Boolean)Config.Client.SHOW_WEAPON_ON_PLAYER_BACK.get()).booleanValue() && this.wrathy_armament$checkWeapon(player) && (((Boolean)Config.Client.SHOW_WEAPON_IF_ARMOR_EQUIP.get()).booleanValue() || !player.m_6844_(EquipmentSlot.CHEST).m_41619_())) {
                List<ItemStack> weaponsToShow = this.getWrathyArmamentWeapons(player);
                HashMap<Integer, Pair> weaponsLocation = new HashMap<Integer, Pair>();
                weaponsLocation.put(0, new Pair((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f)));
                weaponsLocation.put(1, new Pair((Object)Float.valueOf(1.0f), (Object)Float.valueOf(0.0f)));
                weaponsLocation.put(2, new Pair((Object)Float.valueOf(0.0f), (Object)Float.valueOf(1.0f)));
                weaponsLocation.put(3, new Pair((Object)Float.valueOf(-1.0f), (Object)Float.valueOf(0.0f)));
                weaponsLocation.put(4, new Pair((Object)Float.valueOf(0.0f), (Object)Float.valueOf(-1.0f)));
                weaponsToShow.forEach(stack -> {
                    int stackIndex = weaponsToShow.indexOf(stack);
                    float offsetY = RenderUtils.getOscillatingWithNegativeValue(player.f_19797_, 6) / 4.0f;
                    pPoseStack.m_85836_();
                    pPoseStack.m_85841_(0.75f, 0.75f, 0.75f);
                    pPoseStack.m_252781_(Axis.f_252403_.m_252977_(135.0f));
                    Pair offsetToApply = weaponsLocation.get(stackIndex) == null ? new Pair((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.25f + offsetY)) : (Pair)weaponsLocation.get(stackIndex);
                    pPoseStack.m_252880_(((Float)offsetToApply.getFirst()).floatValue() + offsetY, ((Float)offsetToApply.getSecond()).floatValue() + offsetY, 0.75f);
                    this.wrathy_armament$context.m_174025_().m_269128_(stack, ItemDisplayContext.FIXED, pPackedLight, OverlayTexture.f_118083_, pPoseStack, pBuffer, player.m_9236_(), 1);
                    pPoseStack.m_85849_();
                });
            }
        }
    }

    private List<ItemStack> getWrathyArmamentWeapons(Player player) {
        List<ItemStack> weapons = player.m_150109_().f_35974_.stream().filter(stack -> stack.m_41720_() instanceof SwordLikeItem && !player.m_21120_(InteractionHand.MAIN_HAND).equals(stack) && !player.m_21120_(InteractionHand.OFF_HAND).equals(stack)).toList();
        ArrayList<ItemStack> weaponsArray = new ArrayList<ItemStack>(weapons);
        if (weaponsArray.size() > 5) {
            weaponsArray.sort(Comparator.comparingInt(stack -> stack.m_41784_().m_128451_("Sparkles")));
            weaponsArray = new ArrayList<ItemStack>(weaponsArray.subList(weaponsArray.size() - 5, weaponsArray.size()));
        }
        return (Boolean)Config.Client.SHOW_ALL_WEAPONS_ON_PLAYER_BACK.get() != false ? weaponsArray : (weaponsArray.isEmpty() ? List.of(ItemStack.f_41583_) : List.of(weapons.get(0)));
    }

    private boolean wrathy_armament$checkWeapon(Player player) {
        return player.m_150109_().m_216874_(stack -> stack.m_41720_() instanceof SwordLikeItem);
    }
}

