/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.wrathy_armament.client.renderer.layers.moonlord;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.sashakyotoz.wrathy_armament.client.models.mobs.MoonLordModel;
import net.sashakyotoz.wrathy_armament.entities.bosses.MoonLord;

@OnlyIn(value=Dist.CLIENT)
public class MoonLordEmissiveLayer<T extends MoonLord, M extends MoonLordModel<T>>
extends RenderLayer<T, M> {
    private final ResourceLocation texture;
    private final AlphaFunction<T> alphaFunction;
    private final DrawSelector<T, M> drawSelector;

    public MoonLordEmissiveLayer(RenderLayerParent<T, M> pRenderer, ResourceLocation pTexture, AlphaFunction<T> pAlphaFunction, DrawSelector<T, M> pDrawSelector) {
        super(pRenderer);
        this.texture = pTexture;
        this.alphaFunction = pAlphaFunction;
        this.drawSelector = pDrawSelector;
    }

    public void render(PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, T pLivingEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTick, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        if (!pLivingEntity.m_20145_()) {
            this.onlyDrawSelectedParts();
            VertexConsumer vertexconsumer = pBuffer.m_6299_(RenderType.m_234338_((ResourceLocation)this.texture));
            ((MoonLordModel)this.m_117386_()).m_7695_(pPoseStack, vertexconsumer, pPackedLight, LivingEntityRenderer.m_115338_(pLivingEntity, (float)0.0f), 1.0f, 1.0f, 1.0f, this.alphaFunction.apply(pLivingEntity, pPartialTick, pAgeInTicks));
            this.resetDrawForAllParts();
        }
    }

    private void onlyDrawSelectedParts() {
        List<ModelPart> list = this.drawSelector.getPartsToDraw((MoonLordModel)this.m_117386_());
        ((MoonLordModel)this.m_117386_()).m_142109_().m_171331_().forEach(part -> {
            part.f_233556_ = true;
        });
        list.forEach(modelPart -> {
            modelPart.f_233556_ = false;
        });
    }

    private void resetDrawForAllParts() {
        ((MoonLordModel)this.m_117386_()).m_142109_().m_171331_().forEach(modelPart -> {
            modelPart.f_233556_ = false;
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface AlphaFunction<T extends MoonLord> {
        public float apply(T var1, float var2, float var3);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface DrawSelector<T extends MoonLord, M extends EntityModel<T>> {
        public List<ModelPart> getPartsToDraw(M var1);
    }
}

