/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.wrathy_armament.client.renderer.layers.moonlord;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.sashakyotoz.anitexlib.utils.TextureAnimator;
import net.sashakyotoz.wrathy_armament.client.models.mobs.MoonLordModel;
import net.sashakyotoz.wrathy_armament.entities.bosses.MoonLord;
import net.sashakyotoz.wrathy_armament.entities.bosses.core.MoonLordPart;

public class MoonLordEyesLayer
extends RenderLayer<MoonLord, MoonLordModel<MoonLord>> {
    private final ResourceLocation texture;
    private final MoonLordModel<MoonLord> lordModel;

    public MoonLordEyesLayer(RenderLayerParent<MoonLord, MoonLordModel<MoonLord>> pRenderer, ResourceLocation texture) {
        super(pRenderer);
        this.texture = texture;
        this.lordModel = (MoonLordModel)pRenderer.m_7200_();
    }

    public void render(PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, MoonLord moonLord, float pLimbSwing, float pLimbSwingAmount, float pPartialTick, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        if (moonLord.getMainParts().get(0).getHealthPoints() > 0.0f || moonLord.getMainParts().get(2).getHealthPoints() > 0.0f || moonLord.getMainParts().get(3).getHealthPoints() > 0.0f) {
            pPoseStack.m_85836_();
            float[] redModifier = new float[1];
            for (MoonLordPart moonLordPart : moonLord.getMainParts()) {
                if (moonLord.damageTakenByPart.get(moonLordPart.name) != null && moonLord.damageTakenByPart.get(moonLordPart.name) > 0) {
                    redModifier[0] = 1.0f;
                    break;
                }
                redModifier[0] = 0.0f;
            }
            float alphaModifier = this.getAlphaModifier(moonLord);
            ((MoonLordModel)this.m_117386_()).m_102624_((EntityModel)this.lordModel);
            this.lordModel.setupAnim(moonLord, pLimbSwing, pLimbSwingAmount, pAgeInTicks, pNetHeadYaw, pHeadPitch);
            VertexConsumer vertexconsumer = pBuffer.m_6299_(RenderType.m_234338_((ResourceLocation)this.texture));
            this.lordModel.m_7695_(pPoseStack, vertexconsumer, pPackedLight, OverlayTexture.f_118083_, 1.0f, 1.0f - redModifier[0], 1.0f - redModifier[0], alphaModifier);
            pPoseStack.m_85849_();
        }
    }

    private float getAlphaModifier(MoonLord moonLord) {
        float alphaModifier = 1.0f;
        if (this.texture.m_135815_().contains("hand")) {
            if (moonLord.getMainParts().get(2).getHealthPoints() <= 0.0f || moonLord.getMainParts().get(3).getHealthPoints() <= 0.0f) {
                alphaModifier = 0.35f;
            } else if (moonLord.getMainParts().get(2).getHealthPoints() <= 0.0f && moonLord.getMainParts().get(3).getHealthPoints() <= 0.0f) {
                alphaModifier = 0.25f;
            } else if (moonLord.getLordPose().equals((Object)MoonLord.LordPose.ATTACKING)) {
                alphaModifier = TextureAnimator.simpleAlphaFunction((float)0.5f, (float)moonLord.f_19797_);
            }
        }
        return alphaModifier;
    }
}

