/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.wrathy_armament.client.renderer.livings;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidArmorModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ArrowLayer;
import net.minecraft.client.renderer.entity.layers.BeeStingerLayer;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.layers.SpinAttackEffectLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.sashakyotoz.wrathy_armament.WrathyArmament;
import net.sashakyotoz.wrathy_armament.entities.alive.Guide;

public class GuideRenderer
extends LivingEntityRenderer<Guide, PlayerModel<Guide>> {
    public GuideRenderer(EntityRendererProvider.Context pContext, boolean pUseSlimModel) {
        super(pContext, (EntityModel)new PlayerModel(pContext.m_174023_(pUseSlimModel ? ModelLayers.f_171166_ : ModelLayers.f_171162_), pUseSlimModel), 0.5f);
        this.m_115326_((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, (HumanoidModel)new HumanoidArmorModel(pContext.m_174023_(pUseSlimModel ? ModelLayers.f_171167_ : ModelLayers.f_171164_)), (HumanoidModel)new HumanoidArmorModel(pContext.m_174023_(pUseSlimModel ? ModelLayers.f_171168_ : ModelLayers.f_171165_)), pContext.m_266367_()));
        this.m_115326_((RenderLayer)new ItemInHandLayer((RenderLayerParent)this, pContext.m_234598_()));
        this.m_115326_((RenderLayer)new ArrowLayer(pContext, (LivingEntityRenderer)this));
        this.m_115326_((RenderLayer)new CustomHeadLayer((RenderLayerParent)this, pContext.m_174027_(), pContext.m_234598_()));
        this.m_115326_((RenderLayer)new ElytraLayer((RenderLayerParent)this, pContext.m_174027_()));
        this.m_115326_((RenderLayer)new SpinAttackEffectLayer((RenderLayerParent)this, pContext.m_174027_()));
        this.m_115326_((RenderLayer)new BeeStingerLayer((LivingEntityRenderer)this));
    }

    public ResourceLocation getTextureLocation(Guide pEntity) {
        return WrathyArmament.createWALocation("textures/entity/the_guide.png");
    }

    public void render(Guide pEntity, float pEntityYaw, float pPartialTicks, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight) {
        super.m_7392_((LivingEntity)pEntity, pEntityYaw, pPartialTicks, pPoseStack, pBuffer, pPackedLight);
        this.setModelProperties(pEntity);
    }

    private void setModelProperties(Guide guide) {
        PlayerModel playermodel = (PlayerModel)this.m_7200_();
        playermodel.f_102817_ = guide.m_6047_();
        HumanoidModel.ArmPose humanoidmodel$armpose = GuideRenderer.getArmPose(guide, InteractionHand.MAIN_HAND);
        HumanoidModel.ArmPose humanoidmodel$armpose1 = GuideRenderer.getArmPose(guide, InteractionHand.OFF_HAND);
        if (humanoidmodel$armpose.m_102897_()) {
            HumanoidModel.ArmPose armPose = humanoidmodel$armpose1 = guide.m_21206_().m_41619_() ? HumanoidModel.ArmPose.EMPTY : HumanoidModel.ArmPose.ITEM;
        }
        if (guide.m_5737_() == HumanoidArm.RIGHT) {
            playermodel.f_102816_ = humanoidmodel$armpose;
            playermodel.f_102815_ = humanoidmodel$armpose1;
        } else {
            playermodel.f_102816_ = humanoidmodel$armpose1;
            playermodel.f_102815_ = humanoidmodel$armpose;
        }
    }

    public void setupRotations(Guide pEntityLiving, PoseStack pPoseStack, float pAgeInTicks, float pRotationYaw, float pPartialTicks) {
        if (this.m_5936_((LivingEntity)pEntityLiving)) {
            pRotationYaw += (float)(Math.cos((double)pEntityLiving.f_19797_ * 3.25) * Math.PI * (double)0.4f);
        }
        if (!pEntityLiving.m_217003_(Pose.SLEEPING)) {
            pPoseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - pRotationYaw));
        }
        if (GuideRenderer.m_194453_((LivingEntity)pEntityLiving)) {
            pPoseStack.m_252880_(0.0f, pEntityLiving.m_20206_() + 0.1f, 0.0f);
            pPoseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        }
    }

    private static HumanoidModel.ArmPose getArmPose(Guide pPlayer, InteractionHand pHand) {
        HumanoidModel.ArmPose forgeArmPose;
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        if (itemstack.m_41619_()) {
            return HumanoidModel.ArmPose.EMPTY;
        }
        if (pPlayer.m_7655_() == pHand && pPlayer.m_21212_() > 0) {
            UseAnim useanim = itemstack.m_41780_();
            if (useanim == UseAnim.BLOCK) {
                return HumanoidModel.ArmPose.BLOCK;
            }
            if (useanim == UseAnim.BOW) {
                return HumanoidModel.ArmPose.BOW_AND_ARROW;
            }
            if (useanim == UseAnim.SPEAR) {
                return HumanoidModel.ArmPose.THROW_SPEAR;
            }
            if (useanim == UseAnim.CROSSBOW && pHand == pPlayer.m_7655_()) {
                return HumanoidModel.ArmPose.CROSSBOW_CHARGE;
            }
            if (useanim == UseAnim.SPYGLASS) {
                return HumanoidModel.ArmPose.SPYGLASS;
            }
            if (useanim == UseAnim.TOOT_HORN) {
                return HumanoidModel.ArmPose.TOOT_HORN;
            }
            if (useanim == UseAnim.BRUSH) {
                return HumanoidModel.ArmPose.BRUSH;
            }
        } else if (!pPlayer.f_20911_ && itemstack.m_41720_() instanceof CrossbowItem && CrossbowItem.m_40932_((ItemStack)itemstack)) {
            return HumanoidModel.ArmPose.CROSSBOW_HOLD;
        }
        if ((forgeArmPose = IClientItemExtensions.of((ItemStack)itemstack).getArmPose((LivingEntity)pPlayer, pHand, itemstack)) != null) {
            return forgeArmPose;
        }
        return HumanoidModel.ArmPose.ITEM;
    }

    public void scale(Guide pLivingEntity, PoseStack pPoseStack, float pPartialTickTime) {
        float f = 0.9375f;
        pPoseStack.m_85841_(f, f, f);
    }
}

