/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.wrathy_armament.entities.ai_goals.bosses;

import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.pathfinder.Path;
import net.sashakyotoz.wrathy_armament.entities.bosses.JohannesKnight;
import net.sashakyotoz.wrathy_armament.utils.OnActionsTrigger;

public class JohannesKnightAttackGoal
extends Goal {
    private final JohannesKnight knight;
    private final double speedModifier;
    private final boolean followingTargetEvenIfNotSeen;
    private Path path;
    private double pathedTargetX;
    private double pathedTargetY;
    private double pathedTargetZ;
    private int ticksUntilNextPathRecalculation;
    private int ticksUntilNextAttack;
    private long lastCanUseCheck;

    public JohannesKnightAttackGoal(JohannesKnight knight, double speedModifier, boolean followIfInvisible) {
        this.knight = knight;
        this.speedModifier = speedModifier;
        this.followingTargetEvenIfNotSeen = followIfInvisible;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        long i = this.knight.m_9236_().m_46467_();
        if (i - this.lastCanUseCheck < 20L) {
            return false;
        }
        if (this.knight.getKnightPose() == JohannesKnight.KnightPose.DYING) {
            return false;
        }
        if (!this.knight.m_20096_()) {
            return false;
        }
        this.lastCanUseCheck = i;
        LivingEntity livingentity = this.knight.m_5448_();
        if (livingentity == null || !livingentity.m_6084_()) {
            return false;
        }
        this.path = this.knight.m_21573_().m_6570_((Entity)livingentity, 0);
        if (this.path != null) {
            return true;
        }
        return this.knight.m_217066_(livingentity);
    }

    public boolean m_8045_() {
        LivingEntity livingentity = this.knight.m_5448_();
        if (livingentity == null) {
            return false;
        }
        if (!livingentity.m_6084_()) {
            return false;
        }
        if (this.knight.getKnightPose() == JohannesKnight.KnightPose.DYING) {
            return false;
        }
        if (!this.followingTargetEvenIfNotSeen) {
            return this.knight.m_21573_().m_26572_();
        }
        if (!this.knight.m_21444_(livingentity.m_20183_())) {
            return false;
        }
        return !(livingentity instanceof Player) || !livingentity.m_5833_() && !((Player)livingentity).m_7500_();
    }

    public void m_8056_() {
        this.knight.m_21573_().m_26536_(this.path, this.speedModifier);
        this.knight.m_21561_(true);
        this.ticksUntilNextPathRecalculation = 0;
        this.ticksUntilNextAttack = 0;
    }

    public void m_8041_() {
        LivingEntity livingentity = this.knight.m_5448_();
        if (!EntitySelector.f_20406_.test(livingentity)) {
            this.knight.m_6710_(null);
        }
        this.knight.m_21561_(false);
        this.knight.setAttacking(false);
        this.knight.m_21573_().m_26573_();
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        LivingEntity livingentity = this.knight.m_5448_();
        if (livingentity != null) {
            double d0 = this.knight.m_20280_((Entity)livingentity);
            this.knight.m_21563_().m_24960_((Entity)livingentity, 30.0f, 30.0f);
            this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
            if ((this.followingTargetEvenIfNotSeen || this.knight.m_21574_().m_148306_((Entity)livingentity)) && this.ticksUntilNextPathRecalculation <= 0 && (this.pathedTargetX == 0.0 && this.pathedTargetY == 0.0 && this.pathedTargetZ == 0.0 || livingentity.m_20275_(this.pathedTargetX, this.pathedTargetY, this.pathedTargetZ) >= 0.5 || this.knight.m_217043_().m_188501_() < 0.05f)) {
                this.pathedTargetX = livingentity.m_20185_();
                this.pathedTargetY = livingentity.m_20186_();
                this.pathedTargetZ = livingentity.m_20189_();
                this.ticksUntilNextPathRecalculation = 4 + this.knight.m_217043_().m_188503_(7);
                if (d0 > 1024.0) {
                    this.ticksUntilNextPathRecalculation += 10;
                } else if (d0 > 256.0) {
                    this.ticksUntilNextPathRecalculation += 5;
                }
                if (!this.knight.m_21573_().m_5624_((Entity)livingentity, this.speedModifier)) {
                    this.ticksUntilNextPathRecalculation += 15;
                }
                this.ticksUntilNextPathRecalculation = this.m_183277_(this.ticksUntilNextPathRecalculation);
            }
            this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
            this.checkAndPerformAttack(livingentity);
        }
    }

    private void checkAndPerformAttack(LivingEntity entity) {
        if (this.canPerformAttack(entity)) {
            if (this.knight.getKnightPose() == JohannesKnight.KnightPose.IDLING) {
                this.knight.setRandomPose();
            }
            switch (this.knight.getKnightPose()) {
                case ATTACKING: {
                    this.knight.setAttacking(true);
                    OnActionsTrigger.queueServerWork(20, () -> {
                        if (this.knight.m_20280_((Entity)entity) < 16.0) {
                            this.knight.m_7327_((Entity)entity);
                        }
                        this.knight.setAttacking(false);
                        this.knight.setRandomPose();
                    });
                    break;
                }
                case SHOOTING: {
                    if (this.knight.isInSecondPhase()) {
                        this.knight.johannesSwordAbility();
                        break;
                    }
                    this.knight.johannesSwordBackwardsDash();
                    break;
                }
                case JUMPING: {
                    this.knight.johannesSwordDash();
                    break;
                }
                case DASHING: {
                    this.knight.dashing();
                }
            }
            this.resetAttackCooldown();
        }
    }

    protected void resetAttackCooldown() {
        this.ticksUntilNextAttack = this.m_183277_(20);
    }

    private boolean isTimeToAttack() {
        return this.ticksUntilNextAttack <= 0;
    }

    public boolean isWithinExtendedMeleeAttackRange(LivingEntity entity) {
        double d0 = this.knight.m_262793_(entity);
        return d0 <= this.knight.m_142593_(entity) * 1.25;
    }

    private boolean canPerformAttack(LivingEntity entity) {
        return this.isTimeToAttack() && this.isWithinExtendedMeleeAttackRange(entity) && this.knight.m_21574_().m_148306_((Entity)entity);
    }
}

