/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.wrathy_armament.entities.alive;

import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.sashakyotoz.wrathy_armament.entities.bosses.BossLikePathfinderMob;
import net.sashakyotoz.wrathy_armament.registers.WrathyArmamentItems;

public class Guide
extends PathfinderMob
implements RangedAttackMob {
    private final RangedBowAttackGoal<Guide> bowGoal = new RangedBowAttackGoal((Mob)this, 1.0, 20, 15.0f);
    private final MeleeAttackGoal meleeGoal = new MeleeAttackGoal((PathfinderMob)this, 1.2, false);

    public Guide(EntityType<? extends PathfinderMob> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        GuideNames[] poses = GuideNames.values();
        GuideNames currentPose = poses[this.f_19796_.m_188503_(poses.length)];
        this.m_6593_((Component)Component.m_237113_((String)currentPose.gName));
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, BossLikePathfinderMob.class, 6.0f, 1.0, 1.2));
        this.f_21345_.m_25352_(4, (Goal)new OpenDoorGoal((Mob)this, true));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Monster.class, true));
    }

    public boolean m_7307_(Entity pEntity) {
        return pEntity instanceof Guide || pEntity instanceof Player;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ % 500 == 0) {
            this.m_21008_(InteractionHand.MAIN_HAND, this.f_19796_.m_188499_() ? new ItemStack((ItemLike)Items.f_42411_) : new ItemStack((ItemLike)Items.f_42383_));
            this.reassessWeaponGoal();
        }
        if (this.m_5448_() != null) {
            Player player;
            if (this.f_19797_ % 60 == 0 && this.m_21223_() < this.m_21233_() && !this.m_21023_(MobEffects.f_19605_) && !this.m_9236_().m_5776_()) {
                this.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 40, 1));
            }
            if (this.f_19797_ % 5 == 0 && (player = this.m_9236_().m_45930_((Entity)this, 48.0)) != null && player.m_21188_() != null) {
                this.m_6710_(player.m_21188_());
            }
        }
    }

    public void m_6504_(LivingEntity pTarget, float pDistanceFactor) {
        ItemStack itemstack = this.m_6298_(this.m_21120_(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this, item -> item instanceof BowItem)));
        AbstractArrow abstractarrow = ProjectileUtil.m_37300_((LivingEntity)this, (ItemStack)itemstack, (float)pDistanceFactor);
        if (this.m_21205_().m_41720_() instanceof BowItem) {
            abstractarrow = ((BowItem)this.m_21205_().m_41720_()).customArrow(abstractarrow);
        }
        double d0 = pTarget.m_20185_() - this.m_20185_();
        double d1 = pTarget.m_20227_(0.34) - abstractarrow.m_20186_();
        double d2 = pTarget.m_20189_() - this.m_20189_();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        abstractarrow.m_6686_(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.m_9236_().m_46791_().m_19028_() * 4));
        this.m_5496_(SoundEvents.f_11847_, 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
        this.m_9236_().m_7967_((Entity)abstractarrow);
    }

    public void reassessWeaponGoal() {
        if (!this.m_9236_().f_46443_) {
            this.f_21345_.m_25363_((Goal)this.meleeGoal);
            this.f_21345_.m_25363_(this.bowGoal);
            ItemStack itemstack = this.m_21120_(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this, item -> item instanceof BowItem));
            if (itemstack.m_150930_(Items.f_42411_)) {
                int i = 20;
                if (this.m_9236_().m_46791_() != Difficulty.HARD) {
                    i = 40;
                }
                this.bowGoal.m_25797_(i);
                this.f_21345_.m_25352_(4, this.bowGoal);
            } else {
                this.f_21345_.m_25352_(4, (Goal)this.meleeGoal);
            }
        }
    }

    public void m_6667_(DamageSource source) {
        Entity entity = source.m_7639_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (this.m_9236_().m_45527_(this.m_20097_().m_7494_()) && this.m_9236_().m_46462_()) {
                player.m_7197_(((Item)WrathyArmamentItems.LUNAR_VOODOO_DOLL.get()).m_7968_(), true, false);
            }
        }
        super.m_6667_(source);
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        return super.m_6469_(pSource, pAmount) && pSource.m_7639_() instanceof Player;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22282_, 0.1).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22284_, 8.0).m_22268_(Attributes.f_22285_, 2.0).m_22268_(Attributes.f_22279_, 0.3);
    }

    static enum GuideNames {
        ANDREW("Andrew"),
        ASHER("Asher"),
        BRANDON("Brandon"),
        BRETT("Brett"),
        BRIAN("Brian"),
        CODY("Cody"),
        COLIN("Colin"),
        CONNOR("Connor"),
        DYLAN("Dylan"),
        DANIEL("Daniel"),
        JACK("Jack"),
        KYLE("Kyle"),
        MARTY("Marty"),
        RYAN("Ryan"),
        TANNER("Tanner"),
        ZACH("Zach"),
        WYATT("Wyatt"),
        SCOT("Scot"),
        BRADLY("Bradly");

        public final String gName;

        private GuideNames(String gName) {
            this.gName = gName;
        }
    }
}

