/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.wrathy_armament.entities.bosses;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.sashakyotoz.wrathy_armament.entities.ai_goals.ResetAngerTargetGoal;
import net.sashakyotoz.wrathy_armament.entities.bosses.core.PersistentAngerMob;
import net.sashakyotoz.wrathy_armament.registers.WrathyArmamentMiscRegistries;
import org.jetbrains.annotations.NotNull;

public abstract class BossLikePathfinderMob
extends PathfinderMob
implements Enemy,
PersistentAngerMob {
    public static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.m_135353_(BossLikePathfinderMob.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DATA_REMAINING_ANGER_TIME = SynchedEntityData.m_135353_(BossLikePathfinderMob.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public int attackAnimationTimeout = 30;
    public final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)36000, (int)1080000);
    @Nullable
    public UUID persistentAngerTarget;
    private final Collection<AbstractMap.SimpleEntry<Runnable, Integer>> workQueue = new ConcurrentLinkedQueue<AbstractMap.SimpleEntry<Runnable, Integer>>();

    public void queueServerWork(int tick, Runnable action) {
        this.workQueue.add(new AbstractMap.SimpleEntry<Runnable, Integer>(action, tick));
    }

    public BossLikePathfinderMob(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(ATTACKING, (Object)false);
        this.f_19804_.m_135372_(DATA_REMAINING_ANGER_TIME, (Object)0);
        super.m_8097_();
    }

    @Override
    public int getRemainingPersistentAngerTime() {
        return (Integer)this.f_19804_.m_135370_(DATA_REMAINING_ANGER_TIME);
    }

    @Override
    public void setRemainingPersistentAngerTime(int i) {
        this.f_19804_.m_135381_(DATA_REMAINING_ANGER_TIME, (Object)i);
    }

    @Override
    public void startPersistentAngerTimer() {
        this.setRemainingPersistentAngerTime(this.PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    @Override
    @Nullable
    public UUID getPersistentAngerTarget() {
        return this.persistentAngerTarget;
    }

    @Override
    public void setPersistentAngerTarget(@Nullable UUID uuid) {
        this.persistentAngerTarget = uuid;
    }

    public void setAttacking(boolean tmp) {
        this.f_19804_.m_135381_(ATTACKING, (Object)tmp);
    }

    public boolean isAttacking() {
        return (Boolean)this.f_19804_.m_135370_(ATTACKING);
    }

    public boolean m_6785_(double distance) {
        return false;
    }

    public void spawnParticle(Level level, double x, double y, double z, float modifier) {
        this.spawnParticle((ParticleOptions)WrathyArmamentMiscRegistries.FROST_SOUL_RAY.get(), level, x, y, z, modifier);
    }

    protected void m_8099_() {
        this.f_21346_.m_25352_(1, new ResetAngerTargetGoal<BossLikePathfinderMob>(this, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, false));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        super.m_8099_();
    }

    public void m_8107_() {
        this.m_21203_();
        this.updateNoActionTime();
        super.m_8107_();
    }

    public void m_8119_() {
        ArrayList actions = new ArrayList();
        this.workQueue.forEach(work -> {
            work.setValue((Integer)work.getValue() - 1);
            if ((Integer)work.getValue() == 0) {
                actions.add(work);
            }
        });
        actions.forEach(e -> ((Runnable)e.getKey()).run());
        this.workQueue.removeAll(actions);
        super.m_8119_();
    }

    protected void updateNoActionTime() {
        float f = this.m_213856_();
        if (f > 0.5f) {
            this.f_20891_ += 2;
        }
    }

    protected boolean m_7341_(Entity pEntity) {
        return false;
    }

    public boolean m_6149_() {
        return true;
    }

    public void spawnParticle(ParticleOptions type, Level level, double x, double y, double z, float modifier) {
        for (int i = 0; i < 360; ++i) {
            if (i % 20 != 0) continue;
            level.m_7106_(type, x + 0.25, y, z + 0.25, Math.cos(i) * 0.25 * (double)modifier, 0.2, Math.sin(i) * 0.25 * (double)modifier);
        }
    }

    public void hitNearbyMobs(final Component customDeathName, float damage, int radius) {
        List<Entity> entityList = this.m_9236_().m_6443_(Entity.class, new AABB(this.centerOfMob(), this.centerOfMob()).m_82400_((double)radius), e -> true).stream().sorted(Comparator.comparingDouble(entity -> entity.m_20238_(this.centerOfMob()))).toList();
        for (Entity entityIterator : entityList) {
            if (entityIterator == this || !(entityIterator instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entityIterator;
            livingEntity.m_6469_(new DamageSource((Holder)livingEntity.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268433_)){

                public Component m_6157_(@NotNull LivingEntity _msgEntity) {
                    return customDeathName;
                }
            }, damage);
            break;
        }
    }

    public void hitNearbyMobs(float damage, int radius) {
        List<LivingEntity> entityList = this.m_9236_().m_6443_(LivingEntity.class, new AABB(this.centerOfMob(), this.centerOfMob()).m_82400_((double)radius), e -> true).stream().sorted(Comparator.comparingDouble(entity -> entity.m_20238_(this.centerOfMob()))).toList();
        for (LivingEntity entityIterator : entityList) {
            if (entityIterator == this) continue;
            entityIterator.m_6469_(this.m_269291_().m_269425_(), damage);
            break;
        }
    }

    private Vec3 centerOfMob() {
        return new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_());
    }

    public void m_213846_(Component component) {
        super.m_213846_(component);
    }

    public abstract ServerBossEvent bossInfo();

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        this.bossInfo().m_6543_(player);
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        this.bossInfo().m_6539_(player);
    }

    public void m_8024_() {
        super.m_8024_();
        this.bossInfo().m_142711_(this.m_21223_() / this.m_21233_());
    }

    public double getXVector(double speed, double yaw) {
        return speed * Math.cos((yaw + 90.0) * (Math.PI / 180));
    }

    public double getZVector(double speed, double yaw) {
        return speed * Math.sin((yaw + 90.0) * (Math.PI / 180));
    }

    public boolean isMoving() {
        return this.m_20184_().m_165925_() > 1.0E-6;
    }
}

