/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.wrathy_armament.entities.bosses;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.BossEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.AmphibiousPathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.sashakyotoz.wrathy_armament.entities.ai_goals.bosses.HabciakMovementGoal;
import net.sashakyotoz.wrathy_armament.entities.bosses.BossLikePathfinderMob;
import net.sashakyotoz.wrathy_armament.registers.WrathyArmamentItems;
import net.sashakyotoz.wrathy_armament.registers.WrathyArmamentMiscRegistries;
import net.sashakyotoz.wrathy_armament.utils.OnActionsTrigger;

public class Habciak
extends BossLikePathfinderMob {
    private final ServerBossEvent bossEvent = new ServerBossEvent((Component)Component.m_237115_((String)"boss.wrathy_armament.habciak"), BossEvent.BossBarColor.WHITE, BossEvent.BossBarOverlay.NOTCHED_6);
    private static final EntityDataAccessor<HabciakPose> DATA_HABCIAK_POSE = SynchedEntityData.m_135353_(Habciak.class, (EntityDataSerializer)((EntityDataSerializer)WrathyArmamentMiscRegistries.HABCIAK_POSE.get()));
    public final AnimationState death = new AnimationState();
    public final AnimationState jump = new AnimationState();
    public final AnimationState floorAttack = new AnimationState();
    public final AnimationState backFlip = new AnimationState();
    public final AnimationState mirrorCasting = new AnimationState();
    public final AnimationState splash = new AnimationState();
    public int backFlipRotation = 0;

    public Habciak(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
        this.f_21344_ = new AmphibiousPathNavigation((Mob)this, this.m_9236_());
    }

    public Player playerToRender() {
        Player player;
        LivingEntity livingEntity = this.m_5448_();
        return livingEntity instanceof Player ? (player = (Player)livingEntity) : this.m_9236_().m_45930_((Entity)this, 24.0);
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new HabciakMovementGoal(this));
        super.m_8099_();
    }

    protected void m_267689_(float pPartialTick) {
        float f = Math.min(pPartialTick * 4.0f, 1.0f);
        this.f_267362_.m_267566_(this.m_20096_() ? f : 0.0f, 0.4f);
    }

    @Override
    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_HABCIAK_POSE, (Object)HabciakPose.IDLING);
        super.m_8097_();
    }

    private void setHabciakPose(HabciakPose knightPose) {
        this.f_19804_.m_135381_(DATA_HABCIAK_POSE, (Object)knightPose);
    }

    public HabciakPose getHabciakPose() {
        return (HabciakPose)((Object)this.f_19804_.m_135370_(DATA_HABCIAK_POSE));
    }

    public boolean isInPose(HabciakPose phase) {
        return this.getHabciakPose() == phase;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.backFlipRotation > 0) {
            --this.backFlipRotation;
        }
        if (this.f_19797_ % 5 == 0) {
            LivingEntity livingEntity;
            if (this.m_5448_() != null && this.isInPose(HabciakPose.IDLING)) {
                this.changePose();
            }
            if (this.m_21223_() < 480.0f && this.m_21120_(InteractionHand.MAIN_HAND).m_150930_(Items.f_42437_)) {
                this.m_5634_(1.0f);
                this.m_5496_(SoundEvents.f_11912_, 1.5f, 2.0f);
            }
            if ((livingEntity = this.m_5448_()) instanceof Player) {
                Player player = (Player)livingEntity;
                this.m_8061_(EquipmentSlot.HEAD, player.m_6844_(EquipmentSlot.HEAD));
                this.m_8061_(EquipmentSlot.CHEST, player.m_6844_(EquipmentSlot.CHEST));
                if (this.m_6844_(EquipmentSlot.CHEST).m_41720_() instanceof ElytraItem) {
                    if (this.m_20096_() && this.m_217043_().m_216339_(0, 11) == 5) {
                        this.m_246865_(new Vec3(0.0, 1.0, 0.0));
                    }
                    if (!this.m_20096_()) {
                        this.m_20115_(7, true);
                    }
                    if (this.m_21255_()) {
                        this.m_20256_(new Vec3(OnActionsTrigger.getXVector(0.25, this.m_146908_()), this.m_20184_().m_7098_(), OnActionsTrigger.getZVector(0.25, this.m_146908_())));
                    }
                }
                this.m_8061_(EquipmentSlot.LEGS, player.m_6844_(EquipmentSlot.LEGS));
                this.m_8061_(EquipmentSlot.FEET, player.m_6844_(EquipmentSlot.FEET));
                this.m_8061_(EquipmentSlot.OFFHAND, player.m_6844_(EquipmentSlot.OFFHAND));
                if (!this.isInPose(HabciakPose.BYPASSING)) {
                    this.m_21008_(InteractionHand.MAIN_HAND, this.isInPose(HabciakPose.MIRROR_CASTING) ? ((Item)WrathyArmamentItems.MIRROR_SWORD.get()).m_7968_() : player.m_21205_());
                }
            }
        }
    }

    public void m_7350_(EntityDataAccessor<?> dataAccessor) {
        if (DATA_HABCIAK_POSE.equals(dataAccessor)) {
            if (!this.isInPose(HabciakPose.MIRROR_CASTING)) {
                this.mirrorCasting.m_216973_();
            }
            if (!this.isInPose(HabciakPose.JUMPING)) {
                this.jump.m_216973_();
            }
            if (!this.isInPose(HabciakPose.BACKFLIPPING)) {
                this.backFlip.m_216973_();
            }
            switch (this.getHabciakPose()) {
                case JUMPING: {
                    this.jump.m_216977_(this.f_19797_);
                    this.spawnParticle((ParticleOptions)ParticleTypes.f_123796_, this.m_9236_(), this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), 1.5f);
                    this.queueServerWork(30, this::changePose);
                    break;
                }
                case BACKFLIPPING: {
                    this.backFlip.m_216977_(this.f_19797_);
                    this.queueServerWork(20, () -> this.m_20334_(-this.getXVector(1.0, this.m_146908_()), 0.75, -this.getZVector(1.0, this.m_146908_())));
                    this.queueServerWork(50, this::changePose);
                    break;
                }
                case ATTACKING: {
                    this.floorAttack.m_216977_(this.f_19797_);
                    this.queueServerWork(50, () -> {
                        if (this.m_5448_() != null && this.m_5448_().m_20280_((Entity)this) < 9.0) {
                            this.m_19970_((LivingEntity)this, (Entity)this.m_5448_());
                        }
                    });
                    this.queueServerWork(60, this::changePose);
                    break;
                }
                case BYPASSING: {
                    this.m_21008_(InteractionHand.MAIN_HAND, Items.f_42437_.m_7968_());
                    this.m_6672_(InteractionHand.MAIN_HAND);
                    this.queueServerWork(100, this::changePose);
                    break;
                }
                case MIRROR_CASTING: {
                    this.mirrorCasting.m_216977_(this.f_19797_);
                    this.queueServerWork(50, () -> {
                        this.shootTakenDamage();
                        this.changePose();
                    });
                    break;
                }
                case SPLASH: {
                    this.splash.m_216977_(this.f_19797_);
                    this.m_5496_(SoundEvents.f_215695_, 1.5f, 2.0f);
                    this.queueServerWork(20, () -> this.m_20256_(new Vec3(this.getXVector(0.75, this.m_146908_()), 0.65, this.getZVector(0.75, this.m_146908_()))));
                    this.queueServerWork(40, () -> {
                        this.hitNearbyMobs(12.0f, 7);
                        this.changePose();
                    });
                }
            }
        }
        super.m_7350_(dataAccessor);
    }

    private void changePose() {
        switch (this.getHabciakPose()) {
            case BYPASSING: 
            case IDLING: {
                this.setHabciakPose(HabciakPose.ATTACKING);
                break;
            }
            case ATTACKING: {
                this.setHabciakPose(HabciakPose.BACKFLIPPING);
                break;
            }
            case BACKFLIPPING: {
                this.setHabciakPose(HabciakPose.JUMPING);
                break;
            }
            case JUMPING: {
                this.setHabciakPose(HabciakPose.MIRROR_CASTING);
                break;
            }
            case MIRROR_CASTING: {
                this.setHabciakPose(HabciakPose.SPLASH);
                break;
            }
            case SPLASH: {
                this.setHabciakPose(HabciakPose.BYPASSING);
            }
        }
    }

    private void shootTakenDamage() {
        if (this.isInPose(HabciakPose.MIRROR_CASTING)) {
            Vec3 eyePos = this.m_146892_();
            Vec3 lookVec = this.m_20252_(1.0f);
            Vec3 endPos = eyePos.m_82549_(lookVec.m_82490_(9.0));
            int particleCount = 20;
            Vec3 step = endPos.m_82546_(eyePos).m_82490_(1.0 / (double)particleCount);
            double radius = 0.25;
            for (int v = 0; v < 180; ++v) {
                for (int j = 0; j < particleCount; ++j) {
                    Vec3 basePos = eyePos.m_82549_(step.m_82490_((double)j));
                    double angle = (double)v * Math.PI / 20.0 + (double)j * Math.PI / 10.0;
                    double offsetX = radius * Math.cos(angle);
                    double offsetY = radius * Math.sin(angle);
                    Vec3 perpendicular = lookVec.m_82537_(new Vec3(0.0, 1.0, 0.0)).m_82541_();
                    Vec3 particlePos = basePos.m_82549_(perpendicular.m_82490_(offsetX)).m_82520_(0.0, offsetY, 0.0);
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123796_, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 0.0, 0.0, 0.0);
                }
            }
            this.hitNearbyMobs(12.0f, 9);
        }
    }

    protected void m_5907_() {
        this.m_19998_((ItemLike)WrathyArmamentItems.MIRROR_SWORD.get());
    }

    protected void m_6153_() {
        float sin = (float)Math.sin((double)this.f_20919_ * Math.PI / 10.0);
        float cos = (float)Math.cos((double)this.f_20919_ * Math.PI / 10.0);
        float tan = (float)Math.tan((double)this.f_20919_ * Math.PI / 10.0);
        if (this.m_9236_().f_46443_) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123810_, this.m_20185_() + (double)sin, this.m_20186_() + 0.5 + (double)(tan * cos * sin), this.m_20189_() + (double)cos, 0.0, 0.0, 0.0);
        }
        if (this.f_20919_ == 0) {
            this.death.m_216977_(this.f_19797_);
        }
        super.m_6153_();
    }

    public void m_6667_(DamageSource source) {
        this.setHabciakPose(HabciakPose.DYING);
        this.f_20919_ = -80;
        super.m_6667_(source);
    }

    @Override
    public ServerBossEvent bossInfo() {
        return this.bossEvent;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 500.0).m_22268_(Attributes.f_22281_, 12.0).m_22268_(Attributes.f_22277_, 48.0).m_22268_(Attributes.f_22284_, 8.0).m_22268_(Attributes.f_22285_, 8.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22278_, 0.5);
    }

    public static enum HabciakPose {
        DYING,
        ATTACKING,
        MIRROR_CASTING,
        BACKFLIPPING,
        BYPASSING,
        JUMPING,
        SPLASH,
        IDLING;

    }
}

