/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.wrathy_armament.entities.bosses;

import javax.annotation.Nullable;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.sashakyotoz.anitexlib.client.particles.parents.options.ColorableParticleOption;
import net.sashakyotoz.wrathy_armament.entities.ai_goals.bosses.JohannesKnightAttackGoal;
import net.sashakyotoz.wrathy_armament.entities.bosses.BossLikePathfinderMob;
import net.sashakyotoz.wrathy_armament.entities.technical.HarmfulProjectileEntity;
import net.sashakyotoz.wrathy_armament.entities.technical.JohannesSpearEntity;
import net.sashakyotoz.wrathy_armament.registers.WrathyArmamentEntities;
import net.sashakyotoz.wrathy_armament.registers.WrathyArmamentItems;
import net.sashakyotoz.wrathy_armament.registers.WrathyArmamentMiscRegistries;
import net.sashakyotoz.wrathy_armament.registers.WrathyArmamentSounds;
import org.jetbrains.annotations.NotNull;

public class JohannesKnight
extends BossLikePathfinderMob
implements RangedAttackMob {
    private static final EntityDataAccessor<Boolean> IS_IN_SECOND_PHASE = SynchedEntityData.m_135353_(JohannesKnight.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<KnightPose> DATA_KNIGHT_POSE = SynchedEntityData.m_135353_(JohannesKnight.class, (EntityDataSerializer)((EntityDataSerializer)WrathyArmamentMiscRegistries.KNIGHT_POSE.get()));
    private final ServerBossEvent bossEvent = new ServerBossEvent((Component)Component.m_237115_((String)"boss.wrathy_armament.johannes_knight"), BossEvent.BossBarColor.WHITE, BossEvent.BossBarOverlay.NOTCHED_10);
    public static final EntityDimensions KNIGHT_DIMENSIONS = EntityDimensions.m_20398_((float)0.8f, (float)1.9f);
    public static final EntityDimensions FOUNTAIN_DIMENSIONS = EntityDimensions.m_20398_((float)1.5f, (float)2.6f);
    public final AnimationState jumpKnight = new AnimationState();
    public final AnimationState attackKnight = new AnimationState();
    public final AnimationState deathKnight = new AnimationState();
    public final AnimationState attackFountain = new AnimationState();
    public final AnimationState dashFountain = new AnimationState();
    public final AnimationState daggerAttackFountain = new AnimationState();
    public final AnimationState deathFountain = new AnimationState();

    public JohannesKnight(EntityType<? extends JohannesKnight> type, Level level) {
        super(type, level);
        this.m_274367_(1.5f);
        this.f_21364_ = 50;
        this.m_21468_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)WrathyArmamentItems.JOHANNES_SWORD.get()));
    }

    @Override
    protected void m_8097_() {
        this.f_19804_.m_135372_(IS_IN_SECOND_PHASE, (Object)false);
        this.f_19804_.m_135372_(DATA_KNIGHT_POSE, (Object)KnightPose.ATTACKING);
        super.m_8097_();
    }

    private void setIsInSecondPhase(boolean b) {
        this.f_19804_.m_135381_(IS_IN_SECOND_PHASE, (Object)b);
    }

    public boolean isInSecondPhase() {
        return (Boolean)this.f_19804_.m_135370_(IS_IN_SECOND_PHASE);
    }

    public void johannesSwordAbility() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            double Yaw = this.m_146908_();
            double d0 = this.getXVector(3.0, Yaw);
            double d1 = (double)this.m_146909_() * -0.025 + 0.5;
            double d2 = this.getZVector(3.0, Yaw);
            for (int l = 0; l < 16; ++l) {
                this.createSpellEntity(level2, d0 * 2.0, d1, d2 * 2.0, l);
            }
        }
        this.queueServerWork(20, this::setRandomPose);
    }

    private void createSpellEntity(ServerLevel level, double vx, double vy, double vz, int i) {
        level.m_7967_((Entity)new JohannesSpearEntity((Level)level, this.m_20185_() + vx * (double)i, this.m_20186_() + vy, this.m_20189_() + vz * (double)i, 0.0f, i, (LivingEntity)this));
        level.m_7967_((Entity)new JohannesSpearEntity((Level)level, this.m_20185_() + vx * (double)i + 1.0, this.m_20186_() + vy, this.m_20189_() + vz * (double)i + 1.0, 0.0f, i, (LivingEntity)this));
        level.m_7967_((Entity)new JohannesSpearEntity((Level)level, this.m_20185_() + vx * (double)i - 1.0, this.m_20186_() + vy, this.m_20189_() + vz * (double)i - 1.0, 0.0f, i, (LivingEntity)this));
        level.m_7967_((Entity)new JohannesSpearEntity((Level)level, this.m_20185_() + vx * (double)i + 1.0, this.m_20186_() + vy, this.m_20189_() + vz * (double)i + 1.0, 0.0f, i, (LivingEntity)this));
        level.m_7967_((Entity)new JohannesSpearEntity((Level)level, this.m_20185_() + vx * (double)i + 1.0, this.m_20186_() + vy, this.m_20189_() + vz * (double)i - 1.0, 0.0f, i, (LivingEntity)this));
        level.m_214171_(GameEvent.f_157810_, new Vec3(this.m_20185_() + vx * (double)i, this.m_20186_() + vy, this.m_20189_() + vz * (double)i), GameEvent.Context.m_223717_((Entity)this));
    }

    private void setKnightPose(KnightPose knightPose) {
        this.f_19804_.m_135381_(DATA_KNIGHT_POSE, (Object)knightPose);
    }

    public KnightPose getKnightPose() {
        return (KnightPose)((Object)this.f_19804_.m_135370_(DATA_KNIGHT_POSE));
    }

    private void applyDarknessAround(ServerLevel level, Vec3 vec3, @Nullable Entity entity, int i) {
        MobEffectInstance mobeffectinstance = new MobEffectInstance(MobEffects.f_216964_, 260, 0, false, false);
        MobEffectUtil.m_216946_((ServerLevel)level, (Entity)entity, (Vec3)vec3, (double)i, (MobEffectInstance)mobeffectinstance, (int)200);
    }

    public void m_7350_(@NotNull EntityDataAccessor<?> dataAccessor) {
        if (DATA_KNIGHT_POSE.equals(dataAccessor)) {
            if (this.getKnightPose() == KnightPose.DYING) {
                if (!this.isInSecondPhase()) {
                    Level level;
                    if (!this.deathKnight.m_216984_()) {
                        this.deathKnight.m_216977_(this.f_19797_);
                    }
                    if ((level = this.m_9236_()) instanceof ServerLevel) {
                        ServerLevel level2 = (ServerLevel)level;
                        this.applyDarknessAround(level2, Vec3.m_82512_((Vec3i)this.m_20097_()), (Entity)this, 20);
                    }
                    this.m_6210_();
                    this.queueServerWork(40, () -> this.setIsInSecondPhase(true));
                    this.queueServerWork(50, () -> this.dashFountain.m_216977_(this.f_19797_));
                    this.queueServerWork(70, () -> this.setKnightPose(KnightPose.ATTACKING));
                } else if (!this.deathFountain.m_216984_()) {
                    this.deathFountain.m_216977_(this.f_19797_);
                }
            } else if (this.getKnightPose() == KnightPose.IDLING && this.m_5448_() != null) {
                this.queueServerWork(50, this::setRandomPose);
            } else if (this.m_5448_() != null) {
                switch (this.getKnightPose()) {
                    case JUMPING: {
                        if (this.jumpKnight.m_216984_()) break;
                        this.jumpKnight.m_216977_(this.f_19797_);
                        break;
                    }
                    case DASHING: {
                        if (this.dashFountain.m_216984_()) break;
                        this.dashFountain.m_216977_(this.f_19797_);
                        break;
                    }
                    case SHOOTING: {
                        if (this.daggerAttackFountain.m_216984_()) break;
                        this.daggerAttackFountain.m_216977_(this.f_19797_);
                    }
                }
            }
        }
        super.m_7350_(dataAccessor);
    }

    public void m_8108_() {
        this.m_6210_();
        if (this.getKnightPose() == KnightPose.ATTACKING) {
            this.setRandomPose();
        }
        super.m_8108_();
    }

    @NotNull
    public EntityDimensions m_6972_(Pose pose) {
        return !this.isInSecondPhase() ? FOUNTAIN_DIMENSIONS : KNIGHT_DIMENSIONS;
    }

    public void m_6075_() {
        if (this.isAttacking() && this.attackAnimationTimeout <= 0) {
            this.attackAnimationTimeout = 20;
            if (this.isInSecondPhase()) {
                this.attackFountain.m_216977_(this.f_19797_);
            } else {
                this.attackKnight.m_216977_(this.f_19797_);
            }
        } else {
            --this.attackAnimationTimeout;
        }
        this.bossEvent.m_6456_((Component)(this.isInSecondPhase() ? Component.m_237115_((String)"boss.wrathy_armament.johannes_fountain") : Component.m_237115_((String)"boss.wrathy_armament.johannes_knight")));
        this.bossEvent.m_6451_(this.isInSecondPhase() ? BossEvent.BossBarColor.RED : BossEvent.BossBarColor.WHITE);
        this.bossEvent.m_7003_(this.getKnightPose() == KnightPose.DYING);
        super.m_6075_();
    }

    public void m_8098_() {
        if (this.m_21223_() < this.m_21233_() && this.f_19796_.m_188499_()) {
            this.queueServerWork(30, () -> this.setKnightPose(KnightPose.IDLING));
        }
        super.m_8098_();
    }

    public void setRandomPose() {
        int random = this.f_19796_.m_216332_(0, 2);
        block0 : switch (this.getKnightPose()) {
            case SHOOTING: {
                switch (random) {
                    case 1: {
                        this.setKnightPose(KnightPose.DASHING);
                        break block0;
                    }
                    case 2: {
                        this.setKnightPose(KnightPose.JUMPING);
                        break block0;
                    }
                }
                this.setKnightPose(KnightPose.ATTACKING);
                break;
            }
            case ATTACKING: {
                switch (random) {
                    case 1: {
                        this.setKnightPose(KnightPose.DASHING);
                        break block0;
                    }
                    case 2: {
                        this.setKnightPose(KnightPose.JUMPING);
                        break block0;
                    }
                }
                this.setKnightPose(KnightPose.SHOOTING);
                break;
            }
            case DASHING: {
                switch (random) {
                    case 1: {
                        this.setKnightPose(KnightPose.ATTACKING);
                        break block0;
                    }
                    case 2: {
                        this.setKnightPose(KnightPose.JUMPING);
                        break block0;
                    }
                }
                this.setKnightPose(KnightPose.SHOOTING);
                break;
            }
            case JUMPING: {
                switch (random) {
                    case 1: {
                        this.setKnightPose(KnightPose.ATTACKING);
                        break block0;
                    }
                    case 2: {
                        this.setKnightPose(KnightPose.DASHING);
                        break block0;
                    }
                }
                this.setKnightPose(KnightPose.SHOOTING);
            }
        }
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new JohannesKnightAttackGoal(this, 1.0, true));
        this.f_21345_.m_25352_(2, (Goal)new RandomLookAroundGoal((Mob)this){

            public boolean m_8036_() {
                return super.m_8036_() && JohannesKnight.this.getKnightPose() != KnightPose.DYING;
            }
        });
        super.m_8099_();
    }

    public void dashing() {
        double speed = 1.5;
        double Yaw = this.m_146908_();
        int randomOffset = this.f_19796_.m_216332_(-2, 2);
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            HarmfulProjectileEntity projectile = new HarmfulProjectileEntity((EntityType)WrathyArmamentEntities.HARMFUL_PROJECTILE_ENTITY.get(), (Level)level2, 12, "knight_axe");
            projectile.setOwner((LivingEntity)this);
            projectile.setProjectileType("huge_sword");
            projectile.m_6027_(this.m_20185_() + this.getXVector(speed, Yaw) + (double)randomOffset, this.m_20186_() + 1.0, this.m_20189_() + this.getZVector(speed, Yaw) + (double)randomOffset);
            level2.m_7967_((Entity)projectile);
        }
        this.m_20256_(new Vec3((double)randomOffset, 0.25, (double)(-randomOffset)));
        if (!this.isInSecondPhase() && !this.m_21023_(MobEffects.f_19596_)) {
            this.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 100, 3));
        }
        this.queueServerWork(20, this::setRandomPose);
    }

    public void johannesSwordDash() {
        double speed = 1.5;
        double Yaw = this.m_146908_();
        RandomSource random = RandomSource.m_216327_();
        this.m_20334_(0.0, 0.25, 0.0);
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            for (int i = 0; i < 4; ++i) {
                HarmfulProjectileEntity projectile = new HarmfulProjectileEntity((EntityType)WrathyArmamentEntities.HARMFUL_PROJECTILE_ENTITY.get(), (Level)level2, 12, "knight_axe");
                projectile.setOwner((LivingEntity)this);
                projectile.setProjectileType("knight_axe");
                projectile.m_6027_(this.m_20185_() + this.getXVector(speed, Yaw) + (double)random.m_216332_(-2, 2), this.m_20186_() + 1.0 + (double)i, this.m_20189_() + this.getZVector(speed, Yaw) + (double)random.m_216332_(-2, 2));
                level2.m_7967_((Entity)projectile);
            }
        }
        this.queueServerWork(10, () -> this.m_20256_(new Vec3(this.getXVector(speed, Yaw), (double)this.m_146909_() * -0.025 + 0.25, this.getZVector(speed, Yaw))));
        this.queueServerWork(20, this::setRandomPose);
    }

    public void johannesSwordBackwardsDash() {
        this.m_20334_(0.0, 0.5, 0.0);
        double speed = 2.0;
        double Yaw = this.m_146908_();
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            for (int i = 0; i < 4; ++i) {
                HarmfulProjectileEntity projectile = new HarmfulProjectileEntity((EntityType)WrathyArmamentEntities.HARMFUL_PROJECTILE_ENTITY.get(), (Level)level2, 10, "knight_dagger");
                projectile.setOwner((LivingEntity)this);
                projectile.setProjectileType("knight_dagger");
                projectile.m_6027_(this.m_20185_() + this.getXVector(speed + (double)i, Yaw), this.m_20186_() + (double)(this.isInSecondPhase() ? i : 0), this.m_20189_() + this.getZVector(speed + (double)i, Yaw));
                level2.m_7967_((Entity)projectile);
            }
        }
        this.queueServerWork(10, () -> this.m_20256_(new Vec3(-this.getXVector(speed, Yaw), 0.25, -this.getZVector(speed, Yaw))));
        this.queueServerWork(20, this::setRandomPose);
    }

    protected void m_6153_() {
        if (this.getKnightPose() != KnightPose.DYING) {
            this.setKnightPose(KnightPose.DYING);
        }
        if (this.f_20919_ == 19) {
            this.spawnParticle((ParticleOptions)new ColorableParticleOption("sparkle", 1.0f, 0.5f, 0.1f), this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), 2.0f);
        }
        super.m_6153_();
    }

    public void m_6667_(DamageSource source) {
        this.f_20919_ = -120;
        Entity entity = source.m_7639_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            player.m_5661_((Component)Component.m_237115_((String)"boss.wrathy_armament.johannes_fountain.dying"), true);
        }
        super.m_6667_(source);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_21223_() > 25.0f) {
            Entity entity = source.m_7639_();
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                this.m_6710_(livingEntity);
                if (this.f_19796_.m_188501_() > 0.75f) {
                    if (this.f_19796_.m_188499_()) {
                        this.johannesSwordBackwardsDash();
                    } else {
                        this.johannesSwordDash();
                    }
                }
            }
            if (source.m_7639_() instanceof Projectile && this.f_19796_.m_188499_()) {
                this.dashing();
                this.m_216990_(WrathyArmamentSounds.SOUL_SWING);
                return false;
            }
        }
        if (this.getKnightPose() == KnightPose.IDLING) {
            this.setRandomPose();
        }
        if (this.getKnightPose() != KnightPose.DYING && !this.isInSecondPhase() && this.m_21223_() < this.m_21233_() / 2.0f) {
            this.setKnightPose(KnightPose.DYING);
        }
        if (this.getKnightPose() == KnightPose.DYING) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public void m_7380_(CompoundTag tag) {
        tag.m_128379_("isInSecondPhase", this.isInSecondPhase());
        super.m_7380_(tag);
    }

    public void m_7378_(CompoundTag tag) {
        if (tag.m_128471_("isInSecondPhase")) {
            this.setIsInSecondPhase(true);
        }
        super.m_7378_(tag);
    }

    @Override
    public ServerBossEvent bossInfo() {
        return this.bossEvent;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 500.0).m_22268_(Attributes.f_22281_, 15.0).m_22268_(Attributes.f_22277_, 48.0).m_22268_(Attributes.f_22284_, 16.0).m_22268_(Attributes.f_22285_, 10.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22278_, 5.0);
    }

    public void m_6504_(LivingEntity pTarget, float pVelocity) {
        this.setRandomPose();
    }

    public static enum KnightPose {
        DYING,
        ATTACKING,
        DASHING,
        JUMPING,
        SHOOTING,
        IDLING;

    }
}

