/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.wrathy_armament.entities.bosses;

import java.util.Comparator;
import java.util.List;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.sashakyotoz.wrathy_armament.entities.ai_goals.bosses.LichKingMovementGoal;
import net.sashakyotoz.wrathy_armament.entities.alive.LichMyrmidon;
import net.sashakyotoz.wrathy_armament.entities.bosses.BossLikePathfinderMob;
import net.sashakyotoz.wrathy_armament.entities.technical.ParticleLikeEntity;
import net.sashakyotoz.wrathy_armament.registers.WrathyArmamentEntities;
import net.sashakyotoz.wrathy_armament.registers.WrathyArmamentItems;
import net.sashakyotoz.wrathy_armament.registers.WrathyArmamentMiscRegistries;
import net.sashakyotoz.wrathy_armament.registers.WrathyArmamentSounds;

public class LichKing
extends BossLikePathfinderMob {
    private final ServerBossEvent bossEvent = new ServerBossEvent((Component)Component.m_237115_((String)"boss.wrathy_armament.lich_king"), BossEvent.BossBarColor.BLUE, BossEvent.BossBarOverlay.NOTCHED_10);
    private final TargetingConditions targetCountTargeting = TargetingConditions.m_148353_().m_26883_(48.0).m_148355_().m_26893_();
    private static final EntityDataAccessor<KingPose> DATA_KING_POSE = SynchedEntityData.m_135353_(LichKing.class, (EntityDataSerializer)((EntityDataSerializer)WrathyArmamentMiscRegistries.LICH_KING_POSE.get()));
    public final AnimationState spawn = new AnimationState();
    public final AnimationState death = new AnimationState();
    public final AnimationState combo_attack = new AnimationState();
    public final AnimationState combo_attack1 = new AnimationState();
    public final AnimationState combo_attack2 = new AnimationState();
    public final AnimationState spin_attack = new AnimationState();
    public final AnimationState rain_cast = new AnimationState();
    public final AnimationState summon = new AnimationState();
    public final AnimationState transition_to_heal = new AnimationState();
    public final AnimationState heal_pose = new AnimationState();
    private int timeOfAbility = 0;

    public LichKing(EntityType<? extends BossLikePathfinderMob> type, Level level) {
        super(type, level);
        this.m_21468_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)WrathyArmamentItems.FROSTMOURNE.get()));
        this.m_274367_(1.25f);
        this.f_21364_ = 50;
    }

    protected void m_6153_() {
        if (this.f_20919_ == 19) {
            this.spawnParticle(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), 2.0f);
        }
        super.m_6153_();
    }

    public void m_6667_(DamageSource source) {
        this.f_20919_ = -40;
        this.setKingPose(KingPose.DYING);
        super.m_6667_(source);
    }

    public void m_7350_(EntityDataAccessor<?> dataAccessor) {
        if (DATA_KING_POSE.equals(dataAccessor)) {
            if (!this.isInPose(KingPose.HEALING)) {
                this.heal_pose.m_216973_();
                this.transition_to_heal.m_216973_();
            }
            if (!this.isInPose(KingPose.SUMMOING)) {
                this.summon.m_216973_();
            }
            switch (this.getKingPose()) {
                case SPAWNING: {
                    this.spawn.m_216977_(this.f_19797_);
                    break;
                }
                case DYING: {
                    this.death.m_216977_(this.f_19797_);
                    break;
                }
                case ATTACK: {
                    if (this.m_217043_().m_188499_()) {
                        this.combo_attack.m_216977_(this.f_19797_);
                    } else {
                        this.combo_attack1.m_216977_(this.f_19797_);
                    }
                    this.m_5496_(WrathyArmamentSounds.SOUL_SWING, 1.5f, 2.0f);
                    this.queueServerWork(30, () -> {
                        if (this.m_5448_() != null && this.m_5448_().m_20280_((Entity)this) < 11.0) {
                            this.m_19970_((LivingEntity)this, (Entity)this.m_5448_());
                        }
                    });
                    break;
                }
                case SECOND_ATTACK: {
                    this.combo_attack2.m_216977_(this.f_19797_);
                    this.m_5496_(WrathyArmamentSounds.SOUL_SWING, 1.25f, 2.2f);
                    this.queueServerWork(30, () -> {
                        if (this.m_5448_() != null && this.m_5448_().m_20280_((Entity)this) < 12.0) {
                            this.m_19970_((LivingEntity)this, (Entity)this.m_5448_());
                        }
                    });
                    break;
                }
                case SPIN_ATTACK: {
                    this.spin_attack.m_216977_(this.f_19797_);
                    this.m_5496_(WrathyArmamentSounds.SOUL_SWING, 1.75f, 0.9f);
                    this.playSpinAnimation();
                    break;
                }
                case HEALING: {
                    this.transition_to_heal.m_216977_(this.f_19797_);
                    this.f_21344_.m_26573_();
                    this.queueServerWork(11, () -> this.heal_pose.m_216982_(this.f_19797_));
                    break;
                }
                case SUMMOING: {
                    this.summon.m_216977_(this.f_19797_);
                    this.m_5496_(SoundEvents.f_12399_, 1.5f, 0.9f);
                    if (!this.isOrNotMyrmidonsAround()) break;
                    this.queueServerWork(30, this::spawnMyrmidons);
                    break;
                }
                case RAIN_CASTING: {
                    this.rain_cast.m_216977_(this.f_19797_);
                    this.rainCast();
                    this.queueServerWork(50, this::shootSoulRay);
                }
            }
        }
        super.m_7350_(dataAccessor);
    }

    private void spawnMyrmidons() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            int randomCountOfMyrmidons = this.f_19796_.m_216332_(1, 4);
            for (int i = 0; i < randomCountOfMyrmidons; ++i) {
                LichMyrmidon lichMyrmidon = new LichMyrmidon((EntityType<? extends LichMyrmidon>)((EntityType)WrathyArmamentEntities.LICH_MYRMIDON.get()), (Level)serverLevel);
                lichMyrmidon.m_6027_(this.m_20185_() + this.getZVector(2.0, this.m_146908_()), this.m_20186_() + 1.0, this.m_20189_() + this.getZVector(2.0, this.m_146908_()));
                lichMyrmidon.setOwner((LivingEntity)this);
                serverLevel.m_7967_((Entity)lichMyrmidon);
            }
        }
    }

    private void clientDiggingParticles(AnimationState time) {
        if ((float)time.m_216981_() < 1000.0f) {
            RandomSource randomsource = this.m_217043_();
            BlockState blockstate = this.m_20075_();
            if (blockstate.m_60799_() != RenderShape.INVISIBLE) {
                for (int i = 0; i < 30; ++i) {
                    double d0 = this.m_20185_() + (double)Mth.m_216283_((RandomSource)randomsource, (float)-0.7f, (float)0.7f);
                    double d1 = this.m_20186_() + 0.5;
                    double d2 = this.m_20189_() + (double)Mth.m_216283_((RandomSource)randomsource, (float)-0.7f, (float)0.7f);
                    this.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockstate), d0, d1, d2, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public void m_6075_() {
        if (this.spawn.m_216984_() || this.death.m_216984_()) {
            this.clientDiggingParticles(this.spawn.m_216984_() ? this.spawn : this.death);
        }
        if (this.isInPose(KingPose.HEALING) && this.f_19797_ % 20 == 0 && this.m_21223_() != this.m_21233_()) {
            this.spawnParticle((ParticleOptions)WrathyArmamentMiscRegistries.FROST_SOUL_RAY.get(), this.m_9236_(), this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), 2.5f * (float)this.f_19796_.m_216339_(1, 4));
            this.m_5634_(5.0f);
        }
        if (this.timeOfAbility > 0) {
            --this.timeOfAbility;
        }
        if (this.m_5448_() != null && this.timeOfAbility <= 0) {
            this.setPhase();
        }
        super.m_6075_();
    }

    private void setPhase() {
        switch (this.getKingPose()) {
            case SPAWNING: 
            case SUMMOING: {
                this.setKingPose(KingPose.ATTACK);
                break;
            }
            case ATTACK: {
                this.setKingPose(this.m_217043_().m_188499_() ? KingPose.SPIN_ATTACK : KingPose.SECOND_ATTACK);
                break;
            }
            case SECOND_ATTACK: 
            case SPIN_ATTACK: {
                this.setKingPose(KingPose.RAIN_CASTING);
                break;
            }
            case RAIN_CASTING: {
                this.setKingPose(KingPose.HEALING);
                break;
            }
            case HEALING: {
                this.setKingPose(KingPose.SUMMOING);
            }
        }
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new LichKingMovementGoal(this));
        super.m_8099_();
    }

    private boolean isOrNotMyrmidonsAround() {
        int i = this.m_9236_().m_45971_(LichMyrmidon.class, this.targetCountTargeting, (LivingEntity)this, this.m_20191_().m_82400_(48.0)).size();
        return this.m_217043_().m_188503_(5) + 1 > i;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.isInPose(KingPose.HEALING) && this.f_19796_.m_188501_() > 0.75f) {
            this.setPhase();
        }
        return super.m_6469_(source, amount);
    }

    private void shootSoulRay() {
        this.m_216990_(SoundEvents.f_12404_);
        double d0 = -Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180)));
        double d1 = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)));
        float scaling = 0.0f;
        for (int i1 = 0; i1 < 24; ++i1) {
            this.m_9236_().m_7106_((ParticleOptions)WrathyArmamentMiscRegistries.FROST_SOUL_RAY.get(), (double)this.m_9236_().m_45547_(new ClipContext(this.m_20299_(1.0f), this.m_20299_(1.0f).m_82549_(this.m_20252_(1.0f).m_82490_((double)(scaling += 1.0f))), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)this)).m_82425_().m_123341_(), (double)this.m_9236_().m_45547_(new ClipContext(this.m_20299_(1.0f), this.m_20299_(1.0f).m_82549_(this.m_20252_(1.0f).m_82490_((double)scaling)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)this)).m_82425_().m_123342_(), (double)this.m_9236_().m_45547_(new ClipContext(this.m_20299_(1.0f), this.m_20299_(1.0f).m_82549_(this.m_20252_(1.0f).m_82490_((double)scaling)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)this)).m_82425_().m_123343_(), d0, 0.1, d1);
            Vec3 center = new Vec3((double)this.m_9236_().m_45547_(new ClipContext(this.m_20299_(1.0f), this.m_20299_(1.0f).m_82549_(this.m_20252_(1.0f).m_82490_((double)scaling)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)this)).m_82425_().m_123341_(), (double)this.m_9236_().m_45547_(new ClipContext(this.m_20299_(1.0f), this.m_20299_(1.0f).m_82549_(this.m_20252_(1.0f).m_82490_((double)scaling)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)this)).m_82425_().m_123342_(), (double)this.m_9236_().m_45547_(new ClipContext(this.m_20299_(1.0f), this.m_20299_(1.0f).m_82549_(this.m_20252_(1.0f).m_82490_((double)scaling)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)this)).m_82425_().m_123343_());
            List<Entity> entityList = this.m_9236_().m_6443_(Entity.class, new AABB(center, center).m_82400_(2.0), e -> true).stream().sorted(Comparator.comparingDouble(entity -> entity.m_20238_(center))).toList();
            for (Entity entityIterator : entityList) {
                if (entityIterator == this || !(entityIterator instanceof LivingEntity)) continue;
                LivingEntity livingEntity = (LivingEntity)entityIterator;
                livingEntity.m_6469_(this.m_269291_().m_269425_(), 8.0f);
                livingEntity.m_20334_(0.0, 0.5, 0.0);
                this.m_9236_().m_7731_(livingEntity.m_20183_().m_6630_(2), this.m_9236_().m_8055_(livingEntity.m_20183_()), 2);
                this.m_9236_().m_7731_(livingEntity.m_20183_(), Blocks.f_50016_.m_49966_(), 2);
            }
        }
    }

    private void playSpinAnimation() {
        BlockState blockstate = this.m_20075_();
        for (int i = 0; i < 360; ++i) {
            if (i % 20 != 0) continue;
            this.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockstate), this.m_20185_(), this.m_20186_() + 0.25, this.m_20189_(), this.getXVector(3.0, this.m_146908_()), 1.0, this.getZVector(3.0, this.m_146908_()));
        }
        this.queueServerWork(15, () -> {
            if (this.m_5448_() != null && this.spin_attack.m_216984_()) {
                this.hitNearbyMobs(15.0f, 12);
            }
        });
    }

    private void rainCast() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            this.queueServerWork(20, () -> {
                ParticleLikeEntity particleEntity = new ParticleLikeEntity((EntityType)WrathyArmamentEntities.PARTICLE_LIKE_ENTITY.get(), (Level)level2, 1.0f, true, true, 4, (ParticleOptions)ParticleTypes.f_123746_, "lich_rain");
                particleEntity.m_20219_(new Vec3(this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_()));
                level2.m_7967_((Entity)particleEntity);
            });
        }
    }

    private void setKingPose(KingPose knightPose) {
        this.f_19804_.m_135381_(DATA_KING_POSE, (Object)knightPose);
        this.timeOfAbility = knightPose.getAbilityTime;
    }

    public KingPose getKingPose() {
        return (KingPose)((Object)this.f_19804_.m_135370_(DATA_KING_POSE));
    }

    public boolean isInPose(KingPose phase) {
        return this.getKingPose() == phase;
    }

    @Override
    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_KING_POSE, (Object)KingPose.SPAWNING);
        super.m_8097_();
    }

    @Override
    public ServerBossEvent bossInfo() {
        return this.bossEvent;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 600.0).m_22268_(Attributes.f_22281_, 15.0).m_22268_(Attributes.f_22277_, 48.0).m_22268_(Attributes.f_22284_, 12.0).m_22268_(Attributes.f_22285_, 8.0).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22278_, 5.0);
    }

    public static enum KingPose {
        DYING(80),
        SPAWNING(60),
        ATTACK(40),
        SECOND_ATTACK(30),
        SPIN_ATTACK(30),
        RAIN_CASTING(50),
        HEALING(100),
        SUMMOING(30);

        public final int getAbilityTime;

        private KingPose(int actionTime) {
            this.getAbilityTime = actionTime;
        }
    }
}

