/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.wrathy_armament.entities.bosses;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.PartEntity;
import net.sashakyotoz.anitexlib.client.particles.parents.options.ColorableParticleOption;
import net.sashakyotoz.wrathy_armament.entities.ai_goals.bosses.MoonLordMovementGoal;
import net.sashakyotoz.wrathy_armament.entities.alive.TrueEyeOfCthulhu;
import net.sashakyotoz.wrathy_armament.entities.bosses.BossLikePathfinderMob;
import net.sashakyotoz.wrathy_armament.entities.bosses.core.MoonLordPart;
import net.sashakyotoz.wrathy_armament.entities.technical.EyeOfCthulhuProjectile;
import net.sashakyotoz.wrathy_armament.entities.technical.HarmfulProjectileEntity;
import net.sashakyotoz.wrathy_armament.entities.technical.OwnerableMob;
import net.sashakyotoz.wrathy_armament.registers.WrathyArmamentEntities;
import net.sashakyotoz.wrathy_armament.registers.WrathyArmamentMiscRegistries;
import net.sashakyotoz.wrathy_armament.registers.WrathyArmamentSounds;
import net.sashakyotoz.wrathy_armament.utils.OnActionsTrigger;
import net.sashakyotoz.wrathy_armament.utils.RenderUtils;
import org.jetbrains.annotations.NotNull;

public class MoonLord
extends BossLikePathfinderMob {
    private static final EntityDataAccessor<Float> ANIMATION_SCALING = SynchedEntityData.m_135353_(MoonLord.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<LordPose> DATA_LORD_POSE = SynchedEntityData.m_135353_(MoonLord.class, (EntityDataSerializer)((EntityDataSerializer)WrathyArmamentMiscRegistries.LORD_POSE.get()));
    private final ServerBossEvent bossEvent = new ServerBossEvent((Component)Component.m_237115_((String)"entity.wrathy_armament.moon_lord"), BossEvent.BossBarColor.WHITE, BossEvent.BossBarOverlay.NOTCHED_20);
    private final MoonLordPart[] subEntities;
    private final MoonLordPart headEye;
    private final MoonLordPart heart;
    private final MoonLordPart rightHandEye;
    private final MoonLordPart leftHandEye;
    public final HashMap<String, Integer> damageTakenByPart = new HashMap();
    public final AnimationState death = new AnimationState();
    public final AnimationState eyeShooting = new AnimationState();
    public final AnimationState eyeAttack = new AnimationState();
    public final AnimationState interactive = new AnimationState();
    public int deathTicks = 0;
    private int timeOfAbility = 0;
    private static final Predicate<LivingEntity> LIVING_ENTITY_SELECTOR = entity -> entity.m_6336_() != MobType.f_21641_ && entity.m_5789_();
    private final TargetingConditions eyesCountTargeting = TargetingConditions.m_148353_().m_26883_(32.0).m_148355_().m_26893_();

    public MoonLord(EntityType<? extends BossLikePathfinderMob> type, Level level) {
        super(type, level);
        this.f_21364_ = 500;
        this.f_21342_ = new LordMoveControl(this);
        this.headEye = new MoonLordPart(this, "headEye", 1.5f, 1.5f);
        this.heart = new MoonLordPart(this, "heart", 2.5f, 2.5f);
        this.rightHandEye = new MoonLordPart(this, "rightHandEye", 1.5f, 1.5f);
        this.leftHandEye = new MoonLordPart(this, "leftHandEye", 1.5f, 1.5f);
        this.subEntities = new MoonLordPart[]{this.headEye, this.heart, this.rightHandEye, this.leftHandEye};
        this.m_20234_(f_19843_.getAndAdd(this.subEntities.length + 1) + 1);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ANIMATION_SCALING, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(DATA_LORD_POSE, (Object)LordPose.IDLING);
    }

    public float getAnimationScaling() {
        return ((Float)this.f_19804_.m_135370_(ANIMATION_SCALING)).floatValue();
    }

    public void setAnimationScaling(float f) {
        this.f_19804_.m_135381_(ANIMATION_SCALING, (Object)Float.valueOf(f));
    }

    public LordPose getLordPose() {
        return (LordPose)((Object)this.f_19804_.m_135370_(DATA_LORD_POSE));
    }

    public void setLordPose(LordPose pose) {
        this.f_19804_.m_135381_(DATA_LORD_POSE, (Object)pose);
        this.timeOfAbility = pose.getAbilityTime;
    }

    public boolean isInPose(LordPose phase) {
        return this.getLordPose() == phase;
    }

    protected PathNavigation m_6037_(Level level) {
        return new FlyingPathNavigation((Mob)this, level);
    }

    public void applyBrightnessAround(Level level, Vec3 vec3, @Nullable Entity sourceEntity, int i) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            MobEffectInstance mobeffectinstance = new MobEffectInstance((MobEffect)WrathyArmamentMiscRegistries.BRIGHTNESS.get(), 40, 1, false, false);
            MobEffectUtil.m_216946_((ServerLevel)serverLevel, (Entity)sourceEntity, (Vec3)vec3, (double)i, (MobEffectInstance)mobeffectinstance, (int)40);
        }
    }

    @Override
    public ServerBossEvent bossInfo() {
        return this.bossEvent;
    }

    public PartEntity<?>[] getParts() {
        return this.subEntities;
    }

    public boolean isMultipartEntity() {
        return true;
    }

    public void m_20234_(int id) {
        super.m_20234_(id);
        for (int i = 0; i < this.subEntities.length; ++i) {
            this.subEntities[i].m_20234_(id + i + 1);
        }
    }

    public List<MoonLordPart> getMainParts() {
        return Arrays.stream(this.subEntities).toList();
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ % 30 == 0) {
            this.setAnimationScaling((float)this.m_217043_().m_216332_(-10, 10) / 10.0f);
        }
        Vec3[] avec3 = new Vec3[this.subEntities.length];
        for (int j = 0; j < this.subEntities.length; ++j) {
            avec3[j] = new Vec3(this.subEntities[j].m_20185_(), this.subEntities[j].m_20186_(), this.subEntities[j].m_20189_());
        }
        float f14 = this.m_6080_() * ((float)Math.PI / 180);
        float f1 = Mth.m_14031_((float)f14);
        float f15 = Mth.m_14089_((float)f14);
        this.tickPart(this.headEye, -f1 * 0.75f, 5.25, f15 * 0.75f);
        this.tickPart(this.heart, 0.0, 2.0, 0.0);
        this.tickPart(this.rightHandEye, f15 * -3.75f, 1.5, f1 * -3.75f);
        this.tickPart(this.leftHandEye, f15 * 3.75f, 1.5, f1 * 3.75f);
        for (int l = 0; l < this.subEntities.length; ++l) {
            this.subEntities[l].f_19854_ = avec3[l].f_82479_;
            this.subEntities[l].f_19855_ = avec3[l].f_82480_;
            this.subEntities[l].f_19856_ = avec3[l].f_82481_;
            this.subEntities[l].f_19790_ = avec3[l].f_82479_;
            this.subEntities[l].f_19791_ = avec3[l].f_82480_;
            this.subEntities[l].f_19792_ = avec3[l].f_82481_;
        }
        if (this.f_19797_ % 10 == 0) {
            this.getMainParts().forEach(moonLordPart -> {
                if (this.damageTakenByPart.get(moonLordPart.name) != null && this.damageTakenByPart.get(moonLordPart.name) > 0) {
                    this.damageTakenByPart.put(moonLordPart.name, this.damageTakenByPart.get(moonLordPart.name) - 1);
                }
            });
        }
        if (this.timeOfAbility > 0) {
            --this.timeOfAbility;
        }
        if (this.m_5448_() != null && this.timeOfAbility <= 0) {
            this.setLordPose();
        }
        if (this.isInPose(LordPose.LASERING)) {
            LivingEntity target = this.m_5448_();
            if (target != null) {
                double d0 = target.m_20185_() - this.m_20185_();
                double d2 = target.m_20189_() - this.m_20189_();
                double d1 = target.m_20188_() - (this.m_20188_() + (double)2.9f);
                double d3 = Math.sqrt(d0 * d0 + d2 * d2);
                float f = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                float f2 = (float)(-(Mth.m_14136_((double)d1, (double)d3) * 57.2957763671875));
                float getRotYToTarget = this.m_21376_(this.m_146908_(), f, 40.0f);
                float getRotXToTarget = this.m_21376_(this.m_146909_(), f2, 25.0f);
                float delta = RenderUtils.getOscillatingValue(this.f_19797_, 8);
                this.m_146926_(Mth.m_14179_((float)delta, (float)(getRotXToTarget - 30.0f), (float)(getRotXToTarget + 30.0f)));
                this.m_146922_(Mth.m_14179_((float)delta, (float)(getRotYToTarget - 50.0f), (float)(getRotYToTarget + 50.0f)));
            }
            if (this.f_19797_ % 5 == 0) {
                if (this.f_19797_ % 4 == 0) {
                    this.m_5496_(WrathyArmamentSounds.BEAM_SHOOTING, 1.5f, 0.9f);
                }
                for (int i = 0; i < 33; ++i) {
                    Vec3 center = this.posOfViewing((LivingEntity)this, BlockPos.m_274561_((double)this.m_20185_(), (double)this.m_20186_(), (double)this.m_20189_())).m_252807_();
                    List<LivingEntity> entityList = this.m_9236_().m_6443_(LivingEntity.class, new AABB(center, center).m_82400_(1.5), e -> true).stream().sorted(Comparator.comparingDouble(t -> t.m_20238_(center))).toList();
                    for (LivingEntity entity : entityList) {
                        if (entity == this || entity instanceof TrueEyeOfCthulhu) continue;
                        entity.m_6469_(this.m_269291_().m_269425_(), this.m_9236_().m_46791_().equals((Object)Difficulty.HARD) ? 8.0f : 5.0f);
                    }
                }
            }
        }
    }

    private float m_21376_(float pAngle, float pTargetAngle, float pMaxIncrease) {
        float f = Mth.m_14177_((float)(pTargetAngle - pAngle));
        if (f > pMaxIncrease) {
            f = pMaxIncrease;
        }
        if (f < -pMaxIncrease) {
            f = -pMaxIncrease;
        }
        return pAngle + f;
    }

    public int m_8132_() {
        return 55;
    }

    private void tickPart(MoonLordPart moonLordPart, double pOffsetX, double pOffsetY, double pOffsetZ) {
        moonLordPart.m_6034_(this.m_20185_() + pOffsetX, this.m_20186_() + pOffsetY, this.m_20189_() + pOffsetZ);
    }

    public void setLordPose() {
        switch (this.getLordPose()) {
            case IDLING: 
            case TELEPORTING: 
            case EYE_BLADES: {
                this.setLordPose(LordPose.ATTACKING);
                break;
            }
            case ATTACKING: {
                this.setLordPose(LordPose.SHOOTING);
                break;
            }
            case SHOOTING: {
                if (this.m_5448_().m_20280_((Entity)this) > 441.0) {
                    this.setLordPose(LordPose.TELEPORTING);
                    break;
                }
                this.setLordPose(LordPose.LASERING);
                break;
            }
            case LASERING: {
                this.setLordPose(LordPose.EYE_BLADES);
            }
        }
    }

    public void m_7350_(@NotNull EntityDataAccessor<?> dataAccessor) {
        if (DATA_LORD_POSE.equals(dataAccessor)) {
            if (!this.getLordPose().equals((Object)LordPose.IDLING) || !this.getLordPose().equals((Object)LordPose.LASERING)) {
                this.interactive.m_216973_();
            }
            switch (this.getLordPose()) {
                case DYING: {
                    this.death.m_216977_(this.f_19797_);
                    break;
                }
                case ATTACKING: {
                    this.eyeAttack.m_216977_(this.f_19797_);
                    if (this.m_5448_() != null && !this.m_5448_().m_21023_(MobEffects.f_19613_)) {
                        this.m_5448_().m_7292_(new MobEffectInstance(MobEffects.f_19613_, 100, 1));
                        this.m_5448_().m_7292_(new MobEffectInstance(MobEffects.f_19597_, 100, 0));
                    }
                    int i = this.m_9236_().m_45971_(TrueEyeOfCthulhu.class, this.eyesCountTargeting, (LivingEntity)this, this.m_20191_().m_82400_(32.0)).size();
                    this.queueServerWork(20, () -> {
                        if (i < 3) {
                            TrueEyeOfCthulhu eyeOfCthulhu = new TrueEyeOfCthulhu((EntityType<? extends OwnerableMob>)((EntityType)WrathyArmamentEntities.TRUE_EYE_OF_CTHULHU.get()), this.m_9236_());
                            eyeOfCthulhu.setOwner((LivingEntity)this);
                            eyeOfCthulhu.m_20219_(this.m_20097_().m_252807_());
                            eyeOfCthulhu.m_20334_(this.getXVector(2.0, this.m_146908_()), OnActionsTrigger.getYVector(1.0, this.m_146909_()), this.getZVector(2.0, this.m_146908_()));
                            this.m_9236_().m_7967_((Entity)eyeOfCthulhu);
                        } else {
                            this.applyBrightnessAround(this.m_9236_(), this.m_146892_(), (Entity)this, 32);
                        }
                    });
                    break;
                }
                case IDLING: {
                    this.interactive.m_216982_(this.f_19797_);
                    break;
                }
                case LASERING: {
                    this.f_21344_.m_26573_();
                    this.interactive.m_216982_(this.f_19797_);
                    break;
                }
                case EYE_BLADES: {
                    Level level;
                    if (this.m_5448_() != null) {
                        this.m_21391_((Entity)this.m_5448_(), 15.0f, 15.0f);
                    }
                    this.eyeAttack.m_216977_(this.f_19797_);
                    if (this.m_5448_() == null || !((level = this.m_9236_()) instanceof ServerLevel)) break;
                    ServerLevel serverLevel = (ServerLevel)level;
                    for (int i = 0; i < 4; ++i) {
                        int randomOffset = this.m_217043_().m_216339_(-2, 3);
                        HarmfulProjectileEntity projectile = new HarmfulProjectileEntity((EntityType)WrathyArmamentEntities.HARMFUL_PROJECTILE_ENTITY.get(), (Level)serverLevel, 10, "vertical_circle");
                        projectile.setOwner((LivingEntity)this);
                        projectile.setProjectileType("vertical_circle");
                        projectile.m_6027_(this.m_5448_().m_20185_() + (double)randomOffset, this.m_5448_().m_20186_() + 2.5 + (double)i, this.m_5448_().m_20189_() + (double)randomOffset);
                        serverLevel.m_7967_((Entity)projectile);
                    }
                    break;
                }
                case SHOOTING: {
                    this.eyeShooting.m_216977_(this.f_19797_);
                    OnActionsTrigger.queueServerWork(14, () -> {
                        for (int i = -1; i < 2; ++i) {
                            EyeOfCthulhuProjectile projectile = new EyeOfCthulhuProjectile((EntityType<EyeOfCthulhuProjectile>)((EntityType)WrathyArmamentEntities.EYE_OF_CTHULHU_PROJECTILE.get()), (LivingEntity)this, this.m_9236_());
                            projectile.m_5602_((Entity)this);
                            projectile.m_5602_((Entity)this);
                            projectile.m_37251_((Entity)this.leftHandEye, this.m_146909_() - 10.0f, this.m_146908_(), 0.0f, 3.0f, 0.0f);
                            this.m_9236_().m_7967_((Entity)projectile);
                        }
                    });
                    OnActionsTrigger.queueServerWork(28, () -> {
                        for (int i = -1; i < 2; ++i) {
                            EyeOfCthulhuProjectile projectile = new EyeOfCthulhuProjectile((EntityType<EyeOfCthulhuProjectile>)((EntityType)WrathyArmamentEntities.EYE_OF_CTHULHU_PROJECTILE.get()), (LivingEntity)this, this.m_9236_());
                            projectile.m_5602_((Entity)this);
                            projectile.m_37251_((Entity)this.rightHandEye, this.m_146909_() - 10.0f, this.m_146908_(), 0.0f, 3.0f, 0.0f);
                            this.m_9236_().m_7967_((Entity)projectile);
                        }
                    });
                    break;
                }
                case TELEPORTING: {
                    this.applyBrightnessAround(this.m_9236_(), this.m_146892_(), (Entity)this, 48);
                    this.m_5496_(SoundEvents.f_11822_, 1.5f, 2.0f);
                    LivingEntity target = this.m_5448_();
                    if (target == null) break;
                    this.m_6021_(target.m_20208_(2.0), target.m_20186_() + 1.0, target.m_20262_(2.0));
                }
            }
        }
        super.m_7350_(dataAccessor);
    }

    public boolean m_21224_() {
        return super.m_21224_() || this.getLordPose().equals((Object)LordPose.DYING);
    }

    public boolean m_20068_() {
        return true;
    }

    protected float m_6431_(Pose pPose, EntityDimensions pDimensions) {
        return super.m_6431_(pPose, pDimensions) + 2.95f;
    }

    public void m_5997_(double pX, double pY, double pZ) {
    }

    @Override
    public void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 0, false, false, LIVING_ENTITY_SELECTOR));
        this.f_21345_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21345_.m_25352_(3, (Goal)new MoonLordMovementGoal(this));
    }

    public boolean isEyesActive() {
        return this.getMainParts().get(0).getHealthPoints() > 0.0f && this.getMainParts().get(2).getHealthPoints() > 0.0f && this.getMainParts().get(3).getHealthPoints() > 0.0f;
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        return !this.isEyesActive() && super.m_6469_(pSource, pAmount);
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return WrathyArmamentSounds.MOON_LORD_HURT;
    }

    protected void m_6153_() {
        Level level;
        --this.deathTicks;
        if (this.f_20919_ == 10) {
            this.spawnParticle((ParticleOptions)new ColorableParticleOption("sparkle", 0.25f, 0.35f, 1.0f), this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), 5.0f);
            this.m_5496_(SoundEvents.f_11824_, 2.0f, 1.5f);
            this.applyBrightnessAround(this.m_9236_(), this.m_20097_().m_252807_(), (Entity)this, 16);
        }
        if (this.f_20919_ == 19 && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            level2.m_8615_(3000L);
        }
        super.m_6153_();
    }

    private BlockPos posOfViewing(LivingEntity entity, BlockPos pos) {
        BlockPos pos1 = pos;
        int scaling = 0;
        for (int i = 0; i < 32; ++i) {
            BlockPos pos2 = entity.m_9236_().m_45547_(new ClipContext(entity.m_20299_(1.0f), entity.m_20299_(1.0f).m_82549_(entity.m_20252_(1.0f).m_82490_((double)scaling)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)entity)).m_82425_();
            if (!entity.m_9236_().m_8055_(new BlockPos(pos2.m_123341_(), pos2.m_123342_(), pos2.m_123343_())).m_60815_()) {
                ++scaling;
            } else if (this.f_19797_ % 4 == 0) {
                entity.m_9236_().m_7106_((ParticleOptions)WrathyArmamentMiscRegistries.BEAM_SPARKLES.get(), (double)pos2.m_123341_(), (double)((float)pos2.m_123342_() + 0.1f), (double)pos2.m_123343_(), 0.0, 0.125, 0.0);
            }
            pos1 = entity.m_9236_().m_45547_(new ClipContext(entity.m_20299_(1.0f), entity.m_20299_(1.0f).m_82549_(entity.m_20252_(1.0f).m_82490_((double)scaling)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)entity)).m_82425_();
        }
        return pos1;
    }

    public void m_6667_(DamageSource source) {
        this.f_20919_ = -100;
        this.deathTicks = 200;
        this.setLordPose(LordPose.DYING);
        super.m_6667_(source);
    }

    public void m_7023_(Vec3 pTravelVector) {
        if (this.m_6109_()) {
            if (this.m_20069_()) {
                this.m_19920_(0.02f, pTravelVector);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                this.m_20256_(this.m_20184_().m_82490_((double)0.8f));
            } else if (this.m_20077_()) {
                this.m_19920_(0.02f, pTravelVector);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                this.m_20256_(this.m_20184_().m_82490_(0.5));
            } else {
                this.m_19920_(this.m_6113_(), pTravelVector);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                this.m_20256_(this.m_20184_().m_82490_((double)0.91f));
            }
        }
        this.m_267651_(false);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 750.0).m_22268_(Attributes.f_22281_, 15.0).m_22268_(Attributes.f_22277_, 48.0).m_22268_(Attributes.f_22284_, 12.0).m_22268_(Attributes.f_22285_, 12.0).m_22268_(Attributes.f_22279_, 0.15).m_22268_(Attributes.f_22280_, 0.15).m_22268_(Attributes.f_22278_, 1.0);
    }

    public void m_7840_(double pY, boolean pOnGround, BlockState pState, BlockPos pPos) {
    }

    static class LordMoveControl
    extends MoveControl {
        private final MoonLord moonLord;
        private int floatDuration;

        public LordMoveControl(MoonLord moonLord) {
            super((Mob)moonLord);
            this.moonLord = moonLord;
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO && this.floatDuration-- <= 0) {
                this.floatDuration = this.floatDuration + this.moonLord.m_217043_().m_188503_(6) + 2;
                Vec3 vec3 = new Vec3(this.f_24975_ - this.moonLord.m_20185_(), this.f_24976_ - this.moonLord.m_20186_(), this.f_24977_ - this.moonLord.m_20189_());
                double d0 = vec3.m_82553_();
                if (this.canReach(vec3 = vec3.m_82541_(), Mth.m_14165_((double)d0))) {
                    this.moonLord.m_20256_(this.moonLord.m_20184_().m_82549_(vec3.m_82490_(0.15)));
                } else {
                    this.f_24981_ = MoveControl.Operation.WAIT;
                }
            }
        }

        private boolean canReach(Vec3 pos, int length) {
            AABB aabb = this.moonLord.m_20191_();
            for (int i = 1; i < length; ++i) {
                aabb = aabb.m_82383_(pos);
                if (this.moonLord.m_9236_().m_45756_((Entity)this.moonLord, aabb)) continue;
                return false;
            }
            return true;
        }
    }

    public static enum LordPose {
        DYING(120),
        ATTACKING(100),
        LASERING(160),
        SHOOTING(50),
        EYE_BLADES(50),
        TELEPORTING(50),
        IDLING(80);

        public final int getAbilityTime;

        private LordPose(int actionTime) {
            this.getAbilityTime = actionTime;
        }
    }
}

