/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.wrathy_armament.entities.bosses;

import java.util.Comparator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.PowerableMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.sashakyotoz.wrathy_armament.entities.ai_goals.bosses.sashakyotoz.SashaKYotozMovementGoal;
import net.sashakyotoz.wrathy_armament.entities.ai_goals.bosses.sashakyotoz.SashaKYotozRandomStrollGoal;
import net.sashakyotoz.wrathy_armament.entities.bosses.BossLikePathfinderMob;
import net.sashakyotoz.wrathy_armament.registers.WrathyArmamentEntities;
import net.sashakyotoz.wrathy_armament.registers.WrathyArmamentItems;
import net.sashakyotoz.wrathy_armament.registers.WrathyArmamentMiscRegistries;
import org.jetbrains.annotations.NotNull;

public class SashaKYotoz
extends BossLikePathfinderMob
implements PowerableMob {
    private final ServerBossEvent bossEvent = new ServerBossEvent((Component)Component.m_237115_((String)"boss.wrathy_armament.sashakyotoz"), BossEvent.BossBarColor.BLUE, BossEvent.BossBarOverlay.NOTCHED_10);
    private static final EntityDataAccessor<SashaKYotozPhase> DATA_SASHAKYOTOZ_PHASE = SynchedEntityData.m_135353_(SashaKYotoz.class, (EntityDataSerializer)((EntityDataSerializer)WrathyArmamentMiscRegistries.SASHAKYOTOZ_PHASE.get()));
    public int timeOfAbility = 0;
    public final AnimationState idle = new AnimationState();
    public final AnimationState takeOff = new AnimationState();
    public final AnimationState landing = new AnimationState();
    public final AnimationState flying = new AnimationState();
    public final AnimationState attackByScythe = new AnimationState();
    public final AnimationState attackByBlade = new AnimationState();
    public final AnimationState attackPhantomRay = new AnimationState();
    public final AnimationState attackCircleOfPhantoms = new AnimationState();
    public final AnimationState death = new AnimationState();
    private final GroundPathNavigation groundPathNavigation = new GroundPathNavigation((Mob)this, this.m_9236_());
    private final FlyingPathNavigation flyingPathNavigation = new FlyingPathNavigation((Mob)this, this.m_9236_());

    public SashaKYotoz(EntityType<? extends SashaKYotoz> type, Level level) {
        super((EntityType<? extends PathfinderMob>)((EntityType)WrathyArmamentEntities.SASHAKYOTOZ.get()), level);
        this.f_21364_ = 50;
        this.f_21342_ = new FlyingMoveControl((Mob)this, 15, false);
        this.m_274367_(1.25f);
    }

    public void m_7350_(EntityDataAccessor<?> pKey) {
        if (DATA_SASHAKYOTOZ_PHASE.equals(pKey)) {
            if (!this.isInPhase(SashaKYotozPhase.FLYING)) {
                this.f_21344_ = this.groundPathNavigation;
                this.flying.m_216973_();
            }
            if (!this.isInPhase(SashaKYotozPhase.IDLING)) {
                this.idle.m_216973_();
            }
            switch (this.getSashaKYotozPhase()) {
                case IDLING: {
                    this.idle.m_216977_(this.f_19797_);
                    break;
                }
                case FLYING: {
                    this.flying.m_216977_(this.f_19797_);
                    this.f_21344_ = this.flyingPathNavigation;
                    break;
                }
                case LANDING: {
                    this.landing.m_216977_(this.f_19797_);
                    break;
                }
                case RANGED_ATTACKING: {
                    this.attackPhantomRay.m_216977_(this.f_19797_);
                    this.queueServerWork(10, () -> {
                        this.m_20334_(this.getXVector(-1.0, this.m_146908_()), 0.35, this.getZVector(-1.0, this.m_146908_()));
                        this.rayAttack();
                    });
                    break;
                }
                case MELEE_ATTACKING: {
                    this.attackByBlade.m_216977_(this.f_19797_);
                    this.m_5496_(SoundEvents.f_12232_, 1.5f, 2.0f);
                    this.queueServerWork(20, () -> {
                        if (this.m_5448_() != null && this.m_5448_().m_20280_((Entity)this) < 12.0) {
                            this.hurtTarget((LivingEntity)this, this.m_5448_());
                        }
                    });
                    break;
                }
                case MELEE_SCYTHE_ATTACKING: {
                    this.attackByScythe.m_216977_(this.f_19797_);
                    this.m_5496_(SoundEvents.f_12228_, 1.5f, 2.0f);
                    this.queueServerWork(20, () -> {
                        if (this.m_5448_() != null && this.m_5448_().m_20280_((Entity)this) < 16.0) {
                            this.hurtTarget((LivingEntity)this, this.m_5448_());
                        }
                    });
                    break;
                }
                case MELEE_CIRCLE_ATTACKING: {
                    this.attackCircleOfPhantoms.m_216977_(this.f_19797_);
                    this.m_20256_(new Vec3(0.0, -1.0, 0.0));
                    this.queueServerWork(30, () -> {
                        this.spawnParticle((ParticleOptions)WrathyArmamentMiscRegistries.PHANTOM_RAY.get(), this.m_9236_(), this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), 2.0f);
                        this.m_5496_(SoundEvents.f_12232_, 1.5f, 1.6f);
                        this.hitNearbyMobs((Component)Component.m_237115_((String)"death.attack.wrathy_armament.phantom_shock_message"), 12.0f, 7);
                    });
                }
            }
        }
        super.m_7350_(pKey);
    }

    public boolean m_7327_(Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return false;
        }
        this.m_9236_().m_7605_((Entity)this, (byte)4);
        this.m_5496_(SoundEvents.f_12232_, 1.0f, this.m_6100_());
        return this.hurtTarget((LivingEntity)this, (LivingEntity)entity);
    }

    private boolean hurtTarget(LivingEntity warrior, LivingEntity target) {
        float f = (float)warrior.m_21133_(Attributes.f_22281_);
        boolean flag = target.m_6469_(warrior.m_269291_().m_269333_(warrior), f);
        if (flag) {
            warrior.m_19970_(warrior, (Entity)target);
        }
        return flag;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ % 2 == 0 && this.isInPhase(SashaKYotozPhase.FLYING)) {
            this.animatePhantomFlight();
        }
        if (this.timeOfAbility > 0) {
            --this.timeOfAbility;
        }
        if (this.m_5448_() != null && this.timeOfAbility <= 0) {
            this.setPhase();
        }
    }

    public void setPhase() {
        switch (this.getSashaKYotozPhase()) {
            case IDLING: 
            case LANDING: {
                this.setSashaKYotozPhase(this.m_5448_() == null ? SashaKYotozPhase.IDLING : SashaKYotozPhase.MELEE_ATTACKING);
                break;
            }
            case MELEE_ATTACKING: {
                this.setSashaKYotozPhase(SashaKYotozPhase.MELEE_CIRCLE_ATTACKING);
                break;
            }
            case MELEE_CIRCLE_ATTACKING: {
                this.setSashaKYotozPhase(SashaKYotozPhase.MELEE_SCYTHE_ATTACKING);
                break;
            }
            case MELEE_SCYTHE_ATTACKING: {
                this.setSashaKYotozPhase(SashaKYotozPhase.RANGED_ATTACKING);
                break;
            }
            case RANGED_ATTACKING: {
                this.setSashaKYotozPhase(SashaKYotozPhase.TAKING_OFF);
                break;
            }
            case TAKING_OFF: {
                this.setSashaKYotozPhase(SashaKYotozPhase.FLYING);
                break;
            }
            case FLYING: {
                if (this.m_5448_() == null || !(this.m_5448_().m_20280_((Entity)this) < 9.0)) break;
                this.setSashaKYotozPhase(SashaKYotozPhase.LANDING);
            }
        }
    }

    private void animatePhantomFlight() {
        float f = Mth.m_14089_((float)((float)(this.m_19879_() * 3 + this.f_19797_) * 7.45f * ((float)Math.PI / 180) + (float)Math.PI));
        boolean i = true;
        float f2 = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180))) * (1.1f + 0.21f * (float)i);
        float f3 = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))) * (1.1f + 0.21f * (float)i);
        float f4 = (0.3f + f * 0.45f) * ((float)i * 0.2f + 1.0f);
        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123757_, this.m_20185_() + (double)f2, this.m_20186_() + (double)f4 + 0.5, this.m_20189_() + (double)f3, 0.0, 0.0, 0.0);
        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123757_, this.m_20185_() - (double)f2, this.m_20186_() + (double)f4 + 0.5, this.m_20189_() - (double)f3, 0.0, 0.0, 0.0);
    }

    public void rayAttack() {
        this.m_216990_(SoundEvents.f_12232_);
        double d0 = this.getZVector(1.0, this.m_146908_());
        double d1 = this.getXVector(1.0, this.m_146908_());
        float scaling = 0.0f;
        block0: for (int i1 = 0; i1 < 16; ++i1) {
            BlockPos pos = this.m_9236_().m_45547_(new ClipContext(this.m_20299_(1.0f), this.m_20299_(1.0f).m_82549_(this.m_20252_(1.0f).m_82490_((double)scaling)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)this)).m_82425_();
            if (!this.m_9236_().m_8055_(new BlockPos(pos.m_123341_(), pos.m_123342_(), pos.m_123343_())).m_60815_()) {
                scaling += 1.0f;
            }
            BlockPos pos1 = this.m_9236_().m_45547_(new ClipContext(this.m_20299_(1.0f), this.m_20299_(1.0f).m_82549_(this.m_20252_(1.0f).m_82490_((double)scaling)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)this)).m_82425_();
            this.m_9236_().m_7106_((ParticleOptions)WrathyArmamentMiscRegistries.PHANTOM_RAY.get(), (double)pos1.m_123341_(), (double)pos1.m_123342_(), (double)pos1.m_123343_(), d0, 0.1, d1);
            Vec3 center = new Vec3((double)pos1.m_123341_(), (double)pos1.m_123342_(), (double)pos1.m_123343_());
            List<Entity> entityList = this.m_9236_().m_6443_(Entity.class, new AABB(center, center).m_82400_(4.0), e -> true).stream().sorted(Comparator.comparingDouble(entity -> entity.m_20238_(center))).toList();
            for (Entity entityIterator : entityList) {
                if (entityIterator == this || !(entityIterator instanceof LivingEntity)) continue;
                LivingEntity livingEntity = (LivingEntity)entityIterator;
                float damage = livingEntity.m_21233_() - livingEntity.m_21223_() + 2.0f;
                if (damage > 100.0f) {
                    damage /= 5.0f;
                }
                livingEntity.m_6469_(new DamageSource((Holder)livingEntity.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268433_)){

                    public Component m_6157_(@NotNull LivingEntity _msgEntity) {
                        return Component.m_237115_((String)"death.attack.wrathy_armament.phantom_shock_message");
                    }
                }, damage);
                continue block0;
            }
        }
    }

    public void m_20242_(boolean ignored) {
        super.m_20242_(this.isInPhase(SashaKYotozPhase.FLYING));
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new SashaKYotozMovementGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new SashaKYotozRandomStrollGoal(this, 0.8, 160));
    }

    @Override
    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_SASHAKYOTOZ_PHASE, (Object)SashaKYotozPhase.IDLING);
        super.m_8097_();
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, DamageSource source) {
        return !this.isInPhase(SashaKYotozPhase.FLYING) && super.m_142535_(pFallDistance, pMultiplier, source);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        return !this.m_7090_() && super.m_6469_(source, amount);
    }

    protected void m_6153_() {
        if (!this.death.m_216984_()) {
            this.death.m_216977_(this.f_19797_);
        }
        if (this.f_20919_ == 19) {
            this.m_19983_(new ItemStack((ItemLike)WrathyArmamentItems.PHANTOM_LANCER.get()));
            this.m_20334_(0.0, 0.25, 0.0);
            this.m_21406_(EntityType.f_20509_, false);
        }
        super.m_6153_();
    }

    public void m_6667_(DamageSource source) {
        this.f_20919_ = -10;
        super.m_6667_(source);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 500.0).m_22268_(Attributes.f_22281_, 10.0).m_22268_(Attributes.f_22277_, 48.0).m_22268_(Attributes.f_22284_, 10.0).m_22268_(Attributes.f_22285_, 10.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22280_, 0.5).m_22268_(Attributes.f_22278_, 1.0);
    }

    @Override
    public ServerBossEvent bossInfo() {
        return this.bossEvent;
    }

    public boolean m_7090_() {
        return this.isInPhase(SashaKYotozPhase.LANDING) || this.isInPhase(SashaKYotozPhase.TAKING_OFF) || this.isInPhase(SashaKYotozPhase.FLYING);
    }

    public void setSashaKYotozPhase(SashaKYotozPhase phase) {
        this.f_19804_.m_135381_(DATA_SASHAKYOTOZ_PHASE, (Object)phase);
        this.timeOfAbility = phase.getAbilityTime;
    }

    public SashaKYotozPhase getSashaKYotozPhase() {
        return (SashaKYotozPhase)((Object)this.f_19804_.m_135370_(DATA_SASHAKYOTOZ_PHASE));
    }

    public boolean isInPhase(SashaKYotozPhase phase) {
        return this.getSashaKYotozPhase() == phase;
    }

    public static enum SashaKYotozPhase {
        IDLING(100),
        FLYING(80),
        TAKING_OFF(20),
        LANDING(20),
        RANGED_ATTACKING(80),
        MELEE_ATTACKING(50),
        MELEE_CIRCLE_ATTACKING(60),
        MELEE_SCYTHE_ATTACKING(50);

        public final int getAbilityTime;

        private SashaKYotozPhase(int abilityTime) {
            this.getAbilityTime = abilityTime;
        }
    }
}

