/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.wrathy_armament.entities.bosses.core;

import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.entity.PartEntity;
import net.sashakyotoz.wrathy_armament.entities.bosses.MoonLord;
import net.sashakyotoz.wrathy_armament.registers.WrathyArmamentSounds;

public class MoonLordPart
extends PartEntity<MoonLord> {
    private static final EntityDataAccessor<Float> HEALTH_POINTS = SynchedEntityData.m_135353_(MoonLordPart.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public final MoonLord parentMob;
    public final String name;
    private final EntityDimensions size;

    public MoonLordPart(MoonLord parent, String name, float x, float z) {
        super((Entity)parent);
        this.size = EntityDimensions.m_20395_((float)x, (float)z);
        this.m_6210_();
        this.parentMob = parent;
        this.name = name;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(HEALTH_POINTS, (Object)Float.valueOf(150.0f));
    }

    protected void m_7378_(CompoundTag pCompound) {
        this.f_19804_.m_135381_(HEALTH_POINTS, (Object)Float.valueOf(pCompound.m_128457_("healthPoints")));
    }

    protected void m_7380_(CompoundTag pCompound) {
        pCompound.m_128350_("healthPoints", this.getHealthPoints());
    }

    public boolean m_6087_() {
        return true;
    }

    public float getHealthPoints() {
        return ((Float)this.f_19804_.m_135370_(HEALTH_POINTS)).floatValue();
    }

    @Nullable
    public ItemStack m_142340_() {
        return this.parentMob.m_142340_();
    }

    public boolean m_6469_(DamageSource damageSource, float amount) {
        if (this.getHealthPoints() > 0.0f) {
            this.f_19804_.m_135381_(HEALTH_POINTS, (Object)Float.valueOf(this.getHealthPoints() - amount));
            this.parentMob.damageTakenByPart.put(this.name, 3);
            this.m_5496_(WrathyArmamentSounds.MOON_LORD_HURT, 1.1f, 0.9f);
            return !this.m_6673_(damageSource);
        }
        this.f_19804_.m_135381_(HEALTH_POINTS, (Object)Float.valueOf(0.0f));
        return this.parentMob.m_6469_(damageSource, amount);
    }

    public boolean m_7306_(Entity entity) {
        return this == entity || this.parentMob == entity;
    }

    public EntityDimensions m_6972_(Pose pPose) {
        return this.size;
    }

    public boolean m_142391_() {
        return false;
    }
}

