/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.wrathy_armament.entities.bosses.core;

import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;

public interface PersistentAngerMob {
    public static final String TAG_ANGER_TIME = "AngerTime";
    public static final String TAG_ANGRY_AT = "AngryAt";

    public int getRemainingPersistentAngerTime();

    public void setRemainingPersistentAngerTime(int var1);

    @Nullable
    public UUID getPersistentAngerTarget();

    public void setPersistentAngerTarget(@Nullable UUID var1);

    public void startPersistentAngerTimer();

    default public void addPersistentAngerSaveData(CompoundTag tag) {
        tag.m_128405_(TAG_ANGER_TIME, this.getRemainingPersistentAngerTime());
        if (this.getPersistentAngerTarget() != null) {
            tag.m_128362_(TAG_ANGRY_AT, this.getPersistentAngerTarget());
        }
    }

    default public void readPersistentAngerSaveData(Level level, CompoundTag tag) {
        this.setRemainingPersistentAngerTime(tag.m_128451_(TAG_ANGER_TIME));
        if (level instanceof ServerLevel) {
            if (!tag.m_128403_(TAG_ANGRY_AT)) {
                this.setPersistentAngerTarget(null);
            } else {
                UUID uuid = tag.m_128342_(TAG_ANGRY_AT);
                this.setPersistentAngerTarget(uuid);
                Entity entity = ((ServerLevel)level).m_8791_(uuid);
                if (entity != null) {
                    if (entity instanceof Mob) {
                        this.m_6703_((LivingEntity)((Mob)entity));
                    }
                    if (entity instanceof Player) {
                        Player player = (Player)entity;
                        this.m_6598_(player);
                    }
                }
            }
        }
    }

    default public void updatePersistentAnger(ServerLevel level, boolean p_21668_) {
        LivingEntity livingentity = this.m_5448_();
        UUID uuid = this.getPersistentAngerTarget();
        if ((livingentity == null || livingentity.m_21224_()) && uuid != null && level.m_8791_(uuid) instanceof Mob) {
            this.stopBeingAngry();
        } else {
            if (livingentity != null && !Objects.equals(uuid, livingentity.m_20148_())) {
                this.setPersistentAngerTarget(livingentity.m_20148_());
                this.startPersistentAngerTimer();
            }
            if (!(this.getRemainingPersistentAngerTime() <= 0 || livingentity != null && livingentity.m_6095_() == EntityType.f_20532_ && p_21668_)) {
                this.setRemainingPersistentAngerTime(this.getRemainingPersistentAngerTime() - 1);
                if (this.getRemainingPersistentAngerTime() == 0) {
                    this.stopBeingAngry();
                }
            }
        }
    }

    default public boolean isAngryAt(LivingEntity entity) {
        if (!this.m_6779_(entity)) {
            return false;
        }
        return entity.m_6095_() == EntityType.f_20532_ && this.isAngryAtAllPlayers(entity.m_9236_()) || entity.m_20148_().equals(this.getPersistentAngerTarget());
    }

    default public boolean isAngryAtAllPlayers(Level level) {
        return level.m_46469_().m_46207_(GameRules.f_46127_) && this.isAngry() && this.getPersistentAngerTarget() == null;
    }

    default public boolean isAngry() {
        return this.getRemainingPersistentAngerTime() > 0;
    }

    default public void forgetCurrentTargetAndRefreshUniversalAnger() {
        this.stopBeingAngry();
        this.startPersistentAngerTimer();
    }

    default public void stopBeingAngry() {
        this.m_6703_(null);
        this.setPersistentAngerTarget(null);
        this.m_6710_(null);
        this.setRemainingPersistentAngerTime(0);
    }

    @Nullable
    public LivingEntity m_21188_();

    public void m_6703_(@Nullable LivingEntity var1);

    public void m_6598_(@Nullable Player var1);

    public void m_6710_(@Nullable LivingEntity var1);

    public boolean m_6779_(LivingEntity var1);

    @Nullable
    public LivingEntity m_5448_();
}

