/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.wrathy_armament.entities.technical;

import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.sashakyotoz.wrathy_armament.registers.WrathyArmamentEntities;
import net.sashakyotoz.wrathy_armament.registers.WrathyArmamentItems;
import net.sashakyotoz.wrathy_armament.utils.OnActionsTrigger;

public class BladeOfChaosEntity
extends AbstractArrow {
    public int timer;
    private boolean movementFlag;
    private static final EntityDataAccessor<Byte> RETURNING_SPEED = SynchedEntityData.m_135353_(BladeOfChaosEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<String> BEHAVIOR = SynchedEntityData.m_135353_(BladeOfChaosEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private boolean dealtDamage;
    public int clientSideReturnBladeTickCount;
    private ItemStack blade = new ItemStack((ItemLike)WrathyArmamentItems.BLADE_OF_CHAOS.get());

    public BladeOfChaosEntity(Level level, ItemStack stack, LivingEntity livingEntity, String behavior) {
        super((EntityType)WrathyArmamentEntities.BLADE_OF_CHAOS.get(), livingEntity, level);
        this.f_19804_.m_135381_(RETURNING_SPEED, (Object)5);
        this.blade = stack.m_41777_();
        this.f_19804_.m_135381_(BEHAVIOR, (Object)behavior);
        this.m_20242_(!behavior.equals(PossibleBehavior.CRUSH.behaviorName));
        this.timer = 150;
    }

    public BladeOfChaosEntity(EntityType<BladeOfChaosEntity> type, Level level) {
        super(type, level);
        this.timer = 150;
        this.f_19804_.m_135381_(RETURNING_SPEED, (Object)5);
        this.m_20242_(true);
    }

    public String getBehavior() {
        return (String)this.f_19804_.m_135370_(BEHAVIOR);
    }

    public void m_8119_() {
        if (this.timer > 0) {
            --this.timer;
        }
        if (this.f_36704_ > 4) {
            this.dealtDamage = true;
        }
        if (!this.m_9236_().m_46749_(this.m_20097_())) {
            this.m_9236_().m_46597_(this.m_20097_(), this.m_9236_().m_8055_(this.m_20097_()));
        }
        if (!this.isAcceptibleReturnOwner()) {
            this.m_146870_();
        }
        Entity entity = this.m_19749_();
        byte i = (Byte)this.f_19804_.m_135370_(RETURNING_SPEED);
        double speed = 1.5;
        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123756_, this.m_20185_(), this.m_20186_(), this.m_20189_(), OnActionsTrigger.getXVector(speed, this.m_146908_()), OnActionsTrigger.getYVector(speed, this.m_146909_()), OnActionsTrigger.getZVector(speed, this.m_146908_()));
        if (this.timer > 100) {
            switch (this.getBehavior()) {
                case "NEMEAN_CRUSH": {
                    break;
                }
                case "CYCLONE_OF_CHAOS": {
                    if (entity == null) break;
                    BlockPos pos = entity.m_20097_().m_6630_(2);
                    float radius = 4.0f;
                    float angle = (float)(this.f_19797_ % 360) * 5.0f;
                    if (angle >= 360.0f) {
                        angle -= 180.0f;
                    }
                    double x = (double)pos.m_123341_() + (double)radius * Math.cos(angle);
                    double z = (double)pos.m_123343_() + (double)radius * Math.sin(angle);
                    this.m_6034_(x, pos.m_123342_(), z);
                    if (this.f_19797_ % 2 != 0) break;
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123744_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
                    Vec3 center = new Vec3(x, (double)pos.m_123342_(), z);
                    List<Entity> entityList = this.m_9236_().m_6443_(Entity.class, new AABB(center, center).m_82400_(2.0), e -> true).stream().sorted(Comparator.comparingDouble(entity1 -> entity1.m_20238_(center))).toList();
                    for (Entity entityI : entityList) {
                        if (entityI == entity || !(entityI instanceof LivingEntity)) continue;
                        LivingEntity livingEntity = (LivingEntity)entityI;
                        livingEntity.m_6469_(entity.m_269291_().m_269390_((Entity)this, entity), 6.0f);
                        livingEntity.m_20254_(5);
                    }
                    break;
                }
                case "WRATH_OF_ARTEMIS": {
                    if (this.m_19749_() == null) break;
                    if (this.m_20280_(this.m_19749_()) > 40.0 && this.m_20186_() > this.m_19749_().m_20186_() + 3.0) {
                        this.movementFlag = true;
                    }
                    if (!this.movementFlag) {
                        this.m_20334_(this.m_20184_().f_82479_, 1.0, this.m_20184_().f_82481_);
                        break;
                    }
                    this.m_20334_(0.0, -1.0, 0.0);
                }
            }
        }
        if (entity != null && this.timer < 120) {
            this.m_36790_(true);
            Vec3 vec3 = entity.m_146892_().m_82546_(this.m_20182_());
            this.m_20343_(this.m_20185_(), this.m_20186_() + vec3.f_82480_ * 0.015 * (double)i, this.m_20189_());
            if (this.m_9236_().f_46443_) {
                this.f_19791_ = this.m_20186_();
            }
            if (this.getBehavior().equals(PossibleBehavior.CRUSH.behaviorName)) {
                List<Entity> entityList = this.m_9236_().m_6443_(Entity.class, new AABB(this.m_20097_().m_252807_(), this.m_20097_().m_252807_()).m_82400_(2.0), e -> true).stream().sorted(Comparator.comparingDouble(entity1 -> entity1.m_20238_(this.m_20097_().m_252807_()))).toList();
                for (Entity entityI : entityList) {
                    if (entityI == entity || !(entityI instanceof LivingEntity)) continue;
                    LivingEntity livingEntity = (LivingEntity)entityI;
                    livingEntity.m_6469_(entity.m_269291_().m_269390_((Entity)this, entity), 6.0f);
                    livingEntity.m_20254_(5);
                }
            }
            double d0 = 0.05 * (double)i;
            this.m_20256_(this.m_20184_().m_82490_(0.95).m_82549_(vec3.m_82541_().m_82490_(d0)));
            if (this.clientSideReturnBladeTickCount == 0) {
                this.m_5496_(SoundEvents.f_12031_, 2.0f, 0.5f);
            }
            ++this.clientSideReturnBladeTickCount;
        }
        super.m_8119_();
    }

    private boolean isAcceptibleReturnOwner() {
        Entity entity = this.m_19749_();
        return entity != null && entity.m_6084_();
    }

    @Nullable
    protected EntityHitResult m_6351_(Vec3 vec3, Vec3 vec31) {
        return this.dealtDamage ? null : super.m_6351_(vec3, vec31);
    }

    protected void m_5790_(EntityHitResult hitResult) {
        Entity entity = hitResult.m_82443_();
        float f = 15.0f;
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            f += EnchantmentHelper.m_44833_((ItemStack)this.blade, (MobType)livingEntity.m_6336_());
        }
        Entity owner = this.m_19749_();
        DamageSource damagesource = this.m_269291_().m_269390_((Entity)this, (Entity)(owner == null ? this : owner));
        this.dealtDamage = true;
        if (entity.m_6469_(damagesource, f) && entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (owner instanceof LivingEntity) {
                entity.m_6469_(this.m_269291_().m_269233_(), f);
            }
            this.m_7761_(livingEntity);
            this.m_5496_(SoundEvents.f_12031_, 2.0f, 0.5f);
        }
        if (!this.getBehavior().equals(PossibleBehavior.CRUSH.behaviorName)) {
            this.m_20256_(this.m_20184_().m_82542_(-0.01, -0.1, -0.01));
        }
    }

    protected void m_8060_(BlockHitResult pResult) {
        if (this.getBehavior().equals(PossibleBehavior.WRATH.behaviorName) && this.movementFlag) {
            this.m_9236_().m_255391_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 3.0f, false, Level.ExplosionInteraction.NONE);
            OnActionsTrigger.addParticles((ParticleOptions)ParticleTypes.f_123778_, this.m_9236_(), this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), 1.5f);
            this.m_20334_(0.0, 0.5, 0.0);
            this.movementFlag = false;
        } else {
            super.m_8060_(pResult);
        }
    }

    protected ItemStack m_7941_() {
        return this.blade.m_41777_();
    }

    protected SoundEvent m_7239_() {
        return SoundEvents.f_12032_;
    }

    public void m_6123_(Player player) {
        if (this.m_150171_((Entity)player)) {
            super.m_6123_(player);
        } else if (this.m_19749_() == null) {
            this.m_19983_(this.blade.m_41777_());
        }
    }

    public boolean m_142470_(Player pPlayer) {
        return switch (this.f_36705_) {
            case AbstractArrow.Pickup.ALLOWED -> this.addItemToPlayer(pPlayer);
            case AbstractArrow.Pickup.CREATIVE_ONLY -> pPlayer.m_150110_().f_35937_;
            default -> false;
        };
    }

    private boolean addItemToPlayer(Player player) {
        if (player.m_21205_().m_41619_()) {
            player.m_8061_(EquipmentSlot.MAINHAND, this.m_7941_());
            return true;
        }
        if (player.m_21206_().m_41619_()) {
            player.m_8061_(EquipmentSlot.OFFHAND, this.m_7941_());
            return true;
        }
        return player.m_150109_().m_36054_(this.m_7941_());
    }

    protected float m_6882_() {
        return 0.99f;
    }

    public boolean m_6000_(double pX, double pY, double pZ) {
        return true;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(RETURNING_SPEED, (Object)0);
        this.f_19804_.m_135372_(BEHAVIOR, (Object)"");
    }

    public static enum PossibleBehavior {
        CRUSH("NEMEAN_CRUSH"),
        CYCLONE("CYCLONE_OF_CHAOS"),
        WRATH("WRATH_OF_ARTEMIS");

        public final String behaviorName;

        private PossibleBehavior(String behaviorName) {
            this.behaviorName = behaviorName;
        }
    }
}

