/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.wrathy_armament.entities.technical;

import java.util.Comparator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.TheEndGatewayBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.sashakyotoz.wrathy_armament.entities.bosses.JohannesKnight;
import net.sashakyotoz.wrathy_armament.entities.technical.VanishableLikeEntity;
import net.sashakyotoz.wrathy_armament.registers.WrathyArmamentMiscRegistries;
import net.sashakyotoz.wrathy_armament.utils.OnActionsTrigger;

public class HarmfulProjectileEntity
extends VanishableLikeEntity {
    private static final EntityDataAccessor<String> PROJECTILE_TYPE = SynchedEntityData.m_135353_(HarmfulProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Integer> DAMAGE = SynchedEntityData.m_135353_(HarmfulProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private Vec3 vec3 = null;
    public static final EntityDimensions LARGE_SIZE = EntityDimensions.m_20398_((float)2.5f, (float)2.5f);
    public static final EntityDimensions HUGE_SIZE = EntityDimensions.m_20398_((float)3.0f, (float)3.0f);

    public HarmfulProjectileEntity(EntityType<?> type, Level level, int damage, String s) {
        super(type, level);
        this.f_19804_.m_135381_(DAMAGE, (Object)damage);
        this.setProjectileType(s);
        if (s.equals("vertical_circle")) {
            this.f_19794_ = true;
            this.vec3 = new Vec3((double)this.m_9236_().f_46441_.m_216339_(-1, 2), 0.25, (double)this.m_9236_().f_46441_.m_216339_(-1, 2));
        }
    }

    public HarmfulProjectileEntity(EntityType<HarmfulProjectileEntity> type, Level level) {
        super(type, level);
    }

    public String getProjectileType() {
        return (String)this.f_19804_.m_135370_(PROJECTILE_TYPE);
    }

    private int getDamage() {
        return (Integer)this.f_19804_.m_135370_(DAMAGE);
    }

    public void setProjectileType(String s) {
        this.f_19804_.m_135381_(PROJECTILE_TYPE, (Object)s);
    }

    private void onHit(HitResult result) {
        HitResult.Type resultType = result.m_6662_();
        if (resultType == HitResult.Type.ENTITY) {
            this.onHitEntity((EntityHitResult)result);
            this.m_9236_().m_214171_(GameEvent.f_157777_, result.m_82450_(), GameEvent.Context.m_223719_((Entity)this, null));
        }
    }

    public EntityDimensions m_6972_(Pose pose) {
        return switch (this.getProjectileType()) {
            case "huge_sword" -> LARGE_SIZE;
            case "shield_dash" -> HUGE_SIZE;
            default -> super.m_6972_(pose);
        };
    }

    private void onHitEntity(EntityHitResult hitResult) {
        Entity entity = hitResult.m_82443_();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (this.owner != null) {
                livingEntity.m_6469_(this.owner.m_269291_().m_269333_(this.owner), (float)this.getDamage());
                if (this.getProjectileType().equals("shield_dash")) {
                    livingEntity.m_20334_(this.getXVector(this.m_146908_()), this.getYVector(this.m_146909_()) + 0.25, this.getZVector(this.m_146908_()));
                    if (!this.m_9236_().m_5776_()) {
                        this.m_9236_().m_254849_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 4.0f, Level.ExplosionInteraction.NONE);
                    }
                }
                this.m_146870_();
            }
        }
    }

    private boolean canHitEntity(Entity entity1) {
        if (!entity1.m_271807_()) {
            return false;
        }
        LivingEntity entity = this.owner;
        return entity == null || !entity.m_20365_(entity1);
    }

    private void explode() {
        this.m_9236_().m_254849_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 2.5f, Level.ExplosionInteraction.NONE);
        if (this.owner != null) {
            FireworkRocketEntity firework = new FireworkRocketEntity(this.m_9236_(), this.getFirework(), this.owner);
            this.m_9236_().m_7967_((Entity)firework);
        }
        this.m_146870_();
    }

    public void m_6075_() {
        super.m_6075_();
        if (this.timeToVanish < 80 && this.getProjectileType().equals("axe")) {
            ++this.timeToVanish;
        } else if (this.timeToVanish < 100 && (this.getProjectileType().equals("dagger") || this.getProjectileType().equals("knight_dagger"))) {
            ++this.timeToVanish;
        } else if (this.timeToVanish < 90 && this.getProjectileType().equals("knight_axe")) {
            ++this.timeToVanish;
        } else if (this.timeToVanish < 200 && this.getProjectileType().equals("huge_sword")) {
            ++this.timeToVanish;
        } else if (this.timeToVanish < 30 && this.getProjectileType().equals("shield_dash")) {
            ++this.timeToVanish;
        } else if (this.timeToVanish < 50 && this.getProjectileType().equals("vertical_circle")) {
            ++this.timeToVanish;
        } else if (this.getProjectileType().equals("vertical_circle")) {
            this.explode();
        } else {
            this.m_146870_();
        }
        if (this.timeToVanish > 15) {
            this.m_6210_();
            this.m_6478_(MoverType.SELF, this.m_20184_());
            if (this.owner == null && (this.getProjectileType().equals("dagger") || this.getProjectileType().equals("axe") || this.getProjectileType().equals("shield_dash"))) {
                this.owner = this.getNearestPlayer();
            }
            if (this.owner == null && (this.getProjectileType().equals("knight_dagger") || this.getProjectileType().equals("knight_axe"))) {
                this.owner = this.getNearestKnight();
            }
            if (this.f_19797_ % 5 == 0) {
                Vec3 vec31 = this.m_20184_();
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123797_, this.m_20185_() - vec31.f_82479_, this.m_20186_() - vec31.f_82480_ + 0.5, this.m_20189_() - vec31.f_82481_, 0.0, 0.0, 0.0);
            }
            HitResult hitresult = ProjectileUtil.m_278158_((Entity)this, this::canHitEntity);
            boolean flag = false;
            if (hitresult.m_6662_() == HitResult.Type.BLOCK) {
                BlockPos blockpos = ((BlockHitResult)hitresult).m_82425_();
                BlockState blockstate = this.m_9236_().m_8055_(blockpos);
                if (this.getProjectileType().equals("vertical_circle")) {
                    this.explode();
                }
                if (blockstate.m_60713_(Blocks.f_50142_)) {
                    this.m_20221_(blockpos);
                    flag = true;
                } else if (blockstate.m_60713_(Blocks.f_50446_)) {
                    BlockEntity blockentity = this.m_9236_().m_7702_(blockpos);
                    if (blockentity instanceof TheEndGatewayBlockEntity && TheEndGatewayBlockEntity.m_59940_((Entity)this)) {
                        TheEndGatewayBlockEntity.m_155828_((Level)this.m_9236_(), (BlockPos)blockpos, (BlockState)blockstate, (Entity)this, (TheEndGatewayBlockEntity)((TheEndGatewayBlockEntity)blockentity));
                    }
                    flag = true;
                } else {
                    this.m_146870_();
                }
            }
            if (hitresult.m_6662_() != HitResult.Type.MISS && !flag) {
                this.onHit(hitresult);
            }
            switch (this.getProjectileType()) {
                case "axe": 
                case "knight_axe": {
                    if (this.vec3 == null && this.owner != null) {
                        this.vec3 = new Vec3(this.getXVector(this.owner.m_146908_()), -0.16, this.getZVector(this.owner.m_146908_()));
                    }
                    if (this.vec3 == null) break;
                    this.m_20256_(this.vec3);
                    break;
                }
                case "shield_dash": {
                    Level level;
                    if (this.vec3 == null && this.owner != null) {
                        this.vec3 = new Vec3(this.getXVector(this.owner.m_146908_()), 0.0, this.getZVector(this.owner.m_146908_()));
                    }
                    if (this.vec3 == null) break;
                    this.m_20256_(this.vec3);
                    if (this.f_19797_ % 10 != 0 || !((level = this.m_9236_()) instanceof ServerLevel)) break;
                    ServerLevel level2 = (ServerLevel)level;
                    level2.m_8767_((ParticleOptions)ParticleTypes.f_123810_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 3, this.getXVector(-this.m_146908_()), this.getYVector(this.m_146909_()), this.getZVector(-this.m_146908_()), 1.5);
                    break;
                }
                case "dagger": 
                case "knight_dagger": {
                    if (this.vec3 == null && this.owner != null) {
                        this.vec3 = new Vec3(this.getXVector(this.owner.m_146908_()), 0.0, this.getZVector(this.owner.m_146908_()));
                    }
                    if (this.vec3 == null) break;
                    this.m_20256_(this.vec3);
                    break;
                }
                case "huge_sword": {
                    this.swordKnockback();
                    this.m_20334_(0.0, -0.15, 0.0);
                    if (this.timeToVanish >= 120 || this.f_19797_ % 5 != 0) break;
                    this.clientDiggingParticles();
                    break;
                }
                case "vertical_circle": {
                    if (this.f_19797_ % 2 != 0) break;
                    this.m_246865_(new Vec3(0.0, (double)-0.04f, 0.0));
                    this.m_9236_().m_7106_((ParticleOptions)WrathyArmamentMiscRegistries.BEAM_SPARKLES.get(), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.25, 0.0);
                }
            }
        }
    }

    private void clientDiggingParticles() {
        RandomSource randomsource = this.f_19796_;
        BlockState blockstate = this.m_20075_();
        if (blockstate.m_60799_() != RenderShape.INVISIBLE) {
            for (int i = 0; i < 30; ++i) {
                double d0 = this.m_20185_() + (double)Mth.m_216283_((RandomSource)randomsource, (float)-0.7f, (float)0.7f);
                double d1 = this.m_20186_() + 0.5;
                double d2 = this.m_20189_() + (double)Mth.m_216283_((RandomSource)randomsource, (float)-0.7f, (float)0.7f);
                this.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockstate), d0, d1, d2, 0.0, 0.0, 0.0);
            }
        }
    }

    private ItemStack getFirework() {
        ItemStack stack = Items.f_42688_.m_7968_();
        CompoundTag fireworkTag = new CompoundTag();
        CompoundTag fireworksTag = new CompoundTag();
        int[] colors = new int[]{4882687};
        ListTag explosionsTag = new ListTag();
        CompoundTag explosionTag = new CompoundTag();
        explosionTag.m_128405_("Type", 1);
        explosionTag.m_128385_("Colors", colors);
        explosionTag.m_128385_("FadeColors", new int[]{6724056});
        explosionTag.m_128379_("Flicker", true);
        explosionTag.m_128379_("Trail", true);
        explosionsTag.add((Object)explosionTag);
        fireworksTag.m_128365_("Explosions", (Tag)explosionsTag);
        fireworksTag.m_128405_("Flight", -2);
        fireworkTag.m_128365_("Fireworks", (Tag)fireworksTag);
        stack.m_41751_(fireworkTag);
        return stack;
    }

    private void swordKnockback() {
        if (this.owner != null) {
            Vec3 center = new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_());
            List<LivingEntity> entityList = this.m_9236_().m_6443_(LivingEntity.class, new AABB(center, center).m_82400_(2.0), e -> true).stream().sorted(Comparator.comparingDouble(entity -> entity.m_20238_(center))).toList();
            for (LivingEntity entityIterator : entityList) {
                if (entityIterator instanceof JohannesKnight) continue;
                entityIterator.m_6469_(this.m_269291_().m_269333_(this.owner), 8.0f);
                entityIterator.m_20334_(OnActionsTrigger.getXVector(2.0, 180.0f - entityIterator.m_146908_()), 0.5, OnActionsTrigger.getZVector(2.0, 180.0f - entityIterator.m_146908_()));
            }
        }
    }

    public JohannesKnight getNearestKnight() {
        Vec3 center = new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_());
        List<Entity> entityList = this.m_9236_().m_6443_(Entity.class, new AABB(center, center).m_82400_(24.0), e -> true).stream().sorted(Comparator.comparingDouble(entity -> entity.m_20238_(center))).toList();
        for (Entity entityIterator : entityList) {
            if (!(entityIterator instanceof JohannesKnight)) continue;
            JohannesKnight johannesKnight = (JohannesKnight)entityIterator;
            return johannesKnight;
        }
        return null;
    }

    @Override
    protected void m_8097_() {
        this.f_19804_.m_135372_(PROJECTILE_TYPE, (Object)"dagger");
        this.f_19804_.m_135372_(DAMAGE, (Object)5);
    }
}

