/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.wrathy_armament.entities.technical;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.level.Level;
import net.sashakyotoz.wrathy_armament.registers.WrathyArmamentEntities;

public class JohannesSpearEntity
extends Entity
implements TraceableEntity {
    private int warmupDelayTicks;
    private boolean sentSpikeEvent;
    public int lifeTicks = 22;
    private boolean clientSideAttackStarted;
    @Nullable
    private LivingEntity owner;
    @Nullable
    private UUID ownerUUID;

    public JohannesSpearEntity(EntityType<? extends JohannesSpearEntity> type, Level level) {
        super(type, level);
    }

    public JohannesSpearEntity(Level level, double x, double y, double z, float v, int warmupDelayTicks, LivingEntity living) {
        this((EntityType<? extends JohannesSpearEntity>)((EntityType)WrathyArmamentEntities.JOHANNES_SPEAR.get()), level);
        this.warmupDelayTicks = warmupDelayTicks;
        this.setOwner(living);
        this.m_146922_(v * 57.295776f);
        this.m_6034_(x, y, z);
    }

    protected void m_8097_() {
    }

    public void setOwner(@Nullable LivingEntity living) {
        this.owner = living;
        this.ownerUUID = living == null ? null : living.m_20148_();
    }

    @Nullable
    public LivingEntity getOwner() {
        Entity entity;
        if (this.owner == null && this.ownerUUID != null && this.m_9236_() instanceof ServerLevel && (entity = ((ServerLevel)this.m_9236_()).m_8791_(this.ownerUUID)) instanceof LivingEntity) {
            this.owner = (LivingEntity)entity;
        }
        return this.owner;
    }

    protected void m_7378_(CompoundTag compoundTag) {
        this.warmupDelayTicks = compoundTag.m_128451_("Warmup");
        if (compoundTag.m_128403_("Owner")) {
            this.ownerUUID = compoundTag.m_128342_("Owner");
        }
    }

    protected void m_7380_(CompoundTag compoundTag) {
        compoundTag.m_128405_("Warmup", this.warmupDelayTicks);
        if (this.ownerUUID != null) {
            compoundTag.m_128362_("Owner", this.ownerUUID);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            if (this.clientSideAttackStarted) {
                --this.lifeTicks;
                if (this.lifeTicks == 14) {
                    for (int i = 0; i < 12; ++i) {
                        double d0 = this.m_20185_() + (this.f_19796_.m_188500_() * 2.0 - 1.0) * (double)this.m_20205_() * 0.5;
                        double d1 = this.m_20186_() + 0.05 + this.f_19796_.m_188500_();
                        double d2 = this.m_20189_() + (this.f_19796_.m_188500_() * 2.0 - 1.0) * (double)this.m_20205_() * 0.5;
                        double d3 = (this.f_19796_.m_188500_() * 2.0 - 1.0) * 0.3;
                        double d4 = 0.3 + this.f_19796_.m_188500_() * 0.3;
                        double d5 = (this.f_19796_.m_188500_() * 2.0 - 1.0) * 0.3;
                        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123797_, d0, d1 + 1.0, d2, d3, d4, d5);
                    }
                }
            }
        } else if (--this.warmupDelayTicks < 0) {
            if (this.warmupDelayTicks == -8) {
                for (LivingEntity livingentity : this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82377_(0.2, 0.0, 0.2))) {
                    this.dealDamageTo(livingentity);
                }
            }
            if (!this.sentSpikeEvent) {
                this.m_9236_().m_7605_((Entity)this, (byte)4);
                this.sentSpikeEvent = true;
            }
            if (--this.lifeTicks < 0) {
                this.m_146870_();
            }
        }
    }

    private void dealDamageTo(LivingEntity living) {
        LivingEntity livingentity = this.getOwner();
        if (living.m_6084_() && !living.m_20147_() && living != livingentity) {
            if (livingentity == null) {
                living.m_6469_(this.m_269291_().m_269425_(), 6.0f);
            } else {
                if (livingentity.m_7307_((Entity)living)) {
                    return;
                }
                living.m_6469_(this.m_269291_().m_269104_((Entity)this, (Entity)livingentity), 6.0f);
            }
        }
    }

    public void m_7822_(byte bytes) {
        super.m_7822_(bytes);
        if (bytes == 4) {
            this.clientSideAttackStarted = true;
            if (!this.m_20067_()) {
                this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11865_, this.m_5720_(), 1.0f, this.f_19796_.m_188501_() * 0.2f + 0.85f, false);
            }
        }
    }

    public float getAnimationProgress(float j) {
        if (!this.clientSideAttackStarted) {
            return 0.0f;
        }
        int i = this.lifeTicks - 2;
        return i <= 0 ? 1.0f : 1.0f - ((float)i - j) / 20.0f;
    }
}

