/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.wrathy_armament.items;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.sashakyotoz.anitexlib.client.particles.parents.options.ColorableParticleOption;
import net.sashakyotoz.anitexlib.client.renderer.IParticleItem;
import net.sashakyotoz.wrathy_armament.Config;
import net.sashakyotoz.wrathy_armament.items.SwingParticleHolder;
import net.sashakyotoz.wrathy_armament.utils.OnActionsTrigger;
import net.sashakyotoz.wrathy_armament.utils.capabilities.items.XPTiers;
import org.jetbrains.annotations.Nullable;

public abstract class SwordLikeItem
extends Item
implements Vanishable,
IParticleItem {
    public SwordLikeItem(Item.Properties properties) {
        super(properties);
    }

    public void rightClickBlock(Player player, ItemStack stack) {
    }

    public abstract void leftClickAttack(Player var1, ItemStack var2);

    public abstract void rightClick(Player var1, ItemStack var2);

    public abstract void rightClickOnShiftClick(Player var1, ItemStack var2);

    public boolean m_6777_(BlockState state, Level level, BlockPos blockPos, Player player) {
        return !player.m_7500_();
    }

    public float m_8102_(ItemStack stack, BlockState state) {
        if (state.m_60713_(Blocks.f_50033_)) {
            return 15.0f;
        }
        return state.m_204336_(BlockTags.f_278398_) ? 1.5f : 1.0f;
    }

    public boolean m_6813_(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity entity) {
        if (state.m_60800_((BlockGetter)level, pos) != 0.0f) {
            stack.m_41622_(2, entity, entity1 -> entity1.m_21166_(EquipmentSlot.MAINHAND));
        }
        return true;
    }

    public boolean m_8096_(BlockState state) {
        return state.m_60713_(Blocks.f_50033_);
    }

    @Nullable
    public abstract SwingParticleHolder getSwingHolder(LivingEntity var1, ItemStack var2);

    public boolean m_7579_(ItemStack stack, LivingEntity livingEntity, LivingEntity entity) {
        stack.m_41622_(1, entity, entity1 -> entity1.m_21166_(EquipmentSlot.MAINHAND));
        if (this.getCurrentSparkles(stack) < 6 && (float)this.getStoredXP(stack) < (float)XPTiers.XP_FOR_FIFTH_TIER.getNeededXP() * 1.5f) {
            this.setStoredXP(stack, this.getStoredXP(stack) + entity.m_217043_().m_216339_(1, 11));
        }
        return true;
    }

    public void playAnimAndEffects(Level level, Player player, String animName, SoundEvent event, @Nullable ParticleOptions options, boolean flag) {
        OnActionsTrigger.playPlayerAnimation(level, player, animName, flag);
        player.m_216990_(event);
        if (options != null) {
            OnActionsTrigger.addParticles(options, level, player.m_20185_(), player.m_20186_() + 0.25, player.m_20189_(), (float)player.m_217043_().m_188503_(12) / 10.0f + 0.5f);
        }
    }

    public int getCurrentSparkles(ItemStack stack) {
        return stack.m_41784_().m_128451_("Sparkles");
    }

    public int getStoredXP(ItemStack stack) {
        return stack.m_41784_().m_128451_("CombatExperience");
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return super.canApplyAtEnchantingTable(stack, enchantment) && (Boolean)Config.Common.CAN_SHARPNESS_BE_APPLIED.get() != false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return EnchantmentHelper.m_44831_((ItemStack)book).containsKey(Enchantments.f_44977_) ? (Boolean)Config.Common.CAN_SHARPNESS_BE_APPLIED.get() : true;
    }

    public void setStoredXP(ItemStack stack, int value) {
        stack.m_41784_().m_128405_("CombatExperience", value);
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
        if (!pStack.m_41784_().m_128441_("Sparkles")) {
            pStack.m_41784_().m_128405_("Sparkles", 0);
        }
        int sparkles = Math.min(this.getCurrentSparkles(pStack), 5);
        MutableComponent sparkleOnItem = Component.m_237113_((String)"\u2747".repeat(Math.max(0, sparkles))).m_130940_(ChatFormatting.GOLD).m_7220_((Component)Component.m_237113_((String)"\u2747".repeat(Math.max(0, 5 - sparkles))).m_130940_(ChatFormatting.DARK_GRAY));
        pTooltipComponents.add((Component)sparkleOnItem);
        pTooltipComponents.add(CommonComponents.f_237098_);
        if (Screen.m_96638_()) {
            this.appendSwordsDesc(pStack, pLevel, pTooltipComponents);
        } else {
            pTooltipComponents.add(this.getShiftTooltip());
        }
    }

    public abstract void appendSwordsDesc(ItemStack var1, @Nullable Level var2, List<Component> var3);

    public void addParticles(Level level, ItemEntity itemEntity) {
        if (this.getStoredXP(itemEntity.m_32055_()) > XPTiers.values()[this.getCurrentSparkles(itemEntity.m_32055_())].getNeededXP() && itemEntity.f_19797_ % 10 == 0) {
            OnActionsTrigger.addParticles((ParticleOptions)new ColorableParticleOption("sparkle", 1.0f, 1.0f, 1.0f), level, itemEntity.m_20185_(), itemEntity.m_20186_() + 0.25, itemEntity.m_20189_(), 1.5f);
        }
    }

    private Component getShiftTooltip() {
        return Component.m_237115_((String)"tooltip.press_shift").m_130940_(ChatFormatting.DARK_GRAY);
    }
}

