/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.wrathy_armament.items.swords;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Comparator;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.ModList;
import net.sashakyotoz.wrathy_armament.entities.alive.LichMyrmidon;
import net.sashakyotoz.wrathy_armament.entities.technical.ParticleLikeEntity;
import net.sashakyotoz.wrathy_armament.items.SwingParticleHolder;
import net.sashakyotoz.wrathy_armament.items.SwordLikeItem;
import net.sashakyotoz.wrathy_armament.registers.WrathyArmamentEntities;
import net.sashakyotoz.wrathy_armament.registers.WrathyArmamentItems;
import net.sashakyotoz.wrathy_armament.registers.WrathyArmamentMiscRegistries;
import net.sashakyotoz.wrathy_armament.utils.OnActionsTrigger;
import org.antlr.v4.runtime.misc.Triple;
import org.jetbrains.annotations.Nullable;

public class Frostmourne
extends SwordLikeItem {
    public Frostmourne(Item.Properties properties) {
        super(properties);
    }

    @Override
    public void leftClickAttack(Player player, ItemStack stack) {
    }

    @Override
    public void rightClick(Player player, ItemStack stack) {
    }

    @Override
    public void rightClickOnShiftClick(Player player, ItemStack stack) {
        Level level;
        if (stack.m_41784_().m_128451_("charge") > 1 && !player.m_36335_().m_41519_(stack.m_41720_()) && !player.m_6117_() && (level = player.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            stack.m_41784_().m_128405_("charge", stack.m_41784_().m_128451_("charge") - 1);
            LichMyrmidon lichMyrmidon = new LichMyrmidon((EntityType<? extends LichMyrmidon>)((EntityType)WrathyArmamentEntities.LICH_MYRMIDON.get()), (Level)serverLevel);
            lichMyrmidon.m_6027_(player.m_20185_(), player.m_20186_() + 1.0, player.m_20189_());
            lichMyrmidon.setHaveToFindOwner(true);
            serverLevel.m_7967_((Entity)lichMyrmidon);
            player.m_5496_(SoundEvents.f_12404_, 1.5f, 0.9f);
            player.m_36335_().m_41524_(stack.m_41720_(), 30);
        }
    }

    @Override
    @Nullable
    public SwingParticleHolder getSwingHolder(LivingEntity holder, ItemStack stack) {
        return new SwingParticleHolder((ParticleType)WrathyArmamentMiscRegistries.FROST_SOUL_RAY.get(), 1.1f);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        if (slot == EquipmentSlot.MAINHAND) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            builder.putAll(super.getAttributeModifiers(slot, stack));
            builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", 15.5 + (double)((float)this.getCurrentSparkles(stack) / 2.0f), AttributeModifier.Operation.ADDITION));
            builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", -2.8, AttributeModifier.Operation.ADDITION));
            return builder.build();
        }
        return super.getAttributeModifiers(slot, stack);
    }

    @Override
    public void appendSwordsDesc(ItemStack itemstack, Level world, List<Component> list) {
        MutableComponent charge = Component.m_237115_((String)"item.wrathy_armament.frostmourne_charge");
        charge.m_130940_(WrathyArmamentItems.TITLE_FORMAT);
        charge.m_7220_(CommonComponents.f_263701_).m_7220_((Component)Component.m_237115_((String)("" + itemstack.m_41784_().m_128451_("charge"))));
        list.add((Component)Component.m_237115_((String)"item.wrathy_armament.game.frostmourne").m_130940_(WrathyArmamentItems.TITLE_FORMAT).m_130940_(ChatFormatting.ITALIC));
        list.add(CommonComponents.f_237098_);
        list.add((Component)Component.m_237115_((String)"item.wrathy_armament.abilities").m_130940_(WrathyArmamentItems.TITLE_FORMAT));
        list.add((Component)Component.m_237115_((String)"item.wrathy_armament.right_hand").m_130940_(WrathyArmamentItems.DARK_GREY_TITLE_FORMAT));
        list.add(CommonComponents.f_237098_);
        list.add((Component)Component.m_237115_((String)"item.wrathy_armament.frostmourne_hint").m_130940_(WrathyArmamentItems.AQUA_TITLE_FORMAT));
        list.add((Component)Component.m_237115_((String)"item.wrathy_armament.frostmourne_attack").m_130940_(WrathyArmamentItems.TITLE_FORMAT));
        list.add(CommonComponents.f_237098_);
        list.add((Component)Component.m_237115_((String)"item.wrathy_armament.frostmourne_hint1").m_130940_(WrathyArmamentItems.AQUA_TITLE_FORMAT));
        list.add((Component)Component.m_237115_((String)"item.wrathy_armament.frostmourne_attack1").m_130940_(WrathyArmamentItems.TITLE_FORMAT));
        list.add((Component)charge);
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity pLivingEntity, int timeLeft) {
        int i = this.m_8105_(stack) - timeLeft;
        if (i < 0) {
            return;
        }
        float f = OnActionsTrigger.getPowerForTime(i);
        if (!pLivingEntity.m_6144_()) {
            Player player;
            if ((double)f > 0.9) {
                pLivingEntity.m_5496_(SoundEvents.f_12404_, 1.5f, 1.5f);
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    ParticleLikeEntity particleEntity = new ParticleLikeEntity((EntityType)WrathyArmamentEntities.PARTICLE_LIKE_ENTITY.get(), (Level)serverLevel, 0.6f, true, false, 4, (ParticleOptions)ParticleTypes.f_123746_, "rain");
                    particleEntity.setOwner(pLivingEntity);
                    particleEntity.m_20219_(new Vec3(pLivingEntity.m_20185_(), pLivingEntity.m_20186_() + 1.5, pLivingEntity.m_20189_()));
                    level.m_7967_((Entity)particleEntity);
                }
            } else if (pLivingEntity instanceof Player && !(player = (Player)pLivingEntity).m_36335_().m_41519_(stack.m_41720_())) {
                this.playAnimAndEffects(player.m_9236_(), player, "frostmourne_somersault", SoundEvents.f_144167_, null, true);
                OnActionsTrigger.playerCameraData.computeIfAbsent(player.m_20149_(), k -> new Triple((Object)0, (Object)0, (Object)0));
                OnActionsTrigger.playerCameraData.put(player.m_20149_(), (Triple<Integer, Integer, Integer>)new Triple((Object)((Integer)OnActionsTrigger.playerCameraData.get((Object)player.m_20149_()).a), (Object)((Integer)OnActionsTrigger.playerCameraData.get((Object)player.m_20149_()).b + 180), (Object)((Integer)OnActionsTrigger.playerCameraData.get((Object)player.m_20149_()).c)));
                OnActionsTrigger.queueServerWork(8, () -> player.m_20334_(0.0, 0.5, 0.0));
                OnActionsTrigger.queueServerWork(20, () -> {
                    float scaling = 0.0f;
                    double d0 = -Mth.m_14031_((float)(player.m_146908_() * ((float)Math.PI / 180)));
                    double d1 = Mth.m_14089_((float)(player.m_146908_() * ((float)Math.PI / 180)));
                    for (int j = 0; j < 4 + this.getCurrentSparkles(stack) * 2; ++j) {
                        BlockPos pos = level.m_45547_(new ClipContext(player.m_20299_(1.0f), player.m_20299_(1.0f).m_82549_(player.m_20252_(1.0f).m_82490_((double)scaling)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player)).m_82425_();
                        if (!level.m_8055_(new BlockPos(pos.m_123341_(), pos.m_123342_(), pos.m_123343_())).m_60815_()) {
                            scaling += 1.0f;
                        }
                        BlockPos pos1 = level.m_45547_(new ClipContext(player.m_20299_(1.0f), player.m_20299_(1.0f).m_82549_(player.m_20252_(1.0f).m_82490_((double)scaling)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player)).m_82425_();
                        if (!ModList.get().isLoaded("physicsmod")) {
                            for (int k = -2; k < 3; ++k) {
                                for (int l = -1; l < 1; ++l) {
                                    level.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, level.m_8055_(pos1.m_6625_(2))), (double)((float)pos1.m_123341_() + (float)k / 10.0f), (double)((float)pos1.m_123342_() + (float)l / 10.0f), (double)((float)pos1.m_123343_() + (float)k / 10.0f), d0, 0.1 + (double)((float)l / 10.0f), d1);
                                }
                            }
                        }
                        Vec3 center = new Vec3((double)pos1.m_123341_(), (double)pos1.m_123342_(), (double)pos1.m_123343_());
                        List<Entity> entityList = level.m_6443_(Entity.class, new AABB(center, center).m_82400_(3.0), e -> true).stream().sorted(Comparator.comparingDouble(entity -> entity.m_20238_(center))).toList();
                        for (Entity entity2 : entityList) {
                            if (entity2 == player || !(entity2 instanceof LivingEntity)) continue;
                            LivingEntity livingEntity = (LivingEntity)entity2;
                            livingEntity.m_6469_(player.m_269291_().m_269333_((LivingEntity)player), (float)(8 + this.getCurrentSparkles(stack)));
                            livingEntity.m_146917_(200 + this.getCurrentSparkles(stack) * 20);
                        }
                    }
                    OnActionsTrigger.addParticlesWithDelay((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, level.m_8055_(player.m_20097_().m_6625_(2))), level, player.m_20185_(), player.m_20186_() + 1.5, player.m_20189_(), 3.0f, 7);
                });
                player.m_36335_().m_41524_(stack.m_41720_(), 70 - this.getCurrentSparkles(stack) * 5);
            }
        }
    }

    public int m_8105_(ItemStack itemstack) {
        return 32000;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player entity, InteractionHand hand) {
        entity.m_6672_(hand);
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)entity.m_21120_(hand));
    }

    public void m_5929_(Level level, LivingEntity entity, ItemStack stack, int pRemainingUseDuration) {
        if (pRemainingUseDuration % 4 == 0 && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)WrathyArmamentMiscRegistries.FROST_SOUL_RAY.get()), entity.m_20185_() + OnActionsTrigger.getXVector(-2.0, entity.m_146908_()), entity.m_20186_() + 2.0, entity.m_20189_() + OnActionsTrigger.getZVector(-2.0, entity.m_146908_()), 9, OnActionsTrigger.getXVector(2.0, entity.m_146908_()), -0.25, OnActionsTrigger.getZVector(2.0, entity.m_146908_()), 0.5);
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.f_19797_ % 20 == 0) {
                player.m_5496_(SoundEvents.f_12404_, 1.8f, 1.0f);
                int i = this.m_8105_(stack) - pRemainingUseDuration;
                float f = OnActionsTrigger.getPowerForTime(i);
                if (!entity.m_6144_() && (double)f > 0.9) {
                    this.playAnimAndEffects(player.m_9236_(), player, "rain_casting", SoundEvents.f_12404_, null, false);
                }
            }
        }
        super.m_5929_(level, entity, stack, pRemainingUseDuration);
    }
}

