/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.wrathy_armament.items.swords;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Comparator;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.sashakyotoz.anitexlib.client.particles.parents.options.ColorableParticleOption;
import net.sashakyotoz.wrathy_armament.entities.technical.HarmfulProjectileEntity;
import net.sashakyotoz.wrathy_armament.items.SwingParticleHolder;
import net.sashakyotoz.wrathy_armament.items.SwordLikeItem;
import net.sashakyotoz.wrathy_armament.registers.WrathyArmamentEntities;
import net.sashakyotoz.wrathy_armament.registers.WrathyArmamentItems;
import net.sashakyotoz.wrathy_armament.registers.WrathyArmamentSounds;
import net.sashakyotoz.wrathy_armament.registers.WrathyArmamentTags;
import net.sashakyotoz.wrathy_armament.utils.OnActionsTrigger;
import org.jetbrains.annotations.Nullable;

public class MasterSword
extends SwordLikeItem {
    public MasterSword(Item.Properties properties) {
        super(properties);
    }

    @Override
    public void leftClickAttack(Player player, ItemStack stack) {
        if (player.m_6047_()) {
            float scaling = 0.0f;
            block0: for (int i = 0; i < 8; ++i) {
                BlockPos pos = player.m_9236_().m_45547_(new ClipContext(player.m_20299_(1.0f), player.m_20299_(1.0f).m_82549_(player.m_20252_(1.0f).m_82490_((double)scaling)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player)).m_82425_();
                if (!player.m_9236_().m_8055_(new BlockPos(pos.m_123341_(), pos.m_123342_(), pos.m_123343_())).m_60815_()) {
                    scaling += 1.0f;
                }
                BlockPos pos1 = player.m_9236_().m_45547_(new ClipContext(player.m_20299_(1.0f), player.m_20299_(1.0f).m_82549_(player.m_20252_(1.0f).m_82490_((double)scaling)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player)).m_82425_();
                player.m_9236_().m_7106_((ParticleOptions)new ColorableParticleOption("wisp", 0.5f, 0.5f, 1.0f), (double)pos1.m_123341_(), (double)((float)pos1.m_123342_() + 0.5f), (double)pos1.m_123343_(), OnActionsTrigger.getXVector(2.0, player.m_146908_()), OnActionsTrigger.getYVector(1.0, player.m_146909_()), OnActionsTrigger.getZVector(2.0, player.m_146908_()));
                Vec3 center = new Vec3((double)pos1.m_123341_(), (double)pos1.m_123342_(), (double)pos1.m_123343_());
                List<LivingEntity> entityList = player.m_9236_().m_6443_(LivingEntity.class, new AABB(center, center).m_82400_(3.0), e -> true).stream().sorted(Comparator.comparingDouble(entity -> entity.m_20238_(center))).toList();
                for (LivingEntity entity2 : entityList) {
                    if (entity2 == player) continue;
                    entity2.m_6469_(player.m_269291_().m_269333_((LivingEntity)player), (float)(5 + this.getCurrentSparkles(stack)));
                    entity2.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 20, 0));
                    continue block0;
                }
            }
        }
    }

    @Override
    public void rightClick(Player player, ItemStack stack) {
        OnActionsTrigger.addParticles((ParticleOptions)ParticleTypes.f_123810_, player.m_9236_(), player.m_20185_(), player.m_20186_(), player.m_20189_(), 4.0f);
        CompoundTag tag = stack.m_41784_();
        this.playAnimAndEffects(player.m_9236_(), player, player.m_21120_(InteractionHand.MAIN_HAND).m_150930_(stack.m_41720_()) ? "right_handed_circular_swing" : "left_handed_circular_swing", WrathyArmamentSounds.LIGHT_SWING, null, true);
        OnActionsTrigger.queueServerWork(20, () -> {
            if (tag.m_128459_("playerX") != 0.0 && tag.m_128459_("playerZ") != 0.0) {
                player.m_6021_(tag.m_128459_("playerX"), tag.m_128459_("playerY"), tag.m_128459_("playerZ"));
            }
        });
        player.m_36335_().m_41524_(stack.m_41720_(), 20);
    }

    @Override
    public void rightClickOnShiftClick(Player player, ItemStack stack) {
        if (!player.m_36335_().m_41519_(stack.m_41720_())) {
            Level level = player.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel level2 = (ServerLevel)level;
                HarmfulProjectileEntity entity = new HarmfulProjectileEntity((EntityType)WrathyArmamentEntities.HARMFUL_PROJECTILE_ENTITY.get(), (Level)level2, 7 + this.getCurrentSparkles(stack), "shield_dash");
                entity.m_6027_(player.m_20185_() + OnActionsTrigger.getXVector(0.5, player.m_146908_()), player.m_20186_() + 0.25, player.m_20189_() + OnActionsTrigger.getZVector(0.5, player.m_146908_()));
                entity.setOwner((LivingEntity)player);
                level2.m_7967_((Entity)entity);
            }
            this.playAnimAndEffects(player.m_9236_(), player, player.m_21120_(InteractionHand.MAIN_HAND).m_150930_(stack.m_41720_()) ? "right_handed_wind_swing" : "left_handed_wind_swing", SoundEvents.f_11738_, (ParticleOptions)new ColorableParticleOption("sparkle", 0.0f, 0.5f, 1.0f), true);
            player.m_20334_(-OnActionsTrigger.getXVector(1.25, player.m_146908_()), -OnActionsTrigger.getYVector(0.675f, player.m_146909_()) + 0.25, -OnActionsTrigger.getZVector(1.25, player.m_146908_()));
            player.m_36335_().m_41524_(stack.m_41720_(), 50);
        }
    }

    @Override
    @Nullable
    public SwingParticleHolder getSwingHolder(LivingEntity holder, ItemStack stack) {
        return new SwingParticleHolder((ParticleType<?>)ParticleTypes.f_123772_, 1.8f);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        if (slot == EquipmentSlot.MAINHAND) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            builder.putAll(super.getAttributeModifiers(slot, stack));
            builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", 13.5 + (double)((float)this.getCurrentSparkles(stack) / 2.0f), AttributeModifier.Operation.ADDITION));
            builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", -2.4, AttributeModifier.Operation.ADDITION));
            return builder.build();
        }
        return super.getAttributeModifiers(slot, stack);
    }

    @Override
    public void appendSwordsDesc(ItemStack itemstack, Level world, List<Component> list) {
        list.add((Component)Component.m_237115_((String)"item.wrathy_armament.game.master_sword").m_130940_(WrathyArmamentItems.TITLE_FORMAT).m_130940_(ChatFormatting.ITALIC));
        list.add(CommonComponents.f_237098_);
        list.add((Component)Component.m_237115_((String)"item.wrathy_armament.abilities").m_130940_(WrathyArmamentItems.TITLE_FORMAT));
        list.add((Component)Component.m_237115_((String)"item.wrathy_armament.right_hand").m_130940_(WrathyArmamentItems.DARK_GREY_TITLE_FORMAT));
        list.add(CommonComponents.f_237098_);
        list.add((Component)Component.m_237115_((String)"item.wrathy_armament.master_sword_hint").m_130940_(WrathyArmamentItems.AQUA_TITLE_FORMAT));
        list.add((Component)Component.m_237115_((String)"item.wrathy_armament.master_sword_attack").m_130940_(WrathyArmamentItems.TITLE_FORMAT));
        list.add(CommonComponents.f_237098_);
        list.add((Component)Component.m_237115_((String)"item.wrathy_armament.master_sword_hint1").m_130940_(WrathyArmamentItems.AQUA_TITLE_FORMAT));
        list.add((Component)Component.m_237115_((String)"item.wrathy_armament.master_sword_alter_time").m_130940_(WrathyArmamentItems.TITLE_FORMAT));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player entity, InteractionHand hand) {
        entity.m_6672_(hand);
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)entity.m_21120_(hand));
    }

    public int m_8105_(ItemStack itemstack) {
        return 72000;
    }

    public void m_5929_(Level level, LivingEntity entity, ItemStack stack, int i) {
        if (i > 20 && entity.m_6047_() && entity instanceof Player) {
            Player player = (Player)entity;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)new ColorableParticleOption("wisp", 1.0f, 1.0f, 1.0f), entity.m_20185_() + OnActionsTrigger.getXVector(2.0, entity.m_146908_()), entity.m_20186_() + 1.0, entity.m_20189_() + OnActionsTrigger.getZVector(2.0, entity.m_146908_()), 9, OnActionsTrigger.getXVector(2.0, entity.m_146908_()), 0.25, OnActionsTrigger.getZVector(2.0, entity.m_146908_()), 0.5);
            }
            Vec3 center = new Vec3(entity.m_20185_() + OnActionsTrigger.getXVector(2.0, entity.m_146908_()), entity.m_20186_(), entity.m_20189_() + OnActionsTrigger.getZVector(2.0, entity.m_146908_()));
            List<Entity> entities = level.m_6443_(Entity.class, new AABB(center, center).m_82400_(3.0), e -> true).stream().sorted(Comparator.comparingDouble(entity1 -> entity1.m_20238_(center))).toList();
            for (Entity entityIterator : entities) {
                LivingEntity target;
                if (!(entityIterator instanceof LivingEntity) || (target = (LivingEntity)entityIterator) == entity || !target.m_6336_().equals(MobType.f_21641_) || !player.m_6844_(EquipmentSlot.MAINHAND).m_150930_(stack.m_41720_()) || player.m_36335_().m_41519_(stack.m_41720_())) continue;
                entityIterator.m_6469_(entityIterator.m_269291_().m_269425_(), 8.0f);
                if (!stack.m_220157_(1, RandomSource.m_216327_(), null)) continue;
                stack.m_41774_(1);
                stack.m_41721_(0);
            }
        }
        super.m_5929_(level, entity, stack, i);
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int i, boolean isSelected) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.f_19797_ % 400 == 0 && player.m_20096_() && level.m_46575_(player.m_20097_(), (Entity)player)) {
                stack.m_41784_().m_128347_("playerX", player.m_20185_());
                stack.m_41784_().m_128347_("playerY", player.m_20186_());
                stack.m_41784_().m_128347_("playerZ", player.m_20189_());
            }
            if (level instanceof ServerLevel) {
                BlockPos pos;
                ServerLevel serverLevel = (ServerLevel)level;
                if (player.f_19797_ % 10 == 0 && !player.m_36335_().m_41519_(stack.m_41720_()) && (pos = serverLevel.m_215011_(WrathyArmamentTags.Structures.VISIBLE_FOR_MASTER_SWORD, player.m_20097_(), 96, false)) != null) {
                    double distanceSquared = player.m_20275_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
                    double normalizedDistance = Math.min(distanceSquared / 4613.0, 10.0);
                    double lightsValue = 10.0 - normalizedDistance;
                    stack.m_41784_().m_128405_("Lights", (int)Math.round(lightsValue));
                }
            }
        }
    }
}

