/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.wrathy_armament.items.swords;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Comparator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.sashakyotoz.wrathy_armament.items.SwingParticleHolder;
import net.sashakyotoz.wrathy_armament.items.SwordLikeItem;
import net.sashakyotoz.wrathy_armament.registers.WrathyArmamentItems;
import net.sashakyotoz.wrathy_armament.registers.WrathyArmamentSounds;
import net.sashakyotoz.wrathy_armament.utils.OnActionsTrigger;
import org.jetbrains.annotations.Nullable;

public class MirrorSword
extends SwordLikeItem {
    public MirrorSword(Item.Properties properties) {
        super(properties);
    }

    @Override
    public void leftClickAttack(Player player, ItemStack stack) {
    }

    @Override
    public void rightClick(Player player, ItemStack stack) {
    }

    public void spawnArcParticles(Player player, int particleCount, boolean toLeftSide) {
        Vec3 eyePos = player.m_146892_();
        Vec3 lookVec = player.m_20154_();
        Vec3 rightVec = lookVec.m_82537_(new Vec3(0.0, 1.0, 0.0)).m_82541_();
        double arcAngle = 0.7853981633974483;
        double halfArc = arcAngle / 2.0;
        if (toLeftSide) {
            for (int i = 0; i < particleCount; ++i) {
                double angle = -halfArc + arcAngle * (double)i / (double)(particleCount - 1);
                Vec3 offset = rightVec.m_82490_(Math.cos(angle)).m_82549_(lookVec.m_82490_(Math.sin(angle))).m_82541_().m_82490_(1.25);
                Vec3 particlePos = eyePos.m_82549_(offset);
                player.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123810_, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 0.0, 0.0, 0.0);
            }
        } else {
            for (int i = 0; i < particleCount; ++i) {
                double angle = halfArc - arcAngle * (double)i / (double)(particleCount + 1);
                Vec3 offset = rightVec.m_82490_(-Math.cos(angle)).m_82549_(lookVec.m_82490_(-Math.sin(angle))).m_82541_().m_82490_(1.25);
                Vec3 particlePos = eyePos.m_82549_(offset);
                player.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123810_, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public void rightClickOnShiftClick(Player player, ItemStack stack) {
        if (player.m_21205_().m_41720_() instanceof MirrorSword) {
            this.spawnArcParticles(player, 21, true);
            this.playAnimAndEffects(player.m_9236_(), player, "right_arm_mirror_swing", SoundEvents.f_11951_, (ParticleOptions)ParticleTypes.f_123796_, true);
        } else {
            this.spawnArcParticles(player, 21, false);
            this.playAnimAndEffects(player.m_9236_(), player, "left_arm_mirror_swing", SoundEvents.f_11951_, (ParticleOptions)ParticleTypes.f_123796_, true);
        }
        List entities = player.m_9236_().m_45976_(Entity.class, player.m_20191_().m_82400_(7.0));
        for (Entity entity : entities) {
            if (entity == player) continue;
            entity.m_20256_(new Vec3(OnActionsTrigger.getXVector(-2.0, entity.m_146908_()), OnActionsTrigger.getYVector(-1.0, player.m_146909_()), OnActionsTrigger.getZVector(-2.0, entity.m_146908_())));
            for (int i = 0; i < 7; ++i) {
                Vec3 vec3 = entity.m_20097_().m_252807_().m_82549_(new Vec3(OnActionsTrigger.getXVector(-2.0, entity.m_146908_()), OnActionsTrigger.getYVector(-1.0, player.m_146909_()), OnActionsTrigger.getZVector(-2.0, entity.m_146908_())));
                entity.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123810_, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
            }
        }
        player.m_36335_().m_41524_(stack.m_41720_(), 30);
    }

    @Override
    @Nullable
    public SwingParticleHolder getSwingHolder(LivingEntity holder, ItemStack stack) {
        return new SwingParticleHolder((ParticleType<?>)ParticleTypes.f_123796_, 1.8f);
    }

    public int m_8105_(ItemStack itemstack) {
        return 72000;
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity entity, int timeLeft) {
        int i = this.m_8105_(stack) - timeLeft;
        if (i < 0) {
            return;
        }
        float f = OnActionsTrigger.getPowerForTime(i);
        if ((double)f > 0.5) {
            Player player;
            if (level.m_5776_()) {
                Vec3 eyePos = entity.m_146892_();
                Vec3 lookVec = entity.m_20252_(1.0f);
                Vec3 endPos = eyePos.m_82549_(lookVec.m_82490_((double)(3.0f * f)));
                int particleCount = 20;
                Vec3 step = endPos.m_82546_(eyePos).m_82490_(1.0 / (double)particleCount);
                double radius = 0.5;
                for (int v = 0; v < 180; ++v) {
                    for (int j = 0; j < particleCount; ++j) {
                        Vec3 basePos = eyePos.m_82549_(step.m_82490_((double)j));
                        double angle = (double)v * Math.PI / 20.0 + (double)j * Math.PI / 10.0;
                        double offsetX = radius * Math.cos(angle);
                        double offsetY = radius * Math.sin(angle);
                        Vec3 perpendicular = lookVec.m_82537_(new Vec3(0.0, 1.0, 0.0)).m_82541_();
                        Vec3 particlePos = basePos.m_82549_(perpendicular.m_82490_(offsetX)).m_82520_(0.0, offsetY, 0.0);
                        level.m_7106_((ParticleOptions)ParticleTypes.f_123796_, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 0.0, 0.0, 0.0);
                    }
                }
            }
            for (int u = 0; u < 7; ++u) {
                BlockPos pos1 = level.m_45547_(new ClipContext(entity.m_20299_(1.0f), entity.m_20299_(1.0f).m_82549_(entity.m_20252_(1.0f).m_82490_((double)(2.0f * f + (float)u))), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)entity)).m_82425_();
                Vec3 center = pos1.m_252807_();
                List<LivingEntity> entityList = level.m_6443_(LivingEntity.class, new AABB(center, center).m_82400_(2.0), e -> true).stream().sorted(Comparator.comparingDouble(entity1 -> entity1.m_20238_(center))).toList();
                for (LivingEntity entityIterator : entityList) {
                    if (entityIterator != entity) {
                        float damage = stack.m_41784_().m_128457_("damageKeep");
                        entityIterator.m_6469_(entity.m_269291_().m_269264_(), damage);
                        if (entity instanceof Player) {
                            Player player2 = (Player)entity;
                            player2.m_36335_().m_41524_(stack.m_41720_(), Mth.m_216287_((RandomSource)RandomSource.m_216327_(), (int)50, (int)100));
                        }
                    }
                    if (!stack.m_220157_(1, RandomSource.m_216327_(), null)) continue;
                    stack.m_41774_(1);
                    stack.m_41721_(0);
                }
            }
            if (entity instanceof Player && (player = (Player)entity).m_36335_().m_41519_(stack.m_41720_())) {
                this.clearDamageThatKeeps(stack);
            }
        }
    }

    public void m_5929_(Level pLevel, LivingEntity pLivingEntity, ItemStack pStack, int pRemainingUseDuration) {
        if (pLivingEntity.f_19797_ % 12 == 0 && pLivingEntity instanceof Player) {
            Player player = (Player)pLivingEntity;
            this.playAnimAndEffects(pLevel, player, "mirror_sword_wind_swinging", WrathyArmamentSounds.LIGHT_SWING, null, true);
        }
    }

    @Override
    public void appendSwordsDesc(ItemStack itemstack, Level world, List<Component> list) {
        MutableComponent charge = Component.m_237115_((String)"item.wrathy_armament.mirror_sword_charge");
        charge.m_130940_(WrathyArmamentItems.TITLE_FORMAT);
        charge.m_7220_(CommonComponents.f_263701_).m_7220_((Component)Component.m_237115_((String)("" + itemstack.m_41784_().m_128457_("damageKeep"))));
        list.add((Component)Component.m_237115_((String)"item.wrathy_armament.abilities").m_130940_(WrathyArmamentItems.TITLE_FORMAT));
        list.add((Component)Component.m_237115_((String)"item.wrathy_armament.left_hand").m_130940_(WrathyArmamentItems.DARK_GREY_TITLE_FORMAT));
        list.add(CommonComponents.f_237098_);
        list.add((Component)Component.m_237115_((String)"item.wrathy_armament.mirror_sword_hint").m_130940_(WrathyArmamentItems.GOLD_TITLE_FORMAT));
        list.add((Component)Component.m_237115_((String)"item.wrathy_armament.mirror_sword_mirroring").m_130940_(WrathyArmamentItems.TITLE_FORMAT));
        list.add((Component)charge);
    }

    public void addDamageToKeep(float damage, ItemStack stack) {
        if (stack.m_41784_().m_128457_("damageKeep") < 18.0f * ((float)(this.getCurrentSparkles(stack) + 1) / 2.0f)) {
            stack.m_41784_().m_128350_("damageKeep", stack.m_41784_().m_128457_("damageKeep") + damage);
        }
    }

    public void clearDamageThatKeeps(ItemStack stack) {
        stack.m_41784_().m_128350_("damageKeep", 0.0f);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand hand) {
        ItemStack stack = pPlayer.m_21120_(hand);
        if (stack.m_41784_().m_128457_("damageKeep") > 0.0f) {
            pPlayer.m_6672_(hand);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)pPlayer.m_21120_(hand));
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        if (slot == EquipmentSlot.MAINHAND) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            builder.putAll(super.getAttributeModifiers(slot, stack));
            builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", 9.0, AttributeModifier.Operation.ADDITION));
            builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", -2.4, AttributeModifier.Operation.ADDITION));
            return builder.build();
        }
        return super.getAttributeModifiers(slot, stack);
    }
}

