/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.wrathy_armament.items.swords;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.ModList;
import net.sashakyotoz.anitexlib.client.particles.parents.options.ColorableParticleOption;
import net.sashakyotoz.wrathy_armament.entities.technical.ParticleLikeEntity;
import net.sashakyotoz.wrathy_armament.items.SwingParticleHolder;
import net.sashakyotoz.wrathy_armament.items.SwordLikeItem;
import net.sashakyotoz.wrathy_armament.registers.WrathyArmamentEntities;
import net.sashakyotoz.wrathy_armament.registers.WrathyArmamentItems;
import net.sashakyotoz.wrathy_armament.registers.WrathyArmamentMiscRegistries;
import net.sashakyotoz.wrathy_armament.utils.OnActionsTrigger;
import net.sashakyotoz.wrathy_armament.utils.capabilities.ModCapabilities;
import org.jetbrains.annotations.Nullable;

public class MistsplitterReforged
extends SwordLikeItem {
    public MistsplitterReforged(Item.Properties properties) {
        super(properties);
    }

    @Override
    public void leftClickAttack(Player player, ItemStack stack) {
    }

    @Override
    public void rightClick(Player player, ItemStack stack) {
        player.getCapability(ModCapabilities.MISTSPLITTER_DEFENCE).ifPresent(context -> {
            stack.m_41784_().m_128405_("StateIndex", stack.m_41784_().m_128451_("StateIndex") + 1 > States.values().length - 1 ? 0 : stack.m_41784_().m_128451_("StateIndex") + 1);
            player.m_5661_((Component)Component.m_237115_((String)("item.wrathy_armament.abilities." + States.values()[stack.m_41784_().m_128451_((String)"StateIndex")].stateName)), true);
            context.setDefenceType(States.values()[stack.m_41784_().m_128451_((String)"StateIndex")].stateName);
            this.playAnimAndEffects(player.m_9236_(), player, "mistsplitter_mode_switch", SoundEvents.f_11739_, null, false);
        });
    }

    @Override
    public void rightClickOnShiftClick(Player player, ItemStack stack) {
        player.getCapability(ModCapabilities.MISTSPLITTER_DEFENCE).ifPresent(context -> {
            ColorableParticleOption option;
            if (!ModList.get().isLoaded("physicsmod")) {
                switch (context.getDefenceType()) {
                    case "fire": {
                        option = new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50450_.m_49966_());
                        break;
                    }
                    case "water": {
                        option = new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_49990_.m_49966_());
                        break;
                    }
                    case "earth": {
                        option = new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50493_.m_49966_());
                        break;
                    }
                    case "elemental": {
                        option = new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50492_.m_49966_());
                        break;
                    }
                    default: {
                        option = new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50333_.m_49966_());
                        break;
                    }
                }
            } else {
                option = new ColorableParticleOption("sparkle", 1.0f, 1.0f, 1.0f);
            }
            OnActionsTrigger.addParticles((ParticleOptions)option, player.m_9236_(), player.m_20185_(), player.m_20186_() + 1.0, player.m_20189_(), 2.0f);
            context.setDefenseModeFlag(!context.isDefenseModeOn());
            player.m_36335_().m_41524_(stack.m_41720_(), 200);
        });
    }

    @Override
    @Nullable
    public SwingParticleHolder getSwingHolder(LivingEntity holder, ItemStack stack) {
        return new SwingParticleHolder((ParticleType<?>)ParticleTypes.f_123810_, 1.6f);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        if (slot == EquipmentSlot.MAINHAND) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            builder.putAll(super.getAttributeModifiers(slot, stack));
            builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)(11.5f + (float)(stack.m_41784_().m_128451_("RestPower") + this.getCurrentSparkles(stack)) / 2.0f), AttributeModifier.Operation.ADDITION));
            builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)-2.2f, AttributeModifier.Operation.ADDITION));
            return builder.build();
        }
        return super.getAttributeModifiers(slot, stack);
    }

    @Override
    public void appendSwordsDesc(ItemStack itemstack, Level level, List<Component> list) {
        list.add((Component)Component.m_237115_((String)"item.wrathy_armament.game.mistsplitter").m_130940_(WrathyArmamentItems.TITLE_FORMAT).m_130940_(ChatFormatting.ITALIC));
        list.add(CommonComponents.f_237098_);
        list.add((Component)Component.m_237115_((String)"item.wrathy_armament.abilities").m_130940_(WrathyArmamentItems.TITLE_FORMAT));
        list.add((Component)Component.m_237115_((String)"item.wrathy_armament.right_hand").m_130940_(WrathyArmamentItems.DARK_GREY_TITLE_FORMAT));
        list.add(CommonComponents.f_237098_);
        list.add((Component)Component.m_237115_((String)"item.wrathy_armament.mistsplitter_hint").m_130940_(WrathyArmamentItems.PURPLE_TITLE_FORMAT));
        list.add((Component)Component.m_237115_((String)"item.wrathy_armament.mistsplitter_attack").m_130940_(WrathyArmamentItems.TITLE_FORMAT));
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int i1, boolean isSelected) {
        Player player;
        if (entity instanceof Player && (player = (Player)entity).m_21205_().m_150930_(stack.m_41720_()) && stack.m_41784_().m_128451_("RestPower") < 5 && player.f_19797_ % 100 == 0) {
            Level level2 = entity.m_9236_();
            if (level2 instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level2;
                ParticleLikeEntity particleEntity = new ParticleLikeEntity((EntityType)WrathyArmamentEntities.PARTICLE_LIKE_ENTITY.get(), (Level)serverLevel, 0.8f, true, false, 3, (ParticleOptions)WrathyArmamentMiscRegistries.FROST_SOUL_RAY.get(), "cycle");
                particleEntity.m_20219_(new Vec3(entity.m_20185_(), entity.m_20186_() + 1.0, entity.m_20189_()));
                entity.m_9236_().m_7967_((Entity)particleEntity);
            }
            OnActionsTrigger.addParticles((ParticleOptions)new ColorableParticleOption("sparkle", 0.5f, 0.25f, 1.0f), level, player.m_20185_(), player.m_20186_() + 1.0, player.m_20189_(), 2.0f);
            stack.m_41784_().m_128405_("RestPower", stack.m_41784_().m_128451_("RestPower") + 1);
        }
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        if (stack.m_41784_().m_128451_("RestPower") > 1) {
            stack.m_41784_().m_128405_("RestPower", stack.m_41784_().m_128451_("RestPower") - 2);
        }
        return super.onLeftClickEntity(stack, player, entity);
    }

    static enum States {
        FIRE("fire"),
        WATER("water"),
        EARTH("earth"),
        ELEMENTAL("elemental"),
        AIR("air");

        final String stateName;

        private States(String stateName) {
            this.stateName = stateName;
        }
    }
}

