/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.wrathy_armament.items.swords;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.ModList;
import net.sashakyotoz.wrathy_armament.items.SwingParticleHolder;
import net.sashakyotoz.wrathy_armament.items.SwordLikeItem;
import net.sashakyotoz.wrathy_armament.registers.WrathyArmamentItems;
import net.sashakyotoz.wrathy_armament.registers.WrathyArmamentSounds;
import net.sashakyotoz.wrathy_armament.utils.OnActionsTrigger;
import org.antlr.v4.runtime.misc.Triple;
import org.jetbrains.annotations.Nullable;

public class Murasama
extends SwordLikeItem {
    public static final UUID SWIFTNESS = UUID.fromString("91AEAA56-376B-4498-935B-2F7F68070635");

    public Murasama(Item.Properties properties) {
        super(properties);
    }

    @Override
    @Nullable
    public SwingParticleHolder getSwingHolder(LivingEntity holder, ItemStack stack) {
        return new SwingParticleHolder((ParticleType<?>)ParticleTypes.f_123808_, 1.4f);
    }

    @Override
    public void leftClickAttack(Player player, ItemStack stack) {
        if (player.m_6047_()) {
            Level level = player.m_9236_();
            float scaling = 0.0f;
            double d0 = -Mth.m_14031_((float)(player.m_146908_() * ((float)Math.PI / 180)));
            double d1 = Mth.m_14089_((float)(player.m_146908_() * ((float)Math.PI / 180)));
            block0: for (int i = 0; i < 12 + this.getCurrentSparkles(stack) * 2; ++i) {
                BlockPos pos = level.m_45547_(new ClipContext(player.m_20299_(1.0f), player.m_20299_(1.0f).m_82549_(player.m_20252_(1.0f).m_82490_((double)scaling)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player)).m_82425_();
                if (!level.m_8055_(new BlockPos(pos.m_123341_(), pos.m_123342_(), pos.m_123343_())).m_60815_()) {
                    scaling += 1.0f;
                }
                BlockPos pos1 = level.m_45547_(new ClipContext(player.m_20299_(1.0f), player.m_20299_(1.0f).m_82549_(player.m_20252_(1.0f).m_82490_((double)scaling)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player)).m_82425_();
                if (!ModList.get().isLoaded("physicsmod")) {
                    OnActionsTrigger.queueServerWork(20, () -> level.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50330_.m_49966_()), (double)pos1.m_123341_(), (double)pos1.m_123342_(), (double)pos1.m_123343_(), d0, 0.1, d1));
                }
                Vec3 center = new Vec3((double)pos1.m_123341_(), (double)pos1.m_123342_(), (double)pos1.m_123343_());
                List<LivingEntity> entityList = level.m_6443_(LivingEntity.class, new AABB(center, center).m_82400_(3.0), e -> true).stream().sorted(Comparator.comparingDouble(entity -> entity.m_20238_(center))).toList();
                for (LivingEntity entity2 : entityList) {
                    if (entity2 == player) continue;
                    entity2.m_6469_(player.m_269291_().m_269333_((LivingEntity)player), (float)(5 + this.getCurrentSparkles(stack)));
                    entity2.m_20256_(new Vec3(OnActionsTrigger.getXVector(1.5, player.m_146908_()), 0.75, OnActionsTrigger.getZVector(1.5, player.m_146908_())));
                    player.m_6674_(player.m_21205_().m_150930_(stack.m_41720_()) ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND);
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19617_, 50, 4));
                    player.m_6021_(entity2.m_20185_(), entity2.m_20186_(), entity2.m_20189_());
                    continue block0;
                }
            }
        }
    }

    @Override
    public void rightClick(Player player, ItemStack stack) {
        if (!player.m_36335_().m_41519_(stack.m_41720_())) {
            this.playAnimAndEffects(player.m_9236_(), player, "zenith_turn", SoundEvents.f_12057_, null, true);
            OnActionsTrigger.queueServerWork(20, () -> {
                OnActionsTrigger.playerCameraData.computeIfAbsent(player.m_20149_(), k -> new Triple((Object)0, (Object)0, (Object)0));
                OnActionsTrigger.playerCameraData.put(player.m_20149_(), (Triple<Integer, Integer, Integer>)new Triple((Object)((Integer)OnActionsTrigger.playerCameraData.get((Object)player.m_20149_()).a), (Object)((Integer)OnActionsTrigger.playerCameraData.get((Object)player.m_20149_()).b), (Object)((Integer)OnActionsTrigger.playerCameraData.get((Object)player.m_20149_()).c + 360)));
            });
            Vec3 center = new Vec3(player.m_20185_(), player.m_20186_(), player.m_20189_());
            List<LivingEntity> entityList = player.m_9236_().m_6443_(LivingEntity.class, new AABB(center, center).m_82400_(5.0), e -> true).stream().sorted(Comparator.comparingDouble(entity -> entity.m_20238_(center))).toList();
            for (int i = 0; i < 4; ++i) {
                for (LivingEntity entity2 : entityList) {
                    if (entity2 == player) continue;
                    OnActionsTrigger.queueServerWork(14 * (i + 1), () -> entity2.m_6469_(player.m_269291_().m_269333_((LivingEntity)player), (float)(6 + this.getCurrentSparkles(stack))));
                }
                int finalI = i;
                OnActionsTrigger.queueServerWork(14 * (i + 1), () -> player.m_5496_(WrathyArmamentSounds.KATANA_SWING, 1.5f - (float)finalI / 10.0f, 1.0f));
            }
            player.m_36335_().m_41524_(stack.m_41720_(), 45);
        }
    }

    @Override
    public void rightClickOnShiftClick(Player player, ItemStack stack) {
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        if (slot == EquipmentSlot.MAINHAND) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            builder.putAll(super.getAttributeModifiers(slot, stack));
            builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", 12.5 + (double)((float)this.getCurrentSparkles(stack) / 2.0f), AttributeModifier.Operation.ADDITION));
            builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", -1.8, AttributeModifier.Operation.ADDITION));
            builder.put((Object)Attributes.f_22279_, (Object)new AttributeModifier(SWIFTNESS, "Weapon modifier", (double)stack.m_41784_().m_128457_("RestSpeed"), AttributeModifier.Operation.ADDITION));
            return builder.build();
        }
        return super.getAttributeModifiers(slot, stack);
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        if (!player.m_6047_() && (double)stack.m_41784_().m_128457_("RestSpeed") < 0.3) {
            stack.m_41784_().m_128350_("RestSpeed", stack.m_41784_().m_128457_("RestSpeed") + 0.1f);
        }
        return super.onLeftClickEntity(stack, player, entity);
    }

    @Override
    public void appendSwordsDesc(ItemStack itemstack, Level world, List<Component> list) {
        list.add((Component)(itemstack.m_41786_().getString().contains("Blue") ? Component.m_237115_((String)"item.wrathy_armament.game.zenith") : Component.m_237115_((String)"item.wrathy_armament.game.murasama")).m_130940_(WrathyArmamentItems.TITLE_FORMAT).m_130940_(ChatFormatting.ITALIC));
        list.add(CommonComponents.f_237098_);
        list.add((Component)Component.m_237115_((String)"item.wrathy_armament.abilities").m_130940_(WrathyArmamentItems.TITLE_FORMAT));
        list.add((Component)Component.m_237115_((String)"item.wrathy_armament.right_hand").m_130940_(WrathyArmamentItems.DARK_GREY_TITLE_FORMAT));
        list.add(CommonComponents.f_237098_);
        list.add((Component)Component.m_237115_((String)"item.wrathy_armament.murasama_hint").m_130940_(WrathyArmamentItems.RED_DESCRIPTION_FORMAT));
        list.add((Component)Component.m_237115_((String)"item.wrathy_armament.murasama_attack").m_130940_(WrathyArmamentItems.TITLE_FORMAT));
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int pSlotId, boolean pIsSelected) {
        if (entity.f_19797_ % 100 == 0) {
            if (stack.m_41784_().m_128457_("RestSpeed") >= 0.1f) {
                stack.m_41784_().m_128350_("RestSpeed", stack.m_41784_().m_128457_("RestSpeed") - 0.1f);
            }
            if (stack.m_41784_().m_128457_("RestSpeed") < 0.0f) {
                stack.m_41784_().m_128350_("RestSpeed", 0.0f);
            }
        }
        stack.m_41784_().m_128347_("CustomModelData", stack.m_41786_().getString().contains("Muramasa") ? 1.0 : 0.0);
    }
}

