/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.wrathy_armament.items.swords;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Comparator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.sashakyotoz.wrathy_armament.Config;
import net.sashakyotoz.wrathy_armament.items.SwingParticleHolder;
import net.sashakyotoz.wrathy_armament.items.SwordLikeItem;
import net.sashakyotoz.wrathy_armament.registers.WrathyArmamentItems;
import net.sashakyotoz.wrathy_armament.registers.WrathyArmamentMiscRegistries;
import net.sashakyotoz.wrathy_armament.registers.WrathyArmamentSounds;
import net.sashakyotoz.wrathy_armament.utils.OnActionsTrigger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhantomLancer
extends SwordLikeItem {
    public PhantomLancer(Item.Properties properties) {
        super(properties);
    }

    @Override
    public void leftClickAttack(Player player, ItemStack stack) {
    }

    @Override
    public void rightClick(Player player, ItemStack stack) {
    }

    @Override
    public void rightClickOnShiftClick(Player player, ItemStack stack) {
    }

    @Override
    @Nullable
    public SwingParticleHolder getSwingHolder(LivingEntity holder, ItemStack stack) {
        return new SwingParticleHolder((ParticleType)WrathyArmamentMiscRegistries.PHANTOM_RAY.get(), 0.9f);
    }

    public int m_8105_(ItemStack itemstack) {
        return 72000;
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity entity, int timeLeft) {
        int i = this.m_8105_(stack) - timeLeft;
        if (i < 0) {
            return;
        }
        float f = OnActionsTrigger.getPowerForTime(i);
        if (!((double)f < 0.75)) {
            entity.m_216990_(SoundEvents.f_12232_);
            double d0 = -Mth.m_14031_((float)(entity.m_146908_() * ((float)Math.PI / 180)));
            double d1 = Mth.m_14089_((float)(entity.m_146908_() * ((float)Math.PI / 180)));
            int Int = stack.getEnchantmentLevel((Enchantment)WrathyArmamentMiscRegistries.PHANTOM_FURY.get());
            int tmp = Int > 0 ? Int : 1;
            float scaling = 0.0f;
            for (int i1 = 0; i1 < 15 + tmp * 3; ++i1) {
                BlockPos pos = level.m_45547_(new ClipContext(entity.m_20299_(1.0f), entity.m_20299_(1.0f).m_82549_(entity.m_20252_(1.0f).m_82490_((double)scaling)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)entity)).m_82425_();
                if (!level.m_8055_(new BlockPos(pos.m_123341_(), pos.m_123342_(), pos.m_123343_())).m_60815_()) {
                    scaling += 1.0f;
                }
                BlockPos pos1 = level.m_45547_(new ClipContext(entity.m_20299_(1.0f), entity.m_20299_(1.0f).m_82549_(entity.m_20252_(1.0f).m_82490_((double)scaling)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)entity)).m_82425_();
                level.m_7106_((ParticleOptions)WrathyArmamentMiscRegistries.PHANTOM_RAY.get(), (double)pos1.m_123341_(), (double)pos1.m_123342_(), (double)pos1.m_123343_(), d0, 0.1, d1);
                Vec3 center = pos1.m_252807_();
                List<Entity> entityList = level.m_6443_(Entity.class, new AABB(center, center).m_82400_((1.5 + (double)tmp) / 2.0), e -> true).stream().sorted(Comparator.comparingDouble(_entcnd -> _entcnd.m_20238_(center))).toList();
                for (Entity entityIterator : entityList) {
                    if (entityIterator == entity) continue;
                    if (entityIterator instanceof LivingEntity) {
                        LivingEntity livingEntity = (LivingEntity)entityIterator;
                        float damage = livingEntity.m_21233_() - livingEntity.m_21223_() + 2.0f;
                        if (damage > 100.0f) {
                            damage /= 4.0f;
                        }
                        damage = (float)((double)damage * (Double)Config.Common.PHANTOM_LANCER_DAMAGE_MUL.get());
                        livingEntity.m_6469_(new DamageSource((Holder)livingEntity.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268433_)){

                            public Component m_6157_(@NotNull LivingEntity _msgEntity) {
                                return Component.m_237115_((String)"death.attack.wrathy_armament.phantom_shock_message");
                            }
                        }, damage);
                        if (entity instanceof Player) {
                            Player player = (Player)entity;
                            player.m_36335_().m_41524_(stack.m_41720_(), Mth.m_216287_((RandomSource)RandomSource.m_216327_(), (int)60, (int)140));
                        }
                    }
                    if (!stack.m_220157_(1, RandomSource.m_216327_(), null)) continue;
                    stack.m_41774_(1);
                    stack.m_41721_(0);
                }
            }
        }
    }

    @Override
    public void appendSwordsDesc(ItemStack itemstack, Level world, List<Component> list) {
        list.add((Component)Component.m_237115_((String)"item.wrathy_armament.abilities").m_130940_(WrathyArmamentItems.TITLE_FORMAT));
        list.add((Component)Component.m_237115_((String)"item.wrathy_armament.left_hand").m_130940_(WrathyArmamentItems.DARK_GREY_TITLE_FORMAT));
        list.add(CommonComponents.f_237098_);
        list.add((Component)Component.m_237115_((String)"item.wrathy_armament.phantom_lancer_hint").m_130940_(WrathyArmamentItems.AQUA_TITLE_FORMAT));
        list.add((Component)Component.m_237115_((String)"item.wrathy_armament.phantom_lancer_circular_attack").m_130940_(WrathyArmamentItems.TITLE_FORMAT));
        list.add(CommonComponents.f_237098_);
        list.add((Component)Component.m_237115_((String)"item.wrathy_armament.phantom_lancer_hint1").m_130940_(WrathyArmamentItems.AQUA_TITLE_FORMAT));
        list.add((Component)Component.m_237115_((String)"item.wrathy_armament.phantom_lancer_sweep_attack").m_130940_(WrathyArmamentItems.TITLE_FORMAT));
    }

    public void m_5929_(Level level, LivingEntity entity, ItemStack stack, int pRemainingUseDuration) {
        if (entity instanceof Player) {
            int i;
            float f;
            Player player = (Player)entity;
            if (player.f_19797_ % 15 == 0 && (double)(f = OnActionsTrigger.getPowerForTime(i = this.m_8105_(stack) - pRemainingUseDuration)) < 0.75) {
                OnActionsTrigger.playPlayerAnimation(player.m_9236_(), player, "phantom_lancer_swinging", true);
            }
        }
        super.m_5929_(level, entity, stack, pRemainingUseDuration);
    }

    public void onStopUsing(ItemStack stack, LivingEntity entity, int i1) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            Vec3 center = new Vec3(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
            List<Entity> entities = player.m_9236_().m_6443_(Entity.class, new AABB(center, center).m_82400_(3.0), e -> true).stream().sorted(Comparator.comparingDouble(entcnd -> entcnd.m_20238_(center))).toList();
            for (Entity entityIterator : entities) {
                if (entityIterator == null || entityIterator == entity || !player.m_6844_(EquipmentSlot.MAINHAND).m_150930_(stack.m_41720_()) || player.m_36335_().m_41519_(stack.m_41720_())) continue;
                player.m_216990_(WrathyArmamentSounds.ITEM_LANCER_SHOT);
                player.m_6674_(InteractionHand.MAIN_HAND);
                OnActionsTrigger.addParticles((ParticleOptions)ParticleTypes.f_235902_, entity.m_9236_(), entity.m_20185_(), entity.m_20186_() + 1.0, entity.m_20189_(), 1.25f);
                float damage = player.m_21223_() / 2.0f;
                if ((double)damage <= 0.5) {
                    damage = 4.0f;
                }
                entityIterator.m_6469_(entityIterator.m_269291_().m_269264_(), damage);
            }
            stack.m_41622_(1, (LivingEntity)player, entity1 -> entity1.m_21190_(player.m_7655_()));
        }
    }

    public boolean canDisableShield(ItemStack stack, ItemStack shield, LivingEntity entity, LivingEntity attacker) {
        return stack.m_150930_((Item)WrathyArmamentItems.PHANTOM_LANCER.get());
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        player.m_6672_(hand);
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)player.m_21120_(hand));
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        if (slot == EquipmentSlot.MAINHAND) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            builder.putAll(super.getAttributeModifiers(slot, stack));
            builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", 7.5 + (double)((float)this.getCurrentSparkles(stack) / 2.0f), AttributeModifier.Operation.ADDITION));
            builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", -2.4, AttributeModifier.Operation.ADDITION));
            return builder.build();
        }
        return super.getAttributeModifiers(slot, stack);
    }
}

