/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.wrathy_armament.items.swords;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.sashakyotoz.wrathy_armament.entities.technical.ZenithEntity;
import net.sashakyotoz.wrathy_armament.items.SwingParticleHolder;
import net.sashakyotoz.wrathy_armament.items.SwordLikeItem;
import net.sashakyotoz.wrathy_armament.registers.WrathyArmamentItems;
import net.sashakyotoz.wrathy_armament.registers.WrathyArmamentMiscRegistries;
import org.jetbrains.annotations.Nullable;

public class Zenith
extends SwordLikeItem {
    private int timer;

    public Zenith(Item.Properties properties) {
        super(properties);
    }

    @Override
    public void leftClickAttack(Player player, ItemStack stack) {
    }

    @Override
    public void rightClick(Player player, ItemStack stack) {
        Level level = player.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (!player.m_36335_().m_41519_(stack.m_41720_())) {
                if (stack.m_41784_().m_128451_("ZenithIndex") > 2) {
                    stack.m_41784_().m_128347_("CustomModelData", 0.0);
                    stack.m_41784_().m_128405_("ZenithIndex", 0);
                    player.m_36335_().m_41524_(stack.m_41720_(), 60);
                } else {
                    this.zenithAbility(player, stack, serverLevel);
                    stack.m_41784_().m_128347_("CustomModelData", 1.0);
                    stack.m_41784_().m_128405_("ZenithIndex", stack.m_41784_().m_128451_("ZenithIndex") + 1);
                    this.timer = 30;
                    player.m_36335_().m_41524_(stack.m_41720_(), 10);
                }
            }
        }
        this.playAnimAndEffects(player.m_9236_(), player, "zenith_in_hand_rolling", SoundEvents.f_11739_, null, true);
    }

    public void m_6883_(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        if (pEntity instanceof Player) {
            ItemStack stack;
            Player player = (Player)pEntity;
            if (this.timer > 0) {
                --this.timer;
            }
            if (player.m_150109_().m_36063_(new ItemStack((ItemLike)WrathyArmamentItems.ZENITH.get())) && (stack = player.m_150109_().m_8020_(player.m_150109_().m_36030_(new ItemStack((ItemLike)WrathyArmamentItems.ZENITH.get())))).m_41784_().m_128459_("CustomModelData") == 1.0 && this.timer <= 0) {
                stack.m_41784_().m_128347_("CustomModelData", 0.0);
            }
        }
    }

    @Override
    public void rightClickOnShiftClick(Player player, ItemStack stack) {
    }

    @Override
    @Nullable
    public SwingParticleHolder getSwingHolder(LivingEntity holder, ItemStack stack) {
        return new SwingParticleHolder((ParticleType)WrathyArmamentMiscRegistries.ZENITH_WAY.get(), 1.6f);
    }

    private void zenithAbility(Player player, ItemStack stack, ServerLevel level) {
        ZenithEntity zenith = new ZenithEntity((Level)level, (LivingEntity)player, stack.m_41784_().m_128451_("ZenithIndex"));
        zenith.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 3.0f, 1.0f);
        level.m_7967_((Entity)zenith);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        if (slot == EquipmentSlot.MAINHAND) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            builder.putAll(super.getAttributeModifiers(slot, stack));
            builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)(15.0f + (float)this.getCurrentSparkles(stack) / 2.0f), AttributeModifier.Operation.ADDITION));
            builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", -2.8, AttributeModifier.Operation.ADDITION));
            return builder.build();
        }
        return super.getAttributeModifiers(slot, stack);
    }

    @Override
    public void appendSwordsDesc(ItemStack itemstack, Level world, List<Component> list) {
        itemstack.m_41784_().m_128347_("CustomModelData", 0.0);
        list.add((Component)Component.m_237115_((String)"item.wrathy_armament.game.zenith").m_130940_(WrathyArmamentItems.TITLE_FORMAT).m_130940_(ChatFormatting.ITALIC));
        list.add(CommonComponents.f_237098_);
        list.add((Component)Component.m_237115_((String)"item.wrathy_armament.abilities").m_130940_(WrathyArmamentItems.TITLE_FORMAT));
        list.add((Component)Component.m_237115_((String)"item.wrathy_armament.right_hand").m_130940_(WrathyArmamentItems.DARK_GREY_TITLE_FORMAT));
        list.add(CommonComponents.f_237098_);
        list.add((Component)Component.m_237115_((String)"item.wrathy_armament.zenith_hint").m_130940_(WrathyArmamentItems.PURPLE_TITLE_FORMAT));
        list.add((Component)Component.m_237115_((String)"item.wrathy_armament.zenith_ability").m_130940_(WrathyArmamentItems.TITLE_FORMAT));
        list.add(CommonComponents.f_237098_);
    }
}

