/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.wrathy_armament.networking.packets;

import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.sashakyotoz.wrathy_armament.networking.WANetworkingManager;
import net.sashakyotoz.wrathy_armament.networking.packets.UpdateGroupedParticlePacket;

public class UpdateParticlePacket {
    private final double x;
    private final double y;
    private final double z;
    private final float xSpeed;
    private final float ySpeed;
    private final float zSpeed;
    private final ParticleType<?> particle;

    public <T extends ParticleType<?>> UpdateParticlePacket(T pParticle, double pX, double pY, double pZ, float xSpeed, float ySpeed, float zSpeed) {
        this.particle = pParticle;
        this.x = pX;
        this.y = pY;
        this.z = pZ;
        this.xSpeed = xSpeed;
        this.ySpeed = ySpeed;
        this.zSpeed = zSpeed;
    }

    public UpdateParticlePacket(FriendlyByteBuf buffer) {
        ParticleType particletype = (ParticleType)ForgeRegistries.PARTICLE_TYPES.getValue(buffer.m_130281_());
        this.x = buffer.readDouble();
        this.y = buffer.readDouble();
        this.z = buffer.readDouble();
        this.xSpeed = buffer.readFloat();
        this.ySpeed = buffer.readFloat();
        this.zSpeed = buffer.readFloat();
        this.particle = particletype;
    }

    public void toBytes(FriendlyByteBuf buffer) {
        buffer.m_130085_(ForgeRegistries.PARTICLE_TYPES.getKey(this.particle));
        buffer.writeDouble(this.x);
        buffer.writeDouble(this.y);
        buffer.writeDouble(this.z);
        buffer.writeFloat(this.xSpeed);
        buffer.writeFloat(this.ySpeed);
        buffer.writeFloat(this.zSpeed);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> WANetworkingManager.sendToAll(new UpdateGroupedParticlePacket(this.particle, this.particle.m_123742_(), this.x, this.y, this.z, 0.0f, 0.0f, 0.0f, this.xSpeed, this.ySpeed, this.zSpeed, 1)));
        return true;
    }
}

