/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.wrathy_armament.registers;

import com.mojang.serialization.Codec;
import java.util.function.Function;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.sashakyotoz.wrathy_armament.blocks.entities.recipes.WorldshardWorkbenchRecipe;
import net.sashakyotoz.wrathy_armament.blocks.gui.WorldshardWorkbenchMenu;
import net.sashakyotoz.wrathy_armament.client.particles.options.CapturedSoulParticleOption;
import net.sashakyotoz.wrathy_armament.client.particles.options.FireSphereParticleOption;
import net.sashakyotoz.wrathy_armament.entities.bosses.Habciak;
import net.sashakyotoz.wrathy_armament.entities.bosses.JohannesKnight;
import net.sashakyotoz.wrathy_armament.entities.bosses.LichKing;
import net.sashakyotoz.wrathy_armament.entities.bosses.MoonLord;
import net.sashakyotoz.wrathy_armament.entities.bosses.SashaKYotoz;
import net.sashakyotoz.wrathy_armament.miscs.enchants.NightmareJumping;
import net.sashakyotoz.wrathy_armament.miscs.enchants.PhantomFury;
import net.sashakyotoz.wrathy_armament.miscs.enchants.Phantoquake;
import net.sashakyotoz.wrathy_armament.registers.WrathyArmamentBlocks;
import net.sashakyotoz.wrathy_armament.registers.WrathyArmamentItems;
import net.sashakyotoz.wrathy_armament.utils.data.loot.AddItemModifier;
import net.sashakyotoz.wrathy_armament.utils.data.loot.AddSusSandItemModifier;

public class WrathyArmamentMiscRegistries {
    public static final DeferredRegister<ParticleType<?>> PARTICLE_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.PARTICLE_TYPES, (String)"wrathy_armament");
    public static final RegistryObject<SimpleParticleType> PHANTOM_RAY = PARTICLE_TYPES.register("phantom_ray", () -> new SimpleParticleType(true));
    public static final RegistryObject<SimpleParticleType> ZENITH_WAY = PARTICLE_TYPES.register("zenith_way", () -> new SimpleParticleType(true));
    public static final RegistryObject<ParticleType<FireSphereParticleOption>> FIRE_SPHERE = WrathyArmamentMiscRegistries.registerParticle("fire_sphere", true, FireSphereParticleOption.DESERIALIZER, fireSphereParticleType -> FireSphereParticleOption.CODEC);
    public static final RegistryObject<SimpleParticleType> FROST_SOUL_RAY = PARTICLE_TYPES.register("frostsoul_ray", () -> new SimpleParticleType(true));
    public static final RegistryObject<SimpleParticleType> BEAM_SPARKLES = PARTICLE_TYPES.register("beam_sparkles", () -> new SimpleParticleType(true));
    public static final RegistryObject<ParticleType<CapturedSoulParticleOption>> CAPTURED_SOUL = WrathyArmamentMiscRegistries.registerParticle("captured_soul", true, CapturedSoulParticleOption.DESERIALIZER, soul -> CapturedSoulParticleOption.CODEC);
    public static final DeferredRegister<Enchantment> ENCHANTMENTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENCHANTMENTS, (String)"wrathy_armament");
    public static final RegistryObject<Enchantment> PHANTOM_FURY = ENCHANTMENTS.register("phantom_fury", () -> new PhantomFury(Enchantment.Rarity.RARE, EnchantmentCategory.WEAPON, EquipmentSlot.values()));
    public static final RegistryObject<Enchantment> NIGHTMARE_JUMPING = ENCHANTMENTS.register("nightmare_jumping", () -> new NightmareJumping(Enchantment.Rarity.RARE, EnchantmentCategory.WEAPON, EquipmentSlot.values()));
    public static final RegistryObject<Enchantment> PHANTOQUAKE = ENCHANTMENTS.register("phantoquake", () -> new Phantoquake(Enchantment.Rarity.RARE, EnchantmentCategory.WEAPON, EquipmentSlot.values()));
    public static final DeferredRegister<MenuType<?>> MENUS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MENU_TYPES, (String)"wrathy_armament");
    public static final RegistryObject<MenuType<WorldshardWorkbenchMenu>> WORLDSHARD_WORKBENCH = MENUS.register("worldshard_workbench", () -> IForgeMenuType.create(WorldshardWorkbenchMenu::new));
    public static final DeferredRegister<EntityDataSerializer<?>> SERIALIZER = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.ENTITY_DATA_SERIALIZERS, (String)"wrathy_armament");
    public static final RegistryObject<EntityDataSerializer<JohannesKnight.KnightPose>> KNIGHT_POSE = SERIALIZER.register("knight_pose", () -> EntityDataSerializer.m_238090_(JohannesKnight.KnightPose.class));
    public static final RegistryObject<EntityDataSerializer<MoonLord.LordPose>> LORD_POSE = SERIALIZER.register("lord_pose", () -> EntityDataSerializer.m_238090_(MoonLord.LordPose.class));
    public static final RegistryObject<EntityDataSerializer<SashaKYotoz.SashaKYotozPhase>> SASHAKYOTOZ_PHASE = SERIALIZER.register("sashakyotoz_phase", () -> EntityDataSerializer.m_238090_(SashaKYotoz.SashaKYotozPhase.class));
    public static final RegistryObject<EntityDataSerializer<Habciak.HabciakPose>> HABCIAK_POSE = SERIALIZER.register("habciak_pose", () -> EntityDataSerializer.m_238090_(Habciak.HabciakPose.class));
    public static final RegistryObject<EntityDataSerializer<LichKing.KingPose>> LICH_KING_POSE = SERIALIZER.register("lich_king_pose", () -> EntityDataSerializer.m_238090_(LichKing.KingPose.class));
    public static final DeferredRegister<MobEffect> EFFECTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MOB_EFFECTS, (String)"wrathy_armament");
    public static final RegistryObject<MobEffect> BRIGHTNESS = EFFECTS.register("brightness", () -> new MobEffect(MobEffectCategory.HARMFUL, 0xFFFFFF).m_216879_(() -> new MobEffectInstance.FactorData(22)));
    public static final DeferredRegister<Codec<? extends IGlobalLootModifier>> LOOT_MODIFIER_SERIALIZERS = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS, (String)"wrathy_armament");
    public static final RegistryObject<Codec<? extends IGlobalLootModifier>> ADD_ITEM = LOOT_MODIFIER_SERIALIZERS.register("add_item", AddItemModifier.CODEC);
    public static final RegistryObject<Codec<? extends IGlobalLootModifier>> ADD_SUS_SAND_ITEM = LOOT_MODIFIER_SERIALIZERS.register("add_sus_sand_item", AddSusSandItemModifier.CODEC);
    public static final DeferredRegister<RecipeSerializer<?>> RECIPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"wrathy_armament");
    public static final RegistryObject<RecipeSerializer<WorldshardWorkbenchRecipe>> WORLDSHARD_WORKBENCH_CRAFTING = RECIPES.register("worldshard_workbench_crafting", () -> WorldshardWorkbenchRecipe.Serializer.INSTANCE);
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"wrathy_armament");
    public static final RegistryObject<CreativeModeTab> WRATHY_ARMAMENT_TAB = CREATIVE_MODE_TABS.register("wrathy_armament_tab", () -> CreativeModeTab.builder().m_257941_((Component)Component.m_237115_((String)"creativetab.wrathy_armament_tab")).m_257737_(() -> ((Block)WrathyArmamentBlocks.WORLDSHARD_WORKBENCH.get()).m_5456_().m_7968_()).m_257501_((parameters, output) -> {
        output.m_246326_((ItemLike)WrathyArmamentBlocks.WORLDSHARD_WORKBENCH.get());
        output.m_246326_((ItemLike)WrathyArmamentItems.PHANTOM_LANCER.get());
        output.m_246326_((ItemLike)WrathyArmamentItems.MIRROR_SWORD.get());
        output.m_246326_((ItemLike)WrathyArmamentItems.ZENITH.get());
        output.m_246326_((ItemLike)WrathyArmamentItems.JOHANNES_SWORD.get());
        output.m_246326_((ItemLike)WrathyArmamentItems.MASTER_SWORD.get());
        output.m_246326_((ItemLike)WrathyArmamentItems.BLADE_OF_CHAOS.get());
        output.m_246326_((ItemLike)WrathyArmamentItems.FROSTMOURNE.get());
        output.m_246326_((ItemLike)WrathyArmamentItems.MURASAMA.get());
        output.m_246326_((ItemLike)WrathyArmamentItems.MISTSPLITTER_REFORGED.get());
        output.m_246326_((ItemLike)WrathyArmamentItems.HALF_ZATOICHI.get());
        output.m_246326_((ItemLike)WrathyArmamentItems.BLACKRAZOR.get());
        output.m_246326_((ItemLike)WrathyArmamentItems.COPPER_SWORD.get());
        output.m_246326_((ItemLike)WrathyArmamentItems.MEOWMERE.get());
        output.m_246326_((ItemLike)WrathyArmamentItems.MYTHRIL_INGOT.get());
        output.m_246326_((ItemLike)WrathyArmamentItems.LUNAR_VOODOO_DOLL.get());
        output.m_246326_((ItemLike)WrathyArmamentItems.SHARD_OF_CLEAR_MYTHRIL.get());
        output.m_246326_((ItemLike)WrathyArmamentItems.SHARD_OF_ORICHALCUM.get());
        output.m_246326_((ItemLike)WrathyArmamentItems.SHARD_OF_MECHANVIL.get());
        output.m_246326_((ItemLike)WrathyArmamentItems.SHARD_OF_NETHERNESS.get());
    }).m_257652_());

    public static <T extends ParticleOptions> RegistryObject<ParticleType<T>> registerParticle(String pKey, boolean pOverrideLimiter, ParticleOptions.Deserializer<T> pDeserializer, final Function<ParticleType<T>, Codec<T>> pCodecFactory) {
        return PARTICLE_TYPES.register(pKey, () -> new ParticleType<T>(pOverrideLimiter, pDeserializer){

            public Codec<T> m_7652_() {
                return (Codec)pCodecFactory.apply(this);
            }
        });
    }

    public static void register(IEventBus bus) {
        PARTICLE_TYPES.register(bus);
        ENCHANTMENTS.register(bus);
        EFFECTS.register(bus);
        MENUS.register(bus);
        CREATIVE_MODE_TABS.register(bus);
        RECIPES.register(bus);
        SERIALIZER.register(bus);
        LOOT_MODIFIER_SERIALIZERS.register(bus);
    }
}

