/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.wrathy_armament.utils;

import dev.kosmx.playerAnim.api.firstPerson.FirstPersonConfiguration;
import dev.kosmx.playerAnim.api.firstPerson.FirstPersonMode;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.api.layered.KeyframeAnimationPlayer;
import dev.kosmx.playerAnim.api.layered.ModifierLayer;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationAccess;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationRegistry;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.EntityPositionSource;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.sashakyotoz.wrathy_armament.WrathyArmament;
import net.sashakyotoz.wrathy_armament.client.particles.options.CapturedSoulParticleOption;
import net.sashakyotoz.wrathy_armament.entities.technical.BladeOfChaosEntity;
import net.sashakyotoz.wrathy_armament.items.SwordLikeItem;
import net.sashakyotoz.wrathy_armament.registers.WrathyArmamentItems;
import net.sashakyotoz.wrathy_armament.registers.WrathyArmamentMiscRegistries;
import net.sashakyotoz.wrathy_armament.registers.WrathyArmamentSounds;
import net.sashakyotoz.wrathy_armament.registers.WrathyArmamentTags;
import net.sashakyotoz.wrathy_armament.utils.capabilities.HalfZatoichiAbilityCapability;
import net.sashakyotoz.wrathy_armament.utils.capabilities.MistsplitterDefenseCapability;
import net.sashakyotoz.wrathy_armament.utils.capabilities.ModCapabilities;
import org.antlr.v4.runtime.misc.Triple;

@Mod.EventBusSubscriber
public class OnActionsTrigger {
    public static HashMap<String, Triple<Integer, Integer, Integer>> playerCameraData = new HashMap();
    public static HashMap<UUID, ModifierLayer<IAnimation>> animationPlayersMap = new HashMap();
    public static Vec3 vec3 = new Vec3(0.0, -256.0, 0.0);
    private static final UUID HEALTH_MODIFIER = UUID.fromString("2656de64-a009-47c8-8d53-cc0919b59bc9");
    private static final Collection<AbstractMap.SimpleEntry<Runnable, Integer>> workQueue = new ConcurrentLinkedQueue<AbstractMap.SimpleEntry<Runnable, Integer>>();

    public static void queueServerWork(int tick, Runnable action) {
        workQueue.add(new AbstractMap.SimpleEntry<Runnable, Integer>(action, tick));
    }

    @SubscribeEvent
    public static void tick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ArrayList actions = new ArrayList();
            workQueue.forEach(work -> {
                work.setValue((Integer)work.getValue() - 1);
                if ((Integer)work.getValue() == 0) {
                    actions.add(work);
                }
            });
            actions.forEach(e -> ((Runnable)e.getKey()).run());
            workQueue.removeAll(actions);
        }
    }

    @SubscribeEvent
    public static void registerPack(AddPackFindersEvent event) {
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (event.phase == TickEvent.Phase.END) {
            player.getCapability(ModCapabilities.HALF_ZATOICHI_ABILITIES).ifPresent(context -> {
                if (player.m_21051_(Attributes.f_22276_) != null) {
                    if (context.isInAdrenalinMode() && player.m_21051_(Attributes.f_22276_).m_22111_(HEALTH_MODIFIER) == null) {
                        player.m_21051_(Attributes.f_22276_).m_22125_(new AttributeModifier(HEALTH_MODIFIER, "Weapon debuff", (double)(-7 + player.m_21205_().m_41784_().m_128451_("Sparkles")), AttributeModifier.Operation.ADDITION));
                    } else if (!context.isInAdrenalinMode() && player.m_21051_(Attributes.f_22276_).m_22111_(HEALTH_MODIFIER) != null) {
                        player.m_21051_(Attributes.f_22276_).m_22120_(HEALTH_MODIFIER);
                    }
                }
            });
            player.getCapability(ModCapabilities.MISTSPLITTER_DEFENCE).ifPresent(context -> {
                if (context.isDefenseModeOn() && !player.m_21023_(MobEffects.f_19597_) && !player.m_9236_().m_5776_()) {
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 110, 1));
                }
            });
            playerCameraData.forEach((uuid, triple) -> {
                int shakingTime = (Integer)triple.a;
                int rollingTime = (Integer)triple.b;
                int rotatingTime = (Integer)triple.c;
                if (shakingTime > 0) {
                    --shakingTime;
                }
                if (rollingTime > 0) {
                    rollingTime -= 15;
                }
                if (rotatingTime > 0) {
                    rotatingTime -= 15;
                }
                playerCameraData.put((String)uuid, (Triple<Integer, Integer, Integer>)new Triple((Object)shakingTime, (Object)rollingTime, (Object)rotatingTime));
            });
        }
    }

    @SubscribeEvent
    public static void onPlayerAttack(AttackEntityEvent event) {
        Player player = event.getEntity();
        ItemStack stack = player.m_21205_();
        Item item = stack.m_41720_();
        if (item instanceof SwordLikeItem) {
            SwordLikeItem swordLikeItem = (SwordLikeItem)item;
            swordLikeItem.leftClickAttack(player, stack);
        }
        if (stack.m_150930_((Item)WrathyArmamentItems.MISTSPLITTER_REFORGED.get()) && event.getEntity().m_6084_() && (item = event.getTarget()) instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)item;
            player.getCapability(ModCapabilities.MISTSPLITTER_DEFENCE).ifPresent(context -> {
                if (context.isDefenseModeOn()) {
                    if (target.m_6336_() == MobType.f_21641_ && context.getDefenceType().equals("earth")) {
                        target.m_6469_(player.m_269291_().m_269075_(player), (float)(1 + stack.m_41784_().m_128451_("Sparkles")));
                    }
                    if (target.m_6336_() == MobType.f_21644_ && context.getDefenceType().equals("water")) {
                        target.m_6469_(player.m_269291_().m_269075_(player), (float)(1 + stack.m_41784_().m_128451_("Sparkles")));
                    }
                    if (target instanceof FlyingMob && context.getDefenceType().equals("air")) {
                        target.m_6469_(player.m_269291_().m_269075_(player), (float)(1 + stack.m_41784_().m_128451_("Sparkles")));
                    }
                    if (target.m_5825_() && context.getDefenceType().equals("fire")) {
                        target.m_6469_(player.m_269291_().m_269075_(player), (float)(1 + stack.m_41784_().m_128451_("Sparkles")));
                    }
                    if (target.m_6336_() == MobType.f_21640_ && context.getDefenceType().equals("elemental")) {
                        target.m_6469_(player.m_269291_().m_269075_(player), (float)(1 + stack.m_41784_().m_128451_("Sparkles")));
                    }
                    stack.m_41622_(2, (LivingEntity)player, player1 -> player1.m_21190_(InteractionHand.MAIN_HAND));
                    if ((double)player.m_217043_().m_188501_() > 0.875) {
                        context.setDefenseModeFlag(false);
                    }
                }
            });
        }
    }

    @SubscribeEvent
    public static void onPlayerLeftClick(PlayerInteractEvent.LeftClickEmpty event) {
        Item item = event.getItemStack().m_41720_();
        if (item instanceof SwordLikeItem) {
            SwordLikeItem item2 = (SwordLikeItem)item;
            item2.leftClickAttack(event.getEntity(), event.getItemStack());
        }
    }

    @SubscribeEvent
    public static void onEntityDiesEvent(LivingDeathEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof Player) {
            ServerLevel level;
            Level level2;
            CapturedSoulParticleOption option;
            Player player = (Player)entity;
            if (player.m_21205_().m_150930_((Item)WrathyArmamentItems.HALF_ZATOICHI.get())) {
                if (player.m_21205_().m_41784_().m_128451_("charge") < 3) {
                    player.m_21205_().m_41784_().m_128405_("charge", player.m_21205_().m_41784_().m_128451_("charge") + 1);
                }
                player.m_7292_(new MobEffectInstance(MobEffects.f_19601_, 10, 1 + player.m_21205_().m_41784_().m_128451_("charge")));
            }
            if (player.m_21205_().m_150930_((Item)WrathyArmamentItems.FROSTMOURNE.get())) {
                if (player.m_21205_().m_41784_().m_128451_("charge") < 5) {
                    player.m_21205_().m_41784_().m_128405_("charge", player.m_21205_().m_41784_().m_128451_("charge") + 1);
                }
                option = new CapturedSoulParticleOption((PositionSource)new EntityPositionSource((Entity)event.getEntity(), 0.0f), 30, 0.25f, 0.25f, 0.75f);
                level2 = player.m_9236_();
                if (level2 instanceof ServerLevel) {
                    level = (ServerLevel)level2;
                    level.m_8767_((ParticleOptions)option, player.m_20185_(), player.m_20186_(), player.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
            if (player.m_21205_().m_150930_((Item)WrathyArmamentItems.BLACKRAZOR.get())) {
                if (player.m_21205_().m_41784_().m_128451_("charge") < 20) {
                    player.m_21205_().m_41784_().m_128405_("charge", player.m_21205_().m_41784_().m_128451_("charge") + 1);
                }
                option = new CapturedSoulParticleOption((PositionSource)new EntityPositionSource((Entity)event.getEntity(), 0.0f), 30, 0.25f, 0.25f, 0.25f);
                level2 = player.m_9236_();
                if (level2 instanceof ServerLevel) {
                    level = (ServerLevel)level2;
                    level.m_8767_((ParticleOptions)option, player.m_20185_(), player.m_20186_(), player.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
                    level.m_8767_((ParticleOptions)ParticleTypes.f_123750_, player.m_20185_(), player.m_20186_() + 1.0, player.m_20189_(), 5, 0.0, 1.0, 0.0, 1.0);
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19601_, 10, 1));
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 100, 1));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onRightClick(PlayerInteractEvent.RightClickItem event) {
        Player player = event.getEntity();
        ItemStack stack = event.getItemStack();
        Item item = stack.m_41720_();
        if (item instanceof SwordLikeItem) {
            SwordLikeItem swordLikeItem = (SwordLikeItem)item;
            if (!event.getEntity().m_6047_()) {
                swordLikeItem.rightClick(player, stack);
            } else {
                swordLikeItem.rightClickOnShiftClick(player, stack);
            }
        }
        if (stack.m_150930_((Item)WrathyArmamentItems.BLADE_OF_CHAOS.get())) {
            if (player.m_6047_()) {
                OnActionsTrigger.playPlayerAnimation(player.m_9236_(), player, "blade_ability_switch", true);
                player.m_20124_(Pose.FALL_FLYING);
            } else {
                String behavior = BladeOfChaosEntity.PossibleBehavior.values()[stack.m_41784_().m_128451_((String)"StateIndex")].behaviorName;
                if (behavior.equals(BladeOfChaosEntity.PossibleBehavior.CRUSH.behaviorName)) {
                    OnActionsTrigger.playPlayerAnimation(player.m_9236_(), player, "nemean_crush", true);
                } else if (behavior.equals(BladeOfChaosEntity.PossibleBehavior.CYCLONE.behaviorName)) {
                    OnActionsTrigger.playPlayerAnimation(player.m_9236_(), player, "crooked_throw_of_blades", true);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onBlockLeftClick(PlayerInteractEvent.LeftClickBlock event) {
        Player player = event.getEntity();
        ItemStack stack = event.getItemStack();
        Level level = event.getLevel();
        Item item = stack.m_41720_();
        if (item instanceof SwordLikeItem) {
            SwordLikeItem swordLikeItem = (SwordLikeItem)item;
            swordLikeItem.rightClickBlock(player, stack);
        }
        if (stack.getEnchantmentLevel((Enchantment)WrathyArmamentMiscRegistries.PHANTOQUAKE.get()) > 0 && event.getHand() == InteractionHand.MAIN_HAND && event.getLevel().m_8055_(event.getPos().m_6630_(3)).m_60795_() && !event.getEntity().m_36335_().m_41519_(event.getItemStack().m_41720_())) {
            player.m_20334_(0.0, 0.5, 0.0);
            player.m_216990_(SoundEvents.f_12228_);
            player.m_36335_().m_41524_(event.getItemStack().m_41720_(), Mth.m_216287_((RandomSource)RandomSource.m_216327_(), (int)20, (int)80));
            OnActionsTrigger.addParticles((ParticleOptions)ParticleTypes.f_123813_, level, player.m_20185_(), player.m_20186_(), player.m_20189_(), 3.0f);
            Vec3 center = new Vec3((double)event.getPos().m_123341_(), (double)(event.getPos().m_123342_() + 1), (double)event.getPos().m_123343_());
            List<Entity> entities = event.getLevel().m_6443_(Entity.class, new AABB(center, center).m_82400_(4.0), e -> true).stream().sorted(Comparator.comparingDouble(_entcnd -> _entcnd.m_20238_(center))).toList();
            for (Entity entityIterator : entities) {
                if (entityIterator == event.getEntity() || !(entityIterator instanceof LivingEntity)) continue;
                LivingEntity entity = (LivingEntity)entityIterator;
                entity.m_20254_(20);
                entity.m_20334_((double)(RandomSource.m_216327_().m_216339_(0, 2) - 1), 0.75, (double)(RandomSource.m_216327_().m_216339_(0, 2) - 1));
                event.getEntity().m_36335_().m_41524_(event.getItemStack().m_41720_(), Mth.m_216287_((RandomSource)RandomSource.m_216327_(), (int)60, (int)120));
            }
        }
    }

    @SubscribeEvent
    public static void onBlockRightClick(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        if (!player.m_9236_().m_5776_() && !player.m_7500_() && OnActionsTrigger.isCloseToProtectedStructure(player)) {
            player.m_5661_((Component)Component.m_237115_((String)"structure.wrathy_armament.protection"), true);
            event.setCanceled(true);
        }
    }

    private static boolean isCloseToProtectedStructure(Player player) {
        Level level = player.m_9236_();
        if (level instanceof ServerLevel) {
            BlockPos pos;
            ServerLevel serverLevel = (ServerLevel)level;
            if (!player.m_7500_() && (pos = serverLevel.m_215011_(WrathyArmamentTags.Structures.VISIBLE_FOR_MASTER_SWORD, player.m_20097_(), 96, false)) != null) {
                double distanceSquared = player.m_20275_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
                double normalizedDistance = Math.min(distanceSquared / 4613.0, 10.0);
                double lightsValue = 10.0 - normalizedDistance;
                return lightsValue > 8.0;
            }
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onCameraSetup(ViewportEvent.ComputeCameraAngles event) {
        Player player;
        Minecraft minecraft = Minecraft.m_91087_();
        Entity entity = minecraft.m_91288_();
        if (entity instanceof Player && !(player = (Player)entity).m_5833_()) {
            String playerUUID = player.m_20148_().toString();
            playerCameraData.computeIfAbsent(playerUUID, k -> new Triple((Object)0, (Object)0, (Object)0));
            Triple<Integer, Integer, Integer> cameraData = playerCameraData.get(playerUUID);
            int shakingTime = (Integer)cameraData.a;
            int rollingTime = (Integer)cameraData.b;
            int rotatingTime = (Integer)cameraData.c;
            if (player.m_20238_(vec3) < 24.0) {
                float delta = Minecraft.m_91087_().m_91296_();
                float ticksExistedDelta = (float)player.f_19797_ + delta;
                float intensity = 0.025f;
                if (!minecraft.m_91104_() && player.m_9236_().m_5776_() && shakingTime > 0) {
                    event.setPitch((float)((double)event.getPitch() + (double)intensity * Math.cos(ticksExistedDelta * 3.0f + 2.0f) * 25.0));
                    event.setYaw((float)((double)event.getYaw() + (double)intensity * Math.cos(ticksExistedDelta * 5.0f + 1.0f) * 25.0));
                    event.setRoll((float)((double)event.getRoll() + (double)intensity * Math.cos(ticksExistedDelta * 4.0f) * 25.0));
                }
            }
            if (!minecraft.m_91104_() && player.m_9236_().m_5776_()) {
                if (minecraft.f_91066_.m_92176_().m_90612_() && rollingTime > 0) {
                    event.setPitch(-(event.getPitch() + (float)rollingTime));
                }
                if (minecraft.f_91066_.m_92176_().m_90612_() && rotatingTime > 0) {
                    event.setYaw(event.getYaw() + (float)rotatingTime);
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onFogColorSetup(ViewportEvent.ComputeFogColor event) {
        LivingEntity entity;
        Entity entity2 = event.getCamera().m_90592_();
        if (entity2 instanceof LivingEntity && (entity = (LivingEntity)entity2).m_21023_((MobEffect)WrathyArmamentMiscRegistries.BRIGHTNESS.get())) {
            event.setRed(1.0f);
            event.setGreen(1.0f);
            event.setBlue(1.0f);
        }
    }

    @SubscribeEvent
    public static void onAttachCapabilitiesPlayer(AttachCapabilitiesEvent<Entity> event) {
        Player player;
        Object object = event.getObject();
        if (object instanceof Player && !(player = (Player)object).getCapability(ModCapabilities.MISTSPLITTER_DEFENCE).isPresent()) {
            event.addCapability(new ResourceLocation("wrathy_armament", "properties"), (ICapabilityProvider)new ModCapabilities());
        }
    }

    @SubscribeEvent
    public static void onPlayerCloned(PlayerEvent.Clone event) {
        if (event.isWasDeath()) {
            event.getOriginal().getCapability(ModCapabilities.MISTSPLITTER_DEFENCE).ifPresent(oldStore -> event.getOriginal().getCapability(ModCapabilities.MISTSPLITTER_DEFENCE).ifPresent(newStore -> newStore.copyFrom((MistsplitterDefenseCapability)oldStore)));
            event.getOriginal().getCapability(ModCapabilities.HALF_ZATOICHI_ABILITIES).ifPresent(oldStore -> event.getOriginal().getCapability(ModCapabilities.HALF_ZATOICHI_ABILITIES).ifPresent(newStore -> newStore.copyFrom((HalfZatoichiAbilityCapability)oldStore)));
        }
    }

    @SubscribeEvent
    public static void onPlayerAttack(LivingAttackEvent event) {
        Player player;
        LivingEntity entity = event.getEntity();
        int damage = 0;
        Entity entity2 = event.getSource().m_7639_();
        if (entity2 instanceof Player && (player = (Player)entity2).m_21120_(InteractionHand.MAIN_HAND).getEnchantmentLevel((Enchantment)WrathyArmamentMiscRegistries.NIGHTMARE_JUMPING.get()) > 0) {
            if (Math.random() > 0.75) {
                damage = RandomSource.m_216327_().m_216339_(3, 6);
            }
            player.m_6021_(event.getEntity().m_20185_(), event.getEntity().m_20186_(), event.getEntity().m_20189_());
            player.m_216990_(WrathyArmamentSounds.ITEM_LANCER_SHOT);
            entity.m_6469_(new DamageSource((Holder)event.getEntity().m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268433_)){

                public Component m_6157_(LivingEntity _msgEntity) {
                    return Component.m_237115_((String)"death.attack.wrathy_armament.nightmare_jumping");
                }
            }, event.getAmount() + (float)damage);
            if (entity.m_6084_()) {
                entity.m_20334_(0.0, (double)((float)RandomSource.m_216327_().m_216339_(5, 15) / 10.0f), 0.0);
            }
        }
    }

    public static double getXVector(double speed, double yaw) {
        return speed * Math.cos((yaw + 90.0) * (Math.PI / 180));
    }

    public static double getYVector(double speed, double pitch) {
        return pitch * -0.025 * speed;
    }

    public static double getZVector(double speed, double yaw) {
        return speed * Math.sin((yaw + 90.0) * (Math.PI / 180));
    }

    public static void addParticles(ParticleOptions type, Level level, double x, double y, double z, float modifier) {
        for (int i = 0; i < 360; ++i) {
            if (i % 20 != 0) continue;
            level.m_7106_(type, x, y, z, Math.cos(i) * 0.25 * (double)modifier, 0.2, Math.sin(i) * 0.25 * (double)modifier);
        }
    }

    public static void addParticlesWithDelay(ParticleOptions type, Level level, double x, double y, double z, float modifier, int delay) {
        for (int i = 0; i < 360; ++i) {
            if (i % 20 != 0) continue;
            int finalI = i;
            OnActionsTrigger.queueServerWork(finalI * 5 + delay, () -> level.m_7106_(type, x + 0.25, y, z + 0.25, Math.cos(finalI) * 0.25 * (double)modifier, 0.2, Math.sin(finalI) * 0.25 * (double)modifier));
        }
    }

    public static void playPlayerAnimation(Level level, Player player, String path, boolean showParticleTrail) {
        ModifierLayer animation;
        if (level.m_5776_() && (animation = (ModifierLayer)PlayerAnimationAccess.getPlayerAssociatedData((AbstractClientPlayer)((AbstractClientPlayer)player)).get(WrathyArmament.createWALocation("animation"))) != null) {
            if (showParticleTrail) {
                animationPlayersMap.put(player.m_20148_(), (ModifierLayer<IAnimation>)animation);
            }
            animation.setAnimation((IAnimation)new KeyframeAnimationPlayer(PlayerAnimationRegistry.getAnimation((ResourceLocation)WrathyArmament.createWALocation(path))).setFirstPersonMode(FirstPersonMode.THIRD_PERSON_MODEL).setFirstPersonConfiguration(new FirstPersonConfiguration(true, true, true, true)));
        }
    }

    public static boolean isBetterCombatIn() {
        return ModList.get().isLoaded("bettercombat");
    }

    public static boolean isOculusIn() {
        return ModList.get().isLoaded("oculus") || ModList.get().isLoaded("iris");
    }

    public static float getPowerForTime(int i) {
        float f = (float)i / 20.0f;
        f = (f * f + f * 2.0f) / 3.0f;
        return f;
    }
}

