/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.wrathy_armament.utils;

import java.nio.file.Path;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.sashakyotoz.wrathy_armament.client.renderer.layers.TransparentFireLayer;
import net.sashakyotoz.wrathy_armament.client.renderer.layers.WeaponsOnBackLayer;
import net.sashakyotoz.wrathy_armament.entities.alive.Guide;
import net.sashakyotoz.wrathy_armament.entities.alive.LichMyrmidon;
import net.sashakyotoz.wrathy_armament.entities.alive.TrueEyeOfCthulhu;
import net.sashakyotoz.wrathy_armament.entities.bosses.Habciak;
import net.sashakyotoz.wrathy_armament.entities.bosses.JohannesKnight;
import net.sashakyotoz.wrathy_armament.entities.bosses.LichKing;
import net.sashakyotoz.wrathy_armament.entities.bosses.MoonLord;
import net.sashakyotoz.wrathy_armament.entities.bosses.SashaKYotoz;
import net.sashakyotoz.wrathy_armament.registers.WrathyArmamentEntities;
import net.sashakyotoz.wrathy_armament.utils.capabilities.HalfZatoichiAbilityCapability;
import net.sashakyotoz.wrathy_armament.utils.capabilities.MistsplitterDefenseCapability;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class OnModActionsTrigger {
    @SubscribeEvent
    public static void registerPack(AddPackFindersEvent event) {
        if (event.getPackType() == PackType.CLIENT_RESOURCES) {
            Path path = ModList.get().getModFileById("wrathy_armament").getFile().findResource(new String[]{"resourcepacks/pixel_wrathy_swords"});
            Pack builtinDataPack = Pack.m_245429_((String)"wrathy_armament:pixel_wrathy_swords", (Component)Component.m_237115_((String)"pack.wrathy_armament"), (boolean)false, a -> new PathPackResources(a, path, false), (PackType)PackType.CLIENT_RESOURCES, (Pack.Position)Pack.Position.TOP, (PackSource)PackSource.m_247176_(arg -> Component.m_237110_((String)"pack.nameAndSource", (Object[])new Object[]{arg, Component.m_237115_((String)"pack.source.builtin")}).m_130940_(ChatFormatting.GRAY), (boolean)false));
            event.addRepositorySource(packConsumer -> packConsumer.accept(builtinDataPack));
        }
    }

    @SubscribeEvent
    public static void onRegisterCapabilities(RegisterCapabilitiesEvent event) {
        event.register(HalfZatoichiAbilityCapability.class);
        event.register(MistsplitterDefenseCapability.class);
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)WrathyArmamentEntities.SASHAKYOTOZ.get(), SashaKYotoz.createAttributes().m_22265_());
        event.put((EntityType)WrathyArmamentEntities.HABCIAK.get(), Habciak.createAttributes().m_22265_());
        event.put((EntityType)WrathyArmamentEntities.LICH_KING.get(), LichKing.createAttributes().m_22265_());
        event.put((EntityType)WrathyArmamentEntities.JOHANNES_KNIGHT.get(), JohannesKnight.createAttributes().m_22265_());
        event.put((EntityType)WrathyArmamentEntities.MOON_LORD.get(), MoonLord.createAttributes().m_22265_());
        event.put((EntityType)WrathyArmamentEntities.TRUE_EYE_OF_CTHULHU.get(), TrueEyeOfCthulhu.createAttributes().m_22265_());
        event.put((EntityType)WrathyArmamentEntities.LICH_MYRMIDON.get(), LichMyrmidon.createAttributes().m_22265_());
        event.put((EntityType)WrathyArmamentEntities.THE_GUIDE.get(), Guide.createAttributes().m_22265_());
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void registerLayer(EntityRenderersEvent.AddLayers event) {
        event.getSkins().forEach(s -> {
            LivingEntityRenderer livingEntityRenderer = event.getSkin(s);
            if (livingEntityRenderer instanceof PlayerRenderer) {
                PlayerRenderer playerRenderer = (PlayerRenderer)livingEntityRenderer;
                playerRenderer.m_115326_(new TransparentFireLayer(playerRenderer, event.getEntityModels()));
                playerRenderer.m_115326_(new WeaponsOnBackLayer(playerRenderer, event.getContext()));
            }
        });
    }
}

