/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.wrathy_armament.utils.capabilities;

import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.sashakyotoz.wrathy_armament.utils.capabilities.HalfZatoichiAbilityCapability;
import net.sashakyotoz.wrathy_armament.utils.capabilities.MistsplitterDefenseCapability;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModCapabilities
implements ICapabilitySerializable<CompoundTag> {
    public static Capability<MistsplitterDefenseCapability> MISTSPLITTER_DEFENCE = CapabilityManager.get((CapabilityToken)new CapabilityToken<MistsplitterDefenseCapability>(){});
    private MistsplitterDefenseCapability mistsplitterDefenseCapability = null;
    private final LazyOptional<MistsplitterDefenseCapability> mistsplitterDefenseOptional = LazyOptional.of(this::createMistsplitterCapability);
    public static Capability<HalfZatoichiAbilityCapability> HALF_ZATOICHI_ABILITIES = CapabilityManager.get((CapabilityToken)new CapabilityToken<HalfZatoichiAbilityCapability>(){});
    private HalfZatoichiAbilityCapability halfZatoichiAbilityCapability = null;
    private final LazyOptional<HalfZatoichiAbilityCapability> halfZatoichiAbilityOptional = LazyOptional.of(this::createHalfZatoichiCapability);

    private MistsplitterDefenseCapability createMistsplitterCapability() {
        if (this.mistsplitterDefenseCapability == null) {
            this.mistsplitterDefenseCapability = new MistsplitterDefenseCapability();
        }
        return this.mistsplitterDefenseCapability;
    }

    private HalfZatoichiAbilityCapability createHalfZatoichiCapability() {
        if (this.halfZatoichiAbilityCapability == null) {
            this.halfZatoichiAbilityCapability = new HalfZatoichiAbilityCapability();
        }
        return this.halfZatoichiAbilityCapability;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == MISTSPLITTER_DEFENCE) {
            return this.mistsplitterDefenseOptional.cast();
        }
        if (cap == HALF_ZATOICHI_ABILITIES) {
            return this.halfZatoichiAbilityOptional.cast();
        }
        return LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        this.createMistsplitterCapability().saveNBTData(tag);
        this.createHalfZatoichiCapability().saveNBTData(tag);
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.createMistsplitterCapability().loadNBTData(nbt);
        this.createHalfZatoichiCapability().loadNBTData(nbt);
    }
}

