/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.wrathy_armament.utils.data;

import net.minecraft.data.PackOutput;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.registries.RegistryObject;
import net.sashakyotoz.wrathy_armament.registers.WrathyArmamentBlocks;
import net.sashakyotoz.wrathy_armament.registers.WrathyArmamentEntities;
import net.sashakyotoz.wrathy_armament.registers.WrathyArmamentItems;

public class WALangProvider
extends LanguageProvider {
    private static final String NORMAL_CHARS = " abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_,;.?!/\\'";
    private static final String UPSIDE_DOWN_CHARS = " \u0250q\u0254p\u01dd\u025fb\u0265\u0131\u0638\u029e\u05df\u026fuodb\u0279s\u0287n\u028c\u028dx\u028ez\u2c6f\u15fa\u0186\u15e1\u018e\u2132\u2141HI\u017f\u029e\ua780WNO\u0500\u1f49\u1d1aS\u27d8\u2229\u039bMX\u028eZ0\u0196\u1105\u0190\u3123\u03db9\u312586\u203e'\u061b\u02d9\u00bf\u00a1/\\,";
    private final boolean upsideDown;

    public WALangProvider(PackOutput packOutput, String locale, boolean upsideDown) {
        super(packOutput, "wrathy_armament", locale);
        this.upsideDown = upsideDown;
    }

    protected void addTranslations() {
        WrathyArmamentItems.ITEMS.getEntries().stream().filter(item -> !(item.get() instanceof BlockItem)).forEach(this::addItem);
        WrathyArmamentEntities.REGISTRY.getEntries().forEach(this::addEntityType);
        WrathyArmamentBlocks.BLOCKS.getEntries().forEach(this::addBlock);
        this.add("creativetab.wrathy_armament_tab", "Wrathly Armament Arsenal");
        this.add("tooltip.press_shift", "Press [ Shift ]");
        this.add("pack.wrathy_armament", "Wrathly Armament Pixel Swords");
        this.add("item.wrathy_armament.material", "Material");
        this.add("item.wrathy_armament.action_item", "Action Item");
        this.add("subtitles.item.phantom_lancer", "Splash of phantoms");
        this.add("subtitles.item.light_swing", "Light sword swing");
        this.add("subtitles.item.katana_swing", "Katana-like swing");
        this.add("subtitles.item.soul_swing", "Soulful sword swing");
        this.add("subtitles.entity.moon_lord_hurt", "Moon Lord hurt");
        this.add("enchantment.wrathy_armament.phantom_fury", "Phantom Fury");
        this.add("enchantment.wrathy_armament.nightmare_jumping", "Nightmare Jumping");
        this.add("enchantment.wrathy_armament.phantoquake", "Phantoquake");
        this.add("effect.wrathy_armament.brightness", "Brightness");
        this.add("structure.wrathy_armament.protection", "Structure, reinforced by magic, cancels this action");
        this.add("boss.wrathy_armament.sashakyotoz.appeared", "On the fourth sleepless day, nightmare were visualized");
        this.add("boss.wrathy_armament.johannes_fountain.dying", "The sun... I had forgotten how it feels");
        this.addWeaponsDescriptions();
        this.addDeathDescriptions();
        this.addBossDescriptions();
    }

    private void addWeaponsDescriptions() {
        this.add("item.wrathy_armament.abilities", "- Abilities:");
        this.add("item.wrathy_armament.abilities.fire", "\u00a76Fire");
        this.add("item.wrathy_armament.abilities.water", "\u00a79Water");
        this.add("item.wrathy_armament.abilities.elemental", "\u00a75Elementalis");
        this.add("item.wrathy_armament.abilities.earth", "\u00a7aEarth");
        this.add("item.wrathy_armament.abilities.air", "\u00a7fAir");
        this.add("item.wrathy_armament.abilities.WRATH_OF_ARTEMIS", "Wrath of artemis");
        this.add("item.wrathy_armament.abilities.CYCLONE_OF_CHAOS", "Cyclone of chaos");
        this.add("item.wrathy_armament.abilities.NEMEAN_CRUSH", "Nemean crush");
        this.add("item.wrathy_armament.phantom_lancer_hint", "- Circular Attack");
        this.add("item.wrathy_armament.phantom_lancer_hint1", "- Ranged Sweep Attack");
        this.add("item.wrathy_armament.phantom_lancer_circular_attack", "Creates explosion, that hits nearby mobs");
        this.add("item.wrathy_armament.left_hand", "When player holds item in left hand:");
        this.add("item.wrathy_armament.right_hand", "When player holds item in right hand:");
        this.add("death.attack.wrathy_armament.phantom_shock_attack", "Causes splash, that hits mobs within radius of 6 blocks");
        this.add("item.wrathy_armament.phantom_lancer_sweep_attack", "Shoots wave of small phantoms in range of 16 blocks forward to player's view");
        this.add("item.wrathy_armament.johannes_sword_hint", "- Dash");
        this.add("item.wrathy_armament.johannes_sword_dash", "Push player forward to side of its view");
        this.add("item.wrathy_armament.johannes_sword_hint1", "- Spear Attack");
        this.add("item.wrathy_armament.johannes_sword_spear_attack", "Feel power of Johannes to spread spears above ground");
        this.add("item.wrathy_armament.zenith_hint", "- Oo Zenith");
        this.add("item.wrathy_armament.zenith_ability", "When swung, the sword sprites of its component swords fly towards enemies");
        this.add("item.wrathy_armament.master_sword_hint", "- Gale Strike");
        this.add("item.wrathy_armament.master_sword_attack", "Channels the power of the wind, launching the player backward in the direction of their head rotation and leaves explosive wave of air");
        this.add("item.wrathy_armament.master_sword_hint1", "- Alter Time");
        this.add("item.wrathy_armament.master_sword_alter_time", "Turn owner of sword back in time to safer location");
        this.add("item.wrathy_armament.blade_of_chaos_hint", "- Rising Fury");
        this.add("item.wrathy_armament.blade_of_chaos_attack", "Powerful attack, that launches enemies into air and fire them");
        this.add("item.wrathy_armament.blade_of_chaos_hint1", "- God's combo");
        this.add("item.wrathy_armament.blade_of_chaos_attack1", "Feel power of Kratos to manage Nemean crush, Cyclone of chaos and Wrath of artemis");
        this.add("item.wrathy_armament.frostmourne_hint", "- Soulstorm Barrage");
        this.add("item.wrathy_armament.frostmourne_attack", "Summons a torrent of souls that rains down upon the battlefield");
        this.add("item.wrathy_armament.frostmourne_hint1", "- Rising of fallen");
        this.add("item.wrathy_armament.frostmourne_attack1", "Killed undead enemy can arise to be your ally");
        this.add("item.wrathy_armament.frostmourne_charge", "Souls contain: ");
        this.add("item.wrathy_armament.murasama_hint", "- HF-absorption");
        this.add("item.wrathy_armament.murasama_attack", "Each hit of enemy in combo modify speed of sword's owner, stacks to 30%");
        this.add("item.wrathy_armament.mistsplitter_hint", "- Time charger");
        this.add("item.wrathy_armament.mistsplitter_attack", "Time of rest of sword converts in power of next attack");
        this.add("item.wrathy_armament.half_zatoichi_hint", "- Hostage of weapon");
        this.add("item.wrathy_armament.half_zatoichi_attack", "Hitting of enemy awards by regeneration, but switching of weapon takes it away");
        this.add("item.wrathy_armament.half_zatoichi_charge", "Hits charge: ");
        this.add("item.wrathy_armament.mirror_sword_hint", "Sight of reflection");
        this.add("item.wrathy_armament.mirror_sword_mirroring", "Through the prism of sword, pierces hazards moving at player");
        this.add("item.wrathy_armament.mirror_sword_charge", "Damage keep: ");
        this.add("item.wrathy_armament.blackrazor_hint", "Soul Hunter");
        this.add("item.wrathy_armament.blackrazor_attack", "Force and convert target's life into healing energy and a temporary boost of speed and strength for the wielder");
        this.add("item.wrathy_armament.blackrazor_hungry_timer", "Require new souls in: ");
        this.add("item.wrathy_armament.game.master_sword", "-Original from The Legend of Zelda series");
        this.add("item.wrathy_armament.game.johannes_sword", "-Original from Rogue Legacy I");
        this.add("item.wrathy_armament.game.zenith", "-Original from Terraria");
        this.add("item.wrathy_armament.game.blade_of_chaos", "-Original from God of War series");
        this.add("item.wrathy_armament.game.frostmourne", "-Original from World of Warcraft");
        this.add("item.wrathy_armament.game.murasama", "-Original from Metal Gear");
        this.add("item.wrathy_armament.game.mistsplitter", "-Original from Genshin Impact");
        this.add("item.wrathy_armament.game.half_zatoichi", "-Original from Team Fortress 2");
        this.add("item.wrathy_armament.game.blackrazor", "-Original from D&D");
        this.add("jei.wrathy_armament.phantom_lancer", "First weapon that was added to the mod. \nIn itself presents mix of scythe and glaive from Minecraft Dungeons. \nIn mod can be obtained by slaying SashaKYotoz in phantom \narmor that appears each 4th night which player doesn't sleep");
        this.add("jei.wrathy_armament.mirrow_sword", "Weapon made up by Habciak, Polish translator of mod, \nwith idea to reuse taken damage. \nIn mod can be obtained by slaying Habciak in his cuboid\nstructure in desert biomes");
        this.add("jei.wrathy_armament.master_sword", "Sword from The Legend of Zelda series. \nIn mod can be obtained by taking it from stone handler \nin muddy structure in mangrove swamp biome. \nAttacks and abilities are added according to description \nof them on wiki of The Legend of Zelda");
        this.add("jei.wrathy_armament.johannes_sword", "Rogue Legacy inspired sword that Johannes, last boss \nin Rogue Legacy I, has in its arm when fighting player. \nIn mod can be obtained by slaying Johannes \nin huge castle-like structure in plains biomes. \nAttacks and abilities are added according to attacks \nof Johannes in Rogue Legacy against player in final of game");
        this.add("jei.wrathy_armament.frostmourne", "Legendary weapon from World of Warcraft series \nimplemented into mod from scratch of its look. \nIn mod can be obtained by slaying Lich King spawned \nin icecrown citadel structure in snowy plains biomes. \nAttacks and abilities are added according to description \nof them on wiki of WOW");
        this.add("jei.wrathy_armament.mistsplitter_reforged", "Weapon from Genshin Impact, \nsuggested by ash_ketchum0401 to be added into mod. \nAttacks and abilities are added according to description \nof them on wiki and information given by ash_ketchum0401");
        this.add("jei.wrathy_armament.murasama", "Powerful katana-like weapon from Metal Gear series \nimplemented into mod from scratch of its look. \nAttacks and abilities are added according to description \nof them on wiki of Metal Gear. \nEaster egg: rename blade into Muramasa, and it'll change");
        this.add("jei.wrathy_armament.half_zatoichi", "Katana from Team Fortress 2 \nimplemented into mod from its look and gameplay with it. \nAttacks and abilities are added according to videos \nwith using Half Zatoichi.");
        this.add("jei.wrathy_armament.blade_of_chaos", "Legendary blade from God Of War series \nimplemented into mod from its context and look in God Of War 1");
        this.add("jei.wrathy_armament.blackrazor", "Epic sword from Baldur's Gate and D&D in general, \nsuggested by sirdragonblaster to be added into mod. \nIn mod can be obtained by taking it from stone handler \nin buried stone bricks structure in mountain biomes \nAttacks and abilities are added according to description \nof them on wiki and information given by sirdragonblaster");
        this.add("jei.wrathy_armament.lunar_voodoo_doll", "Modified Guide Voodoo Doll. \nDoll can be dropped from Guide if player slayed him at night and moon is visible. \nOnce thrown into water, Moon Lord will be spawned if sky is visible and it's night time");
    }

    private void addDeathDescriptions() {
        this.add("death.attack.wrathy_armament.phantom_shock_message", "Overshocked by phantoms");
        this.add("death.attack.wrathy_armament.blade_of_chaos_message", "Burnt to a crisp");
        this.add("death.attack.wrathy_armament.frostmourne_message", "Take out of soul");
        this.add("death.attack.wrathy_armament.nightmare_jumping", "Set to dust");
        this.add("death.attack.wrathy_armament.johannes_sword_spears", "Spear stabbed");
    }

    private void addBossDescriptions() {
        this.add("boss.wrathy_armament.sashakyotoz", "SashaKYotoz, the Phantom Lancer Keeper");
        this.add("boss.wrathy_armament.habciak", "Habciak, the Mirror Sword Keeper");
        this.add("boss.wrathy_armament.lich_king", "Lich King, the Frostmourne Keeper");
        this.add("boss.wrathy_armament.johannes_knight", "Johannes, the Traitor");
        this.add("boss.wrathy_armament.johannes_fountain", "Johannes, the Fountain");
    }

    private void addEntityType(RegistryObject<EntityType<?>> entity) {
        String key = entity.getId().m_135815_();
        super.add("entity.wrathy_armament." + key, this.convertToName(key));
    }

    public void add(String key, String value) {
        if (this.upsideDown) {
            super.add(key, WALangProvider.toUpsideDown(value));
        } else {
            super.add(key, value);
        }
    }

    private void addBlock(RegistryObject<Block> block) {
        String key = block.getId().m_135815_();
        super.add("block.wrathy_armament." + key, this.convertToName(key));
    }

    private void addItem(RegistryObject<Item> item) {
        String key = item.getId().m_135815_();
        super.add("item.wrathy_armament." + key, this.convertToName(key));
    }

    private String convertToName(String key) {
        StringBuilder builder = new StringBuilder(key.substring(0, 1).toUpperCase() + key.substring(1));
        for (int i = 1; i < builder.length(); ++i) {
            if (builder.charAt(i) != '_') continue;
            builder.deleteCharAt(i);
            builder.replace(i, i + 1, " " + Character.toUpperCase(builder.charAt(i)));
        }
        String name = builder.toString();
        return this.upsideDown ? WALangProvider.toUpsideDown(name) : name;
    }

    private static String toUpsideDown(String name) {
        StringBuilder builder = new StringBuilder();
        for (int i = name.length() - 1; i >= 0; --i) {
            if (i > 2 && name.substring(i - 3, i + 1).equals("%1$s")) {
                builder.append(name, i - 3, i + 1);
                i -= 4;
                continue;
            }
            char upsideDown = UPSIDE_DOWN_CHARS.charAt(NORMAL_CHARS.indexOf(name.charAt(i)));
            builder.append(upsideDown);
        }
        return builder.toString();
    }
}

