package com.bwt;

import com.bwt.block_entities.BwtBlockEntities;
import com.bwt.blocks.BwtBlocks;
import com.bwt.blocks.unfired_pottery.UnfiredDecoratedPotBlockEntity;
import com.bwt.entities.BwtEntities;
import com.bwt.items.BwtItems;
import com.bwt.utils.KilnBlockCookProgressSetter;
import com.bwt.utils.kiln_block_cook_overlay.KilnBlockCookingProgressPayload;
import com.bwt.models.*;
import com.bwt.screens.*;
import com.bwt.utils.Id;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.rendering.v1.BuiltinItemRendererRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.ColorProviderRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityModelLayerRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.minecraft.class_1921;
import net.minecraft.class_1933;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_310;
import net.minecraft.class_3929;
import net.minecraft.class_5272;
import net.minecraft.class_5601;
import net.minecraft.class_5616;
import net.minecraft.class_6880;
import net.minecraft.class_928;
import net.minecraft.class_953;

@Environment(EnvType.CLIENT)
public class BetterWithTimeClient implements ClientModInitializer {
	public static final class_5601 MODEL_WINDMILL_LAYER = new class_5601(Id.of("windmill"), "main");
	public static final class_5601 MODEL_WATER_WHEEL_LAYER = new class_5601(Id.of("water_wheel"), "main");
	public static final class_5601 MECH_HOPPER_FILL_LAYER = new class_5601(Id.of("mech_hopper_fill"), "main");
	public static final class_5601 CAULDRON_FILL_LAYER = new class_5601(Id.of("cauldron_fill"), "main");
	public static final class_5601 CRUCIBLE_FILL_LAYER = new class_5601(Id.of("crucible_fill"), "main");

    private final UnfiredDecoratedPotBlockEntity renderUnfiredDecoratedPot = new UnfiredDecoratedPotBlockEntity(class_2338.field_10980, BwtBlocks.unfiredDecoratedPotBlockWithSherds.method_9564());

	@Override
	public void onInitializeClient() {
		// This entrypoint is suitable for setting up client-specific logic, such as rendering.
        class_5616.method_32144(BwtBlockEntities.mechHopperBlockEntity, MechHopperBlockEntityRenderer::new);
        class_5616.method_32144(BwtBlockEntities.unfiredDecoratedPotBlockEntity, UnfiredDecoratedPotBlockEntityRenderer::new);
        class_5616.method_32144(BwtBlockEntities.cauldronBlockEntity, ctx -> new CookingPotEntityRenderer(ctx, Id.of("textures/block/cauldron_stew.png")));
        class_5616.method_32144(BwtBlockEntities.crucibleBlockEntity, ctx -> new CookingPotEntityRenderer(ctx, Id.of("textures/block/crucible_fill.png")));
		EntityRendererRegistry.register(BwtEntities.windmillEntity, WindmillEntityRenderer::new);
		EntityRendererRegistry.register(BwtEntities.waterWheelEntity, WaterWheelEntityRenderer::new);
		EntityRendererRegistry.register(BwtEntities.movingRopeEntity, MovingRopeEntityRenderer::new);
		EntityRendererRegistry.register(BwtEntities.broadheadArrowEntity, BroadheadArrowEntityRenderer::new);
		EntityRendererRegistry.register(BwtEntities.rottedArrowEntity, RottedArrowEntityRenderer::new);
		EntityRendererRegistry.register(BwtEntities.dynamiteEntity, DynamiteEntityRenderer::new);
		EntityRendererRegistry.register(BwtEntities.miningChargeEntity, MiningChargeEntityRenderer::new);
		EntityRendererRegistry.register(BwtEntities.soulUrnProjectileEntity, class_953::new);
		EntityRendererRegistry.register(BwtEntities.canvasEntity, class_928::new);
		EntityModelLayerRegistry.registerModelLayer(MODEL_WINDMILL_LAYER, WindmillEntityModel::getTexturedModelData);
		EntityModelLayerRegistry.registerModelLayer(MODEL_WATER_WHEEL_LAYER, WaterWheelEntityModel::getTexturedModelData);
		EntityModelLayerRegistry.registerModelLayer(MECH_HOPPER_FILL_LAYER, MechHopperFillModel::getTexturedModelData);
		EntityModelLayerRegistry.registerModelLayer(CAULDRON_FILL_LAYER, CookingPotFillModel::getTexturedModelData);
		EntityModelLayerRegistry.registerModelLayer(CRUCIBLE_FILL_LAYER, CookingPotFillModel::getTexturedModelData);
        BuiltinItemRendererRegistry.INSTANCE.register(
                BwtBlocks.unfiredDecoratedPotBlockWithSherds.method_8389(),
                (stack, mode, matrices, vertexConsumers, light, overlay) -> {
                    renderUnfiredDecoratedPot.readFrom(stack);
                    class_310.method_1551().method_31975().method_23077(renderUnfiredDecoratedPot, matrices, vertexConsumers, light, overlay);
                });
		BlockRenderLayerMap.INSTANCE.putBlocks(class_1921.method_23581(),
				BwtBlocks.lightBlockBlock,
				BwtBlocks.lensBeamGlassBlock,
				BwtBlocks.hempCropBlock,
				BwtBlocks.stoneDetectorRailBlock,
				BwtBlocks.obsidianDetectorRailBlock,
				BwtBlocks.grateBlock,
				BwtBlocks.slatsBlock,
				BwtBlocks.wickerPaneBlock,
				BwtBlocks.platformBlock,
				BwtBlocks.stokedFireBlock,
				BwtBlocks.vineTrapBlock,
				BwtBlocks.bloodWoodBlocks.saplingBlock,
				BwtBlocks.bloodWoodBlocks.pottedSaplingBlock,
				BwtBlocks.bloodWoodBlocks.doorBlock,
				BwtBlocks.bloodWoodBlocks.trapdoorBlock
		);
		BlockRenderLayerMap.INSTANCE.putBlocks(class_1921.method_23579(),
				BwtBlocks.bloodWoodBlocks.leavesBlock,
				BwtBlocks.grassSlabBlock
		);
		class_3929.method_17542(BetterWithTime.blockDispenserScreenHandler, BlockDispenserScreen::new);
		class_3929.method_17542(BetterWithTime.cauldronScreenHandler, CauldronScreen::new);
		class_3929.method_17542(BetterWithTime.crucibleScreenHandler, CrucibleScreen::new);
		class_3929.method_17542(BetterWithTime.millStoneScreenHandler, MillStoneScreen::new);
		class_3929.method_17542(BetterWithTime.pulleyScreenHandler, PulleyScreen::new);
		class_3929.method_17542(BetterWithTime.mechHopperScreenHandler, MechHopperScreen::new);
		class_3929.method_17542(BetterWithTime.soulForgeScreenHandler, SoulForgeScreen::new);

		ColorProviderRegistry.BLOCK.register((state, view, pos, tintIndex) -> {
			if (view == null || pos == null) {
				return class_1933.method_49724();
			}
			class_6880<class_1959> biomeEntry = view.getBiomeFabric(pos);
			if (biomeEntry == null) {
				return class_1933.method_49724();
			}
			return biomeEntry.comp_349().method_8711(pos.method_10263(), pos.method_10260());
		}, BwtBlocks.grassPlanterBlock);
		ColorProviderRegistry.ITEM.register((stack, tintIndex) -> class_1933.method_49724(), BwtBlocks.grassPlanterBlock);

		ColorProviderRegistry.BLOCK.register((state, view, pos, tintIndex) -> {
			if (view == null || pos == null) {
				return class_1933.method_49724();
			}
			class_6880<class_1959> biomeEntry = view.getBiomeFabric(pos);
			if (biomeEntry == null) {
				return class_1933.method_49724();
			}
			return biomeEntry.comp_349().method_8711(pos.method_10263(), pos.method_10260());
		}, BwtBlocks.grassSlabBlock);
		ColorProviderRegistry.ITEM.register((stack, tintIndex) -> class_1933.method_49724(), BwtBlocks.grassSlabBlock);

		class_5272.method_27879(BwtItems.compositeBowItem, Id.mc("pull"), (itemStack, clientWorld, livingEntity, seed) -> {
			if (livingEntity == null) {
				return 0.0F;
			}
			return livingEntity.method_6030() != itemStack ? 0.0F : (itemStack.method_7935(livingEntity) - livingEntity.method_6014()) / 20.0F;
		});

		class_5272.method_27879(BwtItems.compositeBowItem, Id.mc("pulling"), (itemStack, clientWorld, livingEntity, seed) -> {
			if (livingEntity == null) {
				return 0.0F;
			}
			return livingEntity.method_6115() && livingEntity.method_6030() == itemStack ? 1.0F : 0.0F;
		});

		ClientPlayNetworking.registerGlobalReceiver(KilnBlockCookingProgressPayload.ID, (payload, context) -> {
			context.client().execute(() -> {
				if (context.client().field_1769 instanceof KilnBlockCookProgressSetter cookProgressSetter) {
					cookProgressSetter.betterWithTime$setKilnBlockCookingInfo(payload.blockPos(), payload.progress());
				}
			});
		});
	}
}