package com.bwt.blocks;

import com.bwt.sounds.BwtSoundEvents;
import com.bwt.utils.RadiusAroundBlockStream;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2383;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2753;
import net.minecraft.class_2777;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3726;
import net.minecraft.class_5819;

public class BellowsBlock extends class_2248 implements MechPowerBlockBase {
    public static class_2753 FACING = class_2383.field_11177;
    public static final float compressedHeight = 11;
    protected static final int tickRate = 37;

    protected static final class_265 COMPRESSED_SHAPE = class_2248.method_9541(0f, 0f, 0f, 16f, compressedHeight, 16f);

    public BellowsBlock(class_2251 settings) {
        super(settings);
        method_9590(method_9564().method_11657(MECH_POWERED, false));
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 ctx) {
        return state.method_11654(MECH_POWERED) ? COMPRESSED_SHAPE : class_259.method_1077();
    }

    @Override
    public void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(MECH_POWERED, FACING);
    }

    @Override
    public class_2680 method_9605(class_1750 ctx) {
        return this.method_9564().method_11657(FACING, ctx.method_8042().method_10153());
    }

    @Override
    public Predicate<class_2350> getValidAxleInputFaces(class_2680 blockState, class_2338 pos) {
        return direction -> direction != blockState.method_11654(FACING) && direction != class_2350.field_11036;
    }

    @Override
    public Predicate<class_2350> getValidHandCrankFaces(class_2680 blockState, class_2338 pos) {
        return direction -> direction.method_10166().method_10179();
    }

    @Override
    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        super.method_9567(world, pos, state, placer, itemStack);
        schedulePowerUpdate(state, world, pos);
    }

    public void schedulePowerUpdate(class_2680 state, class_1937 world, class_2338 pos) {
        if (isReceivingMechPower(world, state, pos) != isMechPowered(state)) {
            world.method_39279(pos, this, tickRate);
        }
    }

    @Override
    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, class_2338 sourcePos, boolean notify) {
        if (world.field_9236) {
            return;
        }
        schedulePowerUpdate(state, world, pos);
    }

    @Override
    public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        boolean isReceivingMechPower = isReceivingMechPower(world, state, pos);
        if (isReceivingMechPower == isMechPowered(state)) {
            return;
        }
        world.method_8501(pos, state.method_11657(MECH_POWERED, isReceivingMechPower));
        world.method_8396(null, pos, BwtSoundEvents.BELLOWS_COMPRESS, class_3419.field_15245, 0.25f, random.method_43057() * 0.1f + 0.2f);
        if (isReceivingMechPower) {
            stokeFire(world, pos, state);
        }
        else {
            liftEntities(world, pos);
        }
    }

    public void stokeFire(class_1937 world, class_2338 pos, class_2680 state) {
        class_2338 center = pos.method_10079(state.method_11654(FACING), 2);
        RadiusAroundBlockStream.allBlocksInHorizontalRadius(center, 1).forEach(firePos -> {
            class_2338 hibachiPos = firePos.method_10074();
            class_2680 fireState = world.method_8320(firePos);
            if (!fireState.method_26164(class_3481.field_21952)) {
                return;
            }
            class_2680 hibachiState = world.method_8320(hibachiPos);
            if (!hibachiState.method_27852(BwtBlocks.hibachiBlock)) {
                return;
            }
            world.method_8652(firePos, BwtBlocks.stokedFireBlock.getPlacementState(world, firePos), class_2248.field_31036);
        });
    }

    public void liftEntities(class_3218 world, class_2338 pos) {
        class_238 intersectionBox = new class_238(0.01, 0.5, 0.01, 0.99, 0.99, 0.99).method_996(pos);
        List<class_1297> list =  world.method_8390(
                class_1297.class,
                intersectionBox,
                class_1301.field_6155
        );
        list.stream().filter(class_1297::method_5810).forEach(entity -> {
            entity.method_24830(false);
            entity.method_5814(entity.method_23317(), pos.method_10264() + 1, entity.method_23321());
            if(entity instanceof class_3222){
                ((class_3222) entity).field_13987.method_14364(new class_2777(entity));
            }
        });
    }
}
