package com.bwt.blocks;

import com.bwt.sounds.BwtSoundEvents;
import com.bwt.tags.BwtBlockTags;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_5819;


public class BuddyBlock extends SimpleFacingBlock implements RotateWithEmptyHand {
    public static class_2746 POWERED = class_2741.field_12484;

    private final static int tickRate = 5;

    public BuddyBlock(class_2251 settings) {
        super(settings);
        method_9590(method_9564().method_11657(POWERED, false));
    }

    @Override
    public void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(field_10927, POWERED);
    }

    @Override
    public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean notify) {
        // minimal delay same as when the buddy block is changed by a neighbor notification to handle
        // state changes due to being pushed around by a piston
        if (state.method_27852(oldState.method_26204())) {
            return;
        }
        world.method_39279(pos, this, 1);
    }

    @Override
    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        if (state.method_27852(newState.method_26204())) {
            return;
        }
        if (!world.field_9236 && state.method_11654(POWERED) && world.method_8397().method_8677(pos, this)) {
            this.updateNeighbors(world, pos, state.method_11657(POWERED, false));
        }
    }

    @Override
    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (!world.method_8608()
                && !state.method_11654(POWERED)
                && !neighborState.method_26164(BwtBlockTags.DOES_NOT_TRIGGER_BUDDY)
                && !world.method_8397().method_8677(pos, this)
        ) {
            // minimal delay when triggered to avoid notfying neighbors of change in same tick
            // that they are notifying of the original change. Not doing so causes problems
            // with some blocks (like ladders) that haven't finished initializing their state
            // on placement when they send out the notification
            world.method_39279(pos, this, 1);
        }
        return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    @Override
    public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        super.method_9588(state, world, pos, random);
        boolean powered = state.method_11654(POWERED);

        world.method_8652(pos, state.method_11657(POWERED, !powered), class_2248.field_31028);

        if (!powered) {
            // schedule another update to turn the block off
            world.method_39279(pos, this, tickRate);
            world.method_8396(null, pos, BwtSoundEvents.BUDDY_CLICK,
                    class_3419.field_15245, 0.5F, 2F);
        }

        updateNeighbors(world, pos, state);
    }

    @Override
    public int method_9524(class_2680 state, class_1922 world, class_2338 pos, class_2350 direction) {
        return state.method_11654(field_10927) == direction.method_10153() && state.method_11654(POWERED) ? 15 : 0;
    }

    @Override
    public int method_9603(class_2680 state, class_1922 world, class_2338 pos, class_2350 direction) {
        return method_9524(state, world, pos, direction);
    }

    @Override
    public boolean method_9506(class_2680 state) {
        return true;
    }

    public void updateNeighbors(class_1937 world, class_2338 pos, class_2680 state) {
        class_2338 outputPos = pos.method_10093(state.method_11654(field_10927));
        world.method_8492(outputPos, this, pos);
        world.method_8508(outputPos, this, state.method_11654(field_10927).method_10153());
    }
}
