package com.bwt.blocks;

import com.bwt.blocks.block_dispenser.BlockDispenserBlock;
import com.bwt.blocks.blood_wood.BloodWoodBlocks;
import com.bwt.blocks.cauldron.CauldronBlock;
import com.bwt.blocks.crucible.CrucibleBlock;
import com.bwt.blocks.detector.DetectorBlock;
import com.bwt.blocks.detector.DetectorLogicBlock;
import com.bwt.blocks.dirt_slab.DirtPathSlabBlock;
import com.bwt.blocks.dirt_slab.DirtSlabBlock;
import com.bwt.blocks.dirt_slab.GrassSlabBlock;
import com.bwt.blocks.lens.LensBeamBlock;
import com.bwt.blocks.lens.LensBeamGlassBlock;
import com.bwt.blocks.lens.LensBlock;
import com.bwt.blocks.dirt_slab.MyceliumSlabBlock;
import com.bwt.blocks.mech_hopper.MechHopperBlock;
import com.bwt.blocks.mill_stone.MillStoneBlock;
import com.bwt.blocks.mining_charge.MiningChargeBlock;
import com.bwt.blocks.pulley.PulleyBlock;
import com.bwt.blocks.soul_forge.SoulForgeBlock;
import com.bwt.blocks.turntable.TurntableBlock;
import com.bwt.blocks.unfired_pottery.*;
import com.bwt.utils.DyeUtils;
import com.bwt.utils.Id;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.fabric.api.registry.FlattenableBlockRegistry;
import net.minecraft.block.*;
import net.minecraft.class_1747;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2313;
import net.minecraft.class_2378;
import net.minecraft.class_2389;
import net.minecraft.class_2482;
import net.minecraft.class_2498;
import net.minecraft.class_2766;
import net.minecraft.class_3619;
import net.minecraft.class_3620;
import net.minecraft.class_4970;
import net.minecraft.class_7706;
import net.minecraft.class_7923;
import net.minecraft.class_8526;
import net.minecraft.class_9334;
import net.minecraft.item.*;
import java.util.ArrayList;
import java.util.HashMap;

public class BwtBlocks implements ModInitializer {

    public static final AqueductBlock aqueductBlock = new AqueductBlock(class_4970.class_2251.method_9630(class_2246.field_10104));
	public static final class_2248 anchorBlock = new AnchorBlock(class_4970.class_2251.method_9637()
            .method_36557(2f)
            .method_9626(class_2498.field_11544)
            .method_22488()
            .method_51369()
            .method_29292()
    );
	public static final class_2248 axleBlock = new AxleBlock(class_4970.class_2251.method_9637()
            .method_36557(2F)
            .method_9626(class_2498.field_11547)
            .method_50013()
            .method_51369()
            .method_22488()
    );
    public static final class_2248 axlePowerSourceBlock = new AxlePowerSourceBlock(class_4970.class_2251.method_9630(axleBlock));
	public static final class_2248 bellowsBlock = new BellowsBlock(class_4970.class_2251.method_9630(class_2246.field_10161));
	public static final BlockDispenserBlock blockDispenserBlock = new BlockDispenserBlock(class_4970.class_2251.method_9630(class_2246.field_10200)
            .method_36557(3.5f)
    );
    public static final BloodWoodBlocks bloodWoodBlocks = new BloodWoodBlocks().initialize();

	public static final class_2248 buddyBlock = new BuddyBlock(class_4970.class_2251.method_9637()
            .method_36557(3.5f)
            .method_9626(class_2498.field_11544)
            .method_31710(class_3620.field_15993)
            .method_29292()
    );
	public static final class_2248 cauldronBlock = new CauldronBlock(class_4970.class_2251.method_9637()
            .method_26236(class_2246::method_26122)
            .method_22488()
            .method_36557(3.5f)
            .method_36558(10f)
            .method_9626(class_2498.field_11533)
            .method_31710(class_3620.field_16009)
            .method_29292()
    );
//	public static final Block canvasBlock = new CanvasBlock(AbstractBlock.Settings.create());
    public static final ArrayList<ColumnBlock> columnBlocks = new ArrayList<>();
	public static final class_2248 concentratedHellfireBlock = new class_2248(class_4970.class_2251.method_9637().method_36557(2f).method_29292().method_31710(class_3620.field_16002).method_9626(class_2498.field_11533));
	public static final class_2248 companionCubeBlock = new CompanionCubeBlock(class_4970.class_2251.method_9630(class_2246.field_10446)
            .method_36557(0.4f)
    );
	public static final class_2248 companionSlabBlock = new CompanionSlabBlock(class_4970.class_2251.method_9630(companionCubeBlock));
	public static final ArrayList<CornerBlock> cornerBlocks = new ArrayList<>();
	public static final class_2248 crucibleBlock = new CrucibleBlock(class_4970.class_2251.method_9637()
            .method_26236(class_2246::method_26122)
            .method_22488()
            .method_36557(0.6f)
            .method_36558(3f)
            .method_9626(class_2498.field_11537)
            .method_31710(class_3620.field_15979)
            .method_29292()
    );
	public static final class_2248 detectorBlock = new DetectorBlock(class_4970.class_2251.method_9630(class_2246.field_10200)
            .method_36557(3.5f)
    );
	public static final class_2248 detectorLogicBlock = new DetectorLogicBlock(class_4970.class_2251.method_9637()
            .method_51371()
            .method_9634()
            .method_42327()
            .method_50012(class_3619.field_15971)
    );
    public static final class_2248 dungBlock = new class_2248(class_4970.class_2251.method_9637().method_36557(2f).method_31710(class_3620.field_15977).method_9626(class_2498.field_21214));
    public static final class_2248 gearBoxBlock = new GearBoxBlock(class_4970.class_2251.method_9630(class_2246.field_10161)
            .method_36557(2F)
    );
	public static final class_2248 grateBlock = new class_2389(class_4970.class_2251.method_9637()
            .method_36557(0.5f)
            .method_9626(class_2498.field_11547)
            .method_22488()
    );
	public static final class_2248 handCrankBlock = new HandCrankBlock(class_4970.class_2251.method_9637()
            .method_36557(0.5f)
            .method_9626(class_2498.field_11547)
            .method_51369()
            .method_22488()
            .method_26235(class_2246::method_26114)
            .method_26243(class_2246::method_26122)
            .method_26245(class_2246::method_26122)
            .method_29292()
    );
	public static final class_2248 hempCropBlock = new HempCropBlock(class_4970.class_2251.method_9630(class_2246.field_10424));
	public static final class_2248 hibachiBlock = new HibachiBlock(class_4970.class_2251.method_9637()
            .method_36557(3.5f)
            .method_9626(class_2498.field_11544)
            .method_29292()
    );
	public static final class_2248 hopperBlock = new MechHopperBlock(class_4970.class_2251.method_9637()
            .method_36557(2f)
            .method_9626(class_2498.field_11547)
            .method_51369()
            .method_22488()
    );
//	public static final Block infernalEnchanterBlock = new InfernalEnchanterBlock(AbstractBlock.Settings.create());
	public static final class_2248 kilnBlock = new KilnBlock(class_4970.class_2251.method_9630(class_2246.field_10104));
	public static final LensBlock lensBlock = new LensBlock(class_4970.class_2251.method_9637()
            .method_36557(3.5f)
            .method_9626(class_2498.field_11533)
            .method_51369()
            .method_50012(class_3619.field_15972)
    );
    public static final LensBeamBlock lensBeamBlock = new LensBeamBlock(class_4970.class_2251.method_9637()
            .method_51371()
            .method_9634()
            .method_42327()
            .method_50012(class_3619.field_15971)
            .method_9631(state -> state.method_11654(LensBeamBlock.TERMINUS) ? 14 : 0)
            .method_26249(((state, world, pos) -> state.method_11654(LensBeamBlock.TERMINUS)))
    );
    public static final LensBeamGlassBlock lensBeamGlassBlock = new LensBeamGlassBlock(
            class_2246.field_10033,
            class_4970.class_2251
                    .method_9630(class_2246.field_10033)
                    .method_9631(state -> state.method_11654(LensBeamBlock.TERMINUS) ? 14 : 0)
                    .method_26249(((state, world, pos) -> state.method_11654(LensBeamBlock.TERMINUS)))
    );
	public static final class_2248 lightBlockBlock = new LightBlock(class_4970.class_2251.method_9630(class_2246.field_10033)
            .method_9632(0.4f)
            .method_9631(class_2246.method_26107(15))
    );
	public static final class_2248 millStoneBlock = new MillStoneBlock(class_4970.class_2251.method_9630(class_2246.field_10200)
            .method_36557(3.5f)
    );
	public static final MiningChargeBlock miningChargeBlock = new MiningChargeBlock(class_4970.class_2251.method_9637()
            .method_31710(class_3620.field_15977)
            .method_9618()
            .method_9626(class_2498.field_11535)
            .method_50013()
            .method_26236(class_2246::method_26122)
    );
	public static final ArrayList<MouldingBlock> mouldingBlocks = new ArrayList<>();
	public static final class_2248 obsidianPressurePlateBlock = new ObsidianPressurePlateBlock(class_4970.class_2251.method_9630(class_2246.field_10158)
            .method_9629(50.0f, 1200.0f)
    );
	public static final class_2248 obsidianDetectorRailBlock = new class_2313(class_4970.class_2251.method_9630(class_2246.field_10025)
            .method_9629(25.0f, 1200.0f)
    );
    public static final ArrayList<PedestalBlock> pedestalBlocks = new ArrayList<>();
	public static final class_2248 planterBlock = new PlanterBlock(class_4970.class_2251.method_9630(class_2246.field_10415)
            .method_22488()
            .method_36557(0.6f)
    );
	public static final class_2248 soilPlanterBlock = new SoilPlanterBlock(class_4970.class_2251.method_9630(planterBlock));
	public static final class_2248 soulSandPlanterBlock = new SoulSandPlanterBlock(class_4970.class_2251.method_9630(planterBlock));
	public static final class_2248 grassPlanterBlock = new GrassPlanterBlock(class_4970.class_2251.method_9630(planterBlock));
    public static final class_2248 paddingBlock = new PaddingBlock(class_4970.class_2251.method_9637().method_36557(2f).method_31710(class_3620.field_16025).method_9626(class_2498.field_11543));
	public static final class_2248 platformBlock = new PlatformBlock(class_4970.class_2251.method_9630(class_2246.field_10161)
            .method_22488()
            .method_26235(class_2246::method_26114)
            .method_26236(class_2246::method_26122)
            .method_26243(class_2246::method_26122)
            .method_26245(class_2246::method_26122)
            .method_36557(2f)
            .method_50013()
    );
	public static final class_2248 pulleyBlock = new PulleyBlock(class_4970.class_2251.method_9630(class_2246.field_10161)
            .method_36557(2f)
            .method_31710(class_3620.field_15992)
            .method_50012(class_3619.field_15975)
    );
    public static final class_2248 redstoneClutchBlock = new RedstoneClutchBlock(class_4970.class_2251.method_9630(gearBoxBlock));
    public static final class_2248 ropeCoilBlock = new class_2248(class_4970.class_2251.method_9637().method_36557(1f).method_31710(class_3620.field_15977).method_9626(class_2498.field_11535));
	public static final RopeBlock ropeBlock = new RopeBlock(class_4970.class_2251.method_9637()
            .method_36557(0.5f)
            .method_9626(class_2498.field_11535)
            .method_50012(class_3619.field_15971)
    );
	public static final class_2248 sawBlock = new SawBlock(class_4970.class_2251.method_9637()
            .method_36557(2f)
            .method_50013()
            .method_9626(class_2498.field_11547)
            .method_22488()
    );
	public static final ScrewPumpBlock screwPumpBlock = new ScrewPumpBlock(class_4970.class_2251.method_9630(class_2246.field_10161)
            .method_36557(2f)
            .method_36558(5f)
    );
    public static final ArrayList<SidingBlock> sidingBlocks = new ArrayList<>();
	public static final class_2248 slatsBlock = new class_2389(class_4970.class_2251.method_9637()
            .method_9632(0.5f)
            .method_9626(class_2498.field_11547)
            .method_50013()
            .method_22488()
    );
    public static final class_2248 soapBlock = new SimpleFacingBlock(class_4970.class_2251.method_9637().method_36557(2f).method_31710(class_3620.field_16030).method_9626(class_2498.field_11545));
//	public static final Block stakeBlock = new StakeBlock(AbstractBlock.Settings.create());
    public static final StokedFireBlock stokedFireBlock = new StokedFireBlock(class_4970.class_2251.method_9630(class_2246.field_22089));
    public static final class_2248 stoneDetectorRailBlock = new class_2313(class_4970.class_2251.method_9630(class_2246.field_10025));
	public static final class_2248 soulForgeBlock = new SoulForgeBlock(class_4970.class_2251.method_9630(class_2246.field_10535));
    public static final ArrayList<TableBlock> tableBlocks = new ArrayList<>();
	public static final class_2248 turntableBlock = new TurntableBlock(class_4970.class_2251.method_9637()
            .method_9632(2f)
            .method_9626(class_2498.field_11544)
            .method_31710(class_2246.field_10379.method_26403())
    );
    public static final UnfiredPotteryBlock unfiredDecoratedPotBlock = new UnfiredDecoratedPotBlock(class_4970.class_2251.method_9630(class_2246.field_10460)
            .method_22488()
            .method_26236(class_2246::method_26122)
    );
    public static final UnfiredPotteryBlock unfiredDecoratedPotBlockWithSherds = new UnfiredDecoratedPotBlockWithSherds(class_4970.class_2251.method_9630(class_2246.field_10460)
            .method_22488()
            .method_26236(class_2246::method_26122)
    );
	public static final UnfiredPotteryBlock unfiredCrucibleBlock = new UnfiredCrucibleBlock(class_4970.class_2251.method_9630(class_2246.field_10460)
            .method_22488()
            .method_26236(class_2246::method_26122)
    );
	public static final UnfiredPotteryBlock unfiredPlanterBlock = new UnfiredPlanterBlock(class_4970.class_2251.method_9630(class_2246.field_10460)
            .method_22488()
            .method_26236(class_2246::method_26122)
    );
	public static final UnfiredPotteryBlock unfiredVaseBlock = new UnfiredVaseBlock(class_4970.class_2251.method_9630(class_2246.field_10460)
            .method_22488()
            .method_26236(class_2246::method_26122)
    );
	public static final UnfiredPotteryBlock unfiredUrnBlock = new UnfiredUrnBlock(class_4970.class_2251.method_9630(class_2246.field_10460)
            .method_22488()
            .method_26236(class_2246::method_26122)
    );
    public static final UnfiredPotteryBlock unfiredFlowerPotBlock = new UnfiredFlowerPotBlock(class_4970.class_2251.method_9630(class_2246.field_10460)
            .method_22488()
            .method_26236(class_2246::method_26122)
    );
	public static final class_2248 urnBlock = new UrnBlock(class_4970.class_2251.method_9630(class_2246.field_10415)
            .method_22488()
            .method_26236(class_2246::method_26122)
            .method_26235(class_2246::method_26114)
            .method_36557(2f)
    );
	public static final HashMap<class_1767, VaseBlock> vaseBlocks = new HashMap<>();
	public static final class_2248 wickerPaneBlock = new class_2389(class_4970.class_2251.method_9637()
            .method_9632(0.5f)
            .method_9626(class_2498.field_11535)
            .method_50013()
            .method_22488()
    );
    public static final class_2248 wickerBlock = new class_2248(class_4970.class_2251.method_9637().method_36557(2f).method_50013().method_31710(class_3620.field_16017).method_9626(class_2498.field_11535));
    public static final class_2248 wickerSlabBlock = new class_2482(class_4970.class_2251.method_9630(wickerBlock));
    public static final HashMap<class_1767, class_2482> woolSlabBlocks = new HashMap<>();
    public static final class_2248 vineTrapBlock = new VineTrapBlock(class_4970.class_2251.method_9630(class_2246.field_10503)
            .method_26235(class_2246::method_26114)
            .method_9634()
    );
    public static final class_2248 dirtSlabBlock = new DirtSlabBlock(class_4970.class_2251.method_9630(class_2246.field_10566), class_2246.field_10566);
    public static final class_2248 dirtPathSlabBlock = new DirtPathSlabBlock(class_4970.class_2251.method_9630(class_2246.field_10194), class_2246.field_10194);
    public static final class_2248 grassSlabBlock = new GrassSlabBlock(class_4970.class_2251.method_9630(class_2246.field_10219), class_2246.field_10219);
    public static final class_2248 myceliumSlabBlock = new MyceliumSlabBlock(class_4970.class_2251.method_9630(class_2246.field_10402), class_2246.field_10402);
    public static final class_2248 podzolSlabBlock = new MyceliumSlabBlock(class_4970.class_2251.method_9630(class_2246.field_10520), class_2246.field_10520);

    public static final class_2248 netherGroth = new NetherGrothBlock(class_4970.class_2251.method_9637()
                    .method_31710(class_3620.field_16012)
                    .method_26236(class_2246::method_26122)
                    .method_9640()
                    .method_9632(0.2f)
                    .method_23351(0.4F)
                    .method_9626(class_2498.field_22154)
                    .method_50012(class_3619.field_15971)
                    .method_23351(0.8f)
    );

    public static final class_2248 grothedNetherrackBlock = new GrothedNetherrackBlock(class_4970.class_2251.method_9637()
                    .method_31710(class_3620.field_16012)
                    .method_51368(class_2766.field_12653)
                    .method_29292()
                    .method_9632(0.4F)
                    .method_9626(class_2498.field_22145)
    );

    @Override
    public void onInitialize() {
        // Axle
        class_2378.method_10230(class_7923.field_41175, Id.of("axle"), axleBlock);
        class_2378.method_10230(class_7923.field_41178, Id.of("axle"), new class_1747(axleBlock, new class_1792.class_1793()));
        class_2378.method_10230(class_7923.field_41175, Id.of("axle_power_source"), axlePowerSourceBlock);
        // Gearbox
        class_2378.method_10230(class_7923.field_41175, Id.of("gear_box"), gearBoxBlock);
        class_2378.method_10230(class_7923.field_41178, Id.of("gear_box"), new class_1747(gearBoxBlock, new class_1792.class_1793()));
        // Redstone Clutch
        class_2378.method_10230(class_7923.field_41175, Id.of("redstone_clutch"), redstoneClutchBlock);
        class_2378.method_10230(class_7923.field_41178, Id.of("redstone_clutch"), new class_1747(redstoneClutchBlock, new class_1792.class_1793()));
        // Hibachi
        class_2378.method_10230(class_7923.field_41175, Id.of("hibachi"), hibachiBlock);
        class_2378.method_10230(class_7923.field_41178, Id.of("hibachi"), new class_1747(hibachiBlock, new class_1792.class_1793()));
        // Light Block
        class_2378.method_10230(class_7923.field_41175, Id.of("light_block"), lightBlockBlock);
        class_2378.method_10230(class_7923.field_41178, Id.of("light_block"), new class_1747(lightBlockBlock, new class_1792.class_1793()));
        // Block Dispenser
        class_2378.method_10230(class_7923.field_41175, Id.of("block_dispenser"), blockDispenserBlock);
        class_2378.method_10230(class_7923.field_41178, Id.of("block_dispenser"), new class_1747(blockDispenserBlock, new class_1792.class_1793()));
        // Cauldron / Stewing Pot
        class_2378.method_10230(class_7923.field_41175, Id.of("cauldron"), cauldronBlock);
        class_2378.method_10230(class_7923.field_41178, Id.of("cauldron"), new class_1747(cauldronBlock, new class_1792.class_1793()));
        // Obsidian pressure plate
        class_2378.method_10230(class_7923.field_41175, Id.of("obsidian_pressure_plate"), obsidianPressurePlateBlock);
        class_2378.method_10230(class_7923.field_41178, Id.of("obsidian_pressure_plate"), new class_1747(obsidianPressurePlateBlock, new class_1792.class_1793()));
        // Hemp crop
        class_2378.method_10230(class_7923.field_41175, Id.of("hemp_crop_block"), hempCropBlock);
        // Detector Block
        class_2378.method_10230(class_7923.field_41175, Id.of("detector_block"), detectorBlock);
        class_2378.method_10230(class_7923.field_41178, Id.of("detector_block"), new class_1747(detectorBlock, new class_1792.class_1793()));
        class_2378.method_10230(class_7923.field_41175, Id.of("detector_logic_block"), detectorLogicBlock);
        // Mill Stone
        class_2378.method_10230(class_7923.field_41175, Id.of("mill_stone"), millStoneBlock);
        class_2378.method_10230(class_7923.field_41178, Id.of("mill_stone"), new class_1747(millStoneBlock, new class_1792.class_1793()));
        // Companion Cube
        class_2378.method_10230(class_7923.field_41175, Id.of("companion_cube"), companionCubeBlock);
        class_2378.method_10230(class_7923.field_41178, Id.of("companion_cube"), new class_1747(companionCubeBlock, new class_1792.class_1793()));
        // Companion Slab
        class_2378.method_10230(class_7923.field_41175, Id.of("companion_slab"), companionSlabBlock);
        class_2378.method_10230(class_7923.field_41178, Id.of("companion_slab"), new class_1747(companionSlabBlock, new class_1792.class_1793()));
        // Hand Crank
        class_2378.method_10230(class_7923.field_41175, Id.of("hand_crank"), handCrankBlock);
        class_2378.method_10230(class_7923.field_41178, Id.of("hand_crank"), new class_1747(handCrankBlock, new class_1792.class_1793()));
        // Anchor
        class_2378.method_10230(class_7923.field_41175, Id.of("anchor"), anchorBlock);
        class_2378.method_10230(class_7923.field_41178, Id.of("anchor"), new class_1747(anchorBlock, new class_1792.class_1793()));
        // Rope
        class_2378.method_10230(class_7923.field_41175, Id.of("rope"), ropeBlock);
        // Stone Detector Rail
        class_2378.method_10230(class_7923.field_41175, Id.of("stone_detector_rail"), stoneDetectorRailBlock);
        class_2378.method_10230(class_7923.field_41178, Id.of("stone_detector_rail"), new class_1747(stoneDetectorRailBlock, new class_1792.class_1793()));
        // Obsidian Detector Rail
        class_2378.method_10230(class_7923.field_41175, Id.of("obsidian_detector_rail"), obsidianDetectorRailBlock);
        class_2378.method_10230(class_7923.field_41178, Id.of("obsidian_detector_rail"), new class_1747(obsidianDetectorRailBlock, new class_1792.class_1793()));
        // Bwt Hopper
        class_2378.method_10230(class_7923.field_41175, Id.of("hopper"), hopperBlock);
        class_2378.method_10230(class_7923.field_41178, Id.of("hopper"), new class_1747(hopperBlock, new class_1792.class_1793()));
        // Grate
        class_2378.method_10230(class_7923.field_41175, Id.of("grate"), grateBlock);
        class_2378.method_10230(class_7923.field_41178, Id.of("grate"), new class_1747(grateBlock, new class_1792.class_1793()));
        // Slats
        class_2378.method_10230(class_7923.field_41175, Id.of("slats"), slatsBlock);
        class_2378.method_10230(class_7923.field_41178, Id.of("slats"), new class_1747(slatsBlock, new class_1792.class_1793()));
        // Wicker
        class_2378.method_10230(class_7923.field_41175, Id.of("wicker"), wickerPaneBlock);
        class_2378.method_10230(class_7923.field_41178, Id.of("wicker"), new class_1747(wickerPaneBlock, new class_1792.class_1793()));
        // Saw
        class_2378.method_10230(class_7923.field_41175, Id.of("saw"), sawBlock);
        class_2378.method_10230(class_7923.field_41178, Id.of("saw"), new class_1747(sawBlock, new class_1792.class_1793()));
        // Pulley
        class_2378.method_10230(class_7923.field_41175, Id.of("pulley"), pulleyBlock);
        class_2378.method_10230(class_7923.field_41178, Id.of("pulley"), new class_1747(pulleyBlock, new class_1792.class_1793()));
        // Platform
        class_2378.method_10230(class_7923.field_41175, Id.of("platform"), platformBlock);
        class_2378.method_10230(class_7923.field_41178, Id.of("platform"), new class_1747(platformBlock, new class_1792.class_1793()));
        // Turntable
        class_2378.method_10230(class_7923.field_41175, Id.of("turntable"), turntableBlock);
        class_2378.method_10230(class_7923.field_41178, Id.of("turntable"), new class_1747(turntableBlock, new class_1792.class_1793()));
        // Stoked Fire
        class_2378.method_10230(class_7923.field_41175, Id.of("stoked_fire"), stokedFireBlock);
        // Bellows
        class_2378.method_10230(class_7923.field_41175, Id.of("bellows"), bellowsBlock);
        class_2378.method_10230(class_7923.field_41178, Id.of("bellows"), new class_1747(bellowsBlock, new class_1792.class_1793()));
        // Unfired Pottery
        class_2378.method_10230(class_7923.field_41175, Id.of("unfired_decorated_pot_with_sherds"), unfiredDecoratedPotBlockWithSherds);
        class_2378.method_10230(class_7923.field_41178, Id.of("unfired_decorated_pot_with_sherds"), new class_1747(unfiredDecoratedPotBlockWithSherds, new class_1792.class_1793().method_57349(class_9334.field_49621, class_8526.field_44707)));
        class_2378.method_10230(class_7923.field_41175, Id.of("unfired_decorated_pot"), unfiredDecoratedPotBlock);
        class_2378.method_10230(class_7923.field_41178, Id.of("unfired_decorated_pot"), new class_1747(unfiredDecoratedPotBlock, new class_1792.class_1793()));
        class_2378.method_10230(class_7923.field_41175, Id.of("unfired_crucible"), unfiredCrucibleBlock);
        class_2378.method_10230(class_7923.field_41178, Id.of("unfired_crucible"), new class_1747(unfiredCrucibleBlock, new class_1792.class_1793()));
        class_2378.method_10230(class_7923.field_41175, Id.of("unfired_planter"), unfiredPlanterBlock);
        class_2378.method_10230(class_7923.field_41178, Id.of("unfired_planter"), new class_1747(unfiredPlanterBlock, new class_1792.class_1793()));
        class_2378.method_10230(class_7923.field_41175, Id.of("unfired_vase"), unfiredVaseBlock);
        class_2378.method_10230(class_7923.field_41178, Id.of("unfired_vase"), new class_1747(unfiredVaseBlock, new class_1792.class_1793()));
        class_2378.method_10230(class_7923.field_41175, Id.of("unfired_urn"), unfiredUrnBlock);
        class_2378.method_10230(class_7923.field_41178, Id.of("unfired_urn"), new class_1747(unfiredUrnBlock, new class_1792.class_1793()));
        class_2378.method_10230(class_7923.field_41175, Id.of("unfired_flower_pot"), unfiredFlowerPotBlock);
        class_2378.method_10230(class_7923.field_41178, Id.of("unfired_flower_pot"), new class_1747(unfiredFlowerPotBlock, new class_1792.class_1793()));
        // Kiln
        class_2378.method_10230(class_7923.field_41175, Id.of("kiln"), kilnBlock);
        // Blood Wood
        bloodWoodBlocks.register();
        // Mini blocks
        MaterialInheritedBlock.registerMaterialBlocks(
                sidingBlocks, mouldingBlocks, cornerBlocks,
                columnBlocks, pedestalBlocks, tableBlocks
        );
        // Crucible
        class_2378.method_10230(class_7923.field_41175, Id.of("crucible"), crucibleBlock);
        class_2378.method_10230(class_7923.field_41178, Id.of("crucible"), new class_1747(crucibleBlock, new class_1792.class_1793()));
        // Planters
        class_2378.method_10230(class_7923.field_41175, Id.of("planter"), planterBlock);
        class_2378.method_10230(class_7923.field_41178, Id.of("planter"), new class_1747(planterBlock, new class_1792.class_1793()));
        class_2378.method_10230(class_7923.field_41175, Id.of("soil_planter"), soilPlanterBlock);
        class_2378.method_10230(class_7923.field_41178, Id.of("soil_planter"), new class_1747(soilPlanterBlock, new class_1792.class_1793()));
        class_2378.method_10230(class_7923.field_41175, Id.of("soul_sand_planter"), soulSandPlanterBlock);
        class_2378.method_10230(class_7923.field_41178, Id.of("soul_sand_planter"), new class_1747(soulSandPlanterBlock, new class_1792.class_1793()));
        class_2378.method_10230(class_7923.field_41175, Id.of("grass_planter"), grassPlanterBlock);
        class_2378.method_10230(class_7923.field_41178, Id.of("grass_planter"), new class_1747(grassPlanterBlock, new class_1792.class_1793()));
        // Vases
        VaseBlock.registerColors(vaseBlocks);
        // Urn
        class_2378.method_10230(class_7923.field_41175, Id.of("urn"), urnBlock);
        class_2378.method_10230(class_7923.field_41178, Id.of("urn"), new class_1747(urnBlock, new class_1792.class_1793()));
        // SoulForge
        class_2378.method_10230(class_7923.field_41175, Id.of("soul_forge"), soulForgeBlock);
        class_2378.method_10230(class_7923.field_41178, Id.of("soul_forge"), new class_1747(soulForgeBlock, new class_1792.class_1793()));
        // Wool slabs
        DyeUtils.WOOL_COLORS.forEach((dyeColor, woolBlock) -> {
            class_2482 woolSlabBlock = new class_2482(class_4970.class_2251.method_9630(woolBlock));
            woolSlabBlocks.put(dyeColor, woolSlabBlock);
            class_2378.method_10230(class_7923.field_41175, Id.of(dyeColor.method_7792() + "_wool_slab"), woolSlabBlock);
            class_2378.method_10230(class_7923.field_41178, Id.of(dyeColor.method_7792() + "_wool_slab"), new class_1747(woolSlabBlock, new class_1792.class_1793()));
        });
        // Buddy Block
        class_2378.method_10230(class_7923.field_41175, Id.of("buddy_block"), buddyBlock);
        class_2378.method_10230(class_7923.field_41178, Id.of("buddy_block"), new class_1747(buddyBlock, new class_1792.class_1793()));
        // Aesthetic compacting blocks
        class_2378.method_10230(class_7923.field_41175, Id.of("soap_block"), soapBlock);
        class_2378.method_10230(class_7923.field_41178, Id.of("soap_block"), new class_1747(soapBlock, new class_1792.class_1793()));
        class_2378.method_10230(class_7923.field_41175, Id.of("wicker_block"), wickerBlock);
        class_2378.method_10230(class_7923.field_41178, Id.of("wicker_block"), new class_1747(wickerBlock, new class_1792.class_1793()));
        class_2378.method_10230(class_7923.field_41175, Id.of("dung_block"), dungBlock);
        class_2378.method_10230(class_7923.field_41178, Id.of("dung_block"), new class_1747(dungBlock, new class_1792.class_1793()));
        class_2378.method_10230(class_7923.field_41175, Id.of("padding_block"), paddingBlock);
        class_2378.method_10230(class_7923.field_41178, Id.of("padding_block"), new class_1747(paddingBlock, new class_1792.class_1793()));
        class_2378.method_10230(class_7923.field_41175, Id.of("rope_coil_block"), ropeCoilBlock);
        class_2378.method_10230(class_7923.field_41178, Id.of("rope_coil_block"), new class_1747(ropeCoilBlock, new class_1792.class_1793()));
        class_2378.method_10230(class_7923.field_41175, Id.of("concentrated_hellfire_block"), concentratedHellfireBlock);
        class_2378.method_10230(class_7923.field_41178, Id.of("concentrated_hellfire_block"), new class_1747(concentratedHellfireBlock, new class_1792.class_1793()));
        class_2378.method_10230(class_7923.field_41175, Id.of("wicker_slab"), wickerSlabBlock);
        class_2378.method_10230(class_7923.field_41178, Id.of("wicker_slab"), new class_1747(wickerSlabBlock, new class_1792.class_1793()));
        // Mining charge
        class_2378.method_10230(class_7923.field_41175, Id.of("mining_charge"), miningChargeBlock);
        class_2378.method_10230(class_7923.field_41178, Id.of("mining_charge"), new class_1747(miningChargeBlock, new class_1792.class_1793()));
        // Vine trap
        class_2378.method_10230(class_7923.field_41175, Id.of("vine_trap"), vineTrapBlock);
        class_2378.method_10230(class_7923.field_41178, Id.of("vine_trap"), new class_1747(vineTrapBlock, new class_1792.class_1793()));
        // Lens
        class_2378.method_10230(class_7923.field_41175, Id.of("lens"), lensBlock);
        class_2378.method_10230(class_7923.field_41178, Id.of("lens"), new class_1747(lensBlock, new class_1792.class_1793()));
        class_2378.method_10230(class_7923.field_41175, Id.of("lens_beam"), lensBeamBlock);
        class_2378.method_10230(class_7923.field_41175, Id.of("lens_beam_glass"), lensBeamGlassBlock);
        // Dirt Slab
        class_2378.method_10230(class_7923.field_41175, Id.of("dirt_slab"), dirtSlabBlock);
        class_2378.method_10230(class_7923.field_41178, Id.of("dirt_slab"), new class_1747(dirtSlabBlock, new class_1792.class_1793()));
        // Dirt Path Slab
        class_2378.method_10230(class_7923.field_41175, Id.of("dirt_path_slab"), dirtPathSlabBlock);
        class_2378.method_10230(class_7923.field_41178, Id.of("dirt_path_slab"), new class_1747(dirtPathSlabBlock, new class_1792.class_1793()));
        // Grass Slab
        class_2378.method_10230(class_7923.field_41175, Id.of("grass_slab"), grassSlabBlock);
        class_2378.method_10230(class_7923.field_41178, Id.of("grass_slab"), new class_1747(grassSlabBlock, new class_1792.class_1793()));
        // Mycelium Slab
        class_2378.method_10230(class_7923.field_41175, Id.of("mycelium_slab"), myceliumSlabBlock);
        class_2378.method_10230(class_7923.field_41178, Id.of("mycelium_slab"), new class_1747(myceliumSlabBlock, new class_1792.class_1793()));
        // Podzol Slab
        class_2378.method_10230(class_7923.field_41175, Id.of("podzol_slab"), podzolSlabBlock);
        class_2378.method_10230(class_7923.field_41178, Id.of("podzol_slab"), new class_1747(podzolSlabBlock, new class_1792.class_1793()));
        // Nether Groth
        class_2378.method_10230(class_7923.field_41175, Id.of("nether_groth"), netherGroth);
        class_2378.method_10230(class_7923.field_41178, Id.of("nether_groth"), new class_1747(netherGroth, new class_1792.class_1793()));
        // Grothed Netherrack
        class_2378.method_10230(class_7923.field_41175, Id.of("grothed_netherrack"), grothedNetherrackBlock);
        // Aqueduct
        class_2378.method_10230(class_7923.field_41175, Id.of("aqueduct"), aqueductBlock);
        class_2378.method_10230(class_7923.field_41178, Id.of("aqueduct"), new class_1747(aqueductBlock, new class_1792.class_1793()));
        // Screw pump
        class_2378.method_10230(class_7923.field_41175, Id.of("screw_pump"), screwPumpBlock);
        class_2378.method_10230(class_7923.field_41178, Id.of("screw_pump"), new class_1747(screwPumpBlock, new class_1792.class_1793()));

        ItemGroupEvents.modifyEntriesEvent(class_7706.field_40743).register(content -> {
            content.addAfter(class_1802.field_8790, BwtBlocks.netherGroth);
            content.addAfter(class_1802.field_42692, BwtBlocks.bloodWoodBlocks.logBlock);
            content.addAfter(class_1802.field_42694, BwtBlocks.bloodWoodBlocks.leavesBlock);
            content.addAfter(class_1802.field_42688, BwtBlocks.bloodWoodBlocks.saplingBlock);
            content.addAfter(class_2246.field_10566, dirtSlabBlock);
            content.addAfter(class_2246.field_10194, dirtPathSlabBlock);
            content.addAfter(class_2246.field_10219, grassSlabBlock);
            content.addAfter(class_2246.field_10402, myceliumSlabBlock);
            content.addAfter(class_2246.field_10520, podzolSlabBlock);
        });

        ItemGroupEvents.modifyEntriesEvent(class_7706.field_41059).register(content -> {
            content.method_45423(DyeUtils.streamColorItemsSorted(vaseBlocks).map(vaseBlock -> vaseBlock.method_8389().method_7854()).toList());
            content.method_45423(DyeUtils.streamColorItemsSorted(woolSlabBlocks).map(woolSlabBlock -> woolSlabBlock.method_8389().method_7854()).toList());
        });

        ItemGroupEvents.modifyEntriesEvent(class_7706.field_40198).register(content -> {
            content.method_45421(axleBlock);
            content.method_45421(gearBoxBlock);
            content.method_45421(redstoneClutchBlock);
            content.method_45421(hibachiBlock);
            content.method_45421(lightBlockBlock);
            content.method_45421(blockDispenserBlock);
            content.method_45421(obsidianPressurePlateBlock);
            content.method_45421(detectorBlock);
            content.method_45421(buddyBlock);
            content.method_45421(millStoneBlock);
            content.method_45421(handCrankBlock);
            content.method_45421(stoneDetectorRailBlock);
            content.method_45421(obsidianDetectorRailBlock);
            content.method_45421(sawBlock);
            content.method_45421(hopperBlock);
            content.method_45421(pulleyBlock);
            content.method_45421(anchorBlock);
            content.method_45421(platformBlock);
            content.method_45421(turntableBlock);
            content.method_45421(bellowsBlock);
            content.method_45421(cauldronBlock);
            content.method_45421(crucibleBlock);
            content.method_45421(soulForgeBlock);
            content.method_45421(lensBlock);
//            content.add(BwtBlocks.aqueductBlock);
//            content.add(BwtBlocks.screwPumpBlock);
            content.addAfter(class_1802.field_8626, miningChargeBlock);
        });

        ItemGroupEvents.modifyEntriesEvent(class_7706.field_40197).register(content -> {
            content.method_45421(cauldronBlock);
            content.method_45421(crucibleBlock);
            content.method_45421(planterBlock);
            content.method_45421(soilPlanterBlock);
            content.method_45421(soulSandPlanterBlock);
            content.method_45421(grassPlanterBlock);
            content.method_45421(urnBlock);
            content.method_45421(unfiredDecoratedPotBlock);
            content.method_45421(unfiredCrucibleBlock);
            content.method_45421(unfiredPlanterBlock);
            content.method_45421(unfiredVaseBlock);
            content.method_45421(unfiredUrnBlock);
            content.method_45421(unfiredFlowerPotBlock);
            content.addAfter(class_1802.field_8465, soulForgeBlock);
            content.addAfter(class_1802.field_16482, BwtBlocks.vineTrapBlock);
        });

        ItemGroupEvents.modifyEntriesEvent(class_7706.field_40195).register(content -> {
            content.addAfter(class_1802.field_42701,
                    BwtBlocks.bloodWoodBlocks.logBlock,
                    BwtBlocks.bloodWoodBlocks.woodBlock,
                    BwtBlocks.bloodWoodBlocks.strippedLogBlock,
                    BwtBlocks.bloodWoodBlocks.strippedWoodBlock,
                    BwtBlocks.bloodWoodBlocks.planksBlock,
                    BwtBlocks.bloodWoodBlocks.stairsBlock,
                    BwtBlocks.bloodWoodBlocks.slabBlock,
                    BwtBlocks.bloodWoodBlocks.fenceBlock,
                    BwtBlocks.bloodWoodBlocks.fenceGateBlock,
                    BwtBlocks.bloodWoodBlocks.doorBlock,
                    BwtBlocks.bloodWoodBlocks.trapdoorBlock,
                    BwtBlocks.bloodWoodBlocks.pressurePlateBlock,
                    BwtBlocks.bloodWoodBlocks.buttonBlock
            );
            for (int i = 0; i < sidingBlocks.size(); i++) {
                SidingBlock sidingBlock = sidingBlocks.get(i);
                MouldingBlock mouldingBlock = mouldingBlocks.get(i);
                CornerBlock cornerBlock = cornerBlocks.get(i);
                ColumnBlock columnBlock = columnBlocks.get(i);
                PedestalBlock pedestalBlock = pedestalBlocks.get(i);
                TableBlock tableBlock = tableBlocks.get(i);
                if (content.getDisplayStacks().stream().anyMatch(itemStack -> itemStack.method_31574(sidingBlock.fullBlock.method_8389()))) {
                    content.addAfter(sidingBlock.fullBlock, sidingBlock, mouldingBlock, cornerBlock, columnBlock, pedestalBlock, tableBlock);
                }
            }
            content.method_45421(companionCubeBlock);
            content.method_45421(companionSlabBlock);
            content.method_45421(grateBlock);
            content.method_45421(slatsBlock);
            content.method_45421(wickerPaneBlock);
            content.method_45421(wickerBlock);
            content.method_45421(wickerSlabBlock);
            content.method_45421(platformBlock);
            content.method_45421(soapBlock);
            content.method_45421(dungBlock);
            content.method_45421(paddingBlock);
            content.method_45421(ropeCoilBlock);
            content.method_45421(concentratedHellfireBlock);
            content.method_45421(dirtSlabBlock);
            content.method_45421(dirtPathSlabBlock);
            content.method_45421(grassSlabBlock);
            content.method_45421(myceliumSlabBlock);
            content.method_45421(podzolSlabBlock);
        });

        FlattenableBlockRegistry.register(BwtBlocks.grassSlabBlock, BwtBlocks.dirtPathSlabBlock.method_9564());
        FlattenableBlockRegistry.register(BwtBlocks.dirtSlabBlock, BwtBlocks.dirtPathSlabBlock.method_9564());
        FlattenableBlockRegistry.register(BwtBlocks.myceliumSlabBlock, BwtBlocks.dirtPathSlabBlock.method_9564());
        FlattenableBlockRegistry.register(BwtBlocks.podzolSlabBlock, BwtBlocks.dirtPathSlabBlock.method_9564());
    }
}
