package com.bwt.blocks;

import com.bwt.items.BwtItems;
import com.bwt.sounds.BwtSoundEvents;
import org.jetbrains.annotations.NotNull;

import java.util.function.Predicate;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2398;
import net.minecraft.class_2429;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_5819;

public class GearBoxBlock extends SimpleFacingBlock implements MechPowerBlockBase, RotateWithEmptyHand {
    public static final class_2746 NORTH = class_2429.field_11332;
    public static final class_2746 EAST = class_2429.field_11335;
    public static final class_2746 SOUTH = class_2429.field_11331;
    public static final class_2746 WEST = class_2429.field_11328;
    public static final class_2746 UP = class_2429.field_11327;
    public static final class_2746 DOWN = class_2429.field_11330;


    public GearBoxBlock(class_2251 settings) {
        super(settings);
        method_9590(method_9564().method_11657(MECH_POWERED, false));
    }

    @Override
    public void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        MechPowerBlockBase.super.appendProperties(builder);
        builder.method_11667(NORTH, EAST, SOUTH, WEST, UP, DOWN);
    }

    @Override
    public Predicate<class_2350> getValidAxleInputFaces(class_2680 blockState, class_2338 pos) {
        return direction -> direction == blockState.method_11654(field_10927);
    }

    @Override
    public Predicate<class_2350> getValidHandCrankFaces(class_2680 blockState, class_2338 pos) {
        return direction -> false;
    }

    @Override
    public boolean isMechPowered(class_2680 blockState) {
        return MechPowerBlockBase.super.isMechPowered(blockState);
    }

    @Override
    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        super.method_9496(state, world, pos, random);
        if (isMechPowered(state)) {
            emitGearBoxParticles(world, pos, random);
        }
    }

    @Override
    public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        class_2680 updatedState = onUseRotate(state, world, pos, player);
        if (updatedState == state) {
            return class_1269.field_5811;
        }
        // Prevent exploits by turning power off and wait for scheduled reload of power state
        updatedState = updatedState.method_11657(MECH_POWERED, false);
        world.method_8501(pos, updatedState);
        schedulePowerUpdate(updatedState, world, pos);
        return class_1269.field_5812;
    }

    @Override
    public @NotNull class_2680 method_9605(class_1750 ctx) {
        return withConnectionProperties(super.method_9605(ctx), ctx.method_8045(), ctx.method_8037());
    }

    @Override
    public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean notify) {
        schedulePowerUpdate(state, world, pos);
    }

    public static class_2680 withConnectionProperties(class_2680 state, class_1922 world, class_2338 pos) {
        class_2680 downBlock = world.method_8320(pos.method_10074());
        class_2680 upBlock = world.method_8320(pos.method_10084());
        class_2680 northBlock = world.method_8320(pos.method_10095());
        class_2680 eastBlock = world.method_8320(pos.method_10078());
        class_2680 southBlock = world.method_8320(pos.method_10072());
        class_2680 westBlock= world.method_8320(pos.method_10067());
        return state
                .method_47968(NORTH, (northBlock.method_27852(BwtBlocks.axleBlock) || northBlock.method_27852(BwtBlocks.axlePowerSourceBlock))
                        && northBlock.method_11654(AxleBlock.field_11459).equals(class_2350.class_2351.field_11051))
                .method_47968(EAST, (eastBlock.method_27852(BwtBlocks.axleBlock) || eastBlock.method_27852(BwtBlocks.axlePowerSourceBlock))
                        && eastBlock.method_11654(AxleBlock.field_11459).equals(class_2350.class_2351.field_11048))
                .method_47968(SOUTH, (southBlock.method_27852(BwtBlocks.axleBlock) || southBlock.method_27852(BwtBlocks.axlePowerSourceBlock))
                        && southBlock.method_11654(AxleBlock.field_11459).equals(class_2350.class_2351.field_11051))
                .method_47968(WEST, (westBlock.method_27852(BwtBlocks.axleBlock) || westBlock.method_27852(BwtBlocks.axlePowerSourceBlock))
                        && westBlock.method_11654(AxleBlock.field_11459).equals(class_2350.class_2351.field_11048))
                .method_47968(UP, (upBlock.method_27852(BwtBlocks.axleBlock) || upBlock.method_27852(BwtBlocks.axlePowerSourceBlock))
                        && upBlock.method_11654(AxleBlock.field_11459).method_10178())
                .method_47968(DOWN, (downBlock.method_27852(BwtBlocks.axleBlock) || downBlock.method_27852(BwtBlocks.axlePowerSourceBlock))
                        && downBlock.method_11654(AxleBlock.field_11459).method_10178());
    }

    @Override
    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (pos.method_10095().equals(neighborPos)) {
            return state.method_47968(NORTH, (neighborState.method_27852(BwtBlocks.axleBlock) || neighborState.method_27852(BwtBlocks.axlePowerSourceBlock)) && neighborState.method_11654(AxleBlock.field_11459).equals(class_2350.class_2351.field_11051));
        }
        if (pos.method_10078().equals(neighborPos)) {
            return state.method_47968(EAST, (neighborState.method_27852(BwtBlocks.axleBlock) || neighborState.method_27852(BwtBlocks.axlePowerSourceBlock)) && neighborState.method_11654(AxleBlock.field_11459).equals(class_2350.class_2351.field_11048));
        }
        if (pos.method_10072().equals(neighborPos)) {
            return state.method_47968(SOUTH, (neighborState.method_27852(BwtBlocks.axleBlock) || neighborState.method_27852(BwtBlocks.axlePowerSourceBlock)) &&neighborState.method_11654(AxleBlock.field_11459).equals(class_2350.class_2351.field_11051));
        }
        if (pos.method_10067().equals(neighborPos)) {
            return state.method_47968(WEST, (neighborState.method_27852(BwtBlocks.axleBlock) || neighborState.method_27852(BwtBlocks.axlePowerSourceBlock)) &&neighborState.method_11654(AxleBlock.field_11459).equals(class_2350.class_2351.field_11048));
        }
        if (pos.method_10084().equals(neighborPos)) {
            return state.method_47968(UP, (neighborState.method_27852(BwtBlocks.axleBlock) || neighborState.method_27852(BwtBlocks.axlePowerSourceBlock)) &&neighborState.method_11654(AxleBlock.field_11459).method_10178());
        }
        if (pos.method_10074().equals(neighborPos)) {
            return state.method_47968(DOWN, (neighborState.method_27852(BwtBlocks.axleBlock) || neighborState.method_27852(BwtBlocks.axlePowerSourceBlock)) &&neighborState.method_11654(AxleBlock.field_11459).method_10178());
        }
        return state;
    }

    public class_2680 getPowerStates(class_2680 state, class_1937 world, class_2338 pos) {
        return state.method_11657(MECH_POWERED, isReceivingMechPower(world, state, pos));
    }

    public void schedulePowerUpdate(class_2680 state, class_1937 world, class_2338 pos) {
        // Compute new state but don't update yet
        class_2680 newState = getPowerStates(state, world, pos);
        // If block just turned on
        if (isMechPowered(newState) && !isMechPowered(state)) {
            world.method_39279(pos, this, turnOnTickRate);
        }
        // If block just turned off
        else if (!isMechPowered(newState) && isMechPowered(state)) {
            world.method_39279(pos, this, turnOffTickRate);
        }
    }

    @Override
    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, class_2338 sourcePos, boolean notify) {
        if (world.field_9236) {
            return;
        }
        schedulePowerUpdate(state, world, pos);
    }

    public void updatePowerTransfer(class_1937 world, class_2680 blockState, class_2338 pos) {
        class_2680 updatedState = getPowerStates(blockState, world, pos);
        if (isMechPowered(updatedState)) {
            this.playMechSound(world, pos);
        }
        world.method_8501(pos, updatedState);
    }

    @Override
    public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        this.updatePowerTransfer(world, state, pos);
    }

    private void playMechSound(class_1937 world, class_2338 pos) {
        world.method_8396(null, pos, BwtSoundEvents.GEAR_BOX_ACTIVATE,
                class_3419.field_15245, 0.25f, world.field_9229.method_43057() * 0.25F + 0.25F);
//        world.addSyncedBlockEvent(pos, this, 0, 0);
//        world.emitGameEvent(entity, GameEvent.NOTE_BLOCK_PLAY, pos);
    }

    public static void breakGearBox(class_1937 world, class_2338 pos) {
        world.method_8650(pos, false);
        world.method_8396(null, pos, BwtSoundEvents.MECH_EXPLODE, class_3419.field_15245, 0.5f, 1);
        method_9577(world, pos, class_1802.field_8600.method_7854());
        method_9577(world, pos, BwtItems.sawDustItem.method_7854());
        method_9577(world, pos, BwtItems.gearItem.method_7854());
    }

    private void emitGearBoxParticles(class_1937 world, class_2338 pos, class_5819 random) {
        for ( int iTempCount = 0; iTempCount < 5; iTempCount++ )
        {
            float smokeX = (float)pos.method_10263() + random.method_43057();
            float smokeY = (float)pos.method_10264() + random.method_43057() * 0.5F + 1.0F;
            float smokeZ = (float)pos.method_10260() + random.method_43057();
            world.method_8406(class_2398.field_11251, smokeX, smokeY, smokeZ, 0D, 0D, 0D );
        }
    }
}
