package com.bwt.blocks;

import com.bwt.items.BwtItems;
import com.bwt.sounds.BwtSoundEvents;
import net.minecraft.block.*;
import net.minecraft.class_1269;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2753;
import net.minecraft.class_2758;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_5431;
import org.jetbrains.annotations.Nullable;

public class HandCrankBlock extends class_2248 {
    public static class_2753 FACING = class_2741.field_12481;
    public static class_2758 CLICK_TIMER = class_2758.method_11867("click_timer", 0, 7);
    private static final int tickRate = 3;
    private static final int delayBeforeReset = 15;
    private static final int baseHeight = 4;

    public HandCrankBlock(class_2251 settings) {
        super(settings);
    }

    public static boolean isPowered(class_2680 state) {
        return state.method_11654(CLICK_TIMER) > 0;
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(FACING, CLICK_TIMER);
    }

    @Nullable
    @Override
    public class_2680 method_9605(class_1750 ctx) {
        return this.method_9564().method_11657(FACING, ctx.method_8042().method_10153());
    }

    @Override
    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        class_2338 blockPos = pos.method_10074();
        return this.canPlaceAbove(world, blockPos, world.method_8320(blockPos));
    }

    protected boolean canPlaceAbove(class_4538 world, class_2338 pos, class_2680 state) {
        return state.method_30368(world, pos, class_2350.field_11036, class_5431.field_25824);
    }

    @Override
    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return class_2248.method_9541(0f, 0, 0, 16f, baseHeight, 16f);
    }

    @Override
    public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        if ((hit.method_17784().field_1351 - pos.method_10264()) * 16 <= baseHeight) {
            return class_1269.field_5814;
        }

        int clickTimer = state.method_11654(CLICK_TIMER);

        if (clickTimer != 0) {
            return class_1269.field_5814;
        }
        if (player.method_7344().method_7586() <= 8) {
            if (world.field_9236) {
                player.method_7353(class_2561.method_30163("You're too exhausted for manual labor."), true);
            }
            return class_1269.field_5814;
        }
        player.method_7322( 2.0F ); // every two pulls results in a half pip of hunger

        if (world.field_9236) {
            return class_1269.field_5812;
        }

        if (!checkForOverpower(world, pos)) {
            world.method_8501(pos, state.method_11657(CLICK_TIMER, 1));
            playClick(world, pos);
            world.method_39279(pos, this, tickRate);
        }
        else {
            breakWithDrop(world, pos);
        }

        return class_1269.field_5812;
    }

    @Override
    public void method_9588(class_2680 state, class_3218 world, class_2338 pos, net.minecraft.class_5819 random) {
        int clickTimer = state.method_11654(CLICK_TIMER);

        if (clickTimer <= 0) {
            return;
        }
        if (clickTimer >= 7) {
            world.method_8501(pos, state.method_11657(CLICK_TIMER, 0));
            playClick(world, pos);
            return;
        }
        playClick(world, pos);

        if (clickTimer == 6) {
            world.method_39279(pos, this, delayBeforeReset);
        } else {
            world.method_39279(pos, this, tickRate + clickTimer);
        }

        // no notify here as it's not an actual state-change, just an internal timer update
        world.method_30092(pos, state.method_11657(CLICK_TIMER, clickTimer + 1), 0, 0);
    }

    public boolean checkForOverpower(class_1937 world, class_2338 pos) {
        int numPotentialDevicesToPower = 0;

        for (class_2350 direction : class_2350.values()) {
            if (direction.equals(class_2350.field_11036)) {
                continue;
            }

            class_2338 neighborPos = pos.method_10093(direction);
            class_2680 neighborState = world.method_8320(neighborPos);
            class_2248 neighborBlock = neighborState.method_26204();
            if (neighborBlock instanceof MechPowerBlockBase mechNeighborBlock) {
                if (mechNeighborBlock.getValidHandCrankFaces(neighborState, neighborPos).test(direction.method_10153())) {
                    numPotentialDevicesToPower++;
                }
            }
        }

        return numPotentialDevicesToPower > 1;
    }

    public void playClick(class_1937 world, class_2338 pos) {
        world.method_8396(null, pos, BwtSoundEvents.HAND_CRANK_CLICK, class_3419.field_15245, 1.0f,  2.0f);
    }

    public void breakWithDrop(class_1937 world, class_2338 pos) {
        class_2680 airState = class_2246.field_10124.method_9564();
        world.method_8501(pos, airState);
        class_243 centerPos = pos.method_46558();
        world.method_45446(pos, BwtSoundEvents.MECH_EXPLODE, class_3419.field_15245, 0.5f, 1, false);
        for (class_1792 item : new class_1792[]{class_1802.field_8600, class_1802.field_20391, BwtItems.gearItem}) {
            class_1542 itemEntity = new class_1542(world, centerPos.field_1352, centerPos.field_1351, centerPos.field_1350, item.method_7854());
            itemEntity.method_18800(world.field_9229.method_43058() * -0.01 + 0.02, 0.2, world.field_9229.method_43058() * -0.01 + 0.02);
            world.method_8649(itemEntity);
        }
    }

    @Override
    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return state.method_11657(FACING, rotation.method_10503(state.method_11654(FACING)));
    }

    @Override
    protected void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, class_2338 sourcePos, boolean notify) {
        if (world.field_9236 || !world.method_8320(pos).method_27852(this)) {
            return;
        }
        if (method_9558(state, world, pos)) {
            return;
        }
        method_9497(state, world, pos);
        world.method_8650(pos, notify);
    }

    @Override
    protected void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        if (moved) {
            return;
        }
        super.method_9536(state, world, pos, newState, moved);
    }
}
