package com.bwt.blocks;

import com.bwt.items.BwtItems;
import net.minecraft.block.*;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_3726;
import net.minecraft.class_4538;
import net.minecraft.class_5819;

public class HempCropBlock extends class_2302 {
    private static final class_265[] AGE_TO_SHAPE = new class_265[]{
            class_2248.method_9541(0.0D, 0.0D, 0.0D, 16.0D, 2.0D, 16.0D),
            class_2248.method_9541(0.0D, 0.0D, 0.0D, 16.0D, 3.0D, 16.0D),
            class_2248.method_9541(0.0D, 0.0D, 0.0D, 16.0D, 4.0D, 16.0D),
            class_2248.method_9541(0.0D, 0.0D, 0.0D, 16.0D, 5.0D, 16.0D),
            class_2248.method_9541(0.0D, 0.0D, 0.0D, 16.0D, 6.0D, 16.0D),
            class_2248.method_9541(0.0D, 0.0D, 0.0D, 16.0D, 7.0D, 16.0D),
            class_2248.method_9541(0.0D, 0.0D, 0.0D, 16.0D, 8.0D, 16.0D),
            class_2248.method_9541(0.0D, 0.0D, 0.0D, 16.0D, 9.0D, 16.0D),
            class_2248.method_9541(0.0D, 0.0D, 0.0D, 16.0D, 9.0D, 16.0D)
    };
    public static final class_2746 CONNECTED_UP = class_2746.method_11825("connected_up");

    public HempCropBlock(class_2251 settings) {
        super(settings);
        method_9590(method_9564().method_11657(CONNECTED_UP, false));
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(CONNECTED_UP);
    }

    @Override
    public class_1935 method_9832() {
        return BwtItems.hempSeedsItem;
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        int age = state.method_11654(field_10835);
        boolean connectedUp = state.method_11654(CONNECTED_UP);

        double height = (age + 1) / 8d;
        double halfWidth = 0.2f;

        if (age == method_9827() && !connectedUp) {
            height -= 2 / 16d;
        }

        return class_259.method_1081(
                0.5D - halfWidth, 0D, 0.5D - halfWidth,
                0.5D + halfWidth, height, 0.5D + halfWidth
        );
    }

    @Override
    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (!state.method_26184(world, pos) && !world.method_8320(pos.method_10074()).method_27852(this)) {
            return class_2246.field_10124.method_9564();
        }
        if (neighborPos.equals(pos.method_10084())) {
            return state.method_11657(CONNECTED_UP, neighborState.method_27852(this));
        }
        return state;
    }

    @Override
    protected int method_9831(class_1937 world) {
        return 1;
    }

    @Override
    public boolean method_9542(class_2680 state) {
        return true;
    }

    @Override
    public void method_9514(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        class_2680 upState = world.method_8320(pos.method_10084());
        class_2680 up2State = world.method_8320(pos.method_10086(2));

        if (random.method_43048((int)(25.0f / (class_2302.method_9830(this, world, pos))) + 1) != 0) {
            return;
        }
        if (!method_9650(world, random, pos, state)) {
            return;
        }

        if (
                (world.method_8311(pos)
                || (upState.method_27852(BwtBlocks.lightBlockBlock) && upState.method_11654(LightBlock.LIT))
                || (up2State.method_27852(BwtBlocks.lightBlockBlock) && up2State.method_11654(LightBlock.LIT)))
                && world.method_22335(pos, 0) >= 9
        ) {
            method_9652(world, random, pos, state);
        }
    }

    @Override
    public boolean method_9650(class_1937 world, class_5819 random, class_2338 pos, class_2680 state) {
        return !world.method_8320(pos.method_10074()).method_27852(this) && world.method_8320(pos.method_10084()).method_26164(class_3481.field_51989);
    }

    @Override
    public boolean method_9651(class_4538 world, class_2338 pos, class_2680 state) {
        return false;
    }

    @Override
    public void method_9652(class_3218 world, class_5819 random, class_2338 pos, class_2680 state) {
        if (method_9650(world, random, pos, state)) {
            method_9826(world, pos, state);
        }
    }

    @Override
    public void method_9826(class_1937 world, class_2338 pos, class_2680 state) {
        int currentAge = method_9829(state);
        int newAge = currentAge + method_9831(world);
        int maxAge = method_9827();
        if (newAge > maxAge) {
            newAge = maxAge;
            if (world.method_8320(pos.method_10084()).method_26164(class_3481.field_51989)) {
                world.method_8501(pos.method_10084(), method_9564().method_11657(field_10835, maxAge));
            }
        }
        if (newAge != currentAge) {
            world.method_8652(pos, this.method_9828(newAge), class_2248.field_31036);
        }
    }
}
