package com.bwt.blocks;

import com.bwt.blocks.unfired_pottery.UnfiredPotteryBlock;
import com.bwt.recipes.BwtRecipes;
import com.bwt.recipes.kiln.KilnRecipe;
import com.bwt.recipes.kiln.KilnRecipeInput;
import com.bwt.utils.FireDataCluster;
import com.bwt.utils.kiln_block_cook_overlay.KilnBlockCookOverlay;
import org.jetbrains.annotations.Nullable;

import java.util.Arrays;
import java.util.Optional;
import net.minecraft.class_1264;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2398;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2758;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_4538;
import net.minecraft.class_5819;
import net.minecraft.class_8786;
import net.minecraft.class_9323;

public class KilnBlock extends class_2248 {
    private static final int minFireFactorBaseTickRate = 20; // FC value 40
    private static final int maxFireFactorBaseTickRate = 80; // FC value 160

    public static final class_2758 COOK_TIME = class_2758.method_11867("cook_time", 0, 15);

    public KilnBlock(class_2251 settings) {
        super(settings);
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(COOK_TIME);
    }

    @Override
    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        super.method_9567(world, pos, state, placer, itemStack);
        Optional<KilnRecipe> recipe = getRecipe(world, world.method_8320(pos.method_10084()));
        recipe.ifPresent(kilnRecipe -> scheduleUpdateBasedOnCookState(world, pos, kilnRecipe));
    }

    @Override
    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        super.method_9536(state, world, pos, newState, moved);
        if (!newState.method_27852(this)) {
            resetBlockCookProgress(world, pos);
        }
    }

    @Override
    public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        super.method_9588(state, world, pos, random);

        int oldCookCounter = state.method_11654(COOK_TIME);
        int newCookCounter = 0;

        class_2338 cookingBlockPos = pos.method_10084();
        class_2680 cookingBlockState = world.method_8320(cookingBlockPos);
        Optional<KilnRecipe> recipe = getRecipe(world, cookingBlockState);
        if (recipe.isPresent()) {
            if (checkKilnIntegrity(world, pos)) {
                if (oldCookCounter >= 15) {
                    cookBlock(world, pos.method_10084(), cookingBlockState, recipe.get());
                }
                else {
                    newCookCounter = oldCookCounter + 1;
                    scheduleUpdateBasedOnCookState(world, pos, recipe.get());
                }
            }
            else {
                // if we have a valid cook block above, we have to reschedule another tick
                // regardless of other factors, because the shape of the kiln can change without
                // an immediate neighbor changing, causing the cook process to restart
                scheduleUpdateBasedOnCookState(world, pos, recipe.get());
            }
        }

        if (oldCookCounter != newCookCounter) {
            world.method_8501(pos, state.method_11657(COOK_TIME, newCookCounter));
            // The 10 here is the max block breaking progress
            KilnBlockCookOverlay.setKilnBlockCookingInfo(world, pos.method_10084(), ((int) class_3532.method_37166(-1, 9, ((float) newCookCounter) / 15f)));
            if (cookingBlockState.method_28498(UnfiredPotteryBlock.COOKING) && cookingBlockState.method_11654(UnfiredPotteryBlock.COOKING).equals(false)) {
                world.method_8501(cookingBlockPos, cookingBlockState.method_11657(UnfiredPotteryBlock.COOKING, true));
            }
        }
    }

    @Override
    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (neighborPos.equals(pos.method_10074()) && !neighborState.method_27852(BwtBlocks.stokedFireBlock)) {
            // we don't have a stoked fire beneath us, so revert to regular brick
            return class_2246.field_10104.method_9564();
        }
        return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    @Override
    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, class_2338 sourcePos, boolean notify) {
        super.method_9612(state, world, pos, sourceBlock, sourcePos, notify);
        Optional<KilnRecipe> recipe = getRecipe(world, world.method_8320(pos.method_10084()));
        if (recipe.isPresent()) {
            scheduleUpdateBasedOnCookState(world, pos, recipe.get());
        }
        else if (state.method_11654(COOK_TIME) > 0) {
            // reset the cook counter so it doesn't get passed to another block on piston push
            resetBlockCookProgress(world, pos);
            world.method_8501(pos, state.method_11657(COOK_TIME, 0));
        }
    }

    protected void scheduleUpdateBasedOnCookState(class_1937 world, class_2338 pos, KilnRecipe recipe) {
        int iTickRate = computeTickRateBasedOnFireFactor(world, pos);

        iTickRate *= recipe.getCookingTime();

        world.method_39279(pos, this, iTickRate);
    }

    private Optional<KilnRecipe> getRecipe(class_1937 world, class_2680 cookingBlockState) {
        KilnRecipeInput recipeInput = new KilnRecipeInput(cookingBlockState.method_26204());
        return world.method_8433().method_8132(
                BwtRecipes.KILN_RECIPE_TYPE,
                recipeInput,
                world
        ).map(class_8786::comp_1933);
    }

    private void cookBlock(class_1937 world, class_2338 cookingBlockPos, class_2680 cookingBlockState, KilnRecipe recipe) {
        class_9323 components = cookingBlockState.method_26204().method_9574(world, cookingBlockPos, cookingBlockState).method_57353();
        world.method_22352(cookingBlockPos, false);
        class_2371<class_1799> drops = class_2371.method_10212(class_1799.field_8037, recipe.getDrops().stream().map(class_1799::method_7972).toArray(class_1799[]::new));
        if (drops.isEmpty()) {
            return;
        }
        class_1799 firstDrop = drops.get(0);
        firstDrop.method_57365(components.method_57828(componentType -> firstDrop.method_57353().method_57832(componentType)));
        class_1264.method_17349(world, cookingBlockPos, drops);
    }

    private void resetBlockCookProgress(class_1937 world, class_2338 kilnPos) {
        class_2338 cookingBlockPos = kilnPos.method_10084();
        class_2680 cookingBlockState = world.method_8320(cookingBlockPos);
        if (cookingBlockState.method_28498(UnfiredPotteryBlock.COOKING) && cookingBlockState.method_11654(UnfiredPotteryBlock.COOKING).equals(true)) {
            world.method_8501(cookingBlockPos, cookingBlockState.method_11657(UnfiredPotteryBlock.COOKING, false));
        }
        KilnBlockCookOverlay.setKilnBlockCookingInfo(world, cookingBlockPos, -1);
    }

    private boolean checkKilnIntegrity(class_1937 world, class_2338 pos) {
        class_2338 center = pos.method_10084();
        return Arrays.stream(class_2350.values())
                .map(center::method_10093)
                .filter(structurePos -> !structurePos.equals(pos))
                .filter(structurePos -> world.method_8320(structurePos).method_27852(class_2246.field_10104))
                .count() >= 3;
    }

    private int computeTickRateBasedOnFireFactor(class_1937 world, class_2338 pos) {
        FireDataCluster fireDataCluster = FireDataCluster.fromWorld(world, pos);
        int additionalFireCount = fireDataCluster.getStokedCount() - 1;
//        return maxFireFactorBaseTickRate - (additionalFireCount / 8) * (maxFireFactorBaseTickRate - minFireFactorBaseTickRate);
        return ( ( maxFireFactorBaseTickRate - minFireFactorBaseTickRate ) *
                ( 8 - additionalFireCount ) / 8 ) + minFireFactorBaseTickRate;
    }

    @Override
    public class_1799 method_9574(class_4538 world, class_2338 pos, class_2680 state) {
        return class_2246.field_10104.method_9574(world, pos, state);
    }

    @Override
    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        super.method_9496(state, world, pos, random);
        class_2680 blockAboveState = world.method_8320(pos.method_10084());
        if (blockAboveState.method_26164(class_3481.field_51989)) {
            return;
        }
        Optional<KilnRecipe> recipe = getRecipe(world, blockAboveState);
        if (recipe.isEmpty()) {
            return;
        }
        if (!checkKilnIntegrity(world, pos)) {
            return;
        }

        if (!blockAboveState.method_26216(world, pos)) {
            for (int count = 0; count < 2; count++) {
                double xPos = pos.method_10263() + random.method_43058();
                double yPos = pos.method_10264() + 1d + (random.method_43058() * 0.75d);
                double zPos = pos.method_10260() + random.method_43058();

                world.method_8406(class_2398.field_46911, xPos, yPos, zPos, 0d, 0d, 0d);
            }
        }
        else {
            for (class_2350 direction : class_2350.values()) {
                if (direction.method_10166().method_10178()) {
                    continue;
                }
                double xPos = pos.method_10263() + 0.5d;
                double yPos = pos.method_10264() + 1d + (random.method_43058() * 0.75d);
                double zPos = pos.method_10260() + 0.5d;

                double dFacingOffset = 0.75d;
                double dHorizontalOffset = -0.75d + (random.method_43058() * 1.5d);

                // negative z
                if (direction == class_2350.field_11043) {
                    xPos += dHorizontalOffset;
                    zPos -= dFacingOffset;
                }
                // positive z
                else if (direction == class_2350.field_11035) {
                    xPos += dHorizontalOffset;
                    zPos += dFacingOffset;
                }
                // negative x
                else if (direction == class_2350.field_11039) {
                    xPos -= dFacingOffset;
                    zPos += dHorizontalOffset;
                }
                // positive i
                else {
                    xPos += dFacingOffset;
                    zPos += dHorizontalOffset;
                }

                world.method_8406(class_2398.field_46911, xPos, yPos, zPos, 0d, 0d, 0d);
            }
        }
    }
}
