package com.bwt.blocks;

import com.bwt.utils.Id;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_4719;
import net.minecraft.class_5793;
import net.minecraft.class_5794;
import net.minecraft.class_7923;

public abstract class MaterialInheritedBlock extends class_2248 {
    public class_2248 fullBlock;

    public MaterialInheritedBlock(class_2251 settings, class_2248 fullBlock) {
        super(settings);
        this.fullBlock = fullBlock;
    }

    public boolean isWood() {
        return class_7923.field_41175.method_10221(fullBlock).method_12832().contains("planks");
    }

    public static void registerMaterialBlocks(
            ArrayList<SidingBlock> sidingBlocks,
            ArrayList<MouldingBlock> mouldingBlocks,
            ArrayList<CornerBlock> cornerBlocks,
            ArrayList<ColumnBlock> columnBlocks,
            ArrayList<PedestalBlock> pedestalBlocks,
            ArrayList<TableBlock> tableBlocks
    ) {
        class_4719.method_24026()
                .map(woodType -> class_7923.field_41175.method_10223(Id.mc(woodType.comp_1299() + "_planks")))
                .forEach(block -> {
            sidingBlocks.add(SidingBlock.ofBlock(block));
            mouldingBlocks.add(MouldingBlock.ofBlock(block));
            cornerBlocks.add(CornerBlock.ofBlock(block));
            columnBlocks.add(ColumnBlock.ofBlock(block));
            pedestalBlocks.add(PedestalBlock.ofBlock(block));
            tableBlocks.add(TableBlock.ofBlock(block));
        });
        List<class_5794> blockFamilies = List.of(
                class_5793.field_28523,
                class_5793.field_28497,
                class_5793.field_28498,
                class_5793.field_28515,
                class_5793.field_28491,
                class_5793.field_28494,
                class_5793.field_28513,
                class_5793.field_28483,
                class_5793.field_28525,
                class_5793.field_28480,
                class_5793.field_28508,
                class_5793.field_28509,
                class_5793.field_28481,
                class_5793.field_28482,
                class_5793.field_29079,
                class_5793.field_47131,
                class_5793.field_38008,
                class_5793.field_28485,
                class_5793.field_28514,
                class_5793.field_28486
        );
        blockFamilies.stream().map(class_5794::method_33469).forEach(block -> {
            sidingBlocks.add(SidingBlock.ofBlock(block));
            mouldingBlocks.add(MouldingBlock.ofBlock(block));
            cornerBlocks.add(CornerBlock.ofBlock(block));
            columnBlocks.add(ColumnBlock.ofBlock(block));
            pedestalBlocks.add(PedestalBlock.ofBlock(block));
            tableBlocks.add(TableBlock.ofBlock(block));
        });
        for (int i = 0; i < sidingBlocks.size(); i++) {
            SidingBlock sidingBlock = sidingBlocks.get(i);
            MouldingBlock mouldingBlock = mouldingBlocks.get(i);
            CornerBlock cornerBlock = cornerBlocks.get(i);
            ColumnBlock columnBlock = columnBlocks.get(i);
            PedestalBlock pedestalBlock = pedestalBlocks.get(i);
            TableBlock tableBlock = tableBlocks.get(i);
            class_2960 blockId = class_7923.field_41175.method_10221(sidingBlock.fullBlock);
            class_2960 sidingId = Id.of(blockId.method_12832() + "_siding");
            class_2960 mouldingId = Id.of(blockId.method_12832() + "_moulding");
            class_2960 cornerId = Id.of(blockId.method_12832() + "_corner");
            class_2960 columnId = Id.of(blockId.method_12832() + "_column");
            class_2960 pedestalId = Id.of(blockId.method_12832() + "_pedestal");
            class_2960 tableId = Id.of(blockId.method_12832() + "_table");
            class_2378.method_10230(class_7923.field_41175, sidingId, sidingBlock);
            class_2378.method_10230(class_7923.field_41175, mouldingId, mouldingBlock);
            class_2378.method_10230(class_7923.field_41175, cornerId, cornerBlock);
            class_2378.method_10230(class_7923.field_41175, columnId, columnBlock);
            class_2378.method_10230(class_7923.field_41175, pedestalId, pedestalBlock);
            class_2378.method_10230(class_7923.field_41175, tableId, tableBlock);
            class_2378.method_10230(class_7923.field_41178, sidingId, new class_1747(sidingBlock, new class_1792.class_1793()));
            class_2378.method_10230(class_7923.field_41178, mouldingId, new class_1747(mouldingBlock, new class_1792.class_1793()));
            class_2378.method_10230(class_7923.field_41178, cornerId, new class_1747(cornerBlock, new class_1792.class_1793()));
            class_2378.method_10230(class_7923.field_41178, columnId, new class_1747(columnBlock, new class_1792.class_1793()));
            class_2378.method_10230(class_7923.field_41178, pedestalId, new class_1747(pedestalBlock, new class_1792.class_1793()));
            class_2378.method_10230(class_7923.field_41178, tableId, new class_1747(tableBlock, new class_1792.class_1793()));
        }
    }
}
