package com.bwt.blocks;

import com.bwt.sounds.BwtSoundEvents;
import com.bwt.utils.BlockPosAndState;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_3419;

public interface MechPowerBlockBase {
    int turnOnTickRate = 10;
    int turnOffTickRate = 9;

    class_2746 MECH_POWERED = class_2746.method_11825("mech_powered");

    static int getTurnOnTickRate() { return turnOnTickRate; }
    static int getTurnOffTickRate() { return turnOffTickRate; }

    default void appendProperties(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(MECH_POWERED);
    }

    default boolean isMechPowered(class_2680 blockState) {
        return blockState.method_11654(MECH_POWERED);
    }

    default Predicate<class_2350> getValidAxleInputFaces(class_2680 blockState, class_2338 pos) {
        return direction -> true;
    }

    default Predicate<class_2350> getValidHandCrankFaces(class_2680 blockState, class_2338 pos) {
        return direction -> !direction.equals(class_2350.field_11033);
    }

    default Stream<class_2350> getPowerInputFaces(class_1937 world, class_2338 pos, class_2680 blockState) {
        Predicate<class_2350> axlePredicate = getValidAxleInputFaces(blockState, pos);
        Predicate<class_2350> handCrankPredicate = getValidHandCrankFaces(blockState, pos);
        return Arrays.stream(class_2350.values())
                .filter(direction -> {
                    class_2680 inputBlockState = world.method_8320(pos.method_10093(direction));
                    return (axlePredicate.test(direction) && inputBlockState.method_26204() instanceof AxleBlock && AxleBlock.isPowered(inputBlockState) && inputBlockState.method_11654(AxleBlock.field_11459).method_10176(direction))
                            || (handCrankPredicate.test(direction) && inputBlockState.method_26204() instanceof HandCrankBlock && HandCrankBlock.isPowered(inputBlockState));
                });
    }

    default boolean isReceivingMechPower(class_1937 world, class_2680 blockState, class_2338 pos) {
        return getPowerInputFaces(world, pos, blockState).findAny().isPresent();
    }

    default boolean isOverPowered(class_1937 world, class_2680 blockState, class_2338 pos) {
        return getPowerInputFaces(world, pos, blockState).limit(2).count() > 1;
    }

    default void playBangSound(class_1937 world, class_2338 pos, float volume, float pitch) {
        world.method_8396(null, pos, BwtSoundEvents.MECH_BANG, class_3419.field_15245, volume, pitch);
    }

    default void playBangSound(class_1937 world, class_2338 pos, float volume) {
        playBangSound(world, pos, volume, 1);
    }

    default void playBangSound(class_1937 world, class_2338 pos) {
        playBangSound(world, pos, 0.5f);
    }

    default void playCreakSound(class_1937 world, class_2338 pos, float volume) {
        world.method_8396(null, pos, BwtSoundEvents.MECH_CREAK,
                class_3419.field_15245, volume, world.field_9229.method_43057() * 0.25F + 0.25F);
    }

    default void playCreakSound(class_1937 world, class_2338 pos) {
        playCreakSound(world, pos, 0.25f);
    }
}
