package com.bwt.blocks;

import com.bwt.damage_types.BwtDamageTypes;
import com.bwt.items.BwtItems;
import com.bwt.recipes.BlockIngredient;
import com.bwt.recipes.BwtRecipes;
import com.bwt.recipes.saw.SawRecipe;
import com.bwt.recipes.saw.SawRecipeInput;
import com.bwt.sounds.BwtSoundEvents;
import com.bwt.tags.BwtBlockTags;
import com.bwt.utils.BlockUtils;
import net.minecraft.block.*;
import net.minecraft.class_1264;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_238;
import net.minecraft.class_2398;
import net.minecraft.class_2404;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2771;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3726;
import net.minecraft.class_8786;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class SawBlock extends SimpleFacingBlock implements MechPowerBlockBase {
    private static final int powerChangeTickRate = 10;

    private static final int sawTimeBaseTickRate = 15;
    private static final int sawTimeTickRateVariance = 4;

    // This base height prevents chickens slipping through grinders, while allowing items to pass

    public static final float baseHeight = 16f - 4f;

    public static final float bladeLength = 10f;
    public static final float bladeHalfLength = bladeLength * 0.5F;

    public static final float bladeWidth = 0.25f;
    public static final float bladeHalfWidth = bladeWidth * 0.5F;

    public static final float bladeHeight = 16F - baseHeight;
    protected static final class_238 UPWARD_BASE_BOX = new class_238(0f, 0f, 0f, 16f, baseHeight, 16F);
    protected static final class_238 UPWARD_BLADE_BOX = new class_238(8f - bladeHalfLength, baseHeight, 8f - bladeHalfWidth, 8f + bladeHalfLength, baseHeight + bladeHeight, 8f + bladeHalfWidth);
    protected static final class_238 DOWNWARD_BLADE_BOX = new class_238(8f - bladeHalfLength, 0, 8f - bladeHalfWidth, 8f + bladeHalfLength, bladeHeight, 8f + bladeHalfWidth);
    protected static final class_238 NORTH_BLADE_BOX = new class_238(
            8f - bladeHalfLength, 8f - bladeHalfWidth, 16f - baseHeight,
            8f + bladeHalfLength, 8f + bladeHalfWidth, 16f - baseHeight - bladeHeight
    );
    protected static final class_238 SOUTH_BLADE_BOX = new class_238(
            8f - bladeHalfLength, 8f - bladeHalfWidth, baseHeight,
            8f + bladeHalfLength, 8f + bladeHalfWidth, baseHeight + bladeHeight
    );
    protected static final class_238 EAST_BLADE_BOX = new class_238(
            16f - baseHeight, 8f - bladeHalfWidth, 8f - bladeHalfLength,
            16f - baseHeight - bladeHeight, 8f + bladeHalfWidth, 8f + bladeHalfLength
    );
    protected static final class_238 WEST_BLADE_BOX = new class_238(
            (baseHeight), 8f - bladeHalfWidth, 8f - bladeHalfLength,
            baseHeight + bladeHeight, 8f + bladeHalfWidth, 8f + bladeHalfLength
    );

    protected static final List<class_265> COLLISION_SHAPES = Arrays.stream(class_2350.values())
            .map(direction -> BlockUtils.rotateCuboidFromUp(direction, UPWARD_BASE_BOX))
            .toList();

    protected static final List<class_265> BLADE_SHAPES = Stream.of(
            DOWNWARD_BLADE_BOX,
            UPWARD_BLADE_BOX,
            NORTH_BLADE_BOX,
            SOUTH_BLADE_BOX,
            EAST_BLADE_BOX,
            WEST_BLADE_BOX
    ).map(box -> class_2248.method_9541(box.field_1323, box.field_1322, box.field_1321, box.field_1320, box.field_1325, box.field_1324)).toList();

    protected static final List<class_265> OUTLINE_SHAPES = Arrays.stream(class_2350.values())
            .map(direction -> BlockUtils.rotateCuboidFromUp(direction, UPWARD_BASE_BOX)).toList();

    public SawBlock(class_2251 settings) {
        super(settings);
    }

    @Override
    public void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        MechPowerBlockBase.super.appendProperties(builder);
        builder.method_11667(field_10927);
    }

    @NotNull
    @Override
    public class_2680 method_9605(class_1750 ctx) {
        return this.method_9564().method_11657(field_10927, ctx.method_7715().method_10153()).method_11657(MECH_POWERED, false);
    }

    @Override
    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        super.method_9567(world, pos, state, placer, itemStack);
        // note that we can't validate if the update is required here as the block will have
        // its facing set after being added
        world.method_39279(pos, this, powerChangeTickRate);
    }

    @Override
    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return COLLISION_SHAPES.get(state.method_11654(field_10927).method_10146());
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return OUTLINE_SHAPES.get(state.method_11654(field_10927).method_10146());
    }

    @Override
    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, class_2338 sourcePos, boolean notify) {
        super.method_9612(state, world, pos, sourceBlock, sourcePos, notify);
        scheduleUpdateIfRequired(world, state, pos);
    }

    @Override
    public void method_9588(class_2680 state, class_3218 world, class_2338 pos, net.minecraft.class_5819 random) {
        super.method_9588(state, world, pos, random);

        boolean bReceivingPower = isReceivingMechPower(world, state, pos);
        boolean bOn = isMechPowered(state);

        if (bOn != bReceivingPower) {
            emitSawParticles(world, state, pos);

            world.method_8501(pos, state.method_11657(MECH_POWERED, bReceivingPower));

            if (bReceivingPower) {
                playBangSound(world, pos);
                // the saw doesn't cut on the update in which it is powered, so check if another
                // update is required
                scheduleUpdateIfRequired(world, state, pos);
            }
        }
        else if (bOn) {
            sawBlockToFront(world, state, pos);
        }
    }

    @Override
    public void method_9548(class_2680 state, class_1937 world, class_2338 pos, class_1297 entity) {
        super.method_9548(state, world, pos, entity);
        if (!isMechPowered(state)) {
            return;
        }
        if (!(entity instanceof class_1309 livingEntity)) {
            return;
        }
        // construct bounding box from saw
        if (BLADE_SHAPES.get(state.method_11654(field_10927).method_10146()).method_1107().method_996(pos)
                .method_994(livingEntity.method_24833(entity.method_18376()).method_997(livingEntity.method_19538()))) {

            class_1282 damageSource = BwtDamageTypes.of(world, BwtDamageTypes.SAW_DAMAGE_TYPE);
            livingEntity.method_5643(damageSource, 4.0f);
        }
    }

    public void dropItemsOnBreak(class_1937 world, class_2338 pos) {
        class_1264.method_17349(world, pos, class_2371.method_10212(
                class_1799.field_8037,
                new class_1799(BwtItems.gearItem, 1),
                new class_1799(class_1802.field_8600, 2),
                new class_1799(BwtItems.sawDustItem, 2),
                new class_1799(class_1802.field_8620, 2),
                new class_1799(BwtItems.strapItem, 2)
        ));
    }

    protected void scheduleUpdateIfRequired(class_1937 world, class_2680 state, class_2338 pos) {
        if (isMechPowered(state) != isReceivingMechPower(world, state, pos)) {
            world.method_39279(pos, this, powerChangeTickRate);
            return;
        }
        if (!isMechPowered(state)) {
            return;
        }

        // check if we have something to cut in front of us
        class_2338 targetPos = pos.method_10093(state.method_11654(field_10927));
        class_2680 targetState = world.method_8320(targetPos);
        if (!targetState.method_26164(class_3481.field_51989)) {
            world.method_39279(pos, this, sawTimeBaseTickRate + world.field_9229.method_43048(sawTimeTickRateVariance));
        }
    }


    void emitSawParticles(class_1937 world, class_2680 state, class_2338 pos) {
        // compute position of saw blade
        class_2350 facing = state.method_11654(field_10927);
        class_265 bladeFace = BLADE_SHAPES.get(facing.method_10146()).method_52620().method_1096(pos.method_10263(), pos.method_10264(), pos.method_10260());
        double bladeMaxX = bladeFace.method_1105(class_2350.class_2351.field_11048);
        double bladeMaxY = bladeFace.method_1105(class_2350.class_2351.field_11052);
        double bladeMaxZ = bladeFace.method_1105(class_2350.class_2351.field_11051);
        double bladeMinX = bladeFace.method_1091(class_2350.class_2351.field_11048);
        double bladeMinY = bladeFace.method_1091(class_2350.class_2351.field_11052);
        double bladeMinZ = bladeFace.method_1091(class_2350.class_2351.field_11051);
        double fBladeXPos = (bladeMaxX + bladeMinX) / 2;
        double fBladeYPos = (bladeMaxY + bladeMinY) / 2;
        double fBladeZPos = (bladeMaxZ + bladeMinZ) / 2;

        for (int counter = 0; counter < 5; counter++) {
            double smokeX = fBladeXPos + ((world.field_9229.method_43057() - 0.5f) * (bladeMaxX - bladeMinX));
            double smokeY = fBladeYPos + ((world.field_9229.method_43057() * 0.10f) * (bladeMaxY - bladeMinY));
            double smokeZ = fBladeZPos + ((world.field_9229.method_43057() - 0.5f) * (bladeMaxZ - bladeMinZ));
            world.method_8406(class_2398.field_11251, smokeX, smokeY, smokeZ, 0d, 0d, 0d);
        }
    }

    protected void sawBlockToFront(class_1937 world, class_2680 state, class_2338 pos) {
        class_2338 targetPos = pos.method_10093(state.method_11654(field_10927));
        class_2680 targetState = world.method_8320(targetPos);

        if (targetState.method_26164(class_3481.field_51989)) {
            return;
        }

        SawRecipeInput recipeInput = new SawRecipeInput(targetState.method_26204());
        Optional<SawRecipe> recipe = world.method_8433().method_8132(
                BwtRecipes.SAW_RECIPE_TYPE,
                recipeInput,
                world
        ).map(class_8786::comp_1933);
        // Cutting
        if (recipe.isEmpty()) {
            if (targetState.method_26204() instanceof class_2404) {
                return;
            }
            if (targetState.method_26164(BwtBlockTags.SAW_BREAKS_NO_DROPS)) {
                world.method_22352(targetPos, false);
                playBangSound(world, pos);
                return;
            }
            if (targetState.method_26164(BwtBlockTags.SAW_BREAKS_DROPS_LOOT)) {
                world.method_22352(targetPos, true);
                playBangSound(world, pos);
                return;
            }
            if (!targetState.method_26164(BwtBlockTags.SURVIVES_SAW_BLOCK)) {
                breakSaw(world, pos);
            }
            return;
        }

        List<class_1799> results = recipe.get().getResults();
        BlockIngredient blockIngredient = recipe.get().getIngredient();

        // The companion slab is the only partial block that doesn't just get cut regardless of collision
        if (blockIngredient.test(BwtBlocks.companionSlabBlock) && state.method_11654(field_10927).method_10166().method_10179()) {
            return;
        }

        if (blockIngredient.test(BwtBlocks.companionCubeBlock)) {
            world.method_8396(null, pos, BwtSoundEvents.COMPANION_CUBE_DEATH, class_3419.field_15245, 1, 1);
            if (state.method_11654(field_10927).method_10166().method_10179()) {
                results.get(0).method_7939(1);
                world.method_8501(targetPos, BwtBlocks.companionSlabBlock.method_9564());
            }
            else {
                world.method_22352(targetPos, false);
            }
        }
        else {
            world.method_22352(targetPos, false);
        }
        playBangSound(world, pos);

        targetState.method_28500(class_2741.field_12485).filter(property -> property.equals(class_2771.field_12682)).ifPresent((property) ->
            results.forEach(stack -> stack.method_7939(stack.method_7947() * 2))
        );

        class_1264.method_17349(world, targetPos, class_2371.method_10212(class_1799.field_8037, results.toArray(new class_1799[0])));
    }

    public void breakSaw(class_1937 world, class_2338 pos) {
        dropItemsOnBreak(world, pos);
        world.method_22352(pos, false);
        playBangSound(world, pos, 1);
    }

    @Override
    public Predicate<class_2350> getValidAxleInputFaces(class_2680 state, class_2338 pos) {
        return direction -> !direction.equals(state.method_11654(field_10927));
    }

    @Override
    public Predicate<class_2350> getValidHandCrankFaces(class_2680 blockState, class_2338 pos) {
        return direction -> false;
    }

//    @Override
//    public void overpower(World world, BlockPos pos) {
//        breakSaw(world, pos);
//    }

    //----------- Client Side Functionality -----------//


    @Override
    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, net.minecraft.class_5819 random) {
        if (isMechPowered(state)) {
            emitSawParticles(world, state, pos);
        }
    }
}